/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.services.async;

import com.anthropic.core.ClientOptions;
import com.anthropic.core.PrepareRequest;
import com.anthropic.core.RequestOptions;
import com.anthropic.core.handlers.ErrorHandler;
import com.anthropic.core.http.HttpClient;
import com.anthropic.core.http.HttpMethod;
import com.anthropic.core.http.HttpRequest;
import com.anthropic.core.http.HttpResponse;
import com.anthropic.errors.AnthropicError;
import com.anthropic.errors.AnthropicException;
import com.anthropic.models.ModelInfo;
import com.anthropic.models.ModelListPageAsync;
import com.anthropic.models.ModelListParams;
import com.anthropic.models.ModelRetrieveParams;
import com.anthropic.services.async.ModelServiceAsync;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\f2\u0006\u0010\r\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/anthropic/services/async/ModelServiceAsyncImpl;", "Lcom/anthropic/services/async/ModelServiceAsync;", "clientOptions", "Lcom/anthropic/core/ClientOptions;", "<init>", "(Lcom/anthropic/core/ClientOptions;)V", "errorHandler", "Lcom/anthropic/core/http/HttpResponse$Handler;", "Lcom/anthropic/errors/AnthropicError;", "retrieveHandler", "Lcom/anthropic/models/ModelInfo;", "retrieve", "Ljava/util/concurrent/CompletableFuture;", "params", "Lcom/anthropic/models/ModelRetrieveParams;", "requestOptions", "Lcom/anthropic/core/RequestOptions;", "listHandler", "Lcom/anthropic/models/ModelListPageAsync$Response;", "list", "Lcom/anthropic/models/ModelListPageAsync;", "Lcom/anthropic/models/ModelListParams;", "anthropic-java-core"})
@SourceDebugExtension(value={"SMAP\nModelServiceAsyncImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelServiceAsyncImpl.kt\ncom/anthropic/services/async/ModelServiceAsyncImpl\n+ 2 JsonHandler.kt\ncom/anthropic/core/handlers/JsonHandler\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n13#2,9:93\n13#2,9:102\n1#3:111\n*S KotlinDebug\n*F\n+ 1 ModelServiceAsyncImpl.kt\ncom/anthropic/services/async/ModelServiceAsyncImpl\n*L\n27#1:93,9\n59#1:102,9\n*E\n"})
public final class ModelServiceAsyncImpl
implements ModelServiceAsync {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<AnthropicError> errorHandler;
    @NotNull
    private final HttpResponse.Handler<ModelInfo> retrieveHandler;
    @NotNull
    private final HttpResponse.Handler<ModelListPageAsync.Response> listHandler;

    public ModelServiceAsyncImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.retrieveHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ModelInfo>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public ModelInfo handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ModelInfo>(){});
                }
                catch (Exception e) {
                    throw new AnthropicException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.listHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ModelListPageAsync.Response>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public ModelListPageAsync.Response handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ModelListPageAsync.Response>(){});
                }
                catch (Exception e) {
                    throw new AnthropicException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    @Override
    @NotNull
    public CompletableFuture<ModelInfo> retrieve(@NotNull ModelRetrieveParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"v1", "models", params.getPathParam(0)};
        CompletableFuture request = PrepareRequest.prepareAsync(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params);
        CompletionStage completionStage = ((CompletableFuture)request.thenComposeAsync(arg_0 -> ModelServiceAsyncImpl.retrieve$lambda$1(arg_0 -> ModelServiceAsyncImpl.retrieve$lambda$0(this, requestOptions, arg_0), arg_0))).thenApply(arg_0 -> ModelServiceAsyncImpl.retrieve$lambda$5(arg_0 -> ModelServiceAsyncImpl.retrieve$lambda$4(this, requestOptions, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<ModelListPageAsync> list(@NotNull ModelListParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"v1", "models"};
        CompletableFuture request = PrepareRequest.prepareAsync(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params);
        CompletionStage completionStage = ((CompletableFuture)request.thenComposeAsync(arg_0 -> ModelServiceAsyncImpl.list$lambda$7(arg_0 -> ModelServiceAsyncImpl.list$lambda$6(this, requestOptions, arg_0), arg_0))).thenApply(arg_0 -> ModelServiceAsyncImpl.list$lambda$12(arg_0 -> ModelServiceAsyncImpl.list$lambda$11(this, requestOptions, params, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private static final CompletionStage retrieve$lambda$0(ModelServiceAsyncImpl this$0, RequestOptions $requestOptions, HttpRequest it) {
        HttpClient httpClient = this$0.clientOptions.httpClient();
        Intrinsics.checkNotNull((Object)it);
        return httpClient.executeAsync(it, $requestOptions);
    }

    private static final CompletionStage retrieve$lambda$1(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ModelInfo retrieve$lambda$4(ModelServiceAsyncImpl this$0, RequestOptions $requestOptions, HttpResponse response) {
        Object it;
        Object object = response;
        Throwable throwable = null;
        try {
            it = (HttpResponse)object;
            boolean bl = false;
            HttpResponse.Handler<ModelInfo> handler = this$0.retrieveHandler;
            Intrinsics.checkNotNull((Object)it);
            it = handler.handle((HttpResponse)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object it2 = object = it;
        boolean bl = false;
        Boolean bl2 = $requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this$0.clientOptions.responseValidation()) {
            ((ModelInfo)it2).validate();
        }
        return object;
    }

    private static final ModelInfo retrieve$lambda$5(Function1 $tmp0, Object p0) {
        return (ModelInfo)$tmp0.invoke(p0);
    }

    private static final CompletionStage list$lambda$6(ModelServiceAsyncImpl this$0, RequestOptions $requestOptions, HttpRequest it) {
        HttpClient httpClient = this$0.clientOptions.httpClient();
        Intrinsics.checkNotNull((Object)it);
        return httpClient.executeAsync(it, $requestOptions);
    }

    private static final CompletionStage list$lambda$7(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ModelListPageAsync list$lambda$11(ModelServiceAsyncImpl this$0, RequestOptions $requestOptions, ModelListParams $params, HttpResponse response) {
        Object it;
        Object object = response;
        Throwable throwable = null;
        try {
            it = (HttpResponse)object;
            boolean bl = false;
            HttpResponse.Handler<ModelListPageAsync.Response> handler = this$0.listHandler;
            Intrinsics.checkNotNull((Object)it);
            it = handler.handle((HttpResponse)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object it2 = object = it;
        boolean bl = false;
        Boolean bl2 = $requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this$0.clientOptions.responseValidation()) {
            ((ModelListPageAsync.Response)it2).validate();
        }
        it2 = object;
        boolean bl3 = false;
        return ModelListPageAsync.Companion.of(this$0, $params, (ModelListPageAsync.Response)it2);
    }

    private static final ModelListPageAsync list$lambda$12(Function1 $tmp0, Object p0) {
        return (ModelListPageAsync)$tmp0.invoke(p0);
    }
}

