/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.models;

import com.anthropic.core.BaseDeserializer;
import com.anthropic.core.BaseSerializer;
import com.anthropic.core.Check;
import com.anthropic.core.ExcludeMissing;
import com.anthropic.core.JsonField;
import com.anthropic.core.JsonMissing;
import com.anthropic.core.JsonValue;
import com.anthropic.core.NoAutoDetect;
import com.anthropic.core.Utils;
import com.anthropic.errors.AnthropicInvalidDataException;
import com.anthropic.models.Base64ImageSource;
import com.anthropic.models.CacheControlEphemeral;
import com.anthropic.models.UrlImageSource;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NoAutoDetect
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\b\u0007\u0018\u0000 !2\u00020\u0001:\u0003!\"#BI\b\u0003\u0012\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0003\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0003\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0014\b\u0003\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0002\u001a\u00020\u0004J\b\u0010\u000e\u001a\u00020\u0006H\u0007J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u000fJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0007J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u0007J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\nH\u0007J\u0006\u0010\u0015\u001a\u00020\u0000J\u0006\u0010\u0016\u001a\u00020\u0017J\u0013\u0010\u0018\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006$"}, d2={"Lcom/anthropic/models/ImageBlockParam;", "", "source", "Lcom/anthropic/core/JsonField;", "Lcom/anthropic/models/ImageBlockParam$Source;", "type", "Lcom/anthropic/core/JsonValue;", "cacheControl", "Lcom/anthropic/models/CacheControlEphemeral;", "additionalProperties", "", "", "<init>", "(Lcom/anthropic/core/JsonField;Lcom/anthropic/core/JsonValue;Lcom/anthropic/core/JsonField;Ljava/util/Map;)V", "_type", "Ljava/util/Optional;", "_source", "_cacheControl", "_additionalProperties", "validated", "", "validate", "toBuilder", "Lcom/anthropic/models/ImageBlockParam$Builder;", "equals", "other", "hashCode", "", "getHashCode", "()I", "hashCode$delegate", "Lkotlin/Lazy;", "toString", "Companion", "Builder", "Source", "anthropic-java-core"})
public final class ImageBlockParam {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonField<Source> source;
    @NotNull
    private final JsonValue type;
    @NotNull
    private final JsonField<CacheControlEphemeral> cacheControl;
    @NotNull
    private final Map<String, JsonValue> additionalProperties;
    private boolean validated;
    @NotNull
    private final Lazy hashCode$delegate;

    @JsonCreator
    private ImageBlockParam(@JsonProperty(value="source") @ExcludeMissing JsonField<Source> source, @JsonProperty(value="type") @ExcludeMissing JsonValue type, @JsonProperty(value="cache_control") @ExcludeMissing JsonField<CacheControlEphemeral> cacheControl, @JsonAnySetter Map<String, ? extends JsonValue> additionalProperties) {
        this.source = source;
        this.type = type;
        this.cacheControl = cacheControl;
        this.additionalProperties = additionalProperties;
        this.hashCode$delegate = LazyKt.lazy(() -> ImageBlockParam.hashCode_delegate$lambda$4(this));
    }

    /* synthetic */ ImageBlockParam(JsonField jsonField, JsonValue jsonValue, JsonField jsonField2, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            jsonField = JsonMissing.Companion.of();
        }
        if ((n & 2) != 0) {
            jsonValue = JsonMissing.Companion.of();
        }
        if ((n & 4) != 0) {
            jsonField2 = JsonMissing.Companion.of();
        }
        if ((n & 8) != 0) {
            map2 = Utils.immutableEmptyMap();
        }
        this(jsonField, jsonValue, jsonField2, map2);
    }

    @NotNull
    public final Source source() {
        return (Source)this.source.getRequired$anthropic_java_core("source");
    }

    @JsonProperty(value="type")
    @ExcludeMissing
    @NotNull
    public final JsonValue _type() {
        return this.type;
    }

    @NotNull
    public final Optional<CacheControlEphemeral> cacheControl() {
        Optional<Object> optional = Optional.ofNullable(this.cacheControl.getNullable$anthropic_java_core("cache_control"));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @JsonProperty(value="source")
    @ExcludeMissing
    @NotNull
    public final JsonField<Source> _source() {
        return this.source;
    }

    @JsonProperty(value="cache_control")
    @ExcludeMissing
    @NotNull
    public final JsonField<CacheControlEphemeral> _cacheControl() {
        return this.cacheControl;
    }

    @JsonAnyGetter
    @ExcludeMissing
    @NotNull
    public final Map<String, JsonValue> _additionalProperties() {
        return this.additionalProperties;
    }

    @NotNull
    public final ImageBlockParam validate() {
        ImageBlockParam imageBlockParam;
        ImageBlockParam $this$validate_u24lambda_u243 = imageBlockParam = this;
        boolean bl = false;
        if (!$this$validate_u24lambda_u243.validated) {
            $this$validate_u24lambda_u243.source().validate();
            JsonValue it = $this$validate_u24lambda_u243._type();
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)it, (Object)JsonValue.Companion.from("image"))) {
                throw new AnthropicInvalidDataException("'type' is invalid, received " + it, null, 2, null);
            }
            $this$validate_u24lambda_u243.cacheControl().ifPresent(arg_0 -> ImageBlockParam.validate$lambda$3$lambda$2(ImageBlockParam::validate$lambda$3$lambda$1, arg_0));
            $this$validate_u24lambda_u243.validated = true;
        }
        return imageBlockParam;
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder().from$anthropic_java_core(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ImageBlockParam && Intrinsics.areEqual(this.source, ((ImageBlockParam)other).source) && Intrinsics.areEqual((Object)this.type, (Object)((ImageBlockParam)other).type) && Intrinsics.areEqual(this.cacheControl, ((ImageBlockParam)other).cacheControl) && Intrinsics.areEqual(this.additionalProperties, ((ImageBlockParam)other).additionalProperties);
    }

    private final int getHashCode() {
        Lazy lazy = this.hashCode$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public int hashCode() {
        return this.getHashCode();
    }

    @NotNull
    public String toString() {
        return "ImageBlockParam{source=" + this.source + ", type=" + this.type + ", cacheControl=" + this.cacheControl + ", additionalProperties=" + this.additionalProperties + '}';
    }

    private static final Unit validate$lambda$3$lambda$1(CacheControlEphemeral it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.validate();
        return Unit.INSTANCE;
    }

    private static final void validate$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final int hashCode_delegate$lambda$4(ImageBlockParam this$0) {
        Object[] objectArray = new Object[]{this$0.source, this$0.type, this$0.cacheControl, this$0.additionalProperties};
        return Objects.hash(objectArray);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public /* synthetic */ ImageBlockParam(JsonField source, JsonValue type, JsonField cacheControl, Map additionalProperties, DefaultConstructorMarker $constructor_marker) {
        this(source, type, cacheControl, additionalProperties);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0006J\u0014\u0010\u0004\u001a\u00020\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\rJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0014\u0010\t\u001a\u00020\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0018J\u0014\u0010\t\u001a\u00020\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005J\u001a\u0010\u000b\u001a\u00020\u00002\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\u0019J\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\bJ\u001a\u0010\u001d\u001a\u00020\u00002\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\u0019J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\rJ\u0014\u0010\u001f\u001a\u00020\u00002\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0!J\u0006\u0010\"\u001a\u00020\u0010R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/anthropic/models/ImageBlockParam$Builder;", "", "<init>", "()V", "source", "Lcom/anthropic/core/JsonField;", "Lcom/anthropic/models/ImageBlockParam$Source;", "type", "Lcom/anthropic/core/JsonValue;", "cacheControl", "Lcom/anthropic/models/CacheControlEphemeral;", "additionalProperties", "", "", "from", "imageBlockParam", "Lcom/anthropic/models/ImageBlockParam;", "from$anthropic_java_core", "base64Image", "Lcom/anthropic/models/Base64ImageSource;", "urlImage", "Lcom/anthropic/models/UrlImageSource;", "urlImageSource", "url", "Ljava/util/Optional;", "", "putAdditionalProperty", "key", "value", "putAllAdditionalProperties", "removeAdditionalProperty", "removeAllAdditionalProperties", "keys", "", "build", "anthropic-java-core"})
    @SourceDebugExtension(value={"SMAP\nImageBlockParam.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageBlockParam.kt\ncom/anthropic/models/ImageBlockParam$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,312:1\n1#2:313\n1863#3,2:314\n*S KotlinDebug\n*F\n+ 1 ImageBlockParam.kt\ncom/anthropic/models/ImageBlockParam$Builder\n*L\n141#1:314,2\n*E\n"})
    public static final class Builder {
        @Nullable
        private JsonField<Source> source;
        @NotNull
        private JsonValue type = JsonValue.Companion.from("image");
        @NotNull
        private JsonField<CacheControlEphemeral> cacheControl = JsonMissing.Companion.of();
        @NotNull
        private Map<String, JsonValue> additionalProperties = new LinkedHashMap();

        public final /* synthetic */ Builder from$anthropic_java_core(ImageBlockParam imageBlockParam) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)imageBlockParam, (String)"imageBlockParam");
            Builder $this$from_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$from_u24lambda_u240.source = imageBlockParam.source;
            $this$from_u24lambda_u240.type = imageBlockParam.type;
            $this$from_u24lambda_u240.cacheControl = imageBlockParam.cacheControl;
            $this$from_u24lambda_u240.additionalProperties = MapsKt.toMutableMap((Map)imageBlockParam.additionalProperties);
            return builder;
        }

        @NotNull
        public final Builder source(@NotNull Source source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return this.source(JsonField.Companion.of(source));
        }

        @NotNull
        public final Builder source(@NotNull JsonField<Source> source) {
            Builder builder;
            Intrinsics.checkNotNullParameter(source, (String)"source");
            Builder $this$source_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$source_u24lambda_u241.source = source;
            return builder;
        }

        @NotNull
        public final Builder source(@NotNull Base64ImageSource base64Image) {
            Intrinsics.checkNotNullParameter((Object)base64Image, (String)"base64Image");
            return this.source(Source.Companion.ofBase64Image(base64Image));
        }

        @NotNull
        public final Builder source(@NotNull UrlImageSource urlImage) {
            Intrinsics.checkNotNullParameter((Object)urlImage, (String)"urlImage");
            return this.source(Source.Companion.ofUrlImage(urlImage));
        }

        @NotNull
        public final Builder urlImageSource(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return this.source(UrlImageSource.Companion.builder().url(url).build());
        }

        @NotNull
        public final Builder type(@NotNull JsonValue type) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Builder $this$type_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$type_u24lambda_u242.type = type;
            return builder;
        }

        @NotNull
        public final Builder cacheControl(@Nullable CacheControlEphemeral cacheControl) {
            return this.cacheControl(JsonField.Companion.ofNullable(cacheControl));
        }

        @NotNull
        public final Builder cacheControl(@NotNull Optional<CacheControlEphemeral> cacheControl) {
            Intrinsics.checkNotNullParameter(cacheControl, (String)"cacheControl");
            return this.cacheControl((CacheControlEphemeral)cacheControl.orElse(null));
        }

        @NotNull
        public final Builder cacheControl(@NotNull JsonField<CacheControlEphemeral> cacheControl) {
            Builder builder;
            Intrinsics.checkNotNullParameter(cacheControl, (String)"cacheControl");
            Builder $this$cacheControl_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$cacheControl_u24lambda_u243.cacheControl = cacheControl;
            return builder;
        }

        @NotNull
        public final Builder additionalProperties(@NotNull Map<String, ? extends JsonValue> additionalProperties) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalProperties, (String)"additionalProperties");
            Builder $this$additionalProperties_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$additionalProperties_u24lambda_u244.additionalProperties.clear();
            $this$additionalProperties_u24lambda_u244.putAllAdditionalProperties(additionalProperties);
            return builder;
        }

        @NotNull
        public final Builder putAdditionalProperty(@NotNull String key, @NotNull JsonValue value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$putAdditionalProperty_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$putAdditionalProperty_u24lambda_u245.additionalProperties.put(key, value);
            return builder;
        }

        @NotNull
        public final Builder putAllAdditionalProperties(@NotNull Map<String, ? extends JsonValue> additionalProperties) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalProperties, (String)"additionalProperties");
            Builder $this$putAllAdditionalProperties_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$putAllAdditionalProperties_u24lambda_u246.additionalProperties.putAll(additionalProperties);
            return builder;
        }

        @NotNull
        public final Builder removeAdditionalProperty(@NotNull String key) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Builder $this$removeAdditionalProperty_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$removeAdditionalProperty_u24lambda_u247.additionalProperties.remove(key);
            return builder;
        }

        @NotNull
        public final Builder removeAllAdditionalProperties(@NotNull Set<String> keys) {
            Builder builder;
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            Builder $this$removeAllAdditionalProperties_u24lambda_u248 = builder = this;
            boolean bl = false;
            Iterable $this$forEach$iv = keys;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String p0 = (String)element$iv;
                boolean bl2 = false;
                $this$removeAllAdditionalProperties_u24lambda_u248.removeAdditionalProperty(p0);
            }
            return builder;
        }

        @NotNull
        public final ImageBlockParam build() {
            return new ImageBlockParam(Check.checkRequired("source", this.source), this.type, this.cacheControl, Utils.toImmutable(this.additionalProperties), null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/anthropic/models/ImageBlockParam$Companion;", "", "<init>", "()V", "builder", "Lcom/anthropic/models/ImageBlockParam$Builder;", "anthropic-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @JsonDeserialize(using=Deserializer.class)
    @JsonSerialize(using=Serializer.class)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0004\u001d\u001e\u001f B-\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\nJ\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0005J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\u001f\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0016\u001a\u00020\u0000J\u0013\u0010\u0017\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/anthropic/models/ImageBlockParam$Source;", "", "base64Image", "Lcom/anthropic/models/Base64ImageSource;", "urlImage", "Lcom/anthropic/models/UrlImageSource;", "_json", "Lcom/anthropic/core/JsonValue;", "<init>", "(Lcom/anthropic/models/Base64ImageSource;Lcom/anthropic/models/UrlImageSource;Lcom/anthropic/core/JsonValue;)V", "Ljava/util/Optional;", "isBase64Image", "", "isUrlImage", "asBase64Image", "asUrlImage", "accept", "T", "visitor", "Lcom/anthropic/models/ImageBlockParam$Source$Visitor;", "(Lcom/anthropic/models/ImageBlockParam$Source$Visitor;)Ljava/lang/Object;", "validated", "validate", "equals", "other", "hashCode", "", "toString", "", "Companion", "Visitor", "Deserializer", "Serializer", "anthropic-java-core"})
    public static final class Source {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Base64ImageSource base64Image;
        @Nullable
        private final UrlImageSource urlImage;
        @Nullable
        private final JsonValue _json;
        private boolean validated;

        private Source(Base64ImageSource base64Image, UrlImageSource urlImage, JsonValue _json) {
            this.base64Image = base64Image;
            this.urlImage = urlImage;
            this._json = _json;
        }

        /* synthetic */ Source(Base64ImageSource base64ImageSource, UrlImageSource urlImageSource, JsonValue jsonValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                base64ImageSource = null;
            }
            if ((n & 2) != 0) {
                urlImageSource = null;
            }
            if ((n & 4) != 0) {
                jsonValue = null;
            }
            this(base64ImageSource, urlImageSource, jsonValue);
        }

        @NotNull
        public final Optional<Base64ImageSource> base64Image() {
            Optional<Base64ImageSource> optional = Optional.ofNullable(this.base64Image);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            return optional;
        }

        @NotNull
        public final Optional<UrlImageSource> urlImage() {
            Optional<UrlImageSource> optional = Optional.ofNullable(this.urlImage);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            return optional;
        }

        public final boolean isBase64Image() {
            return this.base64Image != null;
        }

        public final boolean isUrlImage() {
            return this.urlImage != null;
        }

        @NotNull
        public final Base64ImageSource asBase64Image() {
            return (Base64ImageSource)Utils.getOrThrow(this.base64Image, "base64Image");
        }

        @NotNull
        public final UrlImageSource asUrlImage() {
            return (UrlImageSource)Utils.getOrThrow(this.urlImage, "urlImage");
        }

        @NotNull
        public final Optional<JsonValue> _json() {
            Optional<JsonValue> optional = Optional.ofNullable(this._json);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            return optional;
        }

        public final <T> T accept(@NotNull Visitor<? extends T> visitor) {
            Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
            return this.base64Image != null ? visitor.visitBase64Image(this.base64Image) : (this.urlImage != null ? visitor.visitUrlImage(this.urlImage) : visitor.unknown(this._json));
        }

        @NotNull
        public final Source validate() {
            Source source;
            Source $this$validate_u24lambda_u240 = source = this;
            boolean bl = false;
            if (!$this$validate_u24lambda_u240.validated) {
                $this$validate_u24lambda_u240.accept((Visitor)new Visitor<Unit>(){

                    public void visitBase64Image(Base64ImageSource base64Image) {
                        Intrinsics.checkNotNullParameter((Object)base64Image, (String)"base64Image");
                        base64Image.validate();
                    }

                    public void visitUrlImage(UrlImageSource urlImage) {
                        Intrinsics.checkNotNullParameter((Object)urlImage, (String)"urlImage");
                        urlImage.validate();
                    }
                });
                $this$validate_u24lambda_u240.validated = true;
            }
            return source;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Source && Intrinsics.areEqual((Object)this.base64Image, (Object)((Source)other).base64Image) && Intrinsics.areEqual((Object)this.urlImage, (Object)((Source)other).urlImage);
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.base64Image, this.urlImage};
            return Objects.hash(objectArray);
        }

        @NotNull
        public String toString() {
            String string;
            if (this.base64Image != null) {
                string = "Source{base64Image=" + this.base64Image + '}';
            } else if (this.urlImage != null) {
                string = "Source{urlImage=" + this.urlImage + '}';
            } else if (this._json != null) {
                string = "Source{_unknown=" + this._json + '}';
            } else {
                throw new IllegalStateException("Invalid Source");
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public static final Source ofBase64Image(@NotNull Base64ImageSource base64Image) {
            return Companion.ofBase64Image(base64Image);
        }

        @JvmStatic
        @NotNull
        public static final Source ofUrlImage(@NotNull UrlImageSource urlImage) {
            return Companion.ofUrlImage(urlImage);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/anthropic/models/ImageBlockParam$Source$Companion;", "", "<init>", "()V", "ofBase64Image", "Lcom/anthropic/models/ImageBlockParam$Source;", "base64Image", "Lcom/anthropic/models/Base64ImageSource;", "ofUrlImage", "urlImage", "Lcom/anthropic/models/UrlImageSource;", "anthropic-java-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Source ofBase64Image(@NotNull Base64ImageSource base64Image) {
                Intrinsics.checkNotNullParameter((Object)base64Image, (String)"base64Image");
                return new Source(base64Image, null, null, 6, null);
            }

            @JvmStatic
            @NotNull
            public final Source ofUrlImage(@NotNull UrlImageSource urlImage) {
                Intrinsics.checkNotNullParameter((Object)urlImage, (String)"urlImage");
                return new Source(null, urlImage, null, 5, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u0002*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lcom/anthropic/models/ImageBlockParam$Source$Deserializer;", "Lcom/anthropic/core/BaseDeserializer;", "Lcom/anthropic/models/ImageBlockParam$Source;", "<init>", "()V", "deserialize", "Lcom/fasterxml/jackson/core/ObjectCodec;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "anthropic-java-core"})
        @SourceDebugExtension(value={"SMAP\nImageBlockParam.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageBlockParam.kt\ncom/anthropic/models/ImageBlockParam$Source$Deserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,312:1\n51#2:313\n51#2:314\n*S KotlinDebug\n*F\n+ 1 ImageBlockParam.kt\ncom/anthropic/models/ImageBlockParam$Source$Deserializer\n*L\n261#1:313\n267#1:314\n*E\n"})
        public static final class Deserializer
        extends BaseDeserializer<Source> {
            public Deserializer() {
                super(Reflection.getOrCreateKotlinClass(Source.class));
            }

            @Override
            @NotNull
            protected Source deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
                String type;
                Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                JsonValue json2 = JsonValue.Companion.fromJsonNode(node);
                Object object = (Map)OptionalsKt.getOrNull(json2.asObject());
                String string = type = object != null && (object = (JsonValue)object.get("type")) != null && (object = ((JsonField)object).asString()) != null ? (String)OptionalsKt.getOrNull(object) : null;
                if (Intrinsics.areEqual(string, (Object)"base64")) {
                    boolean $i$f$jacksonTypeRef = false;
                    Base64ImageSource base64ImageSource = (Base64ImageSource)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<Base64ImageSource>(){}, Deserializer::deserialize$lambda$0);
                    if (base64ImageSource != null) {
                        Base64ImageSource it = base64ImageSource;
                        boolean bl = false;
                        return new Source(it, null, json2, 2, null);
                    }
                } else if (Intrinsics.areEqual((Object)string, (Object)"url")) {
                    boolean $i$f$jacksonTypeRef = false;
                    UrlImageSource urlImageSource = (UrlImageSource)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<UrlImageSource>(){}, Deserializer::deserialize$lambda$2);
                    if (urlImageSource != null) {
                        UrlImageSource it = urlImageSource;
                        boolean bl = false;
                        return new Source(null, it, json2, 1, null);
                    }
                }
                return new Source(null, null, json2, 3, null);
            }

            private static final Unit deserialize$lambda$0(Base64ImageSource it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.validate();
                return Unit.INSTANCE;
            }

            private static final Unit deserialize$lambda$2(UrlImageSource it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.validate();
                return Unit.INSTANCE;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/anthropic/models/ImageBlockParam$Source$Serializer;", "Lcom/anthropic/core/BaseSerializer;", "Lcom/anthropic/models/ImageBlockParam$Source;", "<init>", "()V", "serialize", "", "value", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "anthropic-java-core"})
        public static final class Serializer
        extends BaseSerializer<Source> {
            public Serializer() {
                super(Reflection.getOrCreateKotlinClass(Source.class));
            }

            public void serialize(@NotNull Source value, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
                Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                if (value.base64Image != null) {
                    generator.writeObject((Object)value.base64Image);
                } else if (value.urlImage != null) {
                    generator.writeObject((Object)value.urlImage);
                } else if (value._json != null) {
                    generator.writeObject((Object)value._json);
                } else {
                    throw new IllegalStateException("Invalid Source");
                }
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\u000b\u001a\u00028\u00002\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/anthropic/models/ImageBlockParam$Source$Visitor;", "T", "", "visitBase64Image", "base64Image", "Lcom/anthropic/models/Base64ImageSource;", "(Lcom/anthropic/models/Base64ImageSource;)Ljava/lang/Object;", "visitUrlImage", "urlImage", "Lcom/anthropic/models/UrlImageSource;", "(Lcom/anthropic/models/UrlImageSource;)Ljava/lang/Object;", "unknown", "json", "Lcom/anthropic/core/JsonValue;", "(Lcom/anthropic/core/JsonValue;)Ljava/lang/Object;", "anthropic-java-core"})
        public static interface Visitor<T> {
            public T visitBase64Image(@NotNull Base64ImageSource var1);

            public T visitUrlImage(@NotNull UrlImageSource var1);

            default public T unknown(@Nullable JsonValue json2) {
                throw new AnthropicInvalidDataException("Unknown Source: " + json2, null, 2, null);
            }
        }
    }
}

