/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.services.async;

import com.anthropic.core.ClientOptions;
import com.anthropic.core.PrepareRequest;
import com.anthropic.core.RequestOptions;
import com.anthropic.core.handlers.ErrorHandler;
import com.anthropic.core.http.HttpClient;
import com.anthropic.core.http.HttpMethod;
import com.anthropic.core.http.HttpRequest;
import com.anthropic.core.http.HttpResponse;
import com.anthropic.core.http.HttpResponseFor;
import com.anthropic.core.http.HttpResponseForKt;
import com.anthropic.errors.AnthropicError;
import com.anthropic.errors.AnthropicException;
import com.anthropic.models.ModelInfo;
import com.anthropic.models.ModelListPageAsync;
import com.anthropic.models.ModelListParams;
import com.anthropic.models.ModelRetrieveParams;
import com.anthropic.services.async.ModelServiceAsync;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\u0006\u0010\u000f\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/anthropic/services/async/ModelServiceAsyncImpl;", "Lcom/anthropic/services/async/ModelServiceAsync;", "clientOptions", "Lcom/anthropic/core/ClientOptions;", "<init>", "(Lcom/anthropic/core/ClientOptions;)V", "withRawResponse", "Lcom/anthropic/services/async/ModelServiceAsync$WithRawResponse;", "getWithRawResponse", "()Lcom/anthropic/services/async/ModelServiceAsync$WithRawResponse;", "withRawResponse$delegate", "Lkotlin/Lazy;", "retrieve", "Ljava/util/concurrent/CompletableFuture;", "Lcom/anthropic/models/ModelInfo;", "params", "Lcom/anthropic/models/ModelRetrieveParams;", "requestOptions", "Lcom/anthropic/core/RequestOptions;", "list", "Lcom/anthropic/models/ModelListPageAsync;", "Lcom/anthropic/models/ModelListParams;", "WithRawResponseImpl", "anthropic-java-core"})
public final class ModelServiceAsyncImpl
implements ModelServiceAsync {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final Lazy withRawResponse$delegate;

    public ModelServiceAsyncImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.withRawResponse$delegate = LazyKt.lazy(() -> ModelServiceAsyncImpl.withRawResponse_delegate$lambda$0(this));
    }

    private final ModelServiceAsync.WithRawResponse getWithRawResponse() {
        Lazy lazy = this.withRawResponse$delegate;
        return (ModelServiceAsync.WithRawResponse)lazy.getValue();
    }

    @Override
    @NotNull
    public ModelServiceAsync.WithRawResponse withRawResponse() {
        return this.getWithRawResponse();
    }

    @Override
    @NotNull
    public CompletableFuture<ModelInfo> retrieve(@NotNull ModelRetrieveParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        CompletionStage completionStage = this.withRawResponse().retrieve(params, requestOptions).thenApply(arg_0 -> ModelServiceAsyncImpl.retrieve$lambda$2(ModelServiceAsyncImpl::retrieve$lambda$1, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<ModelListPageAsync> list(@NotNull ModelListParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        CompletionStage completionStage = this.withRawResponse().list(params, requestOptions).thenApply(arg_0 -> ModelServiceAsyncImpl.list$lambda$4(ModelServiceAsyncImpl::list$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private static final WithRawResponseImpl withRawResponse_delegate$lambda$0(ModelServiceAsyncImpl this$0) {
        return new WithRawResponseImpl(this$0.clientOptions);
    }

    private static final ModelInfo retrieve$lambda$1(HttpResponseFor it) {
        return (ModelInfo)it.parse();
    }

    private static final ModelInfo retrieve$lambda$2(Function1 $tmp0, Object p0) {
        return (ModelInfo)$tmp0.invoke(p0);
    }

    private static final ModelListPageAsync list$lambda$3(HttpResponseFor it) {
        return (ModelListPageAsync)it.parse();
    }

    private static final ModelListPageAsync list$lambda$4(Function1 $tmp0, Object p0) {
        return (ModelListPageAsync)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\r0\f2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/anthropic/services/async/ModelServiceAsyncImpl$WithRawResponseImpl;", "Lcom/anthropic/services/async/ModelServiceAsync$WithRawResponse;", "clientOptions", "Lcom/anthropic/core/ClientOptions;", "<init>", "(Lcom/anthropic/core/ClientOptions;)V", "errorHandler", "Lcom/anthropic/core/http/HttpResponse$Handler;", "Lcom/anthropic/errors/AnthropicError;", "retrieveHandler", "Lcom/anthropic/models/ModelInfo;", "retrieve", "Ljava/util/concurrent/CompletableFuture;", "Lcom/anthropic/core/http/HttpResponseFor;", "params", "Lcom/anthropic/models/ModelRetrieveParams;", "requestOptions", "Lcom/anthropic/core/RequestOptions;", "listHandler", "Lcom/anthropic/models/ModelListPageAsync$Response;", "list", "Lcom/anthropic/models/ModelListPageAsync;", "Lcom/anthropic/models/ModelListParams;", "anthropic-java-core"})
    @SourceDebugExtension(value={"SMAP\nModelServiceAsyncImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelServiceAsyncImpl.kt\ncom/anthropic/services/async/ModelServiceAsyncImpl$WithRawResponseImpl\n+ 2 JsonHandler.kt\ncom/anthropic/core/handlers/JsonHandler\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n13#2,9:119\n13#2,9:128\n1#3:137\n*S KotlinDebug\n*F\n+ 1 ModelServiceAsyncImpl.kt\ncom/anthropic/services/async/ModelServiceAsyncImpl$WithRawResponseImpl\n*L\n52#1:119,9\n81#1:128,9\n*E\n"})
    public static final class WithRawResponseImpl
    implements ModelServiceAsync.WithRawResponse {
        @NotNull
        private final ClientOptions clientOptions;
        @NotNull
        private final HttpResponse.Handler<AnthropicError> errorHandler;
        @NotNull
        private final HttpResponse.Handler<ModelInfo> retrieveHandler;
        @NotNull
        private final HttpResponse.Handler<ModelListPageAsync.Response> listHandler;

        public WithRawResponseImpl(@NotNull ClientOptions clientOptions) {
            Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
            this.clientOptions = clientOptions;
            this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
            JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
            boolean $i$f$jsonHandler = false;
            this.retrieveHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ModelInfo>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public ModelInfo handle(HttpResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ModelInfo>(){});
                    }
                    catch (Exception e) {
                        throw new AnthropicException("Error reading response", e);
                    }
                }
            }, this.errorHandler);
            jsonMapper$iv = this.clientOptions.jsonMapper();
            $i$f$jsonHandler = false;
            this.listHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ModelListPageAsync.Response>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public ModelListPageAsync.Response handle(HttpResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ModelListPageAsync.Response>(){});
                    }
                    catch (Exception e) {
                        throw new AnthropicException("Error reading response", e);
                    }
                }
            }, this.errorHandler);
        }

        @Override
        @NotNull
        public CompletableFuture<HttpResponseFor<ModelInfo>> retrieve(@NotNull ModelRetrieveParams params, @NotNull RequestOptions requestOptions) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            String[] stringArray = new String[]{"v1", "models", params.getPathParam(0)};
            CompletableFuture request = PrepareRequest.prepareAsync(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$anthropic_java_core(this.clientOptions));
            CompletionStage completionStage = ((CompletableFuture)request.thenComposeAsync(arg_0 -> WithRawResponseImpl.retrieve$lambda$1(arg_0 -> WithRawResponseImpl.retrieve$lambda$0(this, requestOptions2, arg_0), arg_0))).thenApply(arg_0 -> WithRawResponseImpl.retrieve$lambda$6(arg_0 -> WithRawResponseImpl.retrieve$lambda$5(this, requestOptions2, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
            return completionStage;
        }

        @Override
        @NotNull
        public CompletableFuture<HttpResponseFor<ModelListPageAsync>> list(@NotNull ModelListParams params, @NotNull RequestOptions requestOptions) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            String[] stringArray = new String[]{"v1", "models"};
            CompletableFuture request = PrepareRequest.prepareAsync(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$anthropic_java_core(this.clientOptions));
            CompletionStage completionStage = ((CompletableFuture)request.thenComposeAsync(arg_0 -> WithRawResponseImpl.list$lambda$8(arg_0 -> WithRawResponseImpl.list$lambda$7(this, requestOptions2, arg_0), arg_0))).thenApply(arg_0 -> WithRawResponseImpl.list$lambda$14(arg_0 -> WithRawResponseImpl.list$lambda$13(this, requestOptions2, params, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
            return completionStage;
        }

        private static final CompletionStage retrieve$lambda$0(WithRawResponseImpl this$0, RequestOptions $requestOptions, HttpRequest it) {
            HttpClient httpClient = this$0.clientOptions.httpClient();
            Intrinsics.checkNotNull((Object)it);
            return httpClient.executeAsync(it, $requestOptions);
        }

        private static final CompletionStage retrieve$lambda$1(Function1 $tmp0, Object p0) {
            return (CompletionStage)$tmp0.invoke(p0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final ModelInfo retrieve$lambda$5$lambda$4(HttpResponse $response, WithRawResponseImpl this$0, RequestOptions $requestOptions) {
            Object it;
            Object object = $response;
            Throwable throwable = null;
            try {
                it = (HttpResponse)object;
                boolean bl = false;
                HttpResponse.Handler<ModelInfo> handler = this$0.retrieveHandler;
                Intrinsics.checkNotNull((Object)it);
                it = handler.handle((HttpResponse)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            Object it2 = object = it;
            boolean bl = false;
            Boolean bl2 = $requestOptions.getResponseValidation();
            Intrinsics.checkNotNull((Object)bl2);
            if (bl2.booleanValue()) {
                ((ModelInfo)it2).validate();
            }
            return object;
        }

        private static final HttpResponseFor retrieve$lambda$5(WithRawResponseImpl this$0, RequestOptions $requestOptions, HttpResponse response) {
            Intrinsics.checkNotNull((Object)response);
            return HttpResponseForKt.parseable(response, () -> WithRawResponseImpl.retrieve$lambda$5$lambda$4(response, this$0, $requestOptions));
        }

        private static final HttpResponseFor retrieve$lambda$6(Function1 $tmp0, Object p0) {
            return (HttpResponseFor)$tmp0.invoke(p0);
        }

        private static final CompletionStage list$lambda$7(WithRawResponseImpl this$0, RequestOptions $requestOptions, HttpRequest it) {
            HttpClient httpClient = this$0.clientOptions.httpClient();
            Intrinsics.checkNotNull((Object)it);
            return httpClient.executeAsync(it, $requestOptions);
        }

        private static final CompletionStage list$lambda$8(Function1 $tmp0, Object p0) {
            return (CompletionStage)$tmp0.invoke(p0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final ModelListPageAsync list$lambda$13$lambda$12(HttpResponse $response, WithRawResponseImpl this$0, RequestOptions $requestOptions, ModelListParams $params) {
            Object it;
            Object object = $response;
            Throwable throwable = null;
            try {
                it = (HttpResponse)object;
                boolean bl = false;
                HttpResponse.Handler<ModelListPageAsync.Response> handler = this$0.listHandler;
                Intrinsics.checkNotNull((Object)it);
                it = handler.handle((HttpResponse)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            Object it2 = object = it;
            boolean bl = false;
            Boolean bl2 = $requestOptions.getResponseValidation();
            Intrinsics.checkNotNull((Object)bl2);
            if (bl2.booleanValue()) {
                ((ModelListPageAsync.Response)it2).validate();
            }
            it2 = object;
            boolean bl3 = false;
            return ModelListPageAsync.Companion.of(new ModelServiceAsyncImpl(this$0.clientOptions), $params, (ModelListPageAsync.Response)it2);
        }

        private static final HttpResponseFor list$lambda$13(WithRawResponseImpl this$0, RequestOptions $requestOptions, ModelListParams $params, HttpResponse response) {
            Intrinsics.checkNotNull((Object)response);
            return HttpResponseForKt.parseable(response, () -> WithRawResponseImpl.list$lambda$13$lambda$12(response, this$0, $requestOptions, $params));
        }

        private static final HttpResponseFor list$lambda$14(Function1 $tmp0, Object p0) {
            return (HttpResponseFor)$tmp0.invoke(p0);
        }
    }
}

