/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.core.http;

import com.anthropic.core.MultipartField;
import com.anthropic.core.http.HttpRequestBodies;
import com.anthropic.core.http.HttpRequestBody;
import com.anthropic.errors.AnthropicInvalidDataException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u0001\"\u0006\b\u0000\u0010\u0002\u0018\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u0002H\u0002H\u0086\b\u00a2\u0006\u0002\u0010\u0006\u001a\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0003\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001\u001a(\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\rH\u0000\u00a8\u0006\u0010"}, d2={"json", "Lcom/anthropic/core/http/HttpRequestBody;", "T", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "value", "(Lcom/fasterxml/jackson/databind/json/JsonMapper;Ljava/lang/Object;)Lcom/anthropic/core/http/HttpRequestBody;", "bodyToJson", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "body", "multipartFormData", "fields", "", "", "Lcom/anthropic/core/MultipartField;", "anthropic-java-core"})
@JvmName(name="HttpRequestBodies")
public final class HttpRequestBodies {
    public static final /* synthetic */ <T> HttpRequestBody json(JsonMapper jsonMapper, T value) {
        Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
        boolean $i$f$json = false;
        return new HttpRequestBody(jsonMapper, value){
            private final Lazy bytes$delegate;
            {
                this.bytes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>($jsonMapper, $value){
                    final /* synthetic */ JsonMapper $jsonMapper;
                    final /* synthetic */ T $value;
                    {
                        this.$jsonMapper = $jsonMapper;
                        this.$value = $value;
                    }

                    public final byte[] invoke() {
                        return this.$jsonMapper.writeValueAsBytes(this.$value);
                    }
                }));
            }

            private final byte[] getBytes() {
                Lazy lazy = this.bytes$delegate;
                Object object = lazy.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                return (byte[])object;
            }

            public void writeTo(OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.getBytes());
            }

            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.getBytes().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        };
    }

    public static final /* synthetic */ ObjectNode bodyToJson(ObjectMapper jsonMapper, HttpRequestBody body) {
        Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
        ByteArrayOutputStream jsonData = new ByteArrayOutputStream();
        HttpRequestBody httpRequestBody = body;
        if (httpRequestBody != null) {
            httpRequestBody.writeTo(jsonData);
        }
        if (jsonData.size() > 0) {
            return (ObjectNode)jsonMapper.readValue(jsonData.toByteArray(), ObjectNode.class);
        }
        return null;
    }

    public static final /* synthetic */ HttpRequestBody multipartFormData(JsonMapper jsonMapper, Map fields) {
        Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        return new HttpRequestBody(fields, jsonMapper){
            private final Lazy entity$delegate;
            {
                this.entity$delegate = LazyKt.lazy(() -> multipartFormData.1.entity_delegate$lambda$3($fields, $jsonMapper, this));
            }

            private final HttpEntity getEntity() {
                Lazy lazy = this.entity$delegate;
                Object object = lazy.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                return (HttpEntity)object;
            }

            private final Sequence<Pair<String, InputStream>> serializePart(String name, JsonNode node) {
                Sequence sequence2;
                JsonNodeType jsonNodeType = node.getNodeType();
                switch (jsonNodeType == null ? -1 : multipartFormData.WhenMappings.$EnumSwitchMapping$0[jsonNodeType.ordinal()]) {
                    case 1: 
                    case 2: {
                        sequence2 = SequencesKt.emptySequence();
                        break;
                    }
                    case 6: {
                        Object[] objectArray = new Pair[]{TuplesKt.to((Object)name, (Object)new ByteArrayInputStream(node.binaryValue()))};
                        sequence2 = SequencesKt.sequenceOf((Object[])objectArray);
                        break;
                    }
                    case 3: {
                        Object[] objectArray = new Pair[1];
                        String string = node.textValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textValue(...)");
                        objectArray[0] = TuplesKt.to((Object)name, (Object)this.toInputStream(string));
                        sequence2 = SequencesKt.sequenceOf((Object[])objectArray);
                        break;
                    }
                    case 4: {
                        Object[] objectArray = new Pair[]{TuplesKt.to((Object)name, (Object)this.toInputStream(String.valueOf(node.booleanValue())))};
                        sequence2 = SequencesKt.sequenceOf((Object[])objectArray);
                        break;
                    }
                    case 5: {
                        Object[] objectArray = new Pair[]{TuplesKt.to((Object)name, (Object)this.toInputStream(node.numberValue().toString()))};
                        sequence2 = SequencesKt.sequenceOf((Object[])objectArray);
                        break;
                    }
                    case 7: {
                        Object[] objectArray = new Pair[1];
                        Iterator iterator2 = node.elements();
                        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"elements(...)");
                        objectArray[0] = TuplesKt.to((Object)name, (Object)this.toInputStream(SequencesKt.joinToString$default((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.asSequence((Iterator)iterator2), arg_0 -> multipartFormData.1.serializePart$lambda$4(node, arg_0)), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
                        sequence2 = SequencesKt.sequenceOf((Object[])objectArray);
                        break;
                    }
                    case 8: {
                        Iterator iterator3 = node.fields();
                        Intrinsics.checkNotNullExpressionValue((Object)iterator3, (String)"fields(...)");
                        sequence2 = SequencesKt.flatMap((Sequence)SequencesKt.asSequence((Iterator)iterator3), arg_0 -> multipartFormData.1.serializePart$lambda$5(this, name, arg_0));
                        break;
                    }
                    case -1: 
                    case 9: {
                        throw new AnthropicInvalidDataException("Unexpected JsonNode type: " + node.getNodeType(), null, 2, null);
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return sequence2;
            }

            private final InputStream toInputStream(String $this$toInputStream) {
                String string = $this$toInputStream;
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                return new ByteArrayInputStream(byArray);
            }

            public void writeTo(OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                this.getEntity().writeTo(outputStream);
            }

            public String contentType() {
                String string = this.getEntity().getContentType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContentType(...)");
                return string;
            }

            public long contentLength() {
                return this.getEntity().getContentLength();
            }

            public boolean repeatable() {
                return this.getEntity().isRepeatable();
            }

            public void close() {
                this.getEntity().close();
            }

            private static final HttpEntity entity_delegate$lambda$3(Map $fields, JsonMapper $jsonMapper, multipartFormData.1 this$0) {
                MultipartEntityBuilder multipartEntityBuilder;
                MultipartEntityBuilder $this$entity_delegate_u24lambda_u243_u24lambda_u242 = multipartEntityBuilder = MultipartEntityBuilder.create();
                boolean bl = false;
                Map $this$forEach$iv = $fields;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Sequence<Pair<String, InputStream>> parts;
                    Sequence<Pair<String, InputStream>> sequence2;
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> entry = element$iv = iterator2.next();
                    boolean bl2 = false;
                    String name = (String)entry.getKey();
                    MultipartField field = (MultipartField)entry.getValue();
                    Object knownValue = OptionalsKt.getOrNull(field.value().asKnown());
                    if (knownValue instanceof InputStream) {
                        Object[] objectArray = new Pair[]{TuplesKt.to((Object)name, (Object)knownValue)};
                        sequence2 = SequencesKt.sequenceOf((Object[])objectArray);
                    } else {
                        JsonNode node = $jsonMapper.valueToTree(field.value());
                        Intrinsics.checkNotNull((Object)node);
                        sequence2 = this$0.serializePart(name, node);
                    }
                    Sequence<Pair<String, InputStream>> $this$forEach$iv2 = parts = sequence2;
                    boolean $i$f$forEach2 = false;
                    for (E element$iv2 : $this$forEach$iv2) {
                        Pair pair = (Pair)element$iv2;
                        boolean bl3 = false;
                        String name2 = (String)pair.component1();
                        InputStream bytes2 = (InputStream)pair.component2();
                        $this$entity_delegate_u24lambda_u243_u24lambda_u242.addBinaryBody(name2, bytes2, ContentType.parseLenient((CharSequence)field.contentType()), (String)OptionalsKt.getOrNull(field.filename()));
                    }
                }
                return multipartEntityBuilder.build();
            }

            private static final String serializePart$lambda$4(JsonNode $node, JsonNode element) {
                String string;
                JsonNodeType jsonNodeType = element.getNodeType();
                switch (jsonNodeType == null ? -1 : multipartFormData.WhenMappings.$EnumSwitchMapping$0[jsonNodeType.ordinal()]) {
                    case 1: 
                    case 2: {
                        string = null;
                        break;
                    }
                    case 3: {
                        string = $node.textValue();
                        break;
                    }
                    case 4: {
                        string = String.valueOf($node.booleanValue());
                        break;
                    }
                    case 5: {
                        string = $node.numberValue().toString();
                        break;
                    }
                    case -1: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        throw new AnthropicInvalidDataException("Unexpected JsonNode type in array: " + $node.getNodeType(), null, 2, null);
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }

            private static final Sequence serializePart$lambda$5(multipartFormData.1 this$0, String $name, Map.Entry entry) {
                Intrinsics.checkNotNull((Object)entry);
                String key = (String)entry.getKey();
                JsonNode value = (JsonNode)entry.getValue();
                String string = $name + '[' + key + ']';
                Intrinsics.checkNotNull((Object)value);
                return this$0.serializePart(string, value);
            }
        };
    }
}

