/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.core.http;

import com.anthropic.core.Check;
import com.anthropic.core.RequestOptions;
import com.anthropic.core.http.Headers;
import com.anthropic.core.http.HttpClient;
import com.anthropic.core.http.HttpRequest;
import com.anthropic.core.http.HttpRequestBody;
import com.anthropic.core.http.HttpResponse;
import com.anthropic.errors.AnthropicIoException;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0002!\"B+\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\b\u0010\u0019\u001a\u00020\bH\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/anthropic/core/http/RetryingHttpClient;", "Lcom/anthropic/core/http/HttpClient;", "httpClient", "clock", "Ljava/time/Clock;", "maxRetries", "", "idempotencyHeader", "", "<init>", "(Lcom/anthropic/core/http/HttpClient;Ljava/time/Clock;ILjava/lang/String;)V", "execute", "Lcom/anthropic/core/http/HttpResponse;", "request", "Lcom/anthropic/core/http/HttpRequest;", "requestOptions", "Lcom/anthropic/core/RequestOptions;", "executeAsync", "Ljava/util/concurrent/CompletableFuture;", "close", "", "isRetryable", "", "setRetryCountHeader", "retries", "idempotencyKey", "maybeAddIdempotencyHeader", "shouldRetry", "response", "throwable", "", "getRetryBackoffMillis", "Ljava/time/Duration;", "Companion", "Builder", "anthropic-java-core"})
public final class RetryingHttpClient
implements HttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final Clock clock;
    private final int maxRetries;
    @Nullable
    private final String idempotencyHeader;
    @NotNull
    private static final Timer TIMER = new Timer("RetryingHttpClient", true);

    private RetryingHttpClient(HttpClient httpClient, Clock clock, int maxRetries, String idempotencyHeader) {
        this.httpClient = httpClient;
        this.clock = clock;
        this.maxRetries = maxRetries;
        this.idempotencyHeader = idempotencyHeader;
    }

    @Override
    @NotNull
    public HttpResponse execute(@NotNull HttpRequest request, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        if (!this.isRetryable(request) || this.maxRetries <= 0) {
            return this.httpClient.execute(request, requestOptions);
        }
        HttpRequest modifiedRequest = this.maybeAddIdempotencyHeader(request);
        boolean shouldSendRetryCount = !modifiedRequest.headers().names().contains("X-Stainless-Retry-Count");
        int retries = 0;
        while (true) {
            HttpResponse response;
            if (shouldSendRetryCount) {
                modifiedRequest = this.setRetryCountHeader(modifiedRequest, retries);
            }
            try {
                response = this.httpClient.execute(modifiedRequest, requestOptions);
                if (++retries > this.maxRetries || !this.shouldRetry(response)) {
                    return response;
                }
            }
            catch (Throwable throwable) {
                if (++retries > this.maxRetries || !this.shouldRetry(throwable)) {
                    throw throwable;
                }
                response = null;
            }
            HttpResponse response2 = response;
            Duration backoffMillis = this.getRetryBackoffMillis(retries, response2);
            HttpResponse httpResponse = response2;
            if (httpResponse != null) {
                httpResponse.close();
            }
            Thread.sleep(backoffMillis.toMillis());
        }
    }

    @Override
    @NotNull
    public CompletableFuture<HttpResponse> executeAsync(@NotNull HttpRequest request, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        if (!this.isRetryable(request) || this.maxRetries <= 0) {
            return this.httpClient.executeAsync(request, requestOptions);
        }
        HttpRequest modifiedRequest = this.maybeAddIdempotencyHeader(request);
        boolean shouldSendRetryCount = !modifiedRequest.headers().names().contains("X-Stainless-Retry-Count");
        Ref.IntRef retries = new Ref.IntRef();
        return RetryingHttpClient.executeAsync$executeWithRetries(shouldSendRetryCount, this, retries, modifiedRequest, requestOptions);
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    private final boolean isRetryable(HttpRequest request) {
        HttpRequestBody httpRequestBody = request.body();
        return httpRequestBody != null ? httpRequestBody.repeatable() : true;
    }

    private final HttpRequest setRetryCountHeader(HttpRequest request, int retries) {
        return request.toBuilder().replaceHeaders("X-Stainless-Retry-Count", String.valueOf(retries)).build();
    }

    private final String idempotencyKey() {
        return "stainless-java-retry-" + UUID.randomUUID();
    }

    private final HttpRequest maybeAddIdempotencyHeader(HttpRequest request) {
        if (this.idempotencyHeader == null || request.headers().names().contains(this.idempotencyHeader)) {
            return request;
        }
        return request.toBuilder().putHeader(this.idempotencyHeader, this.idempotencyKey()).build();
    }

    private final boolean shouldRetry(HttpResponse response) {
        String shouldRetryHeader = (String)CollectionsKt.getOrNull(response.headers().values("X-Should-Retry"), (int)0);
        int statusCode = response.statusCode();
        return Intrinsics.areEqual((Object)shouldRetryHeader, (Object)"true") ? true : (Intrinsics.areEqual((Object)shouldRetryHeader, (Object)"false") ? false : (statusCode == 408 ? true : (statusCode == 409 ? true : (statusCode == 429 ? true : statusCode >= 500))));
    }

    private final boolean shouldRetry(Throwable throwable) {
        return throwable instanceof IOException || throwable instanceof AnthropicIoException;
    }

    private final Duration getRetryBackoffMillis(int retries, HttpResponse response) {
        Headers headers;
        if (response != null && (headers = response.headers()) != null) {
            Float f;
            Float f2;
            Float f3;
            Headers headers2 = headers;
            boolean bl = false;
            String string = (String)CollectionsKt.getOrNull(headers2.values("Retry-After-Ms"), (int)0);
            if (string != null && (f3 = StringsKt.toFloatOrNull((String)string)) != null) {
                f2 = Float.valueOf(f3.floatValue() * (float)TimeUnit.MILLISECONDS.toNanos(1L));
            } else {
                String string2 = (String)CollectionsKt.getOrNull(headers2.values("Retry-After"), (int)0);
                if (string2 != null) {
                    String retryAfter = string2;
                    boolean bl2 = false;
                    Float f4 = StringsKt.toFloatOrNull((String)retryAfter);
                    if (f4 != null) {
                        f2 = Float.valueOf(f4.floatValue() * (float)TimeUnit.SECONDS.toNanos(1L));
                    } else {
                        Long l;
                        try {
                            l = ChronoUnit.MILLIS.between(OffsetDateTime.now(this.clock), OffsetDateTime.parse(retryAfter, DateTimeFormatter.RFC_1123_DATE_TIME));
                        }
                        catch (DateTimeParseException e) {
                            l = null;
                        }
                        f2 = l;
                    }
                } else {
                    f2 = null;
                }
            }
            if ((f = f2) != null) {
                Float retryAfterNanos = f;
                boolean bl3 = false;
                Duration retryAfter = Duration.ofNanos(((Number)retryAfterNanos).longValue());
                Comparable comparable = Duration.ofNanos(0L);
                Duration duration = Duration.ofMinutes(1L);
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
                if (RangesKt.rangeTo((Comparable)comparable, (Comparable)duration).contains((Comparable)retryAfter)) {
                    Intrinsics.checkNotNull((Object)retryAfter);
                    return retryAfter;
                }
            }
        }
        double backoffSeconds = Math.min(0.5 * Math.pow(2.0, retries - 1), 8.0);
        double jitter = 1.0 - 0.25 * ThreadLocalRandom.current().nextDouble();
        Duration duration = Duration.ofNanos((long)((double)TimeUnit.SECONDS.toNanos(1L) * backoffSeconds * jitter));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofNanos(...)");
        return duration;
    }

    private static final CompletionStage executeAsync$executeWithRetries$lambda$2$lambda$0(HttpRequest $requestWithRetryCount, RequestOptions $requestOptions, boolean $shouldSendRetryCount, RetryingHttpClient this$0, Ref.IntRef $retries, Void it) {
        return RetryingHttpClient.executeAsync$executeWithRetries($shouldSendRetryCount, this$0, $retries, $requestWithRetryCount, $requestOptions);
    }

    private static final CompletionStage executeAsync$executeWithRetries$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final CompletableFuture<HttpResponse> executeAsync$executeWithRetries$lambda$2(Ref.IntRef retries, RetryingHttpClient this$0, HttpRequest requestWithRetryCount, RequestOptions $requestOptions, boolean shouldSendRetryCount, HttpResponse response, Throwable throwable) {
        block7: {
            block8: {
                block6: {
                    if (response == null) break block6;
                    ++retries.element;
                    if (retries.element > this$0.maxRetries || !this$0.shouldRetry(response)) {
                        CompletableFuture<HttpResponse> completableFuture = CompletableFuture.completedFuture(response);
                        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                        return completableFuture;
                    }
                    break block7;
                }
                ++retries.element;
                if (retries.element > this$0.maxRetries) break block8;
                Throwable throwable2 = throwable;
                Intrinsics.checkNotNull((Object)throwable2);
                if (this$0.shouldRetry(throwable2)) break block7;
            }
            CompletableFuture<HttpResponse> failedFuture = new CompletableFuture<HttpResponse>();
            failedFuture.completeExceptionally(throwable);
            return failedFuture;
        }
        Duration backoffMillis = this$0.getRetryBackoffMillis(retries.element, response);
        HttpResponse httpResponse = response;
        if (httpResponse != null) {
            httpResponse.close();
        }
        CompletionStage completionStage = RetryingHttpClient.Companion.sleepAsync(backoffMillis.toMillis()).thenCompose(arg_0 -> RetryingHttpClient.executeAsync$executeWithRetries$lambda$2$lambda$1(arg_0 -> RetryingHttpClient.executeAsync$executeWithRetries$lambda$2$lambda$0(requestWithRetryCount, $requestOptions, shouldSendRetryCount, this$0, retries, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCompose(...)");
        return completionStage;
    }

    private static final CompletableFuture executeAsync$executeWithRetries$lambda$3(Function2 $tmp0, Object p0, Throwable p1) {
        return (CompletableFuture)$tmp0.invoke(p0, (Object)p1);
    }

    private static final void executeAsync$executeWithRetries$lambda$4(Runnable it) {
        it.run();
    }

    private static final CompletableFuture<HttpResponse> executeAsync$executeWithRetries(boolean shouldSendRetryCount, RetryingHttpClient this$0, Ref.IntRef retries, HttpRequest request, RequestOptions requestOptions) {
        HttpRequest requestWithRetryCount = shouldSendRetryCount ? this$0.setRetryCountHeader(request, retries.element) : request;
        CompletionStage completionStage = ((CompletableFuture)this$0.httpClient.executeAsync(requestWithRetryCount, requestOptions).handleAsync((arg_0, arg_1) -> RetryingHttpClient.executeAsync$executeWithRetries$lambda$3((arg_0, arg_1) -> RetryingHttpClient.executeAsync$executeWithRetries$lambda$2(retries, this$0, requestWithRetryCount, requestOptions, shouldSendRetryCount, arg_0, arg_1), arg_0, arg_1), RetryingHttpClient::executeAsync$executeWithRetries$lambda$4)).thenCompose(Function.identity());
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCompose(...)");
        return completionStage;
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public /* synthetic */ RetryingHttpClient(HttpClient httpClient, Clock clock, int maxRetries, String idempotencyHeader, DefaultConstructorMarker $constructor_marker) {
        this(httpClient, clock, maxRetries, idempotencyHeader);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u0005R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/anthropic/core/http/RetryingHttpClient$Builder;", "", "<init>", "()V", "httpClient", "Lcom/anthropic/core/http/HttpClient;", "clock", "Ljava/time/Clock;", "maxRetries", "", "idempotencyHeader", "", "header", "build", "anthropic-java-core"})
    @SourceDebugExtension(value={"SMAP\nRetryingHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetryingHttpClient.kt\ncom/anthropic/core/http/RetryingHttpClient$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,271:1\n1#2:272\n*E\n"})
    public static final class Builder {
        @Nullable
        private HttpClient httpClient;
        @NotNull
        private Clock clock;
        private int maxRetries;
        @Nullable
        private String idempotencyHeader;

        public Builder() {
            Clock clock = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemUTC(...)");
            this.clock = clock;
            this.maxRetries = 2;
        }

        @NotNull
        public final Builder httpClient(@NotNull HttpClient httpClient) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
            Builder $this$httpClient_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$httpClient_u24lambda_u240.httpClient = httpClient;
            return builder;
        }

        @NotNull
        public final Builder clock(@NotNull Clock clock) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            Builder $this$clock_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$clock_u24lambda_u241.clock = clock;
            return builder;
        }

        @NotNull
        public final Builder maxRetries(int maxRetries) {
            Builder builder;
            Builder $this$maxRetries_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$maxRetries_u24lambda_u242.maxRetries = maxRetries;
            return builder;
        }

        @NotNull
        public final Builder idempotencyHeader(@NotNull String header) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            Builder $this$idempotencyHeader_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$idempotencyHeader_u24lambda_u243.idempotencyHeader = header;
            return builder;
        }

        @NotNull
        public final HttpClient build() {
            return new RetryingHttpClient(Check.checkRequired("httpClient", this.httpClient), this.clock, this.maxRetries, this.idempotencyHeader, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/anthropic/core/http/RetryingHttpClient$Companion;", "", "<init>", "()V", "TIMER", "Ljava/util/Timer;", "sleepAsync", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "millis", "", "builder", "Lcom/anthropic/core/http/RetryingHttpClient$Builder;", "anthropic-java-core"})
    public static final class Companion {
        private Companion() {
        }

        private final CompletableFuture<Void> sleepAsync(long millis) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            TIMER.schedule(new TimerTask(future){
                final /* synthetic */ CompletableFuture<Void> $future;
                {
                    this.$future = $future;
                }

                public void run() {
                    this.$future.complete(null);
                }
            }, millis);
            return future;
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

