/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.models.messages.batches;

import com.anthropic.core.BaseDeserializer;
import com.anthropic.core.BaseSerializer;
import com.anthropic.core.JsonField;
import com.anthropic.core.JsonValue;
import com.anthropic.core.Utils;
import com.anthropic.errors.AnthropicInvalidDataException;
import com.anthropic.models.messages.batches.MessageBatchCanceledResult;
import com.anthropic.models.messages.batches.MessageBatchErroredResult;
import com.anthropic.models.messages.batches.MessageBatchExpiredResult;
import com.anthropic.models.messages.batches.MessageBatchSucceededResult;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 %2\u00020\u0001:\u0004%&'(BE\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eJ\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eJ\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eJ\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0006\u0010\u0012\u001a\u00020\u0010J\u0006\u0010\u0013\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0005J\u0006\u0010\u0016\u001a\u00020\u0007J\u0006\u0010\u0017\u001a\u00020\tJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eJ\u001f\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001e\u001a\u00020\u0000J\u0013\u0010\u001f\u001a\u00020\u00102\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/anthropic/models/messages/batches/MessageBatchResult;", "", "succeeded", "Lcom/anthropic/models/messages/batches/MessageBatchSucceededResult;", "errored", "Lcom/anthropic/models/messages/batches/MessageBatchErroredResult;", "canceled", "Lcom/anthropic/models/messages/batches/MessageBatchCanceledResult;", "expired", "Lcom/anthropic/models/messages/batches/MessageBatchExpiredResult;", "_json", "Lcom/anthropic/core/JsonValue;", "<init>", "(Lcom/anthropic/models/messages/batches/MessageBatchSucceededResult;Lcom/anthropic/models/messages/batches/MessageBatchErroredResult;Lcom/anthropic/models/messages/batches/MessageBatchCanceledResult;Lcom/anthropic/models/messages/batches/MessageBatchExpiredResult;Lcom/anthropic/core/JsonValue;)V", "Ljava/util/Optional;", "isSucceeded", "", "isErrored", "isCanceled", "isExpired", "asSucceeded", "asErrored", "asCanceled", "asExpired", "accept", "T", "visitor", "Lcom/anthropic/models/messages/batches/MessageBatchResult$Visitor;", "(Lcom/anthropic/models/messages/batches/MessageBatchResult$Visitor;)Ljava/lang/Object;", "validated", "validate", "equals", "other", "hashCode", "", "toString", "", "Companion", "Visitor", "Deserializer", "Serializer", "anthropic-java-core"})
public final class MessageBatchResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final MessageBatchSucceededResult succeeded;
    @Nullable
    private final MessageBatchErroredResult errored;
    @Nullable
    private final MessageBatchCanceledResult canceled;
    @Nullable
    private final MessageBatchExpiredResult expired;
    @Nullable
    private final JsonValue _json;
    private boolean validated;

    private MessageBatchResult(MessageBatchSucceededResult succeeded, MessageBatchErroredResult errored, MessageBatchCanceledResult canceled, MessageBatchExpiredResult expired, JsonValue _json) {
        this.succeeded = succeeded;
        this.errored = errored;
        this.canceled = canceled;
        this.expired = expired;
        this._json = _json;
    }

    /* synthetic */ MessageBatchResult(MessageBatchSucceededResult messageBatchSucceededResult, MessageBatchErroredResult messageBatchErroredResult, MessageBatchCanceledResult messageBatchCanceledResult, MessageBatchExpiredResult messageBatchExpiredResult, JsonValue jsonValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            messageBatchSucceededResult = null;
        }
        if ((n & 2) != 0) {
            messageBatchErroredResult = null;
        }
        if ((n & 4) != 0) {
            messageBatchCanceledResult = null;
        }
        if ((n & 8) != 0) {
            messageBatchExpiredResult = null;
        }
        if ((n & 0x10) != 0) {
            jsonValue = null;
        }
        this(messageBatchSucceededResult, messageBatchErroredResult, messageBatchCanceledResult, messageBatchExpiredResult, jsonValue);
    }

    @NotNull
    public final Optional<MessageBatchSucceededResult> succeeded() {
        Optional<MessageBatchSucceededResult> optional = Optional.ofNullable(this.succeeded);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<MessageBatchErroredResult> errored() {
        Optional<MessageBatchErroredResult> optional = Optional.ofNullable(this.errored);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<MessageBatchCanceledResult> canceled() {
        Optional<MessageBatchCanceledResult> optional = Optional.ofNullable(this.canceled);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<MessageBatchExpiredResult> expired() {
        Optional<MessageBatchExpiredResult> optional = Optional.ofNullable(this.expired);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public final boolean isSucceeded() {
        return this.succeeded != null;
    }

    public final boolean isErrored() {
        return this.errored != null;
    }

    public final boolean isCanceled() {
        return this.canceled != null;
    }

    public final boolean isExpired() {
        return this.expired != null;
    }

    @NotNull
    public final MessageBatchSucceededResult asSucceeded() {
        return (MessageBatchSucceededResult)Utils.getOrThrow(this.succeeded, "succeeded");
    }

    @NotNull
    public final MessageBatchErroredResult asErrored() {
        return (MessageBatchErroredResult)Utils.getOrThrow(this.errored, "errored");
    }

    @NotNull
    public final MessageBatchCanceledResult asCanceled() {
        return (MessageBatchCanceledResult)Utils.getOrThrow(this.canceled, "canceled");
    }

    @NotNull
    public final MessageBatchExpiredResult asExpired() {
        return (MessageBatchExpiredResult)Utils.getOrThrow(this.expired, "expired");
    }

    @NotNull
    public final Optional<JsonValue> _json() {
        Optional<JsonValue> optional = Optional.ofNullable(this._json);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public final <T> T accept(@NotNull Visitor<? extends T> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        return this.succeeded != null ? visitor.visitSucceeded(this.succeeded) : (this.errored != null ? visitor.visitErrored(this.errored) : (this.canceled != null ? visitor.visitCanceled(this.canceled) : (this.expired != null ? visitor.visitExpired(this.expired) : visitor.unknown(this._json))));
    }

    @NotNull
    public final MessageBatchResult validate() {
        MessageBatchResult messageBatchResult;
        MessageBatchResult $this$validate_u24lambda_u240 = messageBatchResult = this;
        boolean bl = false;
        if (!$this$validate_u24lambda_u240.validated) {
            $this$validate_u24lambda_u240.accept((Visitor)new Visitor<Unit>(){

                public void visitSucceeded(MessageBatchSucceededResult succeeded) {
                    Intrinsics.checkNotNullParameter((Object)succeeded, (String)"succeeded");
                    succeeded.validate();
                }

                public void visitErrored(MessageBatchErroredResult errored) {
                    Intrinsics.checkNotNullParameter((Object)errored, (String)"errored");
                    errored.validate();
                }

                public void visitCanceled(MessageBatchCanceledResult canceled) {
                    Intrinsics.checkNotNullParameter((Object)canceled, (String)"canceled");
                    canceled.validate();
                }

                public void visitExpired(MessageBatchExpiredResult expired) {
                    Intrinsics.checkNotNullParameter((Object)expired, (String)"expired");
                    expired.validate();
                }
            });
            $this$validate_u24lambda_u240.validated = true;
        }
        return messageBatchResult;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MessageBatchResult && Intrinsics.areEqual((Object)this.succeeded, (Object)((MessageBatchResult)other).succeeded) && Intrinsics.areEqual((Object)this.errored, (Object)((MessageBatchResult)other).errored) && Intrinsics.areEqual((Object)this.canceled, (Object)((MessageBatchResult)other).canceled) && Intrinsics.areEqual((Object)this.expired, (Object)((MessageBatchResult)other).expired);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.succeeded, this.errored, this.canceled, this.expired};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        String string;
        if (this.succeeded != null) {
            string = "MessageBatchResult{succeeded=" + this.succeeded + '}';
        } else if (this.errored != null) {
            string = "MessageBatchResult{errored=" + this.errored + '}';
        } else if (this.canceled != null) {
            string = "MessageBatchResult{canceled=" + this.canceled + '}';
        } else if (this.expired != null) {
            string = "MessageBatchResult{expired=" + this.expired + '}';
        } else if (this._json != null) {
            string = "MessageBatchResult{_unknown=" + this._json + '}';
        } else {
            throw new IllegalStateException("Invalid MessageBatchResult");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final MessageBatchResult ofSucceeded(@NotNull MessageBatchSucceededResult succeeded) {
        return Companion.ofSucceeded(succeeded);
    }

    @JvmStatic
    @NotNull
    public static final MessageBatchResult ofErrored(@NotNull MessageBatchErroredResult errored) {
        return Companion.ofErrored(errored);
    }

    @JvmStatic
    @NotNull
    public static final MessageBatchResult ofCanceled(@NotNull MessageBatchCanceledResult canceled) {
        return Companion.ofCanceled(canceled);
    }

    @JvmStatic
    @NotNull
    public static final MessageBatchResult ofExpired(@NotNull MessageBatchExpiredResult expired) {
        return Companion.ofExpired(expired);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lcom/anthropic/models/messages/batches/MessageBatchResult$Companion;", "", "<init>", "()V", "ofSucceeded", "Lcom/anthropic/models/messages/batches/MessageBatchResult;", "succeeded", "Lcom/anthropic/models/messages/batches/MessageBatchSucceededResult;", "ofErrored", "errored", "Lcom/anthropic/models/messages/batches/MessageBatchErroredResult;", "ofCanceled", "canceled", "Lcom/anthropic/models/messages/batches/MessageBatchCanceledResult;", "ofExpired", "expired", "Lcom/anthropic/models/messages/batches/MessageBatchExpiredResult;", "anthropic-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MessageBatchResult ofSucceeded(@NotNull MessageBatchSucceededResult succeeded) {
            Intrinsics.checkNotNullParameter((Object)succeeded, (String)"succeeded");
            return new MessageBatchResult(succeeded, null, null, null, null, 30, null);
        }

        @JvmStatic
        @NotNull
        public final MessageBatchResult ofErrored(@NotNull MessageBatchErroredResult errored) {
            Intrinsics.checkNotNullParameter((Object)errored, (String)"errored");
            return new MessageBatchResult(null, errored, null, null, null, 29, null);
        }

        @JvmStatic
        @NotNull
        public final MessageBatchResult ofCanceled(@NotNull MessageBatchCanceledResult canceled) {
            Intrinsics.checkNotNullParameter((Object)canceled, (String)"canceled");
            return new MessageBatchResult(null, null, canceled, null, null, 27, null);
        }

        @JvmStatic
        @NotNull
        public final MessageBatchResult ofExpired(@NotNull MessageBatchExpiredResult expired) {
            Intrinsics.checkNotNullParameter((Object)expired, (String)"expired");
            return new MessageBatchResult(null, null, null, expired, null, 23, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u0002*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lcom/anthropic/models/messages/batches/MessageBatchResult$Deserializer;", "Lcom/anthropic/core/BaseDeserializer;", "Lcom/anthropic/models/messages/batches/MessageBatchResult;", "<init>", "()V", "deserialize", "Lcom/fasterxml/jackson/core/ObjectCodec;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "anthropic-java-core"})
    @SourceDebugExtension(value={"SMAP\nMessageBatchResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageBatchResult.kt\ncom/anthropic/models/messages/batches/MessageBatchResult$Deserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,232:1\n51#2:233\n51#2:234\n51#2:235\n51#2:236\n*S KotlinDebug\n*F\n+ 1 MessageBatchResult.kt\ncom/anthropic/models/messages/batches/MessageBatchResult$Deserializer\n*L\n177#1:233\n185#1:234\n193#1:235\n201#1:236\n*E\n"})
    public static final class Deserializer
    extends BaseDeserializer<MessageBatchResult> {
        public Deserializer() {
            super(Reflection.getOrCreateKotlinClass(MessageBatchResult.class));
        }

        @Override
        @NotNull
        protected MessageBatchResult deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
            JsonValue json2;
            block16: {
                String type;
                Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                json2 = JsonValue.Companion.fromJsonNode(node);
                Object object = (Map)OptionalsKt.getOrNull(json2.asObject());
                String string = type = object != null && (object = (JsonValue)object.get("type")) != null && (object = ((JsonField)object).asString()) != null ? (String)OptionalsKt.getOrNull(object) : null;
                if (string == null) break block16;
                int n = -1;
                switch (string.hashCode()) {
                    case -123173735: {
                        if (string.equals("canceled")) {
                            n = 1;
                        }
                        break;
                    }
                    case -1309235419: {
                        if (string.equals("expired")) {
                            n = 2;
                        }
                        break;
                    }
                    case 945734241: {
                        if (string.equals("succeeded")) {
                            n = 3;
                        }
                        break;
                    }
                    case -1478984537: {
                        if (string.equals("errored")) {
                            n = 4;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 3: {
                        boolean $i$f$jacksonTypeRef = false;
                        MessageBatchSucceededResult messageBatchSucceededResult = (MessageBatchSucceededResult)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<MessageBatchSucceededResult>(){}, Deserializer::deserialize$lambda$0);
                        if (messageBatchSucceededResult == null) break;
                        MessageBatchSucceededResult it = messageBatchSucceededResult;
                        boolean bl = false;
                        return new MessageBatchResult(it, null, null, null, json2, 14, null);
                    }
                    case 4: {
                        boolean $i$f$jacksonTypeRef = false;
                        MessageBatchErroredResult messageBatchErroredResult = (MessageBatchErroredResult)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<MessageBatchErroredResult>(){}, Deserializer::deserialize$lambda$2);
                        if (messageBatchErroredResult == null) break;
                        MessageBatchErroredResult it = messageBatchErroredResult;
                        boolean bl = false;
                        return new MessageBatchResult(null, it, null, null, json2, 13, null);
                    }
                    case 1: {
                        boolean $i$f$jacksonTypeRef = false;
                        MessageBatchCanceledResult messageBatchCanceledResult = (MessageBatchCanceledResult)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<MessageBatchCanceledResult>(){}, Deserializer::deserialize$lambda$4);
                        if (messageBatchCanceledResult == null) break;
                        MessageBatchCanceledResult it = messageBatchCanceledResult;
                        boolean bl = false;
                        return new MessageBatchResult(null, null, it, null, json2, 11, null);
                    }
                    case 2: {
                        boolean $i$f$jacksonTypeRef = false;
                        MessageBatchExpiredResult messageBatchExpiredResult = (MessageBatchExpiredResult)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<MessageBatchExpiredResult>(){}, Deserializer::deserialize$lambda$6);
                        if (messageBatchExpiredResult == null) break;
                        MessageBatchExpiredResult it = messageBatchExpiredResult;
                        boolean bl = false;
                        return new MessageBatchResult(null, null, null, it, json2, 7, null);
                    }
                }
            }
            return new MessageBatchResult(null, null, null, null, json2, 15, null);
        }

        private static final Unit deserialize$lambda$0(MessageBatchSucceededResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.validate();
            return Unit.INSTANCE;
        }

        private static final Unit deserialize$lambda$2(MessageBatchErroredResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.validate();
            return Unit.INSTANCE;
        }

        private static final Unit deserialize$lambda$4(MessageBatchCanceledResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.validate();
            return Unit.INSTANCE;
        }

        private static final Unit deserialize$lambda$6(MessageBatchExpiredResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.validate();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/anthropic/models/messages/batches/MessageBatchResult$Serializer;", "Lcom/anthropic/core/BaseSerializer;", "Lcom/anthropic/models/messages/batches/MessageBatchResult;", "<init>", "()V", "serialize", "", "value", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "anthropic-java-core"})
    public static final class Serializer
    extends BaseSerializer<MessageBatchResult> {
        public Serializer() {
            super(Reflection.getOrCreateKotlinClass(MessageBatchResult.class));
        }

        public void serialize(@NotNull MessageBatchResult value, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            if (value.succeeded != null) {
                generator.writeObject((Object)value.succeeded);
            } else if (value.errored != null) {
                generator.writeObject((Object)value.errored);
            } else if (value.canceled != null) {
                generator.writeObject((Object)value.canceled);
            } else if (value.expired != null) {
                generator.writeObject((Object)value.expired);
            } else if (value._json != null) {
                generator.writeObject((Object)value._json);
            } else {
                throw new IllegalStateException("Invalid MessageBatchResult");
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0012J\u0017\u0010\u0013\u001a\u00028\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0017\u00c0\u0006\u0001"}, d2={"Lcom/anthropic/models/messages/batches/MessageBatchResult$Visitor;", "T", "", "visitSucceeded", "succeeded", "Lcom/anthropic/models/messages/batches/MessageBatchSucceededResult;", "(Lcom/anthropic/models/messages/batches/MessageBatchSucceededResult;)Ljava/lang/Object;", "visitErrored", "errored", "Lcom/anthropic/models/messages/batches/MessageBatchErroredResult;", "(Lcom/anthropic/models/messages/batches/MessageBatchErroredResult;)Ljava/lang/Object;", "visitCanceled", "canceled", "Lcom/anthropic/models/messages/batches/MessageBatchCanceledResult;", "(Lcom/anthropic/models/messages/batches/MessageBatchCanceledResult;)Ljava/lang/Object;", "visitExpired", "expired", "Lcom/anthropic/models/messages/batches/MessageBatchExpiredResult;", "(Lcom/anthropic/models/messages/batches/MessageBatchExpiredResult;)Ljava/lang/Object;", "unknown", "json", "Lcom/anthropic/core/JsonValue;", "(Lcom/anthropic/core/JsonValue;)Ljava/lang/Object;", "anthropic-java-core"})
    public static interface Visitor<T> {
        public T visitSucceeded(@NotNull MessageBatchSucceededResult var1);

        public T visitErrored(@NotNull MessageBatchErroredResult var1);

        public T visitCanceled(@NotNull MessageBatchCanceledResult var1);

        public T visitExpired(@NotNull MessageBatchExpiredResult var1);

        default public T unknown(@Nullable JsonValue json2) {
            throw new AnthropicInvalidDataException("Unknown MessageBatchResult: " + json2, null, 2, null);
        }
    }
}

