/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.services.blocking;

import com.anthropic.core.ClientOptions;
import com.anthropic.core.ObjectMappers;
import com.anthropic.core.PrepareRequest;
import com.anthropic.core.RequestOptions;
import com.anthropic.core.handlers.ErrorHandler;
import com.anthropic.core.http.HttpMethod;
import com.anthropic.core.http.HttpRequest;
import com.anthropic.core.http.HttpResponse;
import com.anthropic.core.http.HttpResponseFor;
import com.anthropic.core.http.HttpResponseForKt;
import com.anthropic.errors.AnthropicError;
import com.anthropic.models.models.ModelInfo;
import com.anthropic.models.models.ModelListPage;
import com.anthropic.models.models.ModelListParams;
import com.anthropic.models.models.ModelRetrieveParams;
import com.anthropic.services.blocking.ModelService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/anthropic/services/blocking/ModelServiceImpl;", "Lcom/anthropic/services/blocking/ModelService;", "clientOptions", "Lcom/anthropic/core/ClientOptions;", "<init>", "(Lcom/anthropic/core/ClientOptions;)V", "withRawResponse", "Lcom/anthropic/services/blocking/ModelService$WithRawResponse;", "getWithRawResponse", "()Lcom/anthropic/services/blocking/ModelService$WithRawResponse;", "withRawResponse$delegate", "Lkotlin/Lazy;", "retrieve", "Lcom/anthropic/models/models/ModelInfo;", "params", "Lcom/anthropic/models/models/ModelRetrieveParams;", "requestOptions", "Lcom/anthropic/core/RequestOptions;", "list", "Lcom/anthropic/models/models/ModelListPage;", "Lcom/anthropic/models/models/ModelListParams;", "WithRawResponseImpl", "anthropic-java-core"})
public final class ModelServiceImpl
implements ModelService {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final Lazy withRawResponse$delegate;

    public ModelServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.withRawResponse$delegate = LazyKt.lazy(() -> ModelServiceImpl.withRawResponse_delegate$lambda$0(this));
    }

    private final ModelService.WithRawResponse getWithRawResponse() {
        Lazy lazy = this.withRawResponse$delegate;
        return (ModelService.WithRawResponse)lazy.getValue();
    }

    @Override
    @NotNull
    public ModelService.WithRawResponse withRawResponse() {
        return this.getWithRawResponse();
    }

    @Override
    @NotNull
    public ModelInfo retrieve(@NotNull ModelRetrieveParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        return this.withRawResponse().retrieve(params, requestOptions).parse();
    }

    @Override
    @NotNull
    public ModelListPage list(@NotNull ModelListParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        return this.withRawResponse().list(params, requestOptions).parse();
    }

    private static final WithRawResponseImpl withRawResponse_delegate$lambda$0(ModelServiceImpl this$0) {
        return new WithRawResponseImpl(this$0.clientOptions);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\f2\u0006\u0010\r\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/anthropic/services/blocking/ModelServiceImpl$WithRawResponseImpl;", "Lcom/anthropic/services/blocking/ModelService$WithRawResponse;", "clientOptions", "Lcom/anthropic/core/ClientOptions;", "<init>", "(Lcom/anthropic/core/ClientOptions;)V", "errorHandler", "Lcom/anthropic/core/http/HttpResponse$Handler;", "Lcom/anthropic/errors/AnthropicError;", "retrieveHandler", "Lcom/anthropic/models/models/ModelInfo;", "retrieve", "Lcom/anthropic/core/http/HttpResponseFor;", "params", "Lcom/anthropic/models/models/ModelRetrieveParams;", "requestOptions", "Lcom/anthropic/core/RequestOptions;", "listHandler", "Lcom/anthropic/models/models/ModelListPage$Response;", "list", "Lcom/anthropic/models/models/ModelListPage;", "Lcom/anthropic/models/models/ModelListParams;", "anthropic-java-core"})
    @SourceDebugExtension(value={"SMAP\nModelServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelServiceImpl.kt\ncom/anthropic/services/blocking/ModelServiceImpl$WithRawResponseImpl\n+ 2 JsonHandler.kt\ncom/anthropic/core/handlers/JsonHandler\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n13#2,8:100\n13#2,8:108\n1#3:116\n*S KotlinDebug\n*F\n+ 1 ModelServiceImpl.kt\ncom/anthropic/services/blocking/ModelServiceImpl$WithRawResponseImpl\n*L\n45#1:100,8\n71#1:108,8\n*E\n"})
    public static final class WithRawResponseImpl
    implements ModelService.WithRawResponse {
        @NotNull
        private final ClientOptions clientOptions;
        @NotNull
        private final HttpResponse.Handler<AnthropicError> errorHandler;
        @NotNull
        private final HttpResponse.Handler<ModelInfo> retrieveHandler;
        @NotNull
        private final HttpResponse.Handler<ModelListPage.Response> listHandler;

        public WithRawResponseImpl(@NotNull ClientOptions clientOptions) {
            Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
            this.clientOptions = clientOptions;
            this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
            JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
            boolean $i$f$jsonHandler = false;
            this.retrieveHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ModelInfo>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public ModelInfo handle(HttpResponse response) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        object = this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ModelInfo>(){});
                    }
                    catch (Exception e) {
                        throw ObjectMappers.enhanceJacksonException("Error reading response", e);
                    }
                    return object;
                }
            }, this.errorHandler);
            jsonMapper$iv = this.clientOptions.jsonMapper();
            $i$f$jsonHandler = false;
            this.listHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ModelListPage.Response>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public ModelListPage.Response handle(HttpResponse response) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        object = this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ModelListPage.Response>(){});
                    }
                    catch (Exception e) {
                        throw ObjectMappers.enhanceJacksonException("Error reading response", e);
                    }
                    return object;
                }
            }, this.errorHandler);
        }

        @Override
        @NotNull
        public HttpResponseFor<ModelInfo> retrieve(@NotNull ModelRetrieveParams params, @NotNull RequestOptions requestOptions) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            String[] stringArray = new String[]{"v1", "models", params.getPathParam(0)};
            HttpRequest request = PrepareRequest.prepare(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$anthropic_java_core(this.clientOptions));
            HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions2);
            return HttpResponseForKt.parseable(response, () -> WithRawResponseImpl.retrieve$lambda$2(response, this, requestOptions2));
        }

        @Override
        @NotNull
        public HttpResponseFor<ModelListPage> list(@NotNull ModelListParams params, @NotNull RequestOptions requestOptions) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            String[] stringArray = new String[]{"v1", "models"};
            HttpRequest request = PrepareRequest.prepare(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$anthropic_java_core(this.clientOptions));
            HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions2);
            return HttpResponseForKt.parseable(response, () -> WithRawResponseImpl.list$lambda$6(response, this, requestOptions2, params));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final ModelInfo retrieve$lambda$2(HttpResponse $response, WithRawResponseImpl this$0, RequestOptions $requestOptions) {
            Object it;
            Object object = $response;
            Throwable throwable = null;
            try {
                it = (HttpResponse)object;
                boolean bl = false;
                it = this$0.retrieveHandler.handle((HttpResponse)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            Object it2 = object = it;
            boolean bl = false;
            Boolean bl2 = $requestOptions.getResponseValidation();
            Intrinsics.checkNotNull((Object)bl2);
            if (bl2.booleanValue()) {
                ((ModelInfo)it2).validate();
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final ModelListPage list$lambda$6(HttpResponse $response, WithRawResponseImpl this$0, RequestOptions $requestOptions, ModelListParams $params) {
            Object it;
            Object object = $response;
            Throwable throwable = null;
            try {
                it = (HttpResponse)object;
                boolean bl = false;
                it = this$0.listHandler.handle((HttpResponse)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            Object it2 = object = it;
            boolean bl = false;
            Boolean bl2 = $requestOptions.getResponseValidation();
            Intrinsics.checkNotNull((Object)bl2);
            if (bl2.booleanValue()) {
                ((ModelListPage.Response)it2).validate();
            }
            it2 = object;
            boolean bl3 = false;
            return ModelListPage.Companion.of(new ModelServiceImpl(this$0.clientOptions), $params, (ModelListPage.Response)it2);
        }
    }
}

