/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.core;

import com.anthropic.core.Check;
import com.anthropic.core.JsonField;
import com.anthropic.core.MultipartField;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.json.PackageVersion;
import com.fasterxml.jackson.core.util.VersionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\u001a\b\u0010\u0004\u001a\u00020\u0005H\u0000\u001a-\u0010\u0006\u001a\u0002H\u0007\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\fH\u0000\u00a2\u0006\u0002\u0010\r\u001a-\u0010\u0006\u001a\u0002H\u0007\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000eH\u0000\u00a2\u0006\u0002\u0010\u000f\u001a \u0010\u0010\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a \u0010\u0013\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0012H\u0000\u001a \u0010\u0015\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0012H\u0000\u001a'\u0010\u0017\u001a\u0002H\u0007\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u0001H\u0007\u00a2\u0006\u0002\u0010\u0018\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"MINIMUM_JACKSON_VERSION", "Lcom/fasterxml/jackson/core/Version;", "RUNTIME_JACKSON_VERSIONS", "", "checkJacksonVersionCompatibility", "", "checkKnown", "T", "", "name", "", "value", "Lcom/anthropic/core/JsonField;", "(Ljava/lang/String;Lcom/anthropic/core/JsonField;)Ljava/lang/Object;", "Lcom/anthropic/core/MultipartField;", "(Ljava/lang/String;Lcom/anthropic/core/MultipartField;)Ljava/lang/Object;", "checkLength", "length", "", "checkMaxLength", "maxLength", "checkMinLength", "minLength", "checkRequired", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "anthropic-java-core"})
@JvmName(name="Check")
@SourceDebugExtension(value={"SMAP\nCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Check.kt\ncom/anthropic/core/Check\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1#2:89\n1#2:100\n1603#3,9:90\n1855#3:99\n1856#3:101\n1612#3:102\n*S KotlinDebug\n*F\n+ 1 Check.kt\ncom/anthropic/core/Check\n*L\n49#1:100\n49#1:90,9\n49#1:99\n49#1:101\n49#1:102\n*E\n"})
public final class Check {
    @NotNull
    private static final Version MINIMUM_JACKSON_VERSION;
    @NotNull
    private static final List<Version> RUNTIME_JACKSON_VERSIONS;

    @NotNull
    public static final <T> T checkRequired(@NotNull String name, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        T t = value;
        if (t == null) {
            boolean bl = false;
            String string = '`' + name + "` is required, but was not set";
            throw new IllegalStateException(string.toString());
        }
        return t;
    }

    public static final /* synthetic */ Object checkKnown(String name, JsonField value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object t = value.asKnown().orElseThrow(() -> Check.checkKnown$lambda$1(name, value));
        Intrinsics.checkNotNullExpressionValue(t, (String)"value.asKnown().orElseTh\u2026Class.simpleName}\")\n    }");
        return t;
    }

    public static final /* synthetic */ Object checkKnown(String name, MultipartField value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object t = value.value().asKnown().orElseThrow(() -> Check.checkKnown$lambda$2(name, value));
        Intrinsics.checkNotNullExpressionValue(t, (String)"value.value.asKnown().or\u2026Class.simpleName}\")\n    }");
        return t;
    }

    public static final /* synthetic */ String checkLength(String name, String value, int length) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String it = string = value;
        boolean bl = false;
        if (!(it.length() == length)) {
            boolean bl2 = false;
            String string2 = '`' + name + "` must have length " + length + ", but was " + it.length();
            throw new IllegalStateException(string2.toString());
        }
        return string;
    }

    public static final /* synthetic */ String checkMinLength(String name, String value, int minLength) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String it = string = value;
        boolean bl = false;
        if (!(it.length() >= minLength)) {
            boolean bl2 = false;
            String string2 = minLength == 1 ? '`' + name + "` must be non-empty, but was empty" : '`' + name + "` must have at least length " + minLength + ", but was " + it.length();
            throw new IllegalStateException(string2.toString());
        }
        return string;
    }

    public static final /* synthetic */ String checkMaxLength(String name, String value, int maxLength) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String it = string = value;
        boolean bl = false;
        if (!(it.length() <= maxLength)) {
            boolean bl2 = false;
            String string2 = '`' + name + "` must have at most length " + maxLength + ", but was " + it.length();
            throw new IllegalStateException(string2.toString());
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void checkJacksonVersionCompatibility() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = RUNTIME_JACKSON_VERSIONS;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Version it = (Version)element$iv$iv;
            boolean bl2 = false;
            if ((it.getMajorVersion() != MINIMUM_JACKSON_VERSION.getMajorVersion() ? TuplesKt.to((Object)it, (Object)"incompatible major version") : (it.getMinorVersion() < MINIMUM_JACKSON_VERSION.getMinorVersion() ? TuplesKt.to((Object)it, (Object)"minor version too low") : (it.getMinorVersion() == MINIMUM_JACKSON_VERSION.getMinorVersion() && it.getPatchLevel() < MINIMUM_JACKSON_VERSION.getPatchLevel() ? TuplesKt.to((Object)it, (Object)"patch version too low") : null))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List incompatibleJacksonVersions = (List)destination$iv$iv;
        if (!incompatibleJacksonVersions.isEmpty()) {
            boolean bl = false;
            String string = StringsKt.trimIndent((String)("\nThis SDK depends on Jackson version " + MINIMUM_JACKSON_VERSION + ", but the following incompatible Jackson versions were detected at runtime:\n\n" + SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)incompatibleJacksonVersions), (Function1)checkJacksonVersionCompatibility.1.1.INSTANCE), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n\nThis can happen if you are either:\n1. Directly depending on different Jackson versions\n2. Depending on some library that depends on different Jackson versions, potentially transitively\n\nDouble-check that you are depending on compatible Jackson versions.\n        "));
            throw new IllegalStateException(string.toString());
        }
    }

    private static final IllegalStateException checkKnown$lambda$1(String $name, JsonField $value) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        return new IllegalStateException('`' + $name + "` is not a known type: " + $value.getClass().getSimpleName());
    }

    private static final IllegalStateException checkKnown$lambda$2(String $name, MultipartField $value) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        return new IllegalStateException('`' + $name + "` is not a known type: " + $value.getClass().getSimpleName());
    }

    static {
        Version version = VersionUtil.parseVersion((String)"2.13.4", null, null);
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"parseVersion(\"2.13.4\", null, null)");
        MINIMUM_JACKSON_VERSION = version;
        Object[] objectArray = new Version[]{PackageVersion.VERSION, com.fasterxml.jackson.databind.cfg.PackageVersion.VERSION, com.fasterxml.jackson.datatype.jdk8.PackageVersion.VERSION, com.fasterxml.jackson.datatype.jsr310.PackageVersion.VERSION, com.fasterxml.jackson.module.kotlin.PackageVersion.VERSION};
        RUNTIME_JACKSON_VERSIONS = CollectionsKt.listOf((Object[])objectArray);
    }
}

