/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.core;

import com.anthropic.core.ClientOptions;
import com.anthropic.core.Timeout;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\u001b\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/anthropic/core/RequestOptions;", "", "responseValidation", "", "timeout", "Lcom/anthropic/core/Timeout;", "(Ljava/lang/Boolean;Lcom/anthropic/core/Timeout;)V", "getResponseValidation", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getTimeout", "()Lcom/anthropic/core/Timeout;", "applyDefaultTimeoutFromMaxTokens", "maxTokens", "", "isStreaming", "applyDefaultTimeoutFromMaxTokens$anthropic_java_core", "applyDefaults", "options", "Builder", "Companion", "anthropic-java-core"})
public final class RequestOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Boolean responseValidation;
    @Nullable
    private final Timeout timeout;
    @NotNull
    private static final RequestOptions NONE = Companion.builder().build();

    private RequestOptions(Boolean responseValidation, Timeout timeout) {
        this.responseValidation = responseValidation;
        this.timeout = timeout;
    }

    @Nullable
    public final Boolean getResponseValidation() {
        return this.responseValidation;
    }

    @Nullable
    public final Timeout getTimeout() {
        return this.timeout;
    }

    /*
     * Unable to fully structure code
     */
    public final /* synthetic */ RequestOptions applyDefaultTimeoutFromMaxTokens$anthropic_java_core(long maxTokens, boolean isStreaming) {
        if (this.timeout != null) {
            return this;
        }
        requestOptions = this.applyDefaults(RequestOptions.Companion.builder().timeoutFromMaxTokens$anthropic_java_core(maxTokens).build());
        if (isStreaming) ** GOTO lbl-1000
        v0 = requestOptions.timeout;
        Intrinsics.checkNotNull((Object)v0);
        if (v0.request().compareTo(Duration.ofMinutes(10L)) <= 0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        if (!v1) {
            $i$a$-require-RequestOptions$applyDefaultTimeoutFromMaxTokens$1 = false;
            var5_5 = "Streaming is required for operations that may take longer than 10 minutes.\n\nSee https://github.com/anthropics/anthropic-sdk-java#streaming for more details.";
            throw new IllegalArgumentException(var5_5.toString());
        }
        return requestOptions;
    }

    @NotNull
    public final RequestOptions applyDefaults(@NotNull RequestOptions options) {
        Timeout timeout;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Boolean bl = this.responseValidation;
        if (bl == null) {
            bl = options.responseValidation;
        }
        if (options.timeout != null && this.timeout != null) {
            timeout = this.timeout.assign$anthropic_java_core(options.timeout);
        } else {
            timeout = this.timeout;
            if (timeout == null) {
                timeout = options.timeout;
            }
        }
        return new RequestOptions(bl, timeout);
    }

    @JvmStatic
    @NotNull
    public static final RequestOptions none() {
        return Companion.none();
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public /* synthetic */ RequestOptions(Boolean responseValidation, Timeout timeout, DefaultConstructorMarker $constructor_marker) {
        this(responseValidation, timeout);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\nJ\u0015\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eR\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/anthropic/core/RequestOptions$Builder;", "", "()V", "responseValidation", "", "Ljava/lang/Boolean;", "timeout", "Lcom/anthropic/core/Timeout;", "build", "Lcom/anthropic/core/RequestOptions;", "Ljava/time/Duration;", "timeoutFromMaxTokens", "maxTokens", "", "timeoutFromMaxTokens$anthropic_java_core", "anthropic-java-core"})
    @SourceDebugExtension(value={"SMAP\nRequestOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestOptions.kt\ncom/anthropic/core/RequestOptions$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
    public static final class Builder {
        @Nullable
        private Boolean responseValidation;
        @Nullable
        private Timeout timeout;

        @NotNull
        public final Builder responseValidation(boolean responseValidation) {
            Builder builder;
            Builder $this$responseValidation_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$responseValidation_u24lambda_u240.responseValidation = responseValidation;
            return builder;
        }

        @NotNull
        public final Builder timeout(@NotNull Timeout timeout) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
            Builder $this$timeout_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$timeout_u24lambda_u241.timeout = timeout;
            return builder;
        }

        @NotNull
        public final Builder timeout(@NotNull Duration timeout) {
            Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
            return this.timeout(Timeout.Companion.builder().request(timeout).build());
        }

        public final /* synthetic */ Builder timeoutFromMaxTokens$anthropic_java_core(long maxTokens) {
            Builder builder;
            Builder $this$timeoutFromMaxTokens_u24lambda_u242 = builder = this;
            boolean bl = false;
            Duration timeout = Duration.ofSeconds(Math.min(3600L, Math.max(600L, (long)3600 * maxTokens / (long)128000)));
            $this$timeoutFromMaxTokens_u24lambda_u242.timeout(Timeout.Companion.builder().read(timeout).request(timeout).build());
            return builder;
        }

        @NotNull
        public final RequestOptions build() {
            return new RequestOptions(this.responseValidation, this.timeout, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\u0015\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\b\u0010\u000b\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/anthropic/core/RequestOptions$Companion;", "", "()V", "NONE", "Lcom/anthropic/core/RequestOptions;", "builder", "Lcom/anthropic/core/RequestOptions$Builder;", "from", "clientOptions", "Lcom/anthropic/core/ClientOptions;", "from$anthropic_java_core", "none", "anthropic-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RequestOptions none() {
            return NONE;
        }

        public final /* synthetic */ RequestOptions from$anthropic_java_core(ClientOptions clientOptions) {
            Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
            return this.builder().responseValidation(clientOptions.responseValidation()).timeout(clientOptions.timeout()).build();
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

