// File generated from our OpenAPI spec by Stainless.

package com.anthropic.core.http

import java.io.InputStream
import java.util.Optional

interface HttpResponse : AutoCloseable {

    fun statusCode(): Int

    fun headers(): Headers

    fun requestId(): Optional<String> =
        Optional.ofNullable(headers().values("request-id").firstOrNull())

    fun body(): InputStream

    /** Overridden from [AutoCloseable] to not have a checked exception in its signature. */
    override fun close()

    interface Handler<T> {

        fun handle(response: HttpResponse): T
    }
}
