/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.helpers;

import com.anthropic.core.JsonObject;
import com.anthropic.core.JsonValue;
import com.anthropic.core.ObjectMappers;
import com.anthropic.errors.AnthropicInvalidDataException;
import com.anthropic.helpers.MessageAccumulator;
import com.anthropic.models.messages.CitationCharLocation;
import com.anthropic.models.messages.CitationContentBlockLocation;
import com.anthropic.models.messages.CitationPageLocation;
import com.anthropic.models.messages.CitationsDelta;
import com.anthropic.models.messages.ContentBlock;
import com.anthropic.models.messages.InputJsonDelta;
import com.anthropic.models.messages.Message;
import com.anthropic.models.messages.MessageDeltaUsage;
import com.anthropic.models.messages.RawContentBlockDelta;
import com.anthropic.models.messages.RawContentBlockDeltaEvent;
import com.anthropic.models.messages.RawContentBlockStartEvent;
import com.anthropic.models.messages.RawContentBlockStopEvent;
import com.anthropic.models.messages.RawMessageDeltaEvent;
import com.anthropic.models.messages.RawMessageStartEvent;
import com.anthropic.models.messages.RawMessageStopEvent;
import com.anthropic.models.messages.RawMessageStreamEvent;
import com.anthropic.models.messages.RedactedThinkingBlock;
import com.anthropic.models.messages.SignatureDelta;
import com.anthropic.models.messages.StopReason;
import com.anthropic.models.messages.TextBlock;
import com.anthropic.models.messages.TextCitation;
import com.anthropic.models.messages.TextDelta;
import com.anthropic.models.messages.ThinkingBlock;
import com.anthropic.models.messages.ThinkingDelta;
import com.anthropic.models.messages.ToolUseBlock;
import com.anthropic.models.messages.Usage;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0006\u0010\u0003\u001a\u00020\u0004J\b\u0010\u0012\u001a\u00020\u0006H\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/anthropic/helpers/MessageAccumulator;", "", "()V", "message", "Lcom/anthropic/models/messages/Message;", "messageBuilder", "Lcom/anthropic/models/messages/Message$Builder;", "messageContent", "", "", "Lcom/anthropic/models/messages/ContentBlock;", "messageContentInputJson", "", "messageUsage", "Lcom/anthropic/models/messages/Usage;", "accumulate", "Lcom/anthropic/models/messages/RawMessageStreamEvent;", "event", "requireMessageBuilder", "requireMessageUsage", "Companion", "anthropic-java-core"})
@SourceDebugExtension(value={"SMAP\nMessageAccumulator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageAccumulator.kt\ncom/anthropic/helpers/MessageAccumulator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,350:1\n1#2:351\n*E\n"})
public final class MessageAccumulator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Message message;
    @Nullable
    private Message.Builder messageBuilder;
    @Nullable
    private Usage messageUsage;
    @NotNull
    private final Map<Long, ContentBlock> messageContent = new LinkedHashMap();
    @NotNull
    private final Map<Long, String> messageContentInputJson = new LinkedHashMap();
    @NotNull
    private static final JsonMapper JSON_MAPPER = ObjectMappers.jsonMapper();

    private MessageAccumulator() {
    }

    @NotNull
    public final Message message() {
        Message message = this.message;
        if (message == null) {
            boolean bl = false;
            String string = "'message_stop' event not yet received.";
            throw new IllegalStateException(string.toString());
        }
        return message;
    }

    @NotNull
    public final RawMessageStreamEvent accumulate(@NotNull RawMessageStreamEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.message != null) {
            throw new AnthropicInvalidDataException("'message_stop' event already received.", null, 2, null);
        }
        event.accept((RawMessageStreamEvent.Visitor)new RawMessageStreamEvent.Visitor<Unit>(this){
            final /* synthetic */ MessageAccumulator this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitStart(@NotNull RawMessageStartEvent start) {
                Intrinsics.checkNotNullParameter((Object)start, (String)"start");
                if (MessageAccumulator.access$getMessageBuilder$p(this.this$0) != null) {
                    throw new AnthropicInvalidDataException("'message_start' event already received.", null, 2, null);
                }
                MessageAccumulator.access$setMessageBuilder$p(this.this$0, start.message().toBuilder());
                MessageAccumulator.access$setMessageUsage$p(this.this$0, start.message().usage());
            }

            public void visitDelta(@NotNull RawMessageDeltaEvent deltaEvent) {
                Intrinsics.checkNotNullParameter((Object)deltaEvent, (String)"deltaEvent");
                RawMessageDeltaEvent.Delta delta = deltaEvent.delta();
                if (delta._stopReason().isNull()) {
                    MessageAccumulator.access$requireMessageBuilder(this.this$0).stopReason((StopReason)null);
                } else if (!delta._stopReason().isMissing()) {
                    MessageAccumulator.access$requireMessageBuilder(this.this$0).stopReason(delta.stopReason());
                }
                if (delta._stopSequence().isNull()) {
                    MessageAccumulator.access$requireMessageBuilder(this.this$0).stopSequence((String)null);
                } else if (!delta._stopSequence().isMissing()) {
                    MessageAccumulator.access$requireMessageBuilder(this.this$0).stopSequence(delta.stopSequence().get());
                }
                MessageAccumulator.access$setMessageUsage$p(this.this$0, MessageAccumulator.Companion.mergeMessageUsage$anthropic_java_core(MessageAccumulator.access$requireMessageUsage(this.this$0), deltaEvent.usage()));
            }

            /*
             * WARNING - void declaration
             */
            public void visitStop(@NotNull RawMessageStopEvent stop) {
                Collection<ContentBlock> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)stop, (String)"stop");
                Iterable $this$sortedBy$iv = MessageAccumulator.access$getMessageContent$p(this.this$0).entrySet();
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = (Long)it.getKey();
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Long)it.getKey()));
                    }
                });
                Message.Builder builder = MessageAccumulator.access$requireMessageBuilder(this.this$0);
                MessageAccumulator messageAccumulator = this.this$0;
                boolean $i$f$map = false;
                void var4_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Map.Entry entry = (Map.Entry)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((ContentBlock)it.getValue());
                }
                collection = (List)destination$iv$iv;
                MessageAccumulator.access$setMessage$p(messageAccumulator, builder.content((List<ContentBlock>)collection).usage(MessageAccumulator.access$requireMessageUsage(this.this$0)).build());
                MessageAccumulator.access$setMessageBuilder$p(this.this$0, null);
            }

            public void visitContentBlockStart(@NotNull RawContentBlockStartEvent contentBlockStart) {
                Intrinsics.checkNotNullParameter((Object)contentBlockStart, (String)"contentBlockStart");
                long index = contentBlockStart.index();
                if (MessageAccumulator.access$getMessageContent$p(this.this$0).get(index) != null) {
                    throw new AnthropicInvalidDataException("Content block already started for index " + index + '.', null, 2, null);
                }
                Long l = index;
                MessageAccumulator.access$getMessageContent$p(this.this$0).put(l, contentBlockStart.contentBlock().accept((RawContentBlockStartEvent.ContentBlock.Visitor)new RawContentBlockStartEvent.ContentBlock.Visitor<ContentBlock>(){

                    @NotNull
                    public ContentBlock visitText(@NotNull TextBlock text) {
                        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                        return ContentBlock.Companion.ofText(text);
                    }

                    @NotNull
                    public ContentBlock visitToolUse(@NotNull ToolUseBlock toolUse) {
                        Intrinsics.checkNotNullParameter((Object)toolUse, (String)"toolUse");
                        return ContentBlock.Companion.ofToolUse(toolUse);
                    }

                    @NotNull
                    public ContentBlock visitThinking(@NotNull ThinkingBlock thinking) {
                        Intrinsics.checkNotNullParameter((Object)thinking, (String)"thinking");
                        return ContentBlock.Companion.ofThinking(thinking);
                    }

                    @NotNull
                    public ContentBlock visitRedactedThinking(@NotNull RedactedThinkingBlock redactedThinking) {
                        Intrinsics.checkNotNullParameter((Object)redactedThinking, (String)"redactedThinking");
                        return ContentBlock.Companion.ofRedactedThinking(redactedThinking);
                    }
                }));
            }

            public void visitContentBlockDelta(@NotNull RawContentBlockDeltaEvent contentBlockDelta) {
                Intrinsics.checkNotNullParameter((Object)contentBlockDelta, (String)"contentBlockDelta");
                long index = contentBlockDelta.index();
                ContentBlock contentBlock = (ContentBlock)MessageAccumulator.access$getMessageContent$p(this.this$0).get(index);
                if (contentBlock == null) {
                    throw new AnthropicInvalidDataException("Content block not started for index " + index + '.', null, 2, null);
                }
                ContentBlock oldContentBlock = contentBlock;
                Long l = index;
                MessageAccumulator.access$getMessageContent$p(this.this$0).put(l, contentBlockDelta.delta().accept((RawContentBlockDelta.Visitor)new RawContentBlockDelta.Visitor<ContentBlock>(oldContentBlock, this.this$0, index){
                    final /* synthetic */ ContentBlock $oldContentBlock;
                    final /* synthetic */ MessageAccumulator this$0;
                    final /* synthetic */ long $index;
                    {
                        this.$oldContentBlock = $oldContentBlock;
                        this.this$0 = $receiver;
                        this.$index = $index;
                    }

                    @NotNull
                    public ContentBlock visitText(@NotNull TextDelta text) {
                        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                        return MessageAccumulator.Companion.mergeTextDelta$anthropic_java_core(this.$oldContentBlock, text);
                    }

                    @NotNull
                    public ContentBlock visitInputJson(@NotNull InputJsonDelta inputJson) {
                        Intrinsics.checkNotNullParameter((Object)inputJson, (String)"inputJson");
                        accumulate.visitContentBlockDelta.1 var2_2 = this;
                        MessageAccumulator messageAccumulator = this.this$0;
                        long l = this.$index;
                        ContentBlock contentBlock = this.$oldContentBlock;
                        accumulate.visitContentBlockDelta.1 $this$visitInputJson_u24lambda_u240 = var2_2;
                        boolean bl = false;
                        String oldInputJson = (String)MessageAccumulator.access$getMessageContentInputJson$p(messageAccumulator).get(l);
                        Long l2 = l;
                        Map map2 = MessageAccumulator.access$getMessageContentInputJson$p(messageAccumulator);
                        StringBuilder stringBuilder = new StringBuilder();
                        String string = oldInputJson;
                        if (string == null) {
                            string = "";
                        }
                        map2.put(l2, stringBuilder.append(string).append(inputJson.partialJson()).toString());
                        return contentBlock;
                    }

                    @NotNull
                    public ContentBlock visitCitations(@NotNull CitationsDelta citations2) {
                        Intrinsics.checkNotNullParameter((Object)citations2, (String)"citations");
                        return MessageAccumulator.Companion.mergeCitationsDelta$anthropic_java_core(this.$oldContentBlock, citations2);
                    }

                    @NotNull
                    public ContentBlock visitThinking(@NotNull ThinkingDelta thinking) {
                        Intrinsics.checkNotNullParameter((Object)thinking, (String)"thinking");
                        return MessageAccumulator.Companion.mergeThinkingDelta$anthropic_java_core(this.$oldContentBlock, thinking);
                    }

                    @NotNull
                    public ContentBlock visitSignature(@NotNull SignatureDelta signature) {
                        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                        return MessageAccumulator.Companion.mergeSignatureDelta$anthropic_java_core(this.$oldContentBlock, signature);
                    }
                }));
            }

            public void visitContentBlockStop(@NotNull RawContentBlockStopEvent contentBlockStop) {
                Intrinsics.checkNotNullParameter((Object)contentBlockStop, (String)"contentBlockStop");
                long index = contentBlockStop.index();
                ContentBlock contentBlock = (ContentBlock)MessageAccumulator.access$getMessageContent$p(this.this$0).get(index);
                if (contentBlock == null) {
                    throw new AnthropicInvalidDataException("Content block not started for index " + index + '.', null, 2, null);
                }
                ContentBlock oldContentBlock = contentBlock;
                String inputJson = (String)MessageAccumulator.access$getMessageContentInputJson$p(this.this$0).get(index);
                if (oldContentBlock.isToolUse()) {
                    if (inputJson == null) {
                        throw new AnthropicInvalidDataException("Missing input JSON for index " + index + '.', null, 2, null);
                    }
                    Map map2 = MessageAccumulator.access$getMessageContent$p(this.this$0);
                    Long l = index;
                    ToolUseBlock.Builder builder = oldContentBlock.asToolUse().toBuilder();
                    Object object = MessageAccumulator.access$getJSON_MAPPER$cp().readValue(inputJson, JsonObject.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"JSON_MAPPER.readValue(in\u2026, JsonObject::class.java)");
                    ContentBlock contentBlock2 = ContentBlock.Companion.ofToolUse(builder.input((JsonValue)object).build());
                    map2.put(l, contentBlock2);
                }
            }
        });
        return event;
    }

    private final Message.Builder requireMessageBuilder() {
        Message.Builder builder = this.messageBuilder;
        if (builder == null) {
            throw new AnthropicInvalidDataException("'message_start' event not received.", null, 2, null);
        }
        return builder;
    }

    private final Usage requireMessageUsage() {
        Usage usage = this.messageUsage;
        if (usage == null) {
            throw new AnthropicInvalidDataException("'message_start' event not received.", null, 2, null);
        }
        return usage;
    }

    @JvmStatic
    @NotNull
    public static final MessageAccumulator create() {
        return Companion.create();
    }

    public /* synthetic */ MessageAccumulator(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final /* synthetic */ Message.Builder access$getMessageBuilder$p(MessageAccumulator $this) {
        return $this.messageBuilder;
    }

    public static final /* synthetic */ void access$setMessageBuilder$p(MessageAccumulator $this, Message.Builder builder) {
        $this.messageBuilder = builder;
    }

    public static final /* synthetic */ void access$setMessageUsage$p(MessageAccumulator $this, Usage usage) {
        $this.messageUsage = usage;
    }

    public static final /* synthetic */ Message.Builder access$requireMessageBuilder(MessageAccumulator $this) {
        return $this.requireMessageBuilder();
    }

    public static final /* synthetic */ Usage access$requireMessageUsage(MessageAccumulator $this) {
        return $this.requireMessageUsage();
    }

    public static final /* synthetic */ void access$setMessage$p(MessageAccumulator $this, Message message) {
        $this.message = message;
    }

    public static final /* synthetic */ Map access$getMessageContent$p(MessageAccumulator $this) {
        return $this.messageContent;
    }

    public static final /* synthetic */ Map access$getMessageContentInputJson$p(MessageAccumulator $this) {
        return $this.messageContentInputJson;
    }

    public static final /* synthetic */ JsonMapper access$getJSON_MAPPER$cp() {
        return JSON_MAPPER;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\b\u0010\n\u001a\u00020\u000bH\u0007J\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000fJ\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u001d\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u001d\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/anthropic/helpers/MessageAccumulator$Companion;", "", "()V", "JSON_MAPPER", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "citationsDeltaToTextCitation", "Lcom/anthropic/models/messages/TextCitation;", "citationsDelta", "Lcom/anthropic/models/messages/CitationsDelta;", "citationsDeltaToTextCitation$anthropic_java_core", "create", "Lcom/anthropic/helpers/MessageAccumulator;", "mergeCitationsDelta", "Lcom/anthropic/models/messages/ContentBlock;", "contentBlock", "mergeCitationsDelta$anthropic_java_core", "mergeMessageUsage", "Lcom/anthropic/models/messages/Usage;", "usage", "deltaUsage", "Lcom/anthropic/models/messages/MessageDeltaUsage;", "mergeMessageUsage$anthropic_java_core", "mergeSignatureDelta", "signatureDelta", "Lcom/anthropic/models/messages/SignatureDelta;", "mergeSignatureDelta$anthropic_java_core", "mergeTextDelta", "textDelta", "Lcom/anthropic/models/messages/TextDelta;", "mergeTextDelta$anthropic_java_core", "mergeThinkingDelta", "thinkingDelta", "Lcom/anthropic/models/messages/ThinkingDelta;", "mergeThinkingDelta$anthropic_java_core", "anthropic-java-core"})
    @SourceDebugExtension(value={"SMAP\nMessageAccumulator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageAccumulator.kt\ncom/anthropic/helpers/MessageAccumulator$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,350:1\n1#2:351\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MessageAccumulator create() {
            return new MessageAccumulator(null);
        }

        public final /* synthetic */ Usage mergeMessageUsage$anthropic_java_core(Usage usage, MessageDeltaUsage deltaUsage) {
            Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
            Intrinsics.checkNotNullParameter((Object)deltaUsage, (String)"deltaUsage");
            return usage.toBuilder().outputTokens(usage.outputTokens() + deltaUsage.outputTokens()).build();
        }

        public final /* synthetic */ ContentBlock mergeTextDelta$anthropic_java_core(ContentBlock contentBlock, TextDelta textDelta) {
            Intrinsics.checkNotNullParameter((Object)contentBlock, (String)"contentBlock");
            Intrinsics.checkNotNullParameter((Object)textDelta, (String)"textDelta");
            if (!contentBlock.isText()) {
                boolean $i$a$-require-MessageAccumulator$Companion$mergeTextDelta$22 = false;
                String $i$a$-require-MessageAccumulator$Companion$mergeTextDelta$22 = "Content block is not a text block.";
                throw new IllegalArgumentException($i$a$-require-MessageAccumulator$Companion$mergeTextDelta$22.toString());
            }
            TextBlock oldTextBlock = contentBlock.asText();
            TextBlock newTextBlock = oldTextBlock.toBuilder().text(oldTextBlock.text() + textDelta.text()).build();
            return ContentBlock.Companion.ofText(newTextBlock);
        }

        public final /* synthetic */ ContentBlock mergeCitationsDelta$anthropic_java_core(ContentBlock contentBlock, CitationsDelta citationsDelta) {
            Intrinsics.checkNotNullParameter((Object)contentBlock, (String)"contentBlock");
            Intrinsics.checkNotNullParameter((Object)citationsDelta, (String)"citationsDelta");
            if (!contentBlock.isText()) {
                boolean $i$a$-require-MessageAccumulator$Companion$mergeCitationsDelta$22 = false;
                String $i$a$-require-MessageAccumulator$Companion$mergeCitationsDelta$22 = "Content block is not a text block.";
                throw new IllegalArgumentException($i$a$-require-MessageAccumulator$Companion$mergeCitationsDelta$22.toString());
            }
            TextBlock oldTextBlock = contentBlock.asText();
            TextBlock newTextBlock = oldTextBlock.toBuilder().addCitation(this.citationsDeltaToTextCitation$anthropic_java_core(citationsDelta)).build();
            return ContentBlock.Companion.ofText(newTextBlock);
        }

        public final /* synthetic */ ContentBlock mergeThinkingDelta$anthropic_java_core(ContentBlock contentBlock, ThinkingDelta thinkingDelta) {
            Intrinsics.checkNotNullParameter((Object)contentBlock, (String)"contentBlock");
            Intrinsics.checkNotNullParameter((Object)thinkingDelta, (String)"thinkingDelta");
            if (!contentBlock.isThinking()) {
                boolean $i$a$-require-MessageAccumulator$Companion$mergeThinkingDelta$22 = false;
                String $i$a$-require-MessageAccumulator$Companion$mergeThinkingDelta$22 = "Content block is not a thinking block.";
                throw new IllegalArgumentException($i$a$-require-MessageAccumulator$Companion$mergeThinkingDelta$22.toString());
            }
            ThinkingBlock oldThinkingBlock = contentBlock.asThinking();
            ThinkingBlock newThinkingBlock = oldThinkingBlock.toBuilder().thinking(oldThinkingBlock.thinking() + thinkingDelta.thinking()).build();
            return ContentBlock.Companion.ofThinking(newThinkingBlock);
        }

        public final /* synthetic */ ContentBlock mergeSignatureDelta$anthropic_java_core(ContentBlock contentBlock, SignatureDelta signatureDelta) {
            Intrinsics.checkNotNullParameter((Object)contentBlock, (String)"contentBlock");
            Intrinsics.checkNotNullParameter((Object)signatureDelta, (String)"signatureDelta");
            if (!contentBlock.isThinking()) {
                boolean $i$a$-require-MessageAccumulator$Companion$mergeSignatureDelta$22 = false;
                String $i$a$-require-MessageAccumulator$Companion$mergeSignatureDelta$22 = "Content block is not a thinking block.";
                throw new IllegalArgumentException($i$a$-require-MessageAccumulator$Companion$mergeSignatureDelta$22.toString());
            }
            ThinkingBlock oldThinkingBlock = contentBlock.asThinking();
            ThinkingBlock newThinkingBlock = oldThinkingBlock.toBuilder().signature(signatureDelta.signature()).build();
            return ContentBlock.Companion.ofThinking(newThinkingBlock);
        }

        public final /* synthetic */ TextCitation citationsDeltaToTextCitation$anthropic_java_core(CitationsDelta citationsDelta) {
            Intrinsics.checkNotNullParameter((Object)citationsDelta, (String)"citationsDelta");
            return (TextCitation)citationsDelta.citation().accept((CitationsDelta.Citation.Visitor)new CitationsDelta.Citation.Visitor<TextCitation>(){

                @NotNull
                public TextCitation visitCharLocation(@NotNull CitationCharLocation charLocation) {
                    Intrinsics.checkNotNullParameter((Object)charLocation, (String)"charLocation");
                    return TextCitation.Companion.ofCitationCharLocation(charLocation);
                }

                @NotNull
                public TextCitation visitPageLocation(@NotNull CitationPageLocation pageLocation) {
                    Intrinsics.checkNotNullParameter((Object)pageLocation, (String)"pageLocation");
                    return TextCitation.Companion.ofCitationPageLocation(pageLocation);
                }

                @NotNull
                public TextCitation visitContentBlockLocation(@NotNull CitationContentBlockLocation contentBlockLocation) {
                    Intrinsics.checkNotNullParameter((Object)contentBlockLocation, (String)"contentBlockLocation");
                    return TextCitation.Companion.ofCitationContentBlockLocation(contentBlockLocation);
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

