/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.models.beta;

import com.anthropic.core.BaseDeserializer;
import com.anthropic.core.BaseSerializer;
import com.anthropic.core.JsonField;
import com.anthropic.core.JsonValue;
import com.anthropic.core.Utils;
import com.anthropic.errors.AnthropicInvalidDataException;
import com.anthropic.models.beta.BetaApiError;
import com.anthropic.models.beta.BetaAuthenticationError;
import com.anthropic.models.beta.BetaBillingError;
import com.anthropic.models.beta.BetaGatewayTimeoutError;
import com.anthropic.models.beta.BetaInvalidRequestError;
import com.anthropic.models.beta.BetaNotFoundError;
import com.anthropic.models.beta.BetaOverloadedError;
import com.anthropic.models.beta.BetaPermissionError;
import com.anthropic.models.beta.BetaRateLimitError;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\b\b\u0007\u0018\u0000 ;2\u00020\u0001:\u0004;<=>B\u007f\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019J\u001f\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001d\u00a2\u0006\u0002\u0010\u001eJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019J\u0006\u0010\u001f\u001a\u00020\u0011J\u0006\u0010 \u001a\u00020\u0005J\u0006\u0010!\u001a\u00020\u0007J\u0006\u0010\"\u001a\u00020\u000fJ\u0006\u0010#\u001a\u00020\u0003J\u0006\u0010$\u001a\u00020\u000bJ\u0006\u0010%\u001a\u00020\u0013J\u0006\u0010&\u001a\u00020\tJ\u0006\u0010'\u001a\u00020\rJ\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019J\u0013\u0010(\u001a\u00020\u00182\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019J\b\u0010*\u001a\u00020+H\u0016J\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019J\u0006\u0010,\u001a\u00020\u0018J\u0006\u0010-\u001a\u00020\u0018J\u0006\u0010.\u001a\u00020\u0018J\u0006\u0010/\u001a\u00020\u0018J\u0006\u00100\u001a\u00020\u0018J\u0006\u00101\u001a\u00020\u0018J\u0006\u00102\u001a\u00020\u0018J\u0006\u00103\u001a\u00020\u0018J\u0006\u00104\u001a\u00020\u0018J\u0006\u00105\u001a\u00020\u0018J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0019J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0019J\b\u00106\u001a\u000207H\u0016J\u0006\u00108\u001a\u00020\u0000J\r\u00109\u001a\u00020+H\u0000\u00a2\u0006\u0002\b:R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/anthropic/models/beta/BetaError;", "", "invalidRequest", "Lcom/anthropic/models/beta/BetaInvalidRequestError;", "authentication", "Lcom/anthropic/models/beta/BetaAuthenticationError;", "billing", "Lcom/anthropic/models/beta/BetaBillingError;", "permission", "Lcom/anthropic/models/beta/BetaPermissionError;", "notFound", "Lcom/anthropic/models/beta/BetaNotFoundError;", "rateLimit", "Lcom/anthropic/models/beta/BetaRateLimitError;", "gatewayTimeout", "Lcom/anthropic/models/beta/BetaGatewayTimeoutError;", "api", "Lcom/anthropic/models/beta/BetaApiError;", "overloaded", "Lcom/anthropic/models/beta/BetaOverloadedError;", "_json", "Lcom/anthropic/core/JsonValue;", "(Lcom/anthropic/models/beta/BetaInvalidRequestError;Lcom/anthropic/models/beta/BetaAuthenticationError;Lcom/anthropic/models/beta/BetaBillingError;Lcom/anthropic/models/beta/BetaPermissionError;Lcom/anthropic/models/beta/BetaNotFoundError;Lcom/anthropic/models/beta/BetaRateLimitError;Lcom/anthropic/models/beta/BetaGatewayTimeoutError;Lcom/anthropic/models/beta/BetaApiError;Lcom/anthropic/models/beta/BetaOverloadedError;Lcom/anthropic/core/JsonValue;)V", "validated", "", "Ljava/util/Optional;", "accept", "T", "visitor", "Lcom/anthropic/models/beta/BetaError$Visitor;", "(Lcom/anthropic/models/beta/BetaError$Visitor;)Ljava/lang/Object;", "asApi", "asAuthentication", "asBilling", "asGatewayTimeout", "asInvalidRequest", "asNotFound", "asOverloaded", "asPermission", "asRateLimit", "equals", "other", "hashCode", "", "isApi", "isAuthentication", "isBilling", "isGatewayTimeout", "isInvalidRequest", "isNotFound", "isOverloaded", "isPermission", "isRateLimit", "isValid", "toString", "", "validate", "validity", "validity$anthropic_java_core", "Companion", "Deserializer", "Serializer", "Visitor", "anthropic-java-core"})
public final class BetaError {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final BetaInvalidRequestError invalidRequest;
    @Nullable
    private final BetaAuthenticationError authentication;
    @Nullable
    private final BetaBillingError billing;
    @Nullable
    private final BetaPermissionError permission;
    @Nullable
    private final BetaNotFoundError notFound;
    @Nullable
    private final BetaRateLimitError rateLimit;
    @Nullable
    private final BetaGatewayTimeoutError gatewayTimeout;
    @Nullable
    private final BetaApiError api;
    @Nullable
    private final BetaOverloadedError overloaded;
    @Nullable
    private final JsonValue _json;
    private boolean validated;

    private BetaError(BetaInvalidRequestError invalidRequest, BetaAuthenticationError authentication, BetaBillingError billing, BetaPermissionError permission, BetaNotFoundError notFound, BetaRateLimitError rateLimit, BetaGatewayTimeoutError gatewayTimeout, BetaApiError api, BetaOverloadedError overloaded, JsonValue _json) {
        this.invalidRequest = invalidRequest;
        this.authentication = authentication;
        this.billing = billing;
        this.permission = permission;
        this.notFound = notFound;
        this.rateLimit = rateLimit;
        this.gatewayTimeout = gatewayTimeout;
        this.api = api;
        this.overloaded = overloaded;
        this._json = _json;
    }

    /* synthetic */ BetaError(BetaInvalidRequestError betaInvalidRequestError, BetaAuthenticationError betaAuthenticationError, BetaBillingError betaBillingError, BetaPermissionError betaPermissionError, BetaNotFoundError betaNotFoundError, BetaRateLimitError betaRateLimitError, BetaGatewayTimeoutError betaGatewayTimeoutError, BetaApiError betaApiError, BetaOverloadedError betaOverloadedError, JsonValue jsonValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            betaInvalidRequestError = null;
        }
        if ((n & 2) != 0) {
            betaAuthenticationError = null;
        }
        if ((n & 4) != 0) {
            betaBillingError = null;
        }
        if ((n & 8) != 0) {
            betaPermissionError = null;
        }
        if ((n & 0x10) != 0) {
            betaNotFoundError = null;
        }
        if ((n & 0x20) != 0) {
            betaRateLimitError = null;
        }
        if ((n & 0x40) != 0) {
            betaGatewayTimeoutError = null;
        }
        if ((n & 0x80) != 0) {
            betaApiError = null;
        }
        if ((n & 0x100) != 0) {
            betaOverloadedError = null;
        }
        if ((n & 0x200) != 0) {
            jsonValue = null;
        }
        this(betaInvalidRequestError, betaAuthenticationError, betaBillingError, betaPermissionError, betaNotFoundError, betaRateLimitError, betaGatewayTimeoutError, betaApiError, betaOverloadedError, jsonValue);
    }

    @NotNull
    public final Optional<BetaInvalidRequestError> invalidRequest() {
        Optional<BetaInvalidRequestError> optional = Optional.ofNullable(this.invalidRequest);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(invalidRequest)");
        return optional;
    }

    @NotNull
    public final Optional<BetaAuthenticationError> authentication() {
        Optional<BetaAuthenticationError> optional = Optional.ofNullable(this.authentication);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(authentication)");
        return optional;
    }

    @NotNull
    public final Optional<BetaBillingError> billing() {
        Optional<BetaBillingError> optional = Optional.ofNullable(this.billing);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(billing)");
        return optional;
    }

    @NotNull
    public final Optional<BetaPermissionError> permission() {
        Optional<BetaPermissionError> optional = Optional.ofNullable(this.permission);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(permission)");
        return optional;
    }

    @NotNull
    public final Optional<BetaNotFoundError> notFound() {
        Optional<BetaNotFoundError> optional = Optional.ofNullable(this.notFound);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(notFound)");
        return optional;
    }

    @NotNull
    public final Optional<BetaRateLimitError> rateLimit() {
        Optional<BetaRateLimitError> optional = Optional.ofNullable(this.rateLimit);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(rateLimit)");
        return optional;
    }

    @NotNull
    public final Optional<BetaGatewayTimeoutError> gatewayTimeout() {
        Optional<BetaGatewayTimeoutError> optional = Optional.ofNullable(this.gatewayTimeout);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(gatewayTimeout)");
        return optional;
    }

    @NotNull
    public final Optional<BetaApiError> api() {
        Optional<BetaApiError> optional = Optional.ofNullable(this.api);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(api)");
        return optional;
    }

    @NotNull
    public final Optional<BetaOverloadedError> overloaded() {
        Optional<BetaOverloadedError> optional = Optional.ofNullable(this.overloaded);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(overloaded)");
        return optional;
    }

    public final boolean isInvalidRequest() {
        return this.invalidRequest != null;
    }

    public final boolean isAuthentication() {
        return this.authentication != null;
    }

    public final boolean isBilling() {
        return this.billing != null;
    }

    public final boolean isPermission() {
        return this.permission != null;
    }

    public final boolean isNotFound() {
        return this.notFound != null;
    }

    public final boolean isRateLimit() {
        return this.rateLimit != null;
    }

    public final boolean isGatewayTimeout() {
        return this.gatewayTimeout != null;
    }

    public final boolean isApi() {
        return this.api != null;
    }

    public final boolean isOverloaded() {
        return this.overloaded != null;
    }

    @NotNull
    public final BetaInvalidRequestError asInvalidRequest() {
        return (BetaInvalidRequestError)Utils.getOrThrow(this.invalidRequest, "invalidRequest");
    }

    @NotNull
    public final BetaAuthenticationError asAuthentication() {
        return (BetaAuthenticationError)Utils.getOrThrow(this.authentication, "authentication");
    }

    @NotNull
    public final BetaBillingError asBilling() {
        return (BetaBillingError)Utils.getOrThrow(this.billing, "billing");
    }

    @NotNull
    public final BetaPermissionError asPermission() {
        return (BetaPermissionError)Utils.getOrThrow(this.permission, "permission");
    }

    @NotNull
    public final BetaNotFoundError asNotFound() {
        return (BetaNotFoundError)Utils.getOrThrow(this.notFound, "notFound");
    }

    @NotNull
    public final BetaRateLimitError asRateLimit() {
        return (BetaRateLimitError)Utils.getOrThrow(this.rateLimit, "rateLimit");
    }

    @NotNull
    public final BetaGatewayTimeoutError asGatewayTimeout() {
        return (BetaGatewayTimeoutError)Utils.getOrThrow(this.gatewayTimeout, "gatewayTimeout");
    }

    @NotNull
    public final BetaApiError asApi() {
        return (BetaApiError)Utils.getOrThrow(this.api, "api");
    }

    @NotNull
    public final BetaOverloadedError asOverloaded() {
        return (BetaOverloadedError)Utils.getOrThrow(this.overloaded, "overloaded");
    }

    @NotNull
    public final Optional<JsonValue> _json() {
        Optional<JsonValue> optional = Optional.ofNullable(this._json);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(_json)");
        return optional;
    }

    public final <T> T accept(@NotNull Visitor<? extends T> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        return this.invalidRequest != null ? visitor.visitInvalidRequest(this.invalidRequest) : (this.authentication != null ? visitor.visitAuthentication(this.authentication) : (this.billing != null ? visitor.visitBilling(this.billing) : (this.permission != null ? visitor.visitPermission(this.permission) : (this.notFound != null ? visitor.visitNotFound(this.notFound) : (this.rateLimit != null ? visitor.visitRateLimit(this.rateLimit) : (this.gatewayTimeout != null ? visitor.visitGatewayTimeout(this.gatewayTimeout) : (this.api != null ? visitor.visitApi(this.api) : (this.overloaded != null ? visitor.visitOverloaded(this.overloaded) : visitor.unknown(this._json)))))))));
    }

    @NotNull
    public final BetaError validate() {
        BetaError betaError;
        BetaError $this$validate_u24lambda_u240 = betaError = this;
        boolean bl = false;
        if (!$this$validate_u24lambda_u240.validated) {
            $this$validate_u24lambda_u240.accept((Visitor)new Visitor<Unit>(){

                public void visitInvalidRequest(@NotNull BetaInvalidRequestError invalidRequest) {
                    Intrinsics.checkNotNullParameter((Object)invalidRequest, (String)"invalidRequest");
                    invalidRequest.validate();
                }

                public void visitAuthentication(@NotNull BetaAuthenticationError authentication) {
                    Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
                    authentication.validate();
                }

                public void visitBilling(@NotNull BetaBillingError billing) {
                    Intrinsics.checkNotNullParameter((Object)billing, (String)"billing");
                    billing.validate();
                }

                public void visitPermission(@NotNull BetaPermissionError permission) {
                    Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
                    permission.validate();
                }

                public void visitNotFound(@NotNull BetaNotFoundError notFound) {
                    Intrinsics.checkNotNullParameter((Object)notFound, (String)"notFound");
                    notFound.validate();
                }

                public void visitRateLimit(@NotNull BetaRateLimitError rateLimit) {
                    Intrinsics.checkNotNullParameter((Object)rateLimit, (String)"rateLimit");
                    rateLimit.validate();
                }

                public void visitGatewayTimeout(@NotNull BetaGatewayTimeoutError gatewayTimeout) {
                    Intrinsics.checkNotNullParameter((Object)gatewayTimeout, (String)"gatewayTimeout");
                    gatewayTimeout.validate();
                }

                public void visitApi(@NotNull BetaApiError api) {
                    Intrinsics.checkNotNullParameter((Object)api, (String)"api");
                    api.validate();
                }

                public void visitOverloaded(@NotNull BetaOverloadedError overloaded) {
                    Intrinsics.checkNotNullParameter((Object)overloaded, (String)"overloaded");
                    overloaded.validate();
                }
            });
            $this$validate_u24lambda_u240.validated = true;
        }
        return betaError;
    }

    public final boolean isValid() {
        boolean bl;
        try {
            this.validate();
            bl = true;
        }
        catch (AnthropicInvalidDataException e) {
            bl = false;
        }
        return bl;
    }

    public final /* synthetic */ int validity$anthropic_java_core() {
        return ((Number)this.accept((Visitor)new Visitor<Integer>(){

            @NotNull
            public Integer visitInvalidRequest(@NotNull BetaInvalidRequestError invalidRequest) {
                Intrinsics.checkNotNullParameter((Object)invalidRequest, (String)"invalidRequest");
                return invalidRequest.validity$anthropic_java_core();
            }

            @NotNull
            public Integer visitAuthentication(@NotNull BetaAuthenticationError authentication) {
                Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
                return authentication.validity$anthropic_java_core();
            }

            @NotNull
            public Integer visitBilling(@NotNull BetaBillingError billing) {
                Intrinsics.checkNotNullParameter((Object)billing, (String)"billing");
                return billing.validity$anthropic_java_core();
            }

            @NotNull
            public Integer visitPermission(@NotNull BetaPermissionError permission) {
                Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
                return permission.validity$anthropic_java_core();
            }

            @NotNull
            public Integer visitNotFound(@NotNull BetaNotFoundError notFound) {
                Intrinsics.checkNotNullParameter((Object)notFound, (String)"notFound");
                return notFound.validity$anthropic_java_core();
            }

            @NotNull
            public Integer visitRateLimit(@NotNull BetaRateLimitError rateLimit) {
                Intrinsics.checkNotNullParameter((Object)rateLimit, (String)"rateLimit");
                return rateLimit.validity$anthropic_java_core();
            }

            @NotNull
            public Integer visitGatewayTimeout(@NotNull BetaGatewayTimeoutError gatewayTimeout) {
                Intrinsics.checkNotNullParameter((Object)gatewayTimeout, (String)"gatewayTimeout");
                return gatewayTimeout.validity$anthropic_java_core();
            }

            @NotNull
            public Integer visitApi(@NotNull BetaApiError api) {
                Intrinsics.checkNotNullParameter((Object)api, (String)"api");
                return api.validity$anthropic_java_core();
            }

            @NotNull
            public Integer visitOverloaded(@NotNull BetaOverloadedError overloaded) {
                Intrinsics.checkNotNullParameter((Object)overloaded, (String)"overloaded");
                return overloaded.validity$anthropic_java_core();
            }

            @NotNull
            public Integer unknown(@Nullable JsonValue json2) {
                return 0;
            }
        })).intValue();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BetaError && Intrinsics.areEqual((Object)this.invalidRequest, (Object)((BetaError)other).invalidRequest) && Intrinsics.areEqual((Object)this.authentication, (Object)((BetaError)other).authentication) && Intrinsics.areEqual((Object)this.billing, (Object)((BetaError)other).billing) && Intrinsics.areEqual((Object)this.permission, (Object)((BetaError)other).permission) && Intrinsics.areEqual((Object)this.notFound, (Object)((BetaError)other).notFound) && Intrinsics.areEqual((Object)this.rateLimit, (Object)((BetaError)other).rateLimit) && Intrinsics.areEqual((Object)this.gatewayTimeout, (Object)((BetaError)other).gatewayTimeout) && Intrinsics.areEqual((Object)this.api, (Object)((BetaError)other).api) && Intrinsics.areEqual((Object)this.overloaded, (Object)((BetaError)other).overloaded);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.invalidRequest, this.authentication, this.billing, this.permission, this.notFound, this.rateLimit, this.gatewayTimeout, this.api, this.overloaded};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        String string;
        if (this.invalidRequest != null) {
            string = "BetaError{invalidRequest=" + this.invalidRequest + '}';
        } else if (this.authentication != null) {
            string = "BetaError{authentication=" + this.authentication + '}';
        } else if (this.billing != null) {
            string = "BetaError{billing=" + this.billing + '}';
        } else if (this.permission != null) {
            string = "BetaError{permission=" + this.permission + '}';
        } else if (this.notFound != null) {
            string = "BetaError{notFound=" + this.notFound + '}';
        } else if (this.rateLimit != null) {
            string = "BetaError{rateLimit=" + this.rateLimit + '}';
        } else if (this.gatewayTimeout != null) {
            string = "BetaError{gatewayTimeout=" + this.gatewayTimeout + '}';
        } else if (this.api != null) {
            string = "BetaError{api=" + this.api + '}';
        } else if (this.overloaded != null) {
            string = "BetaError{overloaded=" + this.overloaded + '}';
        } else if (this._json != null) {
            string = "BetaError{_unknown=" + this._json + '}';
        } else {
            throw new IllegalStateException("Invalid BetaError");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final BetaError ofInvalidRequest(@NotNull BetaInvalidRequestError invalidRequest) {
        return Companion.ofInvalidRequest(invalidRequest);
    }

    @JvmStatic
    @NotNull
    public static final BetaError ofAuthentication(@NotNull BetaAuthenticationError authentication) {
        return Companion.ofAuthentication(authentication);
    }

    @JvmStatic
    @NotNull
    public static final BetaError ofBilling(@NotNull BetaBillingError billing) {
        return Companion.ofBilling(billing);
    }

    @JvmStatic
    @NotNull
    public static final BetaError ofPermission(@NotNull BetaPermissionError permission) {
        return Companion.ofPermission(permission);
    }

    @JvmStatic
    @NotNull
    public static final BetaError ofNotFound(@NotNull BetaNotFoundError notFound) {
        return Companion.ofNotFound(notFound);
    }

    @JvmStatic
    @NotNull
    public static final BetaError ofRateLimit(@NotNull BetaRateLimitError rateLimit) {
        return Companion.ofRateLimit(rateLimit);
    }

    @JvmStatic
    @NotNull
    public static final BetaError ofGatewayTimeout(@NotNull BetaGatewayTimeoutError gatewayTimeout) {
        return Companion.ofGatewayTimeout(gatewayTimeout);
    }

    @JvmStatic
    @NotNull
    public static final BetaError ofApi(@NotNull BetaApiError api) {
        return Companion.ofApi(api);
    }

    @JvmStatic
    @NotNull
    public static final BetaError ofOverloaded(@NotNull BetaOverloadedError overloaded) {
        return Companion.ofOverloaded(overloaded);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007\u00a8\u0006\u001f"}, d2={"Lcom/anthropic/models/beta/BetaError$Companion;", "", "()V", "ofApi", "Lcom/anthropic/models/beta/BetaError;", "api", "Lcom/anthropic/models/beta/BetaApiError;", "ofAuthentication", "authentication", "Lcom/anthropic/models/beta/BetaAuthenticationError;", "ofBilling", "billing", "Lcom/anthropic/models/beta/BetaBillingError;", "ofGatewayTimeout", "gatewayTimeout", "Lcom/anthropic/models/beta/BetaGatewayTimeoutError;", "ofInvalidRequest", "invalidRequest", "Lcom/anthropic/models/beta/BetaInvalidRequestError;", "ofNotFound", "notFound", "Lcom/anthropic/models/beta/BetaNotFoundError;", "ofOverloaded", "overloaded", "Lcom/anthropic/models/beta/BetaOverloadedError;", "ofPermission", "permission", "Lcom/anthropic/models/beta/BetaPermissionError;", "ofRateLimit", "rateLimit", "Lcom/anthropic/models/beta/BetaRateLimitError;", "anthropic-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BetaError ofInvalidRequest(@NotNull BetaInvalidRequestError invalidRequest) {
            Intrinsics.checkNotNullParameter((Object)invalidRequest, (String)"invalidRequest");
            return new BetaError(invalidRequest, null, null, null, null, null, null, null, null, null, 1022, null);
        }

        @JvmStatic
        @NotNull
        public final BetaError ofAuthentication(@NotNull BetaAuthenticationError authentication) {
            Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
            return new BetaError(null, authentication, null, null, null, null, null, null, null, null, 1021, null);
        }

        @JvmStatic
        @NotNull
        public final BetaError ofBilling(@NotNull BetaBillingError billing) {
            Intrinsics.checkNotNullParameter((Object)billing, (String)"billing");
            return new BetaError(null, null, billing, null, null, null, null, null, null, null, 1019, null);
        }

        @JvmStatic
        @NotNull
        public final BetaError ofPermission(@NotNull BetaPermissionError permission) {
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
            return new BetaError(null, null, null, permission, null, null, null, null, null, null, 1015, null);
        }

        @JvmStatic
        @NotNull
        public final BetaError ofNotFound(@NotNull BetaNotFoundError notFound) {
            Intrinsics.checkNotNullParameter((Object)notFound, (String)"notFound");
            return new BetaError(null, null, null, null, notFound, null, null, null, null, null, 1007, null);
        }

        @JvmStatic
        @NotNull
        public final BetaError ofRateLimit(@NotNull BetaRateLimitError rateLimit) {
            Intrinsics.checkNotNullParameter((Object)rateLimit, (String)"rateLimit");
            return new BetaError(null, null, null, null, null, rateLimit, null, null, null, null, 991, null);
        }

        @JvmStatic
        @NotNull
        public final BetaError ofGatewayTimeout(@NotNull BetaGatewayTimeoutError gatewayTimeout) {
            Intrinsics.checkNotNullParameter((Object)gatewayTimeout, (String)"gatewayTimeout");
            return new BetaError(null, null, null, null, null, null, gatewayTimeout, null, null, null, 959, null);
        }

        @JvmStatic
        @NotNull
        public final BetaError ofApi(@NotNull BetaApiError api) {
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            return new BetaError(null, null, null, null, null, null, null, api, null, null, 895, null);
        }

        @JvmStatic
        @NotNull
        public final BetaError ofOverloaded(@NotNull BetaOverloadedError overloaded) {
            Intrinsics.checkNotNullParameter((Object)overloaded, (String)"overloaded");
            return new BetaError(null, null, null, null, null, null, null, null, overloaded, null, 767, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/anthropic/models/beta/BetaError$Deserializer;", "Lcom/anthropic/core/BaseDeserializer;", "Lcom/anthropic/models/beta/BetaError;", "()V", "deserialize", "Lcom/fasterxml/jackson/core/ObjectCodec;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "anthropic-java-core"})
    @SourceDebugExtension(value={"SMAP\nBetaError.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BetaError.kt\ncom/anthropic/models/beta/BetaError$Deserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,370:1\n43#2:371\n43#2:372\n43#2:373\n43#2:374\n43#2:375\n43#2:376\n43#2:377\n43#2:378\n43#2:379\n*S KotlinDebug\n*F\n+ 1 BetaError.kt\ncom/anthropic/models/beta/BetaError$Deserializer\n*L\n297#1:371\n302#1:372\n307#1:373\n312#1:374\n317#1:375\n322#1:376\n327#1:377\n332#1:378\n337#1:379\n*E\n"})
    public static final class Deserializer
    extends BaseDeserializer<BetaError> {
        public Deserializer() {
            super(Reflection.getOrCreateKotlinClass(BetaError.class));
        }

        @Override
        @NotNull
        protected BetaError deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
            JsonValue json2;
            block49: {
                String type;
                Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                json2 = JsonValue.Companion.fromJsonNode(node);
                Object object = (Map)OptionalsKt.getOrNull(json2.asObject());
                String string = type = object != null && (object = (JsonValue)object.get("type")) != null && (object = ((JsonField)object).asString()) != null ? (String)OptionalsKt.getOrNull(object) : null;
                if (string == null) break block49;
                int n = -1;
                switch (string.hashCode()) {
                    case 1258890136: {
                        if (string.equals("permission_error")) {
                            n = 1;
                        }
                        break;
                    }
                    case -1266459263: {
                        if (string.equals("authentication_error")) {
                            n = 2;
                        }
                        break;
                    }
                    case 1888290719: {
                        if (string.equals("not_found_error")) {
                            n = 3;
                        }
                        break;
                    }
                    case -88001629: {
                        if (string.equals("api_error")) {
                            n = 4;
                        }
                        break;
                    }
                    case -656062448: {
                        if (string.equals("invalid_request_error")) {
                            n = 5;
                        }
                        break;
                    }
                    case 1700738474: {
                        if (string.equals("timeout_error")) {
                            n = 6;
                        }
                        break;
                    }
                    case -1194176700: {
                        if (string.equals("billing_error")) {
                            n = 7;
                        }
                        break;
                    }
                    case 729998245: {
                        if (string.equals("rate_limit_error")) {
                            n = 8;
                        }
                        break;
                    }
                    case 579677218: {
                        if (string.equals("overloaded_error")) {
                            n = 9;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 5: {
                        BetaError betaError;
                        boolean $i$f$jacksonTypeRef = false;
                        BetaInvalidRequestError betaInvalidRequestError = (BetaInvalidRequestError)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<BetaInvalidRequestError>(){});
                        if (betaInvalidRequestError != null) {
                            BetaInvalidRequestError it = betaInvalidRequestError;
                            boolean bl = false;
                            betaError = new BetaError(it, null, null, null, null, null, null, null, null, json2, 510, null);
                        } else {
                            betaError = new BetaError(null, null, null, null, null, null, null, null, null, json2, 511, null);
                        }
                        return betaError;
                    }
                    case 2: {
                        BetaError betaError;
                        boolean $i$f$jacksonTypeRef = false;
                        BetaAuthenticationError betaAuthenticationError = (BetaAuthenticationError)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<BetaAuthenticationError>(){});
                        if (betaAuthenticationError != null) {
                            BetaAuthenticationError it = betaAuthenticationError;
                            boolean bl = false;
                            betaError = new BetaError(null, it, null, null, null, null, null, null, null, json2, 509, null);
                        } else {
                            betaError = new BetaError(null, null, null, null, null, null, null, null, null, json2, 511, null);
                        }
                        return betaError;
                    }
                    case 7: {
                        BetaError betaError;
                        boolean $i$f$jacksonTypeRef = false;
                        BetaBillingError betaBillingError = (BetaBillingError)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<BetaBillingError>(){});
                        if (betaBillingError != null) {
                            BetaBillingError it = betaBillingError;
                            boolean bl = false;
                            betaError = new BetaError(null, null, it, null, null, null, null, null, null, json2, 507, null);
                        } else {
                            betaError = new BetaError(null, null, null, null, null, null, null, null, null, json2, 511, null);
                        }
                        return betaError;
                    }
                    case 1: {
                        BetaError betaError;
                        boolean $i$f$jacksonTypeRef = false;
                        BetaPermissionError betaPermissionError = (BetaPermissionError)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<BetaPermissionError>(){});
                        if (betaPermissionError != null) {
                            BetaPermissionError it = betaPermissionError;
                            boolean bl = false;
                            betaError = new BetaError(null, null, null, it, null, null, null, null, null, json2, 503, null);
                        } else {
                            betaError = new BetaError(null, null, null, null, null, null, null, null, null, json2, 511, null);
                        }
                        return betaError;
                    }
                    case 3: {
                        BetaError betaError;
                        boolean $i$f$jacksonTypeRef = false;
                        BetaNotFoundError betaNotFoundError = (BetaNotFoundError)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<BetaNotFoundError>(){});
                        if (betaNotFoundError != null) {
                            BetaNotFoundError it = betaNotFoundError;
                            boolean bl = false;
                            betaError = new BetaError(null, null, null, null, it, null, null, null, null, json2, 495, null);
                        } else {
                            betaError = new BetaError(null, null, null, null, null, null, null, null, null, json2, 511, null);
                        }
                        return betaError;
                    }
                    case 8: {
                        BetaError betaError;
                        boolean $i$f$jacksonTypeRef = false;
                        BetaRateLimitError betaRateLimitError = (BetaRateLimitError)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<BetaRateLimitError>(){});
                        if (betaRateLimitError != null) {
                            BetaRateLimitError it = betaRateLimitError;
                            boolean bl = false;
                            betaError = new BetaError(null, null, null, null, null, it, null, null, null, json2, 479, null);
                        } else {
                            betaError = new BetaError(null, null, null, null, null, null, null, null, null, json2, 511, null);
                        }
                        return betaError;
                    }
                    case 6: {
                        BetaError betaError;
                        boolean $i$f$jacksonTypeRef = false;
                        BetaGatewayTimeoutError betaGatewayTimeoutError = (BetaGatewayTimeoutError)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<BetaGatewayTimeoutError>(){});
                        if (betaGatewayTimeoutError != null) {
                            BetaGatewayTimeoutError it = betaGatewayTimeoutError;
                            boolean bl = false;
                            betaError = new BetaError(null, null, null, null, null, null, it, null, null, json2, 447, null);
                        } else {
                            betaError = new BetaError(null, null, null, null, null, null, null, null, null, json2, 511, null);
                        }
                        return betaError;
                    }
                    case 4: {
                        BetaError betaError;
                        boolean $i$f$jacksonTypeRef = false;
                        BetaApiError betaApiError = (BetaApiError)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<BetaApiError>(){});
                        if (betaApiError != null) {
                            BetaApiError it = betaApiError;
                            boolean bl = false;
                            betaError = new BetaError(null, null, null, null, null, null, null, it, null, json2, 383, null);
                        } else {
                            betaError = new BetaError(null, null, null, null, null, null, null, null, null, json2, 511, null);
                        }
                        return betaError;
                    }
                    case 9: {
                        BetaError betaError;
                        boolean $i$f$jacksonTypeRef = false;
                        BetaOverloadedError betaOverloadedError = (BetaOverloadedError)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<BetaOverloadedError>(){});
                        if (betaOverloadedError != null) {
                            BetaOverloadedError it = betaOverloadedError;
                            boolean bl = false;
                            betaError = new BetaError(null, null, null, null, null, null, null, null, it, json2, 255, null);
                        } else {
                            betaError = new BetaError(null, null, null, null, null, null, null, null, null, json2, 511, null);
                        }
                        return betaError;
                    }
                }
            }
            return new BetaError(null, null, null, null, null, null, null, null, null, json2, 511, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/anthropic/models/beta/BetaError$Serializer;", "Lcom/anthropic/core/BaseSerializer;", "Lcom/anthropic/models/beta/BetaError;", "()V", "serialize", "", "value", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "anthropic-java-core"})
    public static final class Serializer
    extends BaseSerializer<BetaError> {
        public Serializer() {
            super(Reflection.getOrCreateKotlinClass(BetaError.class));
        }

        public void serialize(@NotNull BetaError value, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            if (value.invalidRequest != null) {
                generator.writeObject((Object)value.invalidRequest);
            } else if (value.authentication != null) {
                generator.writeObject((Object)value.authentication);
            } else if (value.billing != null) {
                generator.writeObject((Object)value.billing);
            } else if (value.permission != null) {
                generator.writeObject((Object)value.permission);
            } else if (value.notFound != null) {
                generator.writeObject((Object)value.notFound);
            } else if (value.rateLimit != null) {
                generator.writeObject((Object)value.rateLimit);
            } else if (value.gatewayTimeout != null) {
                generator.writeObject((Object)value.gatewayTimeout);
            } else if (value.api != null) {
                generator.writeObject((Object)value.api);
            } else if (value.overloaded != null) {
                generator.writeObject((Object)value.overloaded);
            } else if (value._json != null) {
                generator.writeObject((Object)value._json);
            } else {
                throw new IllegalStateException("Invalid BetaError");
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\u0017\u0010\u0003\u001a\u00028\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0015H&\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u0019H&\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u001dH&\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001f\u001a\u00028\u00002\u0006\u0010 \u001a\u00020!H&\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u00028\u00002\u0006\u0010$\u001a\u00020%H&\u00a2\u0006\u0002\u0010&J\u0015\u0010'\u001a\u00028\u00002\u0006\u0010(\u001a\u00020)H&\u00a2\u0006\u0002\u0010*\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006+\u00c0\u0006\u0001"}, d2={"Lcom/anthropic/models/beta/BetaError$Visitor;", "T", "", "unknown", "json", "Lcom/anthropic/core/JsonValue;", "(Lcom/anthropic/core/JsonValue;)Ljava/lang/Object;", "visitApi", "api", "Lcom/anthropic/models/beta/BetaApiError;", "(Lcom/anthropic/models/beta/BetaApiError;)Ljava/lang/Object;", "visitAuthentication", "authentication", "Lcom/anthropic/models/beta/BetaAuthenticationError;", "(Lcom/anthropic/models/beta/BetaAuthenticationError;)Ljava/lang/Object;", "visitBilling", "billing", "Lcom/anthropic/models/beta/BetaBillingError;", "(Lcom/anthropic/models/beta/BetaBillingError;)Ljava/lang/Object;", "visitGatewayTimeout", "gatewayTimeout", "Lcom/anthropic/models/beta/BetaGatewayTimeoutError;", "(Lcom/anthropic/models/beta/BetaGatewayTimeoutError;)Ljava/lang/Object;", "visitInvalidRequest", "invalidRequest", "Lcom/anthropic/models/beta/BetaInvalidRequestError;", "(Lcom/anthropic/models/beta/BetaInvalidRequestError;)Ljava/lang/Object;", "visitNotFound", "notFound", "Lcom/anthropic/models/beta/BetaNotFoundError;", "(Lcom/anthropic/models/beta/BetaNotFoundError;)Ljava/lang/Object;", "visitOverloaded", "overloaded", "Lcom/anthropic/models/beta/BetaOverloadedError;", "(Lcom/anthropic/models/beta/BetaOverloadedError;)Ljava/lang/Object;", "visitPermission", "permission", "Lcom/anthropic/models/beta/BetaPermissionError;", "(Lcom/anthropic/models/beta/BetaPermissionError;)Ljava/lang/Object;", "visitRateLimit", "rateLimit", "Lcom/anthropic/models/beta/BetaRateLimitError;", "(Lcom/anthropic/models/beta/BetaRateLimitError;)Ljava/lang/Object;", "anthropic-java-core"})
    public static interface Visitor<T> {
        public T visitInvalidRequest(@NotNull BetaInvalidRequestError var1);

        public T visitAuthentication(@NotNull BetaAuthenticationError var1);

        public T visitBilling(@NotNull BetaBillingError var1);

        public T visitPermission(@NotNull BetaPermissionError var1);

        public T visitNotFound(@NotNull BetaNotFoundError var1);

        public T visitRateLimit(@NotNull BetaRateLimitError var1);

        public T visitGatewayTimeout(@NotNull BetaGatewayTimeoutError var1);

        public T visitApi(@NotNull BetaApiError var1);

        public T visitOverloaded(@NotNull BetaOverloadedError var1);

        default public T unknown(@Nullable JsonValue json2) {
            throw new AnthropicInvalidDataException("Unknown BetaError: " + json2, null, 2, null);
        }
    }
}

