/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.services.async;

import com.anthropic.core.Check;
import com.anthropic.core.ClientOptions;
import com.anthropic.core.JsonValue;
import com.anthropic.core.PrepareRequest;
import com.anthropic.core.RequestOptions;
import com.anthropic.core.handlers.ErrorHandler;
import com.anthropic.core.http.HttpClient;
import com.anthropic.core.http.HttpMethod;
import com.anthropic.core.http.HttpRequest;
import com.anthropic.core.http.HttpResponse;
import com.anthropic.core.http.HttpResponseFor;
import com.anthropic.core.http.HttpResponseForKt;
import com.anthropic.errors.AnthropicInvalidDataException;
import com.anthropic.models.models.ModelInfo;
import com.anthropic.models.models.ModelListPageAsync;
import com.anthropic.models.models.ModelListPageResponse;
import com.anthropic.models.models.ModelListParams;
import com.anthropic.models.models.ModelRetrieveParams;
import com.anthropic.services.async.ModelServiceAsync;
import com.anthropic.services.async.ModelServiceAsyncImpl;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/anthropic/services/async/ModelServiceAsyncImpl;", "Lcom/anthropic/services/async/ModelServiceAsync;", "clientOptions", "Lcom/anthropic/core/ClientOptions;", "(Lcom/anthropic/core/ClientOptions;)V", "withRawResponse", "Lcom/anthropic/services/async/ModelServiceAsync$WithRawResponse;", "getWithRawResponse", "()Lcom/anthropic/services/async/ModelServiceAsync$WithRawResponse;", "withRawResponse$delegate", "Lkotlin/Lazy;", "list", "Ljava/util/concurrent/CompletableFuture;", "Lcom/anthropic/models/models/ModelListPageAsync;", "params", "Lcom/anthropic/models/models/ModelListParams;", "requestOptions", "Lcom/anthropic/core/RequestOptions;", "retrieve", "Lcom/anthropic/models/models/ModelInfo;", "Lcom/anthropic/models/models/ModelRetrieveParams;", "WithRawResponseImpl", "anthropic-java-core"})
public final class ModelServiceAsyncImpl
implements ModelServiceAsync {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final Lazy withRawResponse$delegate;

    public ModelServiceAsyncImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.withRawResponse$delegate = LazyKt.lazy((Function0)((Function0)new Function0<WithRawResponseImpl>(this){
            final /* synthetic */ ModelServiceAsyncImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final WithRawResponseImpl invoke() {
                return new WithRawResponseImpl(ModelServiceAsyncImpl.access$getClientOptions$p(this.this$0));
            }
        }));
    }

    private final ModelServiceAsync.WithRawResponse getWithRawResponse() {
        Lazy lazy = this.withRawResponse$delegate;
        return (ModelServiceAsync.WithRawResponse)lazy.getValue();
    }

    @Override
    @NotNull
    public ModelServiceAsync.WithRawResponse withRawResponse() {
        return this.getWithRawResponse();
    }

    @Override
    @NotNull
    public CompletableFuture<ModelInfo> retrieve(@NotNull ModelRetrieveParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        CompletionStage completionStage = this.withRawResponse().retrieve(params, requestOptions).thenApply(arg_0 -> ModelServiceAsyncImpl.retrieve$lambda$0(retrieve.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"withRawResponse().retrie\u2026.thenApply { it.parse() }");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<ModelListPageAsync> list(@NotNull ModelListParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        CompletionStage completionStage = this.withRawResponse().list(params, requestOptions).thenApply(arg_0 -> ModelServiceAsyncImpl.list$lambda$1(list.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"withRawResponse().list(p\u2026.thenApply { it.parse() }");
        return completionStage;
    }

    private static final ModelInfo retrieve$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ModelInfo)$tmp0.invoke(p0);
    }

    private static final ModelListPageAsync list$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ModelListPageAsync)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ClientOptions access$getClientOptions$p(ModelServiceAsyncImpl $this) {
        return $this.clientOptions;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J$\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/anthropic/services/async/ModelServiceAsyncImpl$WithRawResponseImpl;", "Lcom/anthropic/services/async/ModelServiceAsync$WithRawResponse;", "clientOptions", "Lcom/anthropic/core/ClientOptions;", "(Lcom/anthropic/core/ClientOptions;)V", "errorHandler", "Lcom/anthropic/core/http/HttpResponse$Handler;", "Lcom/anthropic/core/JsonValue;", "listHandler", "Lcom/anthropic/models/models/ModelListPageResponse;", "retrieveHandler", "Lcom/anthropic/models/models/ModelInfo;", "list", "Ljava/util/concurrent/CompletableFuture;", "Lcom/anthropic/core/http/HttpResponseFor;", "Lcom/anthropic/models/models/ModelListPageAsync;", "params", "Lcom/anthropic/models/models/ModelListParams;", "requestOptions", "Lcom/anthropic/core/RequestOptions;", "retrieve", "Lcom/anthropic/models/models/ModelRetrieveParams;", "anthropic-java-core"})
    @SourceDebugExtension(value={"SMAP\nModelServiceAsyncImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelServiceAsyncImpl.kt\ncom/anthropic/services/async/ModelServiceAsyncImpl$WithRawResponseImpl\n+ 2 JsonHandler.kt\ncom/anthropic/core/handlers/JsonHandler\n*L\n1#1,125:1\n13#2,8:126\n13#2,8:134\n*S KotlinDebug\n*F\n+ 1 ModelServiceAsyncImpl.kt\ncom/anthropic/services/async/ModelServiceAsyncImpl$WithRawResponseImpl\n*L\n55#1:126,8\n87#1:134,8\n*E\n"})
    public static final class WithRawResponseImpl
    implements ModelServiceAsync.WithRawResponse {
        @NotNull
        private final ClientOptions clientOptions;
        @NotNull
        private final HttpResponse.Handler<JsonValue> errorHandler;
        @NotNull
        private final HttpResponse.Handler<ModelInfo> retrieveHandler;
        @NotNull
        private final HttpResponse.Handler<ModelListPageResponse> listHandler;

        public WithRawResponseImpl(@NotNull ClientOptions clientOptions) {
            Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
            this.clientOptions = clientOptions;
            this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
            JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
            boolean $i$f$jsonHandler = false;
            this.retrieveHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ModelInfo>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public ModelInfo handle(@NotNull HttpResponse response) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        object = this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ModelInfo>(){});
                    }
                    catch (Exception e) {
                        throw new AnthropicInvalidDataException("Error reading response", e);
                    }
                    return object;
                }
            }, this.errorHandler);
            jsonMapper$iv = this.clientOptions.jsonMapper();
            $i$f$jsonHandler = false;
            this.listHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ModelListPageResponse>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public ModelListPageResponse handle(@NotNull HttpResponse response) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        object = this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ModelListPageResponse>(){});
                    }
                    catch (Exception e) {
                        throw new AnthropicInvalidDataException("Error reading response", e);
                    }
                    return object;
                }
            }, this.errorHandler);
        }

        @Override
        @NotNull
        public CompletableFuture<HttpResponseFor<ModelInfo>> retrieve(@NotNull ModelRetrieveParams params, @NotNull RequestOptions requestOptions) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            Check.checkRequired("modelId", OptionalsKt.getOrNull(params.modelId()));
            String[] stringArray = new String[]{"v1", "models", params._pathParam(0)};
            CompletableFuture request2 = PrepareRequest.prepareAsync(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$anthropic_java_core(this.clientOptions));
            CompletionStage completionStage = ((CompletableFuture)request2.thenComposeAsync(arg_0 -> WithRawResponseImpl.retrieve$lambda$0((Function1)new Function1<HttpRequest, CompletionStage<HttpResponse>>(this, requestOptions2){
                final /* synthetic */ WithRawResponseImpl this$0;
                final /* synthetic */ RequestOptions $requestOptions;
                {
                    this.this$0 = $receiver;
                    this.$requestOptions = $requestOptions;
                    super(1);
                }

                public final CompletionStage<HttpResponse> invoke(HttpRequest it) {
                    HttpClient httpClient = WithRawResponseImpl.access$getClientOptions$p(this.this$0).httpClient();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    return httpClient.executeAsync(it, this.$requestOptions);
                }
            }, arg_0))).thenApply(arg_0 -> WithRawResponseImpl.retrieve$lambda$1((Function1)new Function1<HttpResponse, HttpResponseFor<ModelInfo>>(this, requestOptions2){
                final /* synthetic */ WithRawResponseImpl this$0;
                final /* synthetic */ RequestOptions $requestOptions;
                {
                    this.this$0 = $receiver;
                    this.$requestOptions = $requestOptions;
                    super(1);
                }

                public final HttpResponseFor<ModelInfo> invoke(HttpResponse response) {
                    Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                    return HttpResponseForKt.parseable(response, (Function0)new Function0<ModelInfo>(response, this.this$0, this.$requestOptions){
                        final /* synthetic */ HttpResponse $response;
                        final /* synthetic */ WithRawResponseImpl this$0;
                        final /* synthetic */ RequestOptions $requestOptions;
                        {
                            this.$response = $response;
                            this.this$0 = $receiver;
                            this.$requestOptions = $requestOptions;
                            super(0);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @NotNull
                        public final ModelInfo invoke() {
                            Object object = this.$response;
                            Object object2 = this.this$0;
                            Throwable throwable = null;
                            try {
                                Object it = (HttpResponse)object;
                                boolean bl = false;
                                HttpResponse.Handler handler = WithRawResponseImpl.access$getRetrieveHandler$p((WithRawResponseImpl)object2);
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                it = (ModelInfo)handler.handle((HttpResponse)it);
                            }
                            catch (Throwable it) {
                                throwable = it;
                                throw it;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
                            }
                            object = it;
                            object2 = this.$requestOptions;
                            Object it = object;
                            boolean bl = false;
                            Boolean bl2 = ((RequestOptions)object2).getResponseValidation();
                            Intrinsics.checkNotNull((Object)bl2);
                            if (bl2.booleanValue()) {
                                ((ModelInfo)it).validate();
                            }
                            return object;
                        }
                    });
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"override fun retrieve(\n \u2026              }\n        }");
            return completionStage;
        }

        @Override
        @NotNull
        public CompletableFuture<HttpResponseFor<ModelListPageAsync>> list(@NotNull ModelListParams params, @NotNull RequestOptions requestOptions) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            String[] stringArray = new String[]{"v1", "models"};
            CompletableFuture request2 = PrepareRequest.prepareAsync(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$anthropic_java_core(this.clientOptions));
            CompletionStage completionStage = ((CompletableFuture)request2.thenComposeAsync(arg_0 -> WithRawResponseImpl.list$lambda$2((Function1)new Function1<HttpRequest, CompletionStage<HttpResponse>>(this, requestOptions2){
                final /* synthetic */ WithRawResponseImpl this$0;
                final /* synthetic */ RequestOptions $requestOptions;
                {
                    this.this$0 = $receiver;
                    this.$requestOptions = $requestOptions;
                    super(1);
                }

                public final CompletionStage<HttpResponse> invoke(HttpRequest it) {
                    HttpClient httpClient = WithRawResponseImpl.access$getClientOptions$p(this.this$0).httpClient();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    return httpClient.executeAsync(it, this.$requestOptions);
                }
            }, arg_0))).thenApply(arg_0 -> WithRawResponseImpl.list$lambda$3((Function1)new Function1<HttpResponse, HttpResponseFor<ModelListPageAsync>>(this, requestOptions2, params){
                final /* synthetic */ WithRawResponseImpl this$0;
                final /* synthetic */ RequestOptions $requestOptions;
                final /* synthetic */ ModelListParams $params;
                {
                    this.this$0 = $receiver;
                    this.$requestOptions = $requestOptions;
                    this.$params = $params;
                    super(1);
                }

                public final HttpResponseFor<ModelListPageAsync> invoke(HttpResponse response) {
                    Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                    return HttpResponseForKt.parseable(response, (Function0)new Function0<ModelListPageAsync>(response, this.this$0, this.$requestOptions, this.$params){
                        final /* synthetic */ HttpResponse $response;
                        final /* synthetic */ WithRawResponseImpl this$0;
                        final /* synthetic */ RequestOptions $requestOptions;
                        final /* synthetic */ ModelListParams $params;
                        {
                            this.$response = $response;
                            this.this$0 = $receiver;
                            this.$requestOptions = $requestOptions;
                            this.$params = $params;
                            super(0);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @NotNull
                        public final ModelListPageAsync invoke() {
                            Object object = this.$response;
                            Object object2 = this.this$0;
                            Object object3 = null;
                            try {
                                Object it = (HttpResponse)object;
                                boolean bl = false;
                                HttpResponse.Handler handler = WithRawResponseImpl.access$getListHandler$p((WithRawResponseImpl)object2);
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                it = (ModelListPageResponse)handler.handle((HttpResponse)it);
                            }
                            catch (Throwable it) {
                                object3 = it;
                                throw it;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)object3);
                            }
                            object = it;
                            object2 = this.$requestOptions;
                            Object it = object;
                            boolean bl = false;
                            Boolean bl2 = ((RequestOptions)object2).getResponseValidation();
                            Intrinsics.checkNotNull((Object)bl2);
                            if (bl2.booleanValue()) {
                                ((ModelListPageResponse)it).validate();
                            }
                            object2 = this.this$0;
                            object3 = this.$params;
                            Object it2 = object;
                            boolean bl3 = false;
                            return ModelListPageAsync.Companion.builder().service(new ModelServiceAsyncImpl(WithRawResponseImpl.access$getClientOptions$p((WithRawResponseImpl)object2))).streamHandlerExecutor(WithRawResponseImpl.access$getClientOptions$p((WithRawResponseImpl)object2).streamHandlerExecutor()).params((ModelListParams)object3).response((ModelListPageResponse)it2).build();
                        }
                    });
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"override fun list(\n     \u2026              }\n        }");
            return completionStage;
        }

        private static final CompletionStage retrieve$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (CompletionStage)$tmp0.invoke(p0);
        }

        private static final HttpResponseFor retrieve$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (HttpResponseFor)$tmp0.invoke(p0);
        }

        private static final CompletionStage list$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (CompletionStage)$tmp0.invoke(p0);
        }

        private static final HttpResponseFor list$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (HttpResponseFor)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ ClientOptions access$getClientOptions$p(WithRawResponseImpl $this) {
            return $this.clientOptions;
        }

        public static final /* synthetic */ HttpResponse.Handler access$getRetrieveHandler$p(WithRawResponseImpl $this) {
            return $this.retrieveHandler;
        }

        public static final /* synthetic */ HttpResponse.Handler access$getListHandler$p(WithRawResponseImpl $this) {
            return $this.listHandler;
        }
    }
}

