/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.models.beta.files;

import com.anthropic.core.Check;
import com.anthropic.core.ExcludeMissing;
import com.anthropic.core.MultipartField;
import com.anthropic.core.Params;
import com.anthropic.core.Utils;
import com.anthropic.core.http.Headers;
import com.anthropic.core.http.QueryParams;
import com.anthropic.errors.AnthropicInvalidDataException;
import com.anthropic.models.beta.AnthropicBeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0003!\"#B/\b\u0002\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\f\u001a\u00020\bJ\u0006\u0010\r\u001a\u00020\nJ\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u000fJ\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011J\b\u0010\u0014\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\u0006\u0010\u001b\u001a\u00020\u0013J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u0010H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/anthropic/models/beta/files/FileUploadParams;", "Lcom/anthropic/core/Params;", "betas", "", "Lcom/anthropic/models/beta/AnthropicBeta;", "body", "Lcom/anthropic/models/beta/files/FileUploadParams$Body;", "additionalHeaders", "Lcom/anthropic/core/http/Headers;", "additionalQueryParams", "Lcom/anthropic/core/http/QueryParams;", "(Ljava/util/List;Lcom/anthropic/models/beta/files/FileUploadParams$Body;Lcom/anthropic/core/http/Headers;Lcom/anthropic/core/http/QueryParams;)V", "_additionalHeaders", "_additionalQueryParams", "_body", "", "", "Lcom/anthropic/core/MultipartField;", "_file", "Ljava/io/InputStream;", "_headers", "_queryParams", "Ljava/util/Optional;", "equals", "", "other", "", "file", "hashCode", "", "toBuilder", "Lcom/anthropic/models/beta/files/FileUploadParams$Builder;", "toString", "Body", "Builder", "Companion", "anthropic-java-core"})
@SourceDebugExtension(value={"SMAP\nFileUploadParams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUploadParams.kt\ncom/anthropic/models/beta/files/FileUploadParams\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,394:1\n1855#2,2:395\n*S KotlinDebug\n*F\n+ 1 FileUploadParams.kt\ncom/anthropic/models/beta/files/FileUploadParams\n*L\n260#1:395,2\n*E\n"})
public final class FileUploadParams
implements Params {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final List<AnthropicBeta> betas;
    @NotNull
    private final Body body;
    @NotNull
    private final Headers additionalHeaders;
    @NotNull
    private final QueryParams additionalQueryParams;

    private FileUploadParams(List<AnthropicBeta> betas, Body body, Headers additionalHeaders, QueryParams additionalQueryParams) {
        this.betas = betas;
        this.body = body;
        this.additionalHeaders = additionalHeaders;
        this.additionalQueryParams = additionalQueryParams;
    }

    @NotNull
    public final Optional<List<AnthropicBeta>> betas() {
        Optional<List<AnthropicBeta>> optional = Optional.ofNullable(this.betas);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(betas)");
        return optional;
    }

    @NotNull
    public final InputStream file() {
        return this.body.file();
    }

    @NotNull
    public final MultipartField<InputStream> _file() {
        return this.body._file();
    }

    @NotNull
    public final Headers _additionalHeaders() {
        return this.additionalHeaders;
    }

    @NotNull
    public final QueryParams _additionalQueryParams() {
        return this.additionalQueryParams;
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder().from$anthropic_java_core(this);
    }

    @NotNull
    public final Map<String, MultipartField<?>> _body() {
        return Utils.toImmutable(MapsKt.mapOf((Pair)TuplesKt.to((Object)"file", this._file())));
    }

    @Override
    @NotNull
    public Headers _headers() {
        Headers.Builder builder;
        Headers.Builder $this$_headers_u24lambda_u241 = builder = Headers.Companion.builder();
        boolean bl = false;
        List<AnthropicBeta> list2 = this.betas;
        if (list2 != null) {
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnthropicBeta it = (AnthropicBeta)element$iv;
                boolean bl2 = false;
                $this$_headers_u24lambda_u241.put("anthropic-beta", it.toString());
            }
        }
        $this$_headers_u24lambda_u241.putAll(this.additionalHeaders);
        return builder.build();
    }

    @Override
    @NotNull
    public QueryParams _queryParams() {
        return this.additionalQueryParams;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FileUploadParams && Intrinsics.areEqual(this.betas, ((FileUploadParams)other).betas) && Intrinsics.areEqual((Object)this.body, (Object)((FileUploadParams)other).body) && Intrinsics.areEqual((Object)this.additionalHeaders, (Object)((FileUploadParams)other).additionalHeaders) && Intrinsics.areEqual((Object)this.additionalQueryParams, (Object)((FileUploadParams)other).additionalQueryParams);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.betas, this.body, this.additionalHeaders, this.additionalQueryParams};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return "FileUploadParams{betas=" + this.betas + ", body=" + this.body + ", additionalHeaders=" + this.additionalHeaders + ", additionalQueryParams=" + this.additionalQueryParams + '}';
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public /* synthetic */ FileUploadParams(List betas, Body body, Headers additionalHeaders, QueryParams additionalQueryParams, DefaultConstructorMarker $constructor_marker) {
        this(betas, body, additionalHeaders, additionalQueryParams);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u0015\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0007J\u0013\u0010\u000f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010\u0002\u001a\u00020\u0004J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0006\u0010\u0011\u001a\u00020\rJ\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/anthropic/models/beta/files/FileUploadParams$Body;", "", "file", "Lcom/anthropic/core/MultipartField;", "Ljava/io/InputStream;", "(Lcom/anthropic/core/MultipartField;)V", "hashCode", "", "getHashCode", "()I", "hashCode$delegate", "Lkotlin/Lazy;", "validated", "", "_file", "equals", "other", "isValid", "toBuilder", "Lcom/anthropic/models/beta/files/FileUploadParams$Body$Builder;", "toString", "", "validate", "Builder", "Companion", "anthropic-java-core"})
    public static final class Body {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final MultipartField<InputStream> file;
        private boolean validated;
        @NotNull
        private final Lazy hashCode$delegate;

        private Body(MultipartField<InputStream> file) {
            this.file = file;
            this.hashCode$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
                final /* synthetic */ Body this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Integer invoke() {
                    Object[] objectArray = new Object[]{Body.access$getFile$p(this.this$0)};
                    return Objects.hash(objectArray);
                }
            }));
        }

        @NotNull
        public final InputStream file() {
            return (InputStream)this.file.value().getRequired$anthropic_java_core("file");
        }

        @JsonProperty(value="file")
        @ExcludeMissing
        @NotNull
        public final MultipartField<InputStream> _file() {
            return this.file;
        }

        @NotNull
        public final Builder toBuilder() {
            return new Builder().from$anthropic_java_core(this);
        }

        @NotNull
        public final Body validate() {
            Body body;
            Body $this$validate_u24lambda_u240 = body = this;
            boolean bl = false;
            if (!$this$validate_u24lambda_u240.validated) {
                $this$validate_u24lambda_u240.file();
                $this$validate_u24lambda_u240.validated = true;
            }
            return body;
        }

        public final boolean isValid() {
            boolean bl;
            try {
                this.validate();
                bl = true;
            }
            catch (AnthropicInvalidDataException e) {
                bl = false;
            }
            return bl;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Body && Intrinsics.areEqual(this.file, ((Body)other).file);
        }

        private final int getHashCode() {
            Lazy lazy = this.hashCode$delegate;
            return ((Number)lazy.getValue()).intValue();
        }

        public int hashCode() {
            return this.getHashCode();
        }

        @NotNull
        public String toString() {
            return "Body{file=" + this.file + '}';
        }

        @JvmStatic
        @NotNull
        public static final Builder builder() {
            return Companion.builder();
        }

        public /* synthetic */ Body(MultipartField file, DefaultConstructorMarker $constructor_marker) {
            this(file);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\u0003\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0005J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\bJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\tJ\u0015\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\fR\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/anthropic/models/beta/files/FileUploadParams$Body$Builder;", "", "()V", "file", "Lcom/anthropic/core/MultipartField;", "Ljava/io/InputStream;", "build", "Lcom/anthropic/models/beta/files/FileUploadParams$Body;", "Ljava/nio/file/Path;", "", "from", "body", "from$anthropic_java_core", "anthropic-java-core"})
        @SourceDebugExtension(value={"SMAP\nFileUploadParams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUploadParams.kt\ncom/anthropic/models/beta/files/FileUploadParams$Body$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,394:1\n1#2:395\n*E\n"})
        public static final class Builder {
            @Nullable
            private MultipartField<InputStream> file;

            public final /* synthetic */ Builder from$anthropic_java_core(Body body) {
                Builder builder;
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                Builder $this$from_u24lambda_u240 = builder = this;
                boolean bl = false;
                $this$from_u24lambda_u240.file = body.file;
                return builder;
            }

            @NotNull
            public final Builder file(@NotNull InputStream file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return this.file(MultipartField.Companion.of(file));
            }

            @NotNull
            public final Builder file(@NotNull MultipartField<InputStream> file) {
                Builder builder;
                Intrinsics.checkNotNullParameter(file, (String)"file");
                Builder $this$file_u24lambda_u241 = builder = this;
                boolean bl = false;
                $this$file_u24lambda_u241.file = file;
                return builder;
            }

            @NotNull
            public final Builder file(@NotNull byte[] file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return this.file(new ByteArrayInputStream(file));
            }

            @NotNull
            public final Builder file(@NotNull Path file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                MultipartField.Builder<InputStream> builder = MultipartField.Companion.builder();
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(this, *options)");
                return this.file(builder.value(inputStream).filename(PathsKt.getName((Path)file)).build());
            }

            @NotNull
            public final Body build() {
                return new Body(Check.checkRequired("file", this.file), null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/anthropic/models/beta/files/FileUploadParams$Body$Companion;", "", "()V", "builder", "Lcom/anthropic/models/beta/files/FileUploadParams$Body$Builder;", "anthropic-java-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Builder builder() {
                return new Builder();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0010\n\u0002\u0010\"\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0010J \u0010\u0003\u001a\u00020\u00002\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00120\u0011J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0013J \u0010\u0005\u001a\u00020\u00002\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00120\u0011J\u001a\u0010\u0007\u001a\u00020\u00002\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00150\u0014J\u0016\u0010\u0007\u001a\u00020\u00002\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0015J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u0019\u001a\u00020\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001bJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001cJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001dJ\u0015\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b J\u0016\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010#\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u000f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012J\u0016\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010'\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u000f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0010J \u0010(\u001a\u00020\u00002\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00120\u0011J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0013J \u0010)\u001a\u00020\u00002\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00120\u0011J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u000fJ\u000e\u0010+\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u000fJ\u0014\u0010,\u001a\u00020\u00002\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0.J\u0014\u0010/\u001a\u00020\u00002\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000f0.J\u0016\u00101\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u00101\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u000f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012J\u0016\u00102\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u00102\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u000f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012J\u000e\u00103\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0010J \u00103\u001a\u00020\u00002\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00120\u0011J\u000e\u00104\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0013J \u00104\u001a\u00020\u00002\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00120\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/anthropic/models/beta/files/FileUploadParams$Builder;", "", "()V", "additionalHeaders", "Lcom/anthropic/core/http/Headers$Builder;", "additionalQueryParams", "Lcom/anthropic/core/http/QueryParams$Builder;", "betas", "", "Lcom/anthropic/models/beta/AnthropicBeta;", "body", "Lcom/anthropic/models/beta/files/FileUploadParams$Body$Builder;", "addBeta", "beta", "value", "", "Lcom/anthropic/core/http/Headers;", "", "", "Lcom/anthropic/core/http/QueryParams;", "Ljava/util/Optional;", "", "Lcom/anthropic/models/beta/files/FileUploadParams$Body;", "build", "Lcom/anthropic/models/beta/files/FileUploadParams;", "file", "Lcom/anthropic/core/MultipartField;", "Ljava/io/InputStream;", "Ljava/nio/file/Path;", "", "from", "fileUploadParams", "from$anthropic_java_core", "putAdditionalHeader", "name", "putAdditionalHeaders", "values", "putAdditionalQueryParam", "key", "putAdditionalQueryParams", "putAllAdditionalHeaders", "putAllAdditionalQueryParams", "removeAdditionalHeaders", "removeAdditionalQueryParams", "removeAllAdditionalHeaders", "names", "", "removeAllAdditionalQueryParams", "keys", "replaceAdditionalHeaders", "replaceAdditionalQueryParams", "replaceAllAdditionalHeaders", "replaceAllAdditionalQueryParams", "anthropic-java-core"})
    @SourceDebugExtension(value={"SMAP\nFileUploadParams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUploadParams.kt\ncom/anthropic/models/beta/files/FileUploadParams$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,394:1\n1#2:395\n*E\n"})
    public static final class Builder {
        @Nullable
        private List<AnthropicBeta> betas;
        @NotNull
        private Body.Builder body = Body.Companion.builder();
        @NotNull
        private Headers.Builder additionalHeaders = Headers.Companion.builder();
        @NotNull
        private QueryParams.Builder additionalQueryParams = QueryParams.Companion.builder();

        public final /* synthetic */ Builder from$anthropic_java_core(FileUploadParams fileUploadParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)fileUploadParams, (String)"fileUploadParams");
            Builder $this$from_u24lambda_u240 = builder = this;
            boolean bl = false;
            List list2 = fileUploadParams.betas;
            $this$from_u24lambda_u240.betas = list2 != null ? CollectionsKt.toMutableList((Collection)list2) : null;
            $this$from_u24lambda_u240.body = fileUploadParams.body.toBuilder();
            $this$from_u24lambda_u240.additionalHeaders = fileUploadParams.additionalHeaders.toBuilder();
            $this$from_u24lambda_u240.additionalQueryParams = fileUploadParams.additionalQueryParams.toBuilder();
            return builder;
        }

        @NotNull
        public final Builder betas(@Nullable List<AnthropicBeta> betas) {
            Builder builder;
            Builder $this$betas_u24lambda_u241 = builder = this;
            boolean bl = false;
            List<AnthropicBeta> list2 = betas;
            $this$betas_u24lambda_u241.betas = list2 != null ? CollectionsKt.toMutableList((Collection)list2) : null;
            return builder;
        }

        @NotNull
        public final Builder betas(@NotNull Optional<List<AnthropicBeta>> betas) {
            Intrinsics.checkNotNullParameter(betas, (String)"betas");
            return this.betas((List)OptionalsKt.getOrNull(betas));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder addBeta(@NotNull AnthropicBeta beta2) {
            void $this$addBeta_u24lambda_u243_u24lambda_u242;
            List list2;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)beta2, (String)"beta");
            Builder $this$addBeta_u24lambda_u243 = builder = this;
            boolean bl = false;
            List list3 = $this$addBeta_u24lambda_u243.betas;
            if (list3 == null) {
                list3 = new ArrayList();
            }
            List list4 = list2 = list3;
            Builder builder2 = $this$addBeta_u24lambda_u243;
            boolean bl2 = false;
            $this$addBeta_u24lambda_u243_u24lambda_u242.add(beta2);
            builder2.betas = list2;
            return builder;
        }

        @NotNull
        public final Builder addBeta(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.addBeta(AnthropicBeta.Companion.of(value));
        }

        @NotNull
        public final Builder body(@NotNull Body body) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Builder $this$body_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$body_u24lambda_u244.body = body.toBuilder();
            return builder;
        }

        @NotNull
        public final Builder file(@NotNull InputStream file) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Builder $this$file_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$file_u24lambda_u245.body.file(file);
            return builder;
        }

        @NotNull
        public final Builder file(@NotNull MultipartField<InputStream> file) {
            Builder builder;
            Intrinsics.checkNotNullParameter(file, (String)"file");
            Builder $this$file_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$file_u24lambda_u246.body.file(file);
            return builder;
        }

        @NotNull
        public final Builder file(@NotNull byte[] file) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Builder $this$file_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$file_u24lambda_u247.body.file(file);
            return builder;
        }

        @NotNull
        public final Builder file(@NotNull Path file) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Builder $this$file_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$file_u24lambda_u248.body.file(file);
            return builder;
        }

        @NotNull
        public final Builder additionalHeaders(@NotNull Headers additionalHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)additionalHeaders, (String)"additionalHeaders");
            Builder $this$additionalHeaders_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$additionalHeaders_u24lambda_u249.additionalHeaders.clear();
            $this$additionalHeaders_u24lambda_u249.putAllAdditionalHeaders(additionalHeaders);
            return builder;
        }

        @NotNull
        public final Builder additionalHeaders(@NotNull Map<String, ? extends Iterable<String>> additionalHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalHeaders, (String)"additionalHeaders");
            Builder $this$additionalHeaders_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$additionalHeaders_u24lambda_u2410.additionalHeaders.clear();
            $this$additionalHeaders_u24lambda_u2410.putAllAdditionalHeaders(additionalHeaders);
            return builder;
        }

        @NotNull
        public final Builder putAdditionalHeader(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$putAdditionalHeader_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$putAdditionalHeader_u24lambda_u2411.additionalHeaders.put(name, value);
            return builder;
        }

        @NotNull
        public final Builder putAdditionalHeaders(@NotNull String name, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$putAdditionalHeaders_u24lambda_u2412 = builder = this;
            boolean bl = false;
            $this$putAdditionalHeaders_u24lambda_u2412.additionalHeaders.put(name, values);
            return builder;
        }

        @NotNull
        public final Builder putAllAdditionalHeaders(@NotNull Headers additionalHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)additionalHeaders, (String)"additionalHeaders");
            Builder $this$putAllAdditionalHeaders_u24lambda_u2413 = builder = this;
            boolean bl = false;
            $this$putAllAdditionalHeaders_u24lambda_u2413.additionalHeaders.putAll(additionalHeaders);
            return builder;
        }

        @NotNull
        public final Builder putAllAdditionalHeaders(@NotNull Map<String, ? extends Iterable<String>> additionalHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalHeaders, (String)"additionalHeaders");
            Builder $this$putAllAdditionalHeaders_u24lambda_u2414 = builder = this;
            boolean bl = false;
            $this$putAllAdditionalHeaders_u24lambda_u2414.additionalHeaders.putAll(additionalHeaders);
            return builder;
        }

        @NotNull
        public final Builder replaceAdditionalHeaders(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$replaceAdditionalHeaders_u24lambda_u2415 = builder = this;
            boolean bl = false;
            $this$replaceAdditionalHeaders_u24lambda_u2415.additionalHeaders.replace(name, value);
            return builder;
        }

        @NotNull
        public final Builder replaceAdditionalHeaders(@NotNull String name, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$replaceAdditionalHeaders_u24lambda_u2416 = builder = this;
            boolean bl = false;
            $this$replaceAdditionalHeaders_u24lambda_u2416.additionalHeaders.replace(name, values);
            return builder;
        }

        @NotNull
        public final Builder replaceAllAdditionalHeaders(@NotNull Headers additionalHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)additionalHeaders, (String)"additionalHeaders");
            Builder $this$replaceAllAdditionalHeaders_u24lambda_u2417 = builder = this;
            boolean bl = false;
            $this$replaceAllAdditionalHeaders_u24lambda_u2417.additionalHeaders.replaceAll(additionalHeaders);
            return builder;
        }

        @NotNull
        public final Builder replaceAllAdditionalHeaders(@NotNull Map<String, ? extends Iterable<String>> additionalHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalHeaders, (String)"additionalHeaders");
            Builder $this$replaceAllAdditionalHeaders_u24lambda_u2418 = builder = this;
            boolean bl = false;
            $this$replaceAllAdditionalHeaders_u24lambda_u2418.additionalHeaders.replaceAll(additionalHeaders);
            return builder;
        }

        @NotNull
        public final Builder removeAdditionalHeaders(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$removeAdditionalHeaders_u24lambda_u2419 = builder = this;
            boolean bl = false;
            $this$removeAdditionalHeaders_u24lambda_u2419.additionalHeaders.remove(name);
            return builder;
        }

        @NotNull
        public final Builder removeAllAdditionalHeaders(@NotNull Set<String> names) {
            Builder builder;
            Intrinsics.checkNotNullParameter(names, (String)"names");
            Builder $this$removeAllAdditionalHeaders_u24lambda_u2420 = builder = this;
            boolean bl = false;
            $this$removeAllAdditionalHeaders_u24lambda_u2420.additionalHeaders.removeAll(names);
            return builder;
        }

        @NotNull
        public final Builder additionalQueryParams(@NotNull QueryParams additionalQueryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)additionalQueryParams, (String)"additionalQueryParams");
            Builder $this$additionalQueryParams_u24lambda_u2421 = builder = this;
            boolean bl = false;
            $this$additionalQueryParams_u24lambda_u2421.additionalQueryParams.clear();
            $this$additionalQueryParams_u24lambda_u2421.putAllAdditionalQueryParams(additionalQueryParams);
            return builder;
        }

        @NotNull
        public final Builder additionalQueryParams(@NotNull Map<String, ? extends Iterable<String>> additionalQueryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalQueryParams, (String)"additionalQueryParams");
            Builder $this$additionalQueryParams_u24lambda_u2422 = builder = this;
            boolean bl = false;
            $this$additionalQueryParams_u24lambda_u2422.additionalQueryParams.clear();
            $this$additionalQueryParams_u24lambda_u2422.putAllAdditionalQueryParams(additionalQueryParams);
            return builder;
        }

        @NotNull
        public final Builder putAdditionalQueryParam(@NotNull String key, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$putAdditionalQueryParam_u24lambda_u2423 = builder = this;
            boolean bl = false;
            $this$putAdditionalQueryParam_u24lambda_u2423.additionalQueryParams.put(key, value);
            return builder;
        }

        @NotNull
        public final Builder putAdditionalQueryParams(@NotNull String key, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$putAdditionalQueryParams_u24lambda_u2424 = builder = this;
            boolean bl = false;
            $this$putAdditionalQueryParams_u24lambda_u2424.additionalQueryParams.put(key, values);
            return builder;
        }

        @NotNull
        public final Builder putAllAdditionalQueryParams(@NotNull QueryParams additionalQueryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)additionalQueryParams, (String)"additionalQueryParams");
            Builder $this$putAllAdditionalQueryParams_u24lambda_u2425 = builder = this;
            boolean bl = false;
            $this$putAllAdditionalQueryParams_u24lambda_u2425.additionalQueryParams.putAll(additionalQueryParams);
            return builder;
        }

        @NotNull
        public final Builder putAllAdditionalQueryParams(@NotNull Map<String, ? extends Iterable<String>> additionalQueryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalQueryParams, (String)"additionalQueryParams");
            Builder $this$putAllAdditionalQueryParams_u24lambda_u2426 = builder = this;
            boolean bl = false;
            $this$putAllAdditionalQueryParams_u24lambda_u2426.additionalQueryParams.putAll(additionalQueryParams);
            return builder;
        }

        @NotNull
        public final Builder replaceAdditionalQueryParams(@NotNull String key, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$replaceAdditionalQueryParams_u24lambda_u2427 = builder = this;
            boolean bl = false;
            $this$replaceAdditionalQueryParams_u24lambda_u2427.additionalQueryParams.replace(key, value);
            return builder;
        }

        @NotNull
        public final Builder replaceAdditionalQueryParams(@NotNull String key, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$replaceAdditionalQueryParams_u24lambda_u2428 = builder = this;
            boolean bl = false;
            $this$replaceAdditionalQueryParams_u24lambda_u2428.additionalQueryParams.replace(key, values);
            return builder;
        }

        @NotNull
        public final Builder replaceAllAdditionalQueryParams(@NotNull QueryParams additionalQueryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)additionalQueryParams, (String)"additionalQueryParams");
            Builder $this$replaceAllAdditionalQueryParams_u24lambda_u2429 = builder = this;
            boolean bl = false;
            $this$replaceAllAdditionalQueryParams_u24lambda_u2429.additionalQueryParams.replaceAll(additionalQueryParams);
            return builder;
        }

        @NotNull
        public final Builder replaceAllAdditionalQueryParams(@NotNull Map<String, ? extends Iterable<String>> additionalQueryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalQueryParams, (String)"additionalQueryParams");
            Builder $this$replaceAllAdditionalQueryParams_u24lambda_u2430 = builder = this;
            boolean bl = false;
            $this$replaceAllAdditionalQueryParams_u24lambda_u2430.additionalQueryParams.replaceAll(additionalQueryParams);
            return builder;
        }

        @NotNull
        public final Builder removeAdditionalQueryParams(@NotNull String key) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Builder $this$removeAdditionalQueryParams_u24lambda_u2431 = builder = this;
            boolean bl = false;
            $this$removeAdditionalQueryParams_u24lambda_u2431.additionalQueryParams.remove(key);
            return builder;
        }

        @NotNull
        public final Builder removeAllAdditionalQueryParams(@NotNull Set<String> keys) {
            Builder builder;
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            Builder $this$removeAllAdditionalQueryParams_u24lambda_u2432 = builder = this;
            boolean bl = false;
            $this$removeAllAdditionalQueryParams_u24lambda_u2432.additionalQueryParams.removeAll(keys);
            return builder;
        }

        @NotNull
        public final FileUploadParams build() {
            List<AnthropicBeta> list2 = this.betas;
            return new FileUploadParams(list2 != null ? Utils.toImmutable(list2) : null, this.body.build(), this.additionalHeaders.build(), this.additionalQueryParams.build(), null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/anthropic/models/beta/files/FileUploadParams$Companion;", "", "()V", "builder", "Lcom/anthropic/models/beta/files/FileUploadParams$Builder;", "anthropic-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

