/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.models.messages;

import com.anthropic.core.BaseDeserializer;
import com.anthropic.core.BaseSerializer;
import com.anthropic.core.JsonField;
import com.anthropic.core.JsonValue;
import com.anthropic.core.Utils;
import com.anthropic.errors.AnthropicInvalidDataException;
import com.anthropic.models.messages.DocumentBlockParam;
import com.anthropic.models.messages.ImageBlockParam;
import com.anthropic.models.messages.RedactedThinkingBlockParam;
import com.anthropic.models.messages.ServerToolUseBlockParam;
import com.anthropic.models.messages.TextBlockParam;
import com.anthropic.models.messages.ThinkingBlockParam;
import com.anthropic.models.messages.ToolResultBlockParam;
import com.anthropic.models.messages.ToolUseBlockParam;
import com.anthropic.models.messages.WebSearchToolResultBlockParam;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\b\b\u0007\u0018\u0000 ;2\u00020\u0001:\u0004;<=>B\u007f\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019J\u001f\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0006\u0010\u001f\u001a\u00020\u0007J\u0006\u0010 \u001a\u00020\u0005J\u0006\u0010!\u001a\u00020\u000bJ\u0006\u0010\"\u001a\u00020\u0011J\u0006\u0010#\u001a\u00020\u0003J\u0006\u0010$\u001a\u00020\tJ\u0006\u0010%\u001a\u00020\u000fJ\u0006\u0010&\u001a\u00020\rJ\u0006\u0010'\u001a\u00020\u0013J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019J\u0013\u0010(\u001a\u00020\u00182\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010*\u001a\u00020+H\u0016J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019J\u0006\u0010,\u001a\u00020\u0018J\u0006\u0010-\u001a\u00020\u0018J\u0006\u0010.\u001a\u00020\u0018J\u0006\u0010/\u001a\u00020\u0018J\u0006\u00100\u001a\u00020\u0018J\u0006\u00101\u001a\u00020\u0018J\u0006\u00102\u001a\u00020\u0018J\u0006\u00103\u001a\u00020\u0018J\u0006\u00104\u001a\u00020\u0018J\u0006\u00105\u001a\u00020\u0018J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019J\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0019J\b\u00106\u001a\u000207H\u0016J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0019J\u0006\u00108\u001a\u00020\u0000J\r\u00109\u001a\u00020+H\u0000\u00a2\u0006\u0002\b:J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/anthropic/models/messages/ContentBlockParam;", "", "text", "Lcom/anthropic/models/messages/TextBlockParam;", "image", "Lcom/anthropic/models/messages/ImageBlockParam;", "document", "Lcom/anthropic/models/messages/DocumentBlockParam;", "thinking", "Lcom/anthropic/models/messages/ThinkingBlockParam;", "redactedThinking", "Lcom/anthropic/models/messages/RedactedThinkingBlockParam;", "toolUse", "Lcom/anthropic/models/messages/ToolUseBlockParam;", "toolResult", "Lcom/anthropic/models/messages/ToolResultBlockParam;", "serverToolUse", "Lcom/anthropic/models/messages/ServerToolUseBlockParam;", "webSearchToolResult", "Lcom/anthropic/models/messages/WebSearchToolResultBlockParam;", "_json", "Lcom/anthropic/core/JsonValue;", "(Lcom/anthropic/models/messages/TextBlockParam;Lcom/anthropic/models/messages/ImageBlockParam;Lcom/anthropic/models/messages/DocumentBlockParam;Lcom/anthropic/models/messages/ThinkingBlockParam;Lcom/anthropic/models/messages/RedactedThinkingBlockParam;Lcom/anthropic/models/messages/ToolUseBlockParam;Lcom/anthropic/models/messages/ToolResultBlockParam;Lcom/anthropic/models/messages/ServerToolUseBlockParam;Lcom/anthropic/models/messages/WebSearchToolResultBlockParam;Lcom/anthropic/core/JsonValue;)V", "validated", "", "Ljava/util/Optional;", "accept", "T", "visitor", "Lcom/anthropic/models/messages/ContentBlockParam$Visitor;", "(Lcom/anthropic/models/messages/ContentBlockParam$Visitor;)Ljava/lang/Object;", "asDocument", "asImage", "asRedactedThinking", "asServerToolUse", "asText", "asThinking", "asToolResult", "asToolUse", "asWebSearchToolResult", "equals", "other", "hashCode", "", "isDocument", "isImage", "isRedactedThinking", "isServerToolUse", "isText", "isThinking", "isToolResult", "isToolUse", "isValid", "isWebSearchToolResult", "toString", "", "validate", "validity", "validity$anthropic_java_core", "Companion", "Deserializer", "Serializer", "Visitor", "anthropic-java-core"})
public final class ContentBlockParam {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final TextBlockParam text;
    @Nullable
    private final ImageBlockParam image;
    @Nullable
    private final DocumentBlockParam document;
    @Nullable
    private final ThinkingBlockParam thinking;
    @Nullable
    private final RedactedThinkingBlockParam redactedThinking;
    @Nullable
    private final ToolUseBlockParam toolUse;
    @Nullable
    private final ToolResultBlockParam toolResult;
    @Nullable
    private final ServerToolUseBlockParam serverToolUse;
    @Nullable
    private final WebSearchToolResultBlockParam webSearchToolResult;
    @Nullable
    private final JsonValue _json;
    private boolean validated;

    private ContentBlockParam(TextBlockParam text, ImageBlockParam image, DocumentBlockParam document, ThinkingBlockParam thinking, RedactedThinkingBlockParam redactedThinking, ToolUseBlockParam toolUse, ToolResultBlockParam toolResult, ServerToolUseBlockParam serverToolUse, WebSearchToolResultBlockParam webSearchToolResult, JsonValue _json) {
        this.text = text;
        this.image = image;
        this.document = document;
        this.thinking = thinking;
        this.redactedThinking = redactedThinking;
        this.toolUse = toolUse;
        this.toolResult = toolResult;
        this.serverToolUse = serverToolUse;
        this.webSearchToolResult = webSearchToolResult;
        this._json = _json;
    }

    /* synthetic */ ContentBlockParam(TextBlockParam textBlockParam, ImageBlockParam imageBlockParam, DocumentBlockParam documentBlockParam, ThinkingBlockParam thinkingBlockParam, RedactedThinkingBlockParam redactedThinkingBlockParam, ToolUseBlockParam toolUseBlockParam, ToolResultBlockParam toolResultBlockParam, ServerToolUseBlockParam serverToolUseBlockParam, WebSearchToolResultBlockParam webSearchToolResultBlockParam, JsonValue jsonValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            textBlockParam = null;
        }
        if ((n & 2) != 0) {
            imageBlockParam = null;
        }
        if ((n & 4) != 0) {
            documentBlockParam = null;
        }
        if ((n & 8) != 0) {
            thinkingBlockParam = null;
        }
        if ((n & 0x10) != 0) {
            redactedThinkingBlockParam = null;
        }
        if ((n & 0x20) != 0) {
            toolUseBlockParam = null;
        }
        if ((n & 0x40) != 0) {
            toolResultBlockParam = null;
        }
        if ((n & 0x80) != 0) {
            serverToolUseBlockParam = null;
        }
        if ((n & 0x100) != 0) {
            webSearchToolResultBlockParam = null;
        }
        if ((n & 0x200) != 0) {
            jsonValue = null;
        }
        this(textBlockParam, imageBlockParam, documentBlockParam, thinkingBlockParam, redactedThinkingBlockParam, toolUseBlockParam, toolResultBlockParam, serverToolUseBlockParam, webSearchToolResultBlockParam, jsonValue);
    }

    @NotNull
    public final Optional<TextBlockParam> text() {
        Optional<TextBlockParam> optional = Optional.ofNullable(this.text);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(text)");
        return optional;
    }

    @NotNull
    public final Optional<ImageBlockParam> image() {
        Optional<ImageBlockParam> optional = Optional.ofNullable(this.image);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(image)");
        return optional;
    }

    @NotNull
    public final Optional<DocumentBlockParam> document() {
        Optional<DocumentBlockParam> optional = Optional.ofNullable(this.document);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(document)");
        return optional;
    }

    @NotNull
    public final Optional<ThinkingBlockParam> thinking() {
        Optional<ThinkingBlockParam> optional = Optional.ofNullable(this.thinking);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(thinking)");
        return optional;
    }

    @NotNull
    public final Optional<RedactedThinkingBlockParam> redactedThinking() {
        Optional<RedactedThinkingBlockParam> optional = Optional.ofNullable(this.redactedThinking);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(redactedThinking)");
        return optional;
    }

    @NotNull
    public final Optional<ToolUseBlockParam> toolUse() {
        Optional<ToolUseBlockParam> optional = Optional.ofNullable(this.toolUse);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(toolUse)");
        return optional;
    }

    @NotNull
    public final Optional<ToolResultBlockParam> toolResult() {
        Optional<ToolResultBlockParam> optional = Optional.ofNullable(this.toolResult);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(toolResult)");
        return optional;
    }

    @NotNull
    public final Optional<ServerToolUseBlockParam> serverToolUse() {
        Optional<ServerToolUseBlockParam> optional = Optional.ofNullable(this.serverToolUse);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(serverToolUse)");
        return optional;
    }

    @NotNull
    public final Optional<WebSearchToolResultBlockParam> webSearchToolResult() {
        Optional<WebSearchToolResultBlockParam> optional = Optional.ofNullable(this.webSearchToolResult);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(webSearchToolResult)");
        return optional;
    }

    public final boolean isText() {
        return this.text != null;
    }

    public final boolean isImage() {
        return this.image != null;
    }

    public final boolean isDocument() {
        return this.document != null;
    }

    public final boolean isThinking() {
        return this.thinking != null;
    }

    public final boolean isRedactedThinking() {
        return this.redactedThinking != null;
    }

    public final boolean isToolUse() {
        return this.toolUse != null;
    }

    public final boolean isToolResult() {
        return this.toolResult != null;
    }

    public final boolean isServerToolUse() {
        return this.serverToolUse != null;
    }

    public final boolean isWebSearchToolResult() {
        return this.webSearchToolResult != null;
    }

    @NotNull
    public final TextBlockParam asText() {
        return (TextBlockParam)Utils.getOrThrow(this.text, "text");
    }

    @NotNull
    public final ImageBlockParam asImage() {
        return (ImageBlockParam)Utils.getOrThrow(this.image, "image");
    }

    @NotNull
    public final DocumentBlockParam asDocument() {
        return (DocumentBlockParam)Utils.getOrThrow(this.document, "document");
    }

    @NotNull
    public final ThinkingBlockParam asThinking() {
        return (ThinkingBlockParam)Utils.getOrThrow(this.thinking, "thinking");
    }

    @NotNull
    public final RedactedThinkingBlockParam asRedactedThinking() {
        return (RedactedThinkingBlockParam)Utils.getOrThrow(this.redactedThinking, "redactedThinking");
    }

    @NotNull
    public final ToolUseBlockParam asToolUse() {
        return (ToolUseBlockParam)Utils.getOrThrow(this.toolUse, "toolUse");
    }

    @NotNull
    public final ToolResultBlockParam asToolResult() {
        return (ToolResultBlockParam)Utils.getOrThrow(this.toolResult, "toolResult");
    }

    @NotNull
    public final ServerToolUseBlockParam asServerToolUse() {
        return (ServerToolUseBlockParam)Utils.getOrThrow(this.serverToolUse, "serverToolUse");
    }

    @NotNull
    public final WebSearchToolResultBlockParam asWebSearchToolResult() {
        return (WebSearchToolResultBlockParam)Utils.getOrThrow(this.webSearchToolResult, "webSearchToolResult");
    }

    @NotNull
    public final Optional<JsonValue> _json() {
        Optional<JsonValue> optional = Optional.ofNullable(this._json);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(_json)");
        return optional;
    }

    public final <T> T accept(@NotNull Visitor<? extends T> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        return this.text != null ? visitor.visitText(this.text) : (this.image != null ? visitor.visitImage(this.image) : (this.document != null ? visitor.visitDocument(this.document) : (this.thinking != null ? visitor.visitThinking(this.thinking) : (this.redactedThinking != null ? visitor.visitRedactedThinking(this.redactedThinking) : (this.toolUse != null ? visitor.visitToolUse(this.toolUse) : (this.toolResult != null ? visitor.visitToolResult(this.toolResult) : (this.serverToolUse != null ? visitor.visitServerToolUse(this.serverToolUse) : (this.webSearchToolResult != null ? visitor.visitWebSearchToolResult(this.webSearchToolResult) : visitor.unknown(this._json)))))))));
    }

    @NotNull
    public final ContentBlockParam validate() {
        ContentBlockParam contentBlockParam;
        ContentBlockParam $this$validate_u24lambda_u240 = contentBlockParam = this;
        boolean bl = false;
        if (!$this$validate_u24lambda_u240.validated) {
            $this$validate_u24lambda_u240.accept((Visitor)new Visitor<Unit>(){

                public void visitText(@NotNull TextBlockParam text) {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    text.validate();
                }

                public void visitImage(@NotNull ImageBlockParam image) {
                    Intrinsics.checkNotNullParameter((Object)image, (String)"image");
                    image.validate();
                }

                public void visitDocument(@NotNull DocumentBlockParam document) {
                    Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                    document.validate();
                }

                public void visitThinking(@NotNull ThinkingBlockParam thinking) {
                    Intrinsics.checkNotNullParameter((Object)thinking, (String)"thinking");
                    thinking.validate();
                }

                public void visitRedactedThinking(@NotNull RedactedThinkingBlockParam redactedThinking) {
                    Intrinsics.checkNotNullParameter((Object)redactedThinking, (String)"redactedThinking");
                    redactedThinking.validate();
                }

                public void visitToolUse(@NotNull ToolUseBlockParam toolUse) {
                    Intrinsics.checkNotNullParameter((Object)toolUse, (String)"toolUse");
                    toolUse.validate();
                }

                public void visitToolResult(@NotNull ToolResultBlockParam toolResult) {
                    Intrinsics.checkNotNullParameter((Object)toolResult, (String)"toolResult");
                    toolResult.validate();
                }

                public void visitServerToolUse(@NotNull ServerToolUseBlockParam serverToolUse) {
                    Intrinsics.checkNotNullParameter((Object)serverToolUse, (String)"serverToolUse");
                    serverToolUse.validate();
                }

                public void visitWebSearchToolResult(@NotNull WebSearchToolResultBlockParam webSearchToolResult) {
                    Intrinsics.checkNotNullParameter((Object)webSearchToolResult, (String)"webSearchToolResult");
                    webSearchToolResult.validate();
                }
            });
            $this$validate_u24lambda_u240.validated = true;
        }
        return contentBlockParam;
    }

    public final boolean isValid() {
        boolean bl;
        try {
            this.validate();
            bl = true;
        }
        catch (AnthropicInvalidDataException e) {
            bl = false;
        }
        return bl;
    }

    public final /* synthetic */ int validity$anthropic_java_core() {
        return ((Number)this.accept((Visitor)new Visitor<Integer>(){

            @NotNull
            public Integer visitText(@NotNull TextBlockParam text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return text.validity$anthropic_java_core();
            }

            @NotNull
            public Integer visitImage(@NotNull ImageBlockParam image) {
                Intrinsics.checkNotNullParameter((Object)image, (String)"image");
                return image.validity$anthropic_java_core();
            }

            @NotNull
            public Integer visitDocument(@NotNull DocumentBlockParam document) {
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                return document.validity$anthropic_java_core();
            }

            @NotNull
            public Integer visitThinking(@NotNull ThinkingBlockParam thinking) {
                Intrinsics.checkNotNullParameter((Object)thinking, (String)"thinking");
                return thinking.validity$anthropic_java_core();
            }

            @NotNull
            public Integer visitRedactedThinking(@NotNull RedactedThinkingBlockParam redactedThinking) {
                Intrinsics.checkNotNullParameter((Object)redactedThinking, (String)"redactedThinking");
                return redactedThinking.validity$anthropic_java_core();
            }

            @NotNull
            public Integer visitToolUse(@NotNull ToolUseBlockParam toolUse) {
                Intrinsics.checkNotNullParameter((Object)toolUse, (String)"toolUse");
                return toolUse.validity$anthropic_java_core();
            }

            @NotNull
            public Integer visitToolResult(@NotNull ToolResultBlockParam toolResult) {
                Intrinsics.checkNotNullParameter((Object)toolResult, (String)"toolResult");
                return toolResult.validity$anthropic_java_core();
            }

            @NotNull
            public Integer visitServerToolUse(@NotNull ServerToolUseBlockParam serverToolUse) {
                Intrinsics.checkNotNullParameter((Object)serverToolUse, (String)"serverToolUse");
                return serverToolUse.validity$anthropic_java_core();
            }

            @NotNull
            public Integer visitWebSearchToolResult(@NotNull WebSearchToolResultBlockParam webSearchToolResult) {
                Intrinsics.checkNotNullParameter((Object)webSearchToolResult, (String)"webSearchToolResult");
                return webSearchToolResult.validity$anthropic_java_core();
            }

            @NotNull
            public Integer unknown(@Nullable JsonValue json2) {
                return 0;
            }
        })).intValue();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContentBlockParam && Intrinsics.areEqual((Object)this.text, (Object)((ContentBlockParam)other).text) && Intrinsics.areEqual((Object)this.image, (Object)((ContentBlockParam)other).image) && Intrinsics.areEqual((Object)this.document, (Object)((ContentBlockParam)other).document) && Intrinsics.areEqual((Object)this.thinking, (Object)((ContentBlockParam)other).thinking) && Intrinsics.areEqual((Object)this.redactedThinking, (Object)((ContentBlockParam)other).redactedThinking) && Intrinsics.areEqual((Object)this.toolUse, (Object)((ContentBlockParam)other).toolUse) && Intrinsics.areEqual((Object)this.toolResult, (Object)((ContentBlockParam)other).toolResult) && Intrinsics.areEqual((Object)this.serverToolUse, (Object)((ContentBlockParam)other).serverToolUse) && Intrinsics.areEqual((Object)this.webSearchToolResult, (Object)((ContentBlockParam)other).webSearchToolResult);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.text, this.image, this.document, this.thinking, this.redactedThinking, this.toolUse, this.toolResult, this.serverToolUse, this.webSearchToolResult};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        String string;
        if (this.text != null) {
            string = "ContentBlockParam{text=" + this.text + '}';
        } else if (this.image != null) {
            string = "ContentBlockParam{image=" + this.image + '}';
        } else if (this.document != null) {
            string = "ContentBlockParam{document=" + this.document + '}';
        } else if (this.thinking != null) {
            string = "ContentBlockParam{thinking=" + this.thinking + '}';
        } else if (this.redactedThinking != null) {
            string = "ContentBlockParam{redactedThinking=" + this.redactedThinking + '}';
        } else if (this.toolUse != null) {
            string = "ContentBlockParam{toolUse=" + this.toolUse + '}';
        } else if (this.toolResult != null) {
            string = "ContentBlockParam{toolResult=" + this.toolResult + '}';
        } else if (this.serverToolUse != null) {
            string = "ContentBlockParam{serverToolUse=" + this.serverToolUse + '}';
        } else if (this.webSearchToolResult != null) {
            string = "ContentBlockParam{webSearchToolResult=" + this.webSearchToolResult + '}';
        } else if (this._json != null) {
            string = "ContentBlockParam{_unknown=" + this._json + '}';
        } else {
            throw new IllegalStateException("Invalid ContentBlockParam");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final ContentBlockParam ofText(@NotNull TextBlockParam text) {
        return Companion.ofText(text);
    }

    @JvmStatic
    @NotNull
    public static final ContentBlockParam ofImage(@NotNull ImageBlockParam image) {
        return Companion.ofImage(image);
    }

    @JvmStatic
    @NotNull
    public static final ContentBlockParam ofDocument(@NotNull DocumentBlockParam document) {
        return Companion.ofDocument(document);
    }

    @JvmStatic
    @NotNull
    public static final ContentBlockParam ofThinking(@NotNull ThinkingBlockParam thinking) {
        return Companion.ofThinking(thinking);
    }

    @JvmStatic
    @NotNull
    public static final ContentBlockParam ofRedactedThinking(@NotNull RedactedThinkingBlockParam redactedThinking) {
        return Companion.ofRedactedThinking(redactedThinking);
    }

    @JvmStatic
    @NotNull
    public static final ContentBlockParam ofToolUse(@NotNull ToolUseBlockParam toolUse) {
        return Companion.ofToolUse(toolUse);
    }

    @JvmStatic
    @NotNull
    public static final ContentBlockParam ofToolResult(@NotNull ToolResultBlockParam toolResult) {
        return Companion.ofToolResult(toolResult);
    }

    @JvmStatic
    @NotNull
    public static final ContentBlockParam ofServerToolUse(@NotNull ServerToolUseBlockParam serverToolUse) {
        return Companion.ofServerToolUse(serverToolUse);
    }

    @JvmStatic
    @NotNull
    public static final ContentBlockParam ofWebSearchToolResult(@NotNull WebSearchToolResultBlockParam webSearchToolResult) {
        return Companion.ofWebSearchToolResult(webSearchToolResult);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007\u00a8\u0006\u001f"}, d2={"Lcom/anthropic/models/messages/ContentBlockParam$Companion;", "", "()V", "ofDocument", "Lcom/anthropic/models/messages/ContentBlockParam;", "document", "Lcom/anthropic/models/messages/DocumentBlockParam;", "ofImage", "image", "Lcom/anthropic/models/messages/ImageBlockParam;", "ofRedactedThinking", "redactedThinking", "Lcom/anthropic/models/messages/RedactedThinkingBlockParam;", "ofServerToolUse", "serverToolUse", "Lcom/anthropic/models/messages/ServerToolUseBlockParam;", "ofText", "text", "Lcom/anthropic/models/messages/TextBlockParam;", "ofThinking", "thinking", "Lcom/anthropic/models/messages/ThinkingBlockParam;", "ofToolResult", "toolResult", "Lcom/anthropic/models/messages/ToolResultBlockParam;", "ofToolUse", "toolUse", "Lcom/anthropic/models/messages/ToolUseBlockParam;", "ofWebSearchToolResult", "webSearchToolResult", "Lcom/anthropic/models/messages/WebSearchToolResultBlockParam;", "anthropic-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ContentBlockParam ofText(@NotNull TextBlockParam text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new ContentBlockParam(text, null, null, null, null, null, null, null, null, null, 1022, null);
        }

        @JvmStatic
        @NotNull
        public final ContentBlockParam ofImage(@NotNull ImageBlockParam image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            return new ContentBlockParam(null, image, null, null, null, null, null, null, null, null, 1021, null);
        }

        @JvmStatic
        @NotNull
        public final ContentBlockParam ofDocument(@NotNull DocumentBlockParam document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            return new ContentBlockParam(null, null, document, null, null, null, null, null, null, null, 1019, null);
        }

        @JvmStatic
        @NotNull
        public final ContentBlockParam ofThinking(@NotNull ThinkingBlockParam thinking) {
            Intrinsics.checkNotNullParameter((Object)thinking, (String)"thinking");
            return new ContentBlockParam(null, null, null, thinking, null, null, null, null, null, null, 1015, null);
        }

        @JvmStatic
        @NotNull
        public final ContentBlockParam ofRedactedThinking(@NotNull RedactedThinkingBlockParam redactedThinking) {
            Intrinsics.checkNotNullParameter((Object)redactedThinking, (String)"redactedThinking");
            return new ContentBlockParam(null, null, null, null, redactedThinking, null, null, null, null, null, 1007, null);
        }

        @JvmStatic
        @NotNull
        public final ContentBlockParam ofToolUse(@NotNull ToolUseBlockParam toolUse) {
            Intrinsics.checkNotNullParameter((Object)toolUse, (String)"toolUse");
            return new ContentBlockParam(null, null, null, null, null, toolUse, null, null, null, null, 991, null);
        }

        @JvmStatic
        @NotNull
        public final ContentBlockParam ofToolResult(@NotNull ToolResultBlockParam toolResult) {
            Intrinsics.checkNotNullParameter((Object)toolResult, (String)"toolResult");
            return new ContentBlockParam(null, null, null, null, null, null, toolResult, null, null, null, 959, null);
        }

        @JvmStatic
        @NotNull
        public final ContentBlockParam ofServerToolUse(@NotNull ServerToolUseBlockParam serverToolUse) {
            Intrinsics.checkNotNullParameter((Object)serverToolUse, (String)"serverToolUse");
            return new ContentBlockParam(null, null, null, null, null, null, null, serverToolUse, null, null, 895, null);
        }

        @JvmStatic
        @NotNull
        public final ContentBlockParam ofWebSearchToolResult(@NotNull WebSearchToolResultBlockParam webSearchToolResult) {
            Intrinsics.checkNotNullParameter((Object)webSearchToolResult, (String)"webSearchToolResult");
            return new ContentBlockParam(null, null, null, null, null, null, null, null, webSearchToolResult, null, 767, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/anthropic/models/messages/ContentBlockParam$Deserializer;", "Lcom/anthropic/core/BaseDeserializer;", "Lcom/anthropic/models/messages/ContentBlockParam;", "()V", "deserialize", "Lcom/fasterxml/jackson/core/ObjectCodec;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "anthropic-java-core"})
    @SourceDebugExtension(value={"SMAP\nContentBlockParam.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentBlockParam.kt\ncom/anthropic/models/messages/ContentBlockParam$Deserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,425:1\n43#2:426\n43#2:427\n43#2:428\n43#2:429\n43#2:430\n43#2:431\n43#2:432\n43#2:433\n43#2:434\n1#3:435\n*S KotlinDebug\n*F\n+ 1 ContentBlockParam.kt\ncom/anthropic/models/messages/ContentBlockParam$Deserializer\n*L\n351#1:426\n356#1:427\n361#1:428\n366#1:429\n371#1:430\n376#1:431\n381#1:432\n386#1:433\n391#1:434\n*E\n"})
    public static final class Deserializer
    extends BaseDeserializer<ContentBlockParam> {
        public Deserializer() {
            super(Reflection.getOrCreateKotlinClass(ContentBlockParam.class));
        }

        @Override
        @NotNull
        protected ContentBlockParam deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
            JsonValue json2;
            block49: {
                String type;
                Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                json2 = JsonValue.Companion.fromJsonNode(node);
                Object object = (Map)OptionalsKt.getOrNull(json2.asObject());
                String string = type = object != null && (object = (JsonValue)object.get("type")) != null && (object = ((JsonField)object).asString()) != null ? (String)OptionalsKt.getOrNull(object) : null;
                if (string == null) break block49;
                int n = -1;
                switch (string.hashCode()) {
                    case 100313435: {
                        if (string.equals("image")) {
                            n = 1;
                        }
                        break;
                    }
                    case -983248288: {
                        if (string.equals("tool_use")) {
                            n = 2;
                        }
                        break;
                    }
                    case -371072860: {
                        if (string.equals("tool_result")) {
                            n = 3;
                        }
                        break;
                    }
                    case 861720859: {
                        if (string.equals("document")) {
                            n = 4;
                        }
                        break;
                    }
                    case -882361265: {
                        if (string.equals("redacted_thinking")) {
                            n = 5;
                        }
                        break;
                    }
                    case -1912254500: {
                        if (string.equals("server_tool_use")) {
                            n = 6;
                        }
                        break;
                    }
                    case 3556653: {
                        if (string.equals("text")) {
                            n = 7;
                        }
                        break;
                    }
                    case 1224578480: {
                        if (string.equals("thinking")) {
                            n = 8;
                        }
                        break;
                    }
                    case 503733080: {
                        if (string.equals("web_search_tool_result")) {
                            n = 9;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 7: {
                        ContentBlockParam contentBlockParam;
                        boolean $i$f$jacksonTypeRef = false;
                        TextBlockParam textBlockParam = (TextBlockParam)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<TextBlockParam>(){});
                        if (textBlockParam != null) {
                            TextBlockParam it = textBlockParam;
                            boolean bl = false;
                            contentBlockParam = new ContentBlockParam(it, null, null, null, null, null, null, null, null, json2, 510, null);
                        } else {
                            contentBlockParam = new ContentBlockParam(null, null, null, null, null, null, null, null, null, json2, 511, null);
                        }
                        return contentBlockParam;
                    }
                    case 1: {
                        ContentBlockParam contentBlockParam;
                        boolean $i$f$jacksonTypeRef = false;
                        ImageBlockParam imageBlockParam = (ImageBlockParam)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<ImageBlockParam>(){});
                        if (imageBlockParam != null) {
                            ImageBlockParam it = imageBlockParam;
                            boolean bl = false;
                            contentBlockParam = new ContentBlockParam(null, it, null, null, null, null, null, null, null, json2, 509, null);
                        } else {
                            contentBlockParam = new ContentBlockParam(null, null, null, null, null, null, null, null, null, json2, 511, null);
                        }
                        return contentBlockParam;
                    }
                    case 4: {
                        ContentBlockParam contentBlockParam;
                        boolean $i$f$jacksonTypeRef = false;
                        DocumentBlockParam documentBlockParam = (DocumentBlockParam)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<DocumentBlockParam>(){});
                        if (documentBlockParam != null) {
                            DocumentBlockParam it = documentBlockParam;
                            boolean bl = false;
                            contentBlockParam = new ContentBlockParam(null, null, it, null, null, null, null, null, null, json2, 507, null);
                        } else {
                            contentBlockParam = new ContentBlockParam(null, null, null, null, null, null, null, null, null, json2, 511, null);
                        }
                        return contentBlockParam;
                    }
                    case 8: {
                        ContentBlockParam contentBlockParam;
                        boolean $i$f$jacksonTypeRef = false;
                        ThinkingBlockParam thinkingBlockParam = (ThinkingBlockParam)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<ThinkingBlockParam>(){});
                        if (thinkingBlockParam != null) {
                            ThinkingBlockParam it = thinkingBlockParam;
                            boolean bl = false;
                            contentBlockParam = new ContentBlockParam(null, null, null, it, null, null, null, null, null, json2, 503, null);
                        } else {
                            contentBlockParam = new ContentBlockParam(null, null, null, null, null, null, null, null, null, json2, 511, null);
                        }
                        return contentBlockParam;
                    }
                    case 5: {
                        ContentBlockParam contentBlockParam;
                        boolean $i$f$jacksonTypeRef = false;
                        RedactedThinkingBlockParam redactedThinkingBlockParam = (RedactedThinkingBlockParam)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<RedactedThinkingBlockParam>(){});
                        if (redactedThinkingBlockParam != null) {
                            RedactedThinkingBlockParam it = redactedThinkingBlockParam;
                            boolean bl = false;
                            contentBlockParam = new ContentBlockParam(null, null, null, null, it, null, null, null, null, json2, 495, null);
                        } else {
                            contentBlockParam = new ContentBlockParam(null, null, null, null, null, null, null, null, null, json2, 511, null);
                        }
                        return contentBlockParam;
                    }
                    case 2: {
                        ContentBlockParam contentBlockParam;
                        boolean $i$f$jacksonTypeRef = false;
                        ToolUseBlockParam toolUseBlockParam = (ToolUseBlockParam)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<ToolUseBlockParam>(){});
                        if (toolUseBlockParam != null) {
                            ToolUseBlockParam it = toolUseBlockParam;
                            boolean bl = false;
                            contentBlockParam = new ContentBlockParam(null, null, null, null, null, it, null, null, null, json2, 479, null);
                        } else {
                            contentBlockParam = new ContentBlockParam(null, null, null, null, null, null, null, null, null, json2, 511, null);
                        }
                        return contentBlockParam;
                    }
                    case 3: {
                        ContentBlockParam contentBlockParam;
                        boolean $i$f$jacksonTypeRef = false;
                        ToolResultBlockParam toolResultBlockParam = (ToolResultBlockParam)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<ToolResultBlockParam>(){});
                        if (toolResultBlockParam != null) {
                            ToolResultBlockParam it = toolResultBlockParam;
                            boolean bl = false;
                            contentBlockParam = new ContentBlockParam(null, null, null, null, null, null, it, null, null, json2, 447, null);
                        } else {
                            contentBlockParam = new ContentBlockParam(null, null, null, null, null, null, null, null, null, json2, 511, null);
                        }
                        return contentBlockParam;
                    }
                    case 6: {
                        ContentBlockParam contentBlockParam;
                        boolean $i$f$jacksonTypeRef = false;
                        ServerToolUseBlockParam serverToolUseBlockParam = (ServerToolUseBlockParam)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<ServerToolUseBlockParam>(){});
                        if (serverToolUseBlockParam != null) {
                            ServerToolUseBlockParam it = serverToolUseBlockParam;
                            boolean bl = false;
                            contentBlockParam = new ContentBlockParam(null, null, null, null, null, null, null, it, null, json2, 383, null);
                        } else {
                            contentBlockParam = new ContentBlockParam(null, null, null, null, null, null, null, null, null, json2, 511, null);
                        }
                        return contentBlockParam;
                    }
                    case 9: {
                        ContentBlockParam contentBlockParam;
                        boolean $i$f$jacksonTypeRef = false;
                        WebSearchToolResultBlockParam webSearchToolResultBlockParam = (WebSearchToolResultBlockParam)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<WebSearchToolResultBlockParam>(){});
                        if (webSearchToolResultBlockParam != null) {
                            WebSearchToolResultBlockParam it = webSearchToolResultBlockParam;
                            boolean bl = false;
                            contentBlockParam = new ContentBlockParam(null, null, null, null, null, null, null, null, it, json2, 255, null);
                        } else {
                            contentBlockParam = new ContentBlockParam(null, null, null, null, null, null, null, null, null, json2, 511, null);
                        }
                        return contentBlockParam;
                    }
                }
            }
            return new ContentBlockParam(null, null, null, null, null, null, null, null, null, json2, 511, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/anthropic/models/messages/ContentBlockParam$Serializer;", "Lcom/anthropic/core/BaseSerializer;", "Lcom/anthropic/models/messages/ContentBlockParam;", "()V", "serialize", "", "value", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "anthropic-java-core"})
    public static final class Serializer
    extends BaseSerializer<ContentBlockParam> {
        public Serializer() {
            super(Reflection.getOrCreateKotlinClass(ContentBlockParam.class));
        }

        public void serialize(@NotNull ContentBlockParam value, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            if (value.text != null) {
                generator.writeObject((Object)value.text);
            } else if (value.image != null) {
                generator.writeObject((Object)value.image);
            } else if (value.document != null) {
                generator.writeObject((Object)value.document);
            } else if (value.thinking != null) {
                generator.writeObject((Object)value.thinking);
            } else if (value.redactedThinking != null) {
                generator.writeObject((Object)value.redactedThinking);
            } else if (value.toolUse != null) {
                generator.writeObject((Object)value.toolUse);
            } else if (value.toolResult != null) {
                generator.writeObject((Object)value.toolResult);
            } else if (value.serverToolUse != null) {
                generator.writeObject((Object)value.serverToolUse);
            } else if (value.webSearchToolResult != null) {
                generator.writeObject((Object)value.webSearchToolResult);
            } else if (value._json != null) {
                generator.writeObject((Object)value._json);
            } else {
                throw new IllegalStateException("Invalid ContentBlockParam");
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\u0017\u0010\u0003\u001a\u00028\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0015H&\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u0019H&\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u001dH&\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001f\u001a\u00028\u00002\u0006\u0010 \u001a\u00020!H&\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u00028\u00002\u0006\u0010$\u001a\u00020%H&\u00a2\u0006\u0002\u0010&J\u0015\u0010'\u001a\u00028\u00002\u0006\u0010(\u001a\u00020)H&\u00a2\u0006\u0002\u0010*\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006+\u00c0\u0006\u0001"}, d2={"Lcom/anthropic/models/messages/ContentBlockParam$Visitor;", "T", "", "unknown", "json", "Lcom/anthropic/core/JsonValue;", "(Lcom/anthropic/core/JsonValue;)Ljava/lang/Object;", "visitDocument", "document", "Lcom/anthropic/models/messages/DocumentBlockParam;", "(Lcom/anthropic/models/messages/DocumentBlockParam;)Ljava/lang/Object;", "visitImage", "image", "Lcom/anthropic/models/messages/ImageBlockParam;", "(Lcom/anthropic/models/messages/ImageBlockParam;)Ljava/lang/Object;", "visitRedactedThinking", "redactedThinking", "Lcom/anthropic/models/messages/RedactedThinkingBlockParam;", "(Lcom/anthropic/models/messages/RedactedThinkingBlockParam;)Ljava/lang/Object;", "visitServerToolUse", "serverToolUse", "Lcom/anthropic/models/messages/ServerToolUseBlockParam;", "(Lcom/anthropic/models/messages/ServerToolUseBlockParam;)Ljava/lang/Object;", "visitText", "text", "Lcom/anthropic/models/messages/TextBlockParam;", "(Lcom/anthropic/models/messages/TextBlockParam;)Ljava/lang/Object;", "visitThinking", "thinking", "Lcom/anthropic/models/messages/ThinkingBlockParam;", "(Lcom/anthropic/models/messages/ThinkingBlockParam;)Ljava/lang/Object;", "visitToolResult", "toolResult", "Lcom/anthropic/models/messages/ToolResultBlockParam;", "(Lcom/anthropic/models/messages/ToolResultBlockParam;)Ljava/lang/Object;", "visitToolUse", "toolUse", "Lcom/anthropic/models/messages/ToolUseBlockParam;", "(Lcom/anthropic/models/messages/ToolUseBlockParam;)Ljava/lang/Object;", "visitWebSearchToolResult", "webSearchToolResult", "Lcom/anthropic/models/messages/WebSearchToolResultBlockParam;", "(Lcom/anthropic/models/messages/WebSearchToolResultBlockParam;)Ljava/lang/Object;", "anthropic-java-core"})
    public static interface Visitor<T> {
        public T visitText(@NotNull TextBlockParam var1);

        public T visitImage(@NotNull ImageBlockParam var1);

        public T visitDocument(@NotNull DocumentBlockParam var1);

        public T visitThinking(@NotNull ThinkingBlockParam var1);

        public T visitRedactedThinking(@NotNull RedactedThinkingBlockParam var1);

        public T visitToolUse(@NotNull ToolUseBlockParam var1);

        public T visitToolResult(@NotNull ToolResultBlockParam var1);

        public T visitServerToolUse(@NotNull ServerToolUseBlockParam var1);

        public T visitWebSearchToolResult(@NotNull WebSearchToolResultBlockParam var1);

        default public T unknown(@Nullable JsonValue json2) {
            throw new AnthropicInvalidDataException("Unknown ContentBlockParam: " + json2, null, 2, null);
        }
    }
}

