/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.vertex.backends;

import com.anthropic.backends.Backend;
import com.anthropic.core.Check;
import com.anthropic.core.ObjectMappers;
import com.anthropic.core.http.HttpRequest;
import com.anthropic.core.http.HttpRequestBodies;
import com.anthropic.core.http.HttpRequestBody;
import com.anthropic.errors.AnthropicException;
import com.anthropic.errors.AnthropicInvalidDataException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.OutputStream;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000bR\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/anthropic/vertex/backends/VertexBackend;", "Lcom/anthropic/backends/Backend;", "googleCredentials", "Lcom/google/auth/oauth2/GoogleCredentials;", "region", "", "project", "(Lcom/google/auth/oauth2/GoogleCredentials;Ljava/lang/String;Ljava/lang/String;)V", "()Lcom/google/auth/oauth2/GoogleCredentials;", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "()Ljava/lang/String;", "authorizeRequest", "Lcom/anthropic/core/http/HttpRequest;", "request", "baseUrl", "close", "", "prepareRequest", "Builder", "Companion", "anthropic-java-vertex"})
@SourceDebugExtension(value={"SMAP\nVertexBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VertexBackend.kt\ncom/anthropic/vertex/backends/VertexBackend\n+ 2 HttpRequestBodies.kt\ncom/anthropic/core/http/HttpRequestBodies\n*L\n1#1,193:1\n34#2:194\n46#2:195\n*S KotlinDebug\n*F\n+ 1 VertexBackend.kt\ncom/anthropic/vertex/backends/VertexBackend\n*L\n122#1:194\n122#1:195\n*E\n"})
public final class VertexBackend
implements Backend {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GoogleCredentials googleCredentials;
    @NotNull
    private final String region;
    @NotNull
    private final String project;
    @NotNull
    private final JsonMapper jsonMapper;
    @NotNull
    private static final String ANTHROPIC_VERSION = "vertex-2023-10-16";
    @NotNull
    private static final String ENV_REGION = "CLOUD_ML_REGION";
    @NotNull
    private static final String ENV_PROJECT = "ANTHROPIC_VERTEX_PROJECT_ID";
    @NotNull
    private static final String HEADER_AUTHORIZATION = "Authorization";

    private VertexBackend(GoogleCredentials googleCredentials, String region, String project) {
        this.googleCredentials = googleCredentials;
        this.region = region;
        this.project = project;
        this.jsonMapper = ObjectMappers.jsonMapper();
    }

    @JvmName(name="googleCredentials")
    @NotNull
    public final GoogleCredentials googleCredentials() {
        return this.googleCredentials;
    }

    @JvmName(name="region")
    @NotNull
    public final String region() {
        return this.region;
    }

    @JvmName(name="project")
    @NotNull
    public final String project() {
        return this.project;
    }

    @NotNull
    public String baseUrl() {
        return "https://" + this.region + "-aiplatform.googleapis.com";
    }

    @NotNull
    public HttpRequest prepareRequest(@NotNull HttpRequest request) {
        JsonNode model;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        List pathSegments = request.pathSegments();
        if (pathSegments.isEmpty() || !Intrinsics.areEqual(pathSegments.get(0), (Object)"v1")) {
            throw new AnthropicInvalidDataException("Expected first 'v1' path segment.", null, 2, null);
        }
        if (pathSegments.size() <= 1) {
            throw new AnthropicInvalidDataException("Missing service name from request URL.", null, 2, null);
        }
        boolean isCountTokens = false;
        switch ((String)pathSegments.get(1)) {
            case "projects": {
                throw new IllegalArgumentException("Request already prepared for Vertex.");
            }
            case "messages": {
                if (pathSegments.size() <= 2) break;
                String string = (String)pathSegments.get(2);
                if (Intrinsics.areEqual((Object)string, (Object)"batches")) {
                    throw new AnthropicException("Batch API is not supported for Vertex.", null, 2, null);
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"count_tokens")) break;
                isCountTokens = true;
                break;
            }
            default: {
                throw new AnthropicException("Service is not supported for Vertex: " + (String)pathSegments.get(1) + '.', null, 2, null);
            }
            case "complete": 
        }
        ObjectNode jsonBody = HttpRequestBodies.bodyToJson((ObjectMapper)((ObjectMapper)this.jsonMapper), (HttpRequestBody)request.body());
        if (jsonBody == null) {
            throw new AnthropicInvalidDataException("Request has no body.", null, 2, null);
        }
        jsonBody.put("anthropic_version", ANTHROPIC_VERSION);
        String endpoint = null;
        if (isCountTokens) {
            endpoint = "count-tokens:rawPredict";
        } else {
            JsonNode jsonNode = jsonBody.remove("model");
            if (jsonNode == null) {
                throw new AnthropicInvalidDataException("No model found in body.", null, 2, null);
            }
            model = jsonNode;
            String modelId = model.asText();
            JsonNode jsonNode2 = jsonBody.get("stream");
            boolean isStream = jsonNode2 != null ? jsonNode2.asBoolean() : false;
            String specifier = isStream ? "streamRawPredict" : "rawPredict";
            endpoint = modelId + ':' + specifier;
        }
        model = new JsonNode[]{"v1", "projects", this.project, "locations", this.region, "publishers", "anthropic", "models", endpoint};
        JsonMapper jsonMapper$iv = this.jsonMapper;
        boolean $i$f$json = false;
        return request.toBuilder().replaceAllPathSegments((String[])model).body(new HttpRequestBody(jsonMapper$iv, jsonBody){
            @NotNull
            private final Lazy bytes$delegate;
            {
                this.bytes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>($jsonMapper, $value){
                    final /* synthetic */ JsonMapper $jsonMapper;
                    final /* synthetic */ Object $value;
                    {
                        this.$jsonMapper = $jsonMapper;
                        this.$value = $value;
                        super(0);
                    }

                    public final byte[] invoke() {
                        return this.$jsonMapper.writeValueAsBytes(this.$value);
                    }
                }));
            }

            private final byte[] getBytes() {
                Object object = this.bytes$delegate.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-bytes>(...)");
                return (byte[])object;
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.getBytes());
            }

            @NotNull
            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.getBytes().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        }).build();
    }

    @NotNull
    public HttpRequest authorizeRequest(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.googleCredentials.refreshIfExpired();
        if (!(!request.headers().names().contains(HEADER_AUTHORIZATION))) {
            boolean bl = false;
            String string = "Request already authorized for Vertex.";
            throw new IllegalArgumentException(string.toString());
        }
        return request.toBuilder().putHeader(HEADER_AUTHORIZATION, "Bearer " + this.googleCredentials.getAccessToken().getTokenValue()).build();
    }

    public void close() {
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @JvmStatic
    @NotNull
    public static final VertexBackend fromEnv() {
        return Companion.fromEnv();
    }

    public /* synthetic */ VertexBackend(GoogleCredentials googleCredentials, String region, String project, DefaultConstructorMarker $constructor_marker) {
        this(googleCredentials, region, project);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0000J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/anthropic/vertex/backends/VertexBackend$Builder;", "", "()V", "googleCredentials", "Lcom/google/auth/oauth2/GoogleCredentials;", "project", "", "region", "build", "Lcom/anthropic/vertex/backends/VertexBackend;", "fromEnv", "anthropic-java-vertex"})
    @SourceDebugExtension(value={"SMAP\nVertexBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VertexBackend.kt\ncom/anthropic/vertex/backends/VertexBackend$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n1#2:194\n*E\n"})
    public static final class Builder {
        @Nullable
        private GoogleCredentials googleCredentials;
        @Nullable
        private String region;
        @Nullable
        private String project;

        @NotNull
        public final Builder fromEnv() {
            Builder builder;
            Builder $this$fromEnv_u24lambda_u240 = builder = this;
            boolean bl = false;
            try {
                $this$fromEnv_u24lambda_u240.googleCredentials = GoogleCredentials.getApplicationDefault();
            }
            catch (Exception e) {
                throw new IllegalStateException("Google OAuth2 credentials could not be resolved.", e);
            }
            String string = System.getenv(VertexBackend.ENV_REGION);
            if (string == null) {
                throw new IllegalStateException("No region set in CLOUD_ML_REGION environment variable.");
            }
            $this$fromEnv_u24lambda_u240.region = string;
            String string2 = System.getenv(VertexBackend.ENV_PROJECT);
            if (string2 == null) {
                throw new IllegalStateException("No project set in ANTHROPIC_VERTEX_PROJECT_ID environment variable.");
            }
            $this$fromEnv_u24lambda_u240.project = string2;
            return builder;
        }

        @NotNull
        public final Builder googleCredentials(@NotNull GoogleCredentials googleCredentials) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)googleCredentials, (String)"googleCredentials");
            Builder $this$googleCredentials_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$googleCredentials_u24lambda_u241.googleCredentials = googleCredentials;
            return builder;
        }

        @NotNull
        public final Builder region(@NotNull String region) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)region, (String)"region");
            Builder $this$region_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$region_u24lambda_u242.region = region;
            return builder;
        }

        @NotNull
        public final Builder project(@NotNull String project) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Builder $this$project_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$project_u24lambda_u243.project = project;
            return builder;
        }

        @NotNull
        public final VertexBackend build() {
            return new VertexBackend((GoogleCredentials)Check.checkRequired((String)"googleCredentials", (Object)this.googleCredentials), (String)Check.checkRequired((String)"region", (Object)this.region), (String)Check.checkRequired((String)"project", (Object)this.project), null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/anthropic/vertex/backends/VertexBackend$Companion;", "", "()V", "ANTHROPIC_VERSION", "", "ENV_PROJECT", "ENV_REGION", "HEADER_AUTHORIZATION", "builder", "Lcom/anthropic/vertex/backends/VertexBackend$Builder;", "fromEnv", "Lcom/anthropic/vertex/backends/VertexBackend;", "anthropic-java-vertex"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        @JvmStatic
        @NotNull
        public final VertexBackend fromEnv() {
            return this.builder().fromEnv().build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

