/*
 * Decompiled with CFR 0.152.
 */
package com.drmilk.nbawrapper.domain;

import com.drmilk.nbawrapper.config.AppConfig;
import com.drmilk.nbawrapper.domain.TeamMin;
import com.drmilk.nbawrapper.domain.utils.team.Game;
import com.drmilk.nbawrapper.domain.utils.team.PlayerOverview;
import com.drmilk.nbawrapper.domain.utils.team.TeamLeaders;
import com.drmilk.nbawrapper.domain.utils.team.TeamLeadersResponse;
import com.drmilk.nbawrapper.domain.utils.team.TeamRosterResponse;
import com.drmilk.nbawrapper.domain.utils.team.TeamScheduleResponse;
import com.drmilk.nbawrapper.domain.utils.team.TeamSummary;
import com.drmilk.nbawrapper.domain.utils.team.TeamSummaryResponse;
import com.drmilk.nbawrapper.exception.TeamNotFoundException;
import com.drmilk.nbawrapper.utils.QueryManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.debatty.java.stringsimilarity.Cosine;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

public class Team {
    private static AbstractApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{AppConfig.class});
    private static ObjectMapper objectMapper = (ObjectMapper)context.getBean("objectMapper");
    private static String currentSeason = (String)context.getBean("currentSeason");
    private static String sourceBaseUrl = (String)context.getBean("sourceBaseUrl");
    public static final String LOGO_BASE_URL = "http://i.cdn.turner.com/nba/nba/assets/logos/teams/secondary/web/";
    public static final String LOGO_END_URL = ".svg";
    private TeamSummary teamSummary;
    private List<String> roster;
    private TeamLeaders teamLeaders;
    private List<Game> games;
    private String logoUrl;

    private Team(String teamId) throws TeamNotFoundException {
        try {
            HttpResponse teamSummaryResponse = QueryManager.getHttpResponse(sourceBaseUrl + "/" + currentSeason + "/teams.json");
            TeamSummaryResponse teamSummaries = (TeamSummaryResponse)objectMapper.readValue(teamSummaryResponse.getEntity().getContent(), TeamSummaryResponse.class);
            for (TeamSummary teamSummary : teamSummaries.getLeague().getStandard()) {
                if (!teamSummary.getTeamId().equals(teamId)) continue;
                this.teamSummary = teamSummary;
                break;
            }
            HttpResponse teamScheduleResponse = QueryManager.getHttpResponse(sourceBaseUrl + "/" + currentSeason + "/teams/" + teamId + "/schedule.json");
            TeamScheduleResponse teamSchedules = (TeamScheduleResponse)objectMapper.readValue(teamScheduleResponse.getEntity().getContent(), TeamScheduleResponse.class);
            this.games = teamSchedules.getLeague().getGames();
            HttpResponse teamRosterResponse = QueryManager.getHttpResponse(sourceBaseUrl + "/" + currentSeason + "/teams/" + teamId + "/roster.json");
            TeamRosterResponse teamRoster = (TeamRosterResponse)objectMapper.readValue(teamRosterResponse.getEntity().getContent(), TeamRosterResponse.class);
            this.roster = new ArrayList<String>();
            for (PlayerOverview playerOverview : teamRoster.getLeague().getStandard().getPlayers()) {
                this.roster.add(playerOverview.getPersonId());
            }
            HttpResponse teamLeadersResponse = QueryManager.getHttpResponse(sourceBaseUrl + "/" + currentSeason + "/teams/" + teamId + "/leaders.json");
            this.teamLeaders = ((TeamLeadersResponse)objectMapper.readValue(teamLeadersResponse.getEntity().getContent(), TeamLeadersResponse.class)).getLeague().getStandard();
            this.logoUrl = LOGO_BASE_URL + this.teamSummary.getTricode() + LOGO_END_URL;
        }
        catch (Exception e) {
            throw new TeamNotFoundException("Could not find a team with teamId '" + teamId + "'");
        }
    }

    public static TeamMin getShortProfileByTeamId(String teamId) throws TeamNotFoundException {
        try {
            TeamMin result = new TeamMin();
            HttpResponse teamSummaryResponse = QueryManager.getHttpResponse(sourceBaseUrl + "/" + currentSeason + "/teams.json");
            TeamSummaryResponse teamSummaries = (TeamSummaryResponse)objectMapper.readValue(teamSummaryResponse.getEntity().getContent(), TeamSummaryResponse.class);
            for (TeamSummary teamSummary : teamSummaries.getLeague().getStandard()) {
                if (!teamSummary.getTeamId().equals(teamId)) continue;
                result.setLogoUrl(LOGO_BASE_URL + teamSummary.getTricode() + LOGO_END_URL);
                result.setFullName(teamSummary.getFullName());
                result.setTriCode(teamSummary.getTricode());
                break;
            }
            return result;
        }
        catch (Exception e) {
            throw new TeamNotFoundException("Could not find a team with teamId '" + teamId + "'");
        }
    }

    public static Team getTeamById(String teamId) throws TeamNotFoundException {
        return new Team(teamId);
    }

    public static Team getTeamByNameKeywords(String teamNameKeywords) throws TeamNotFoundException {
        try {
            String teamId = null;
            Double bestSimilarity = 1.0;
            Cosine algorithm = new Cosine();
            HttpResponse leagueTeamsResponse = QueryManager.getHttpResponse(sourceBaseUrl + "/" + currentSeason + "/teams.json");
            TeamSummaryResponse teamSummaries = (TeamSummaryResponse)objectMapper.readValue(leagueTeamsResponse.getEntity().getContent(), TeamSummaryResponse.class);
            for (TeamSummary teamSummary : teamSummaries.getLeague().getStandard()) {
                String fullName = teamSummary.getFullName();
                Double currentSimilarity = algorithm.distance(fullName.toLowerCase(), teamNameKeywords.toLowerCase());
                if (!(currentSimilarity < bestSimilarity)) continue;
                bestSimilarity = currentSimilarity;
                teamId = teamSummary.getTeamId();
            }
            if (teamId == null) {
                throw new TeamNotFoundException("Could not find a team using keywords '" + teamNameKeywords + "'");
            }
            return new Team(teamId);
        }
        catch (Exception e) {
            throw new TeamNotFoundException("Could not find a team using keywords '" + teamNameKeywords + "'");
        }
    }

    public Boolean getIsNBAFranchise() {
        return this.teamSummary.getIsNBAFranchise();
    }

    public void setIsNBAFranchise(Boolean isNBAFranchise) {
        this.teamSummary.setIsNBAFranchise(isNBAFranchise);
    }

    public Boolean getIsAllStar() {
        return this.teamSummary.getIsAllStar();
    }

    public void setIsAllStar(Boolean isAllStar) {
        this.teamSummary.setIsAllStar(isAllStar);
    }

    public String getCity() {
        return this.teamSummary.getCity();
    }

    public void setCity(String city) {
        this.teamSummary.setCity(city);
    }

    public String getAltcityName() {
        return this.teamSummary.getAltcityName();
    }

    public void setAltcityName(String altcityName) {
        this.teamSummary.setAltcityName(altcityName);
    }

    public String getFullName() {
        return this.teamSummary.getFullName();
    }

    public void setFullName(String fullName) {
        this.teamSummary.setFullName(fullName);
    }

    public String getTricode() {
        return this.teamSummary.getTricode();
    }

    public void setTricode(String tricode) {
        this.teamSummary.setTricode(tricode);
    }

    public String getTeamId() {
        return this.teamSummary.getTeamId();
    }

    public void setTeamId(String teamId) {
        this.teamSummary.setTeamId(teamId);
    }

    public String getNickname() {
        return this.teamSummary.getNickname();
    }

    public void setNickname(String nickname) {
        this.teamSummary.setNickname(nickname);
    }

    public String getUrlName() {
        return this.teamSummary.getUrlName();
    }

    public void setUrlName(String urlName) {
        this.teamSummary.setUrlName(urlName);
    }

    public String getConfName() {
        return this.teamSummary.getConfName();
    }

    public void setConfName(String confName) {
        this.teamSummary.setConfName(confName);
    }

    public String getDivName() {
        return this.teamSummary.getDivName();
    }

    public void setDivName(String divName) {
        this.teamSummary.setDivName(divName);
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public List<Game> getGames() {
        return this.games;
    }

    public void setGames(List<Game> games) {
        this.games = games;
    }

    public List<String> getRoster() {
        return this.roster;
    }

    public void setRoster(List<String> roster) {
        this.roster = roster;
    }

    public TeamLeaders getTeamLeaders() {
        return this.teamLeaders;
    }

    public void setTeamLeaders(TeamLeaders teamLeaders) {
        this.teamLeaders = teamLeaders;
    }
}

