/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apidesigner.resource.projects.projectId.api.name;

import java.net.URLEncoder;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.mule.apidesigner.exceptions.ApiDesignerXapiException;
import org.mule.apidesigner.resource.projects.projectId.api.name.version.Version;
import org.mule.apidesigner.responses.ApiDesignerXapiResponse;

public class Name {
    private String _baseUrl;
    private Client _client;

    public Name() {
        this._baseUrl = null;
        this._client = null;
    }

    public Name(String baseUrl, Client _client, String uriParam) {
        this._baseUrl = baseUrl + "/" + URLEncoder.encode(uriParam);
        this._client = _client;
    }

    protected Client getClient() {
        return this._client;
    }

    private String getBaseUri() {
        return this._baseUrl;
    }

    public ApiDesignerXapiResponse<Void> get(String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("GET");
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ApiDesignerXapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ApiDesignerXapiResponse<Object> apiResponse = new ApiDesignerXapiResponse<Object>(null, (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }

    public Version version(String version) {
        return new Version(this.getBaseUri(), this.getClient(), version);
    }
}

