/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apidesigner.resource.projects.projectId.branches.branch;

import java.net.URLEncoder;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.mule.apidesigner.exceptions.ApiDesignerXapiException;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.acquireLock.AcquireLock;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.clean.Clean;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.exchange.Exchange;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.files.Files;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.model.BranchDELETEHeader;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.open.Open;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.publish.Publish;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.releaseLock.ReleaseLock;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.save.Save;
import org.mule.apidesigner.resource.projects.projectId.branches.branch.status.Status;
import org.mule.apidesigner.responses.ApiDesignerXapiResponse;

public class Branch {
    private String _baseUrl;
    private Client _client;
    public final Save save;
    public final Publish publish;
    public final ReleaseLock releaseLock;
    public final Open open;
    public final Clean clean;
    public final Status status;
    public final AcquireLock acquireLock;
    public final Files files;
    public final Exchange exchange;

    public Branch() {
        this._baseUrl = null;
        this._client = null;
        this.save = null;
        this.publish = null;
        this.releaseLock = null;
        this.open = null;
        this.clean = null;
        this.status = null;
        this.acquireLock = null;
        this.files = null;
        this.exchange = null;
    }

    public Branch(String baseUrl, Client _client, String uriParam) {
        this._baseUrl = baseUrl + "/" + URLEncoder.encode(uriParam);
        this._client = _client;
        this.save = new Save(this.getBaseUri(), this.getClient());
        this.publish = new Publish(this.getBaseUri(), this.getClient());
        this.releaseLock = new ReleaseLock(this.getBaseUri(), this.getClient());
        this.open = new Open(this.getBaseUri(), this.getClient());
        this.clean = new Clean(this.getBaseUri(), this.getClient());
        this.status = new Status(this.getBaseUri(), this.getClient());
        this.acquireLock = new AcquireLock(this.getBaseUri(), this.getClient());
        this.files = new Files(this.getBaseUri(), this.getClient());
        this.exchange = new Exchange(this.getBaseUri(), this.getClient());
    }

    protected Client getClient() {
        return this._client;
    }

    private String getBaseUri() {
        return this._baseUrl;
    }

    public ApiDesignerXapiResponse<Void> delete(BranchDELETEHeader headers, String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (headers.getXOrganizationId() != null) {
            invocationBuilder.header("x-organization-id", (Object)headers.getXOrganizationId());
        }
        if (headers.getXOwnerId() != null) {
            invocationBuilder.header("x-owner-id", (Object)headers.getXOwnerId());
        }
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("DELETE");
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ApiDesignerXapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ApiDesignerXapiResponse<Object> apiResponse = new ApiDesignerXapiResponse<Object>(null, (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }
}

