/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exchange.resource.assets.groupId.assetId.version;

import java.net.URLEncoder;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.mule.exchange.exceptions.ExchangexapiException;
import org.mule.exchange.resource.assets.groupId.assetId.version.api.Api;
import org.mule.exchange.resource.assets.groupId.assetId.version.asset.Asset;
import org.mule.exchange.resource.assets.groupId.assetId.version.domain.Domain;
import org.mule.exchange.resource.assets.groupId.assetId.version.model.VersionDELETEHeader;
import org.mule.exchange.resource.assets.groupId.assetId.version.policies.Policies;
import org.mule.exchange.resource.assets.groupId.assetId.version.portal.Portal;
import org.mule.exchange.resource.assets.groupId.assetId.version.rating.Rating;
import org.mule.exchange.resource.assets.groupId.assetId.version.reviews.Reviews;
import org.mule.exchange.resource.assets.groupId.assetId.version.status.Status;
import org.mule.exchange.resource.assets.groupId.assetId.version.tags.Tags;
import org.mule.exchange.responses.ExchangexapiResponse;

public class Version {
    private String _baseUrl;
    private Client _client;
    public final Asset asset;
    public final Status status;
    public final Tags tags;
    public final Rating rating;
    public final Policies policies;
    public final Reviews reviews;
    public final Domain domain;
    public final Api api;
    public final Portal portal;

    public Version() {
        this._baseUrl = null;
        this._client = null;
        this.asset = null;
        this.status = null;
        this.tags = null;
        this.rating = null;
        this.policies = null;
        this.reviews = null;
        this.domain = null;
        this.api = null;
        this.portal = null;
    }

    public Version(String baseUrl, Client _client, String uriParam) {
        this._baseUrl = baseUrl + "/" + URLEncoder.encode(uriParam);
        this._client = _client;
        this.asset = new Asset(this.getBaseUri(), this.getClient());
        this.status = new Status(this.getBaseUri(), this.getClient());
        this.tags = new Tags(this.getBaseUri(), this.getClient());
        this.rating = new Rating(this.getBaseUri(), this.getClient());
        this.policies = new Policies(this.getBaseUri(), this.getClient());
        this.reviews = new Reviews(this.getBaseUri(), this.getClient());
        this.domain = new Domain(this.getBaseUri(), this.getClient());
        this.api = new Api(this.getBaseUri(), this.getClient());
        this.portal = new Portal(this.getBaseUri(), this.getClient());
    }

    protected Client getClient() {
        return this._client;
    }

    private String getBaseUri() {
        return this._baseUrl;
    }

    public ExchangexapiResponse<Void> delete(VersionDELETEHeader headers, String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (headers.getXDeleteType() != null) {
            invocationBuilder.header("X-Delete-Type", (Object)headers.getXDeleteType());
        }
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("DELETE");
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ExchangexapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ExchangexapiResponse<Object> apiResponse = new ExchangexapiResponse<Object>(null, (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }
}

