/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.collections;

import com.aoapps.collections.AoArrays;
import com.aoapps.collections.EnumerationIterator;
import com.aoapps.collections.IntArrayList;
import com.aoapps.collections.LongArrayList;
import com.aoapps.collections.MinimalList;
import com.aoapps.collections.SortedArrayList;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class AoCollections {
    public static final SortedSet<?> EMPTY_SORTED_SET = new EmptySortedSet();
    private static final Class<?>[] unmodifiableCollectionClasses = new Class[]{Collections.unmodifiableCollection(Collections.emptyList()).getClass(), Collections.singletonList(null).getClass(), Collections.unmodifiableList(new ArrayList(0)).getClass(), Collections.unmodifiableList(new LinkedList()).getClass(), Collections.singleton(null).getClass(), Collections.unmodifiableSet(Collections.emptySet()).getClass(), AoArrays.UnmodifiableArraySet.class, SingletonSortedSet.class, Collections.unmodifiableSortedSet(AoCollections.emptySortedSet()).getClass()};
    private static final Class<?>[] unmodifiableListClasses = new Class[]{Collections.singletonList(null).getClass(), Collections.unmodifiableList(new ArrayList(0)).getClass(), Collections.unmodifiableList(new LinkedList()).getClass()};
    private static final Class<?>[] unmodifiableSetClasses = new Class[]{Collections.singleton(null).getClass(), Collections.unmodifiableSet(Collections.emptySet()).getClass(), Collections.unmodifiableMap(Collections.emptyMap()).entrySet().getClass(), AoArrays.UnmodifiableArraySet.class, SingletonSortedSet.class, Collections.unmodifiableSortedSet(AoCollections.emptySortedSet()).getClass()};
    private static final Class<?>[] unmodifiableSortedSetClasses = new Class[]{SingletonSortedSet.class, Collections.unmodifiableSortedSet(AoCollections.emptySortedSet()).getClass()};
    private static final Class<?>[] unmodifiableMapClasses = new Class[]{Collections.emptyMap().getClass(), Collections.singletonMap(null, null).getClass(), Collections.unmodifiableMap(Collections.emptyMap()).getClass(), Collections.unmodifiableSortedMap(new TreeMap()).getClass()};
    private static final Class<?>[] unmodifiableSortedMapClasses = new Class[]{Collections.unmodifiableSortedMap(new TreeMap()).getClass()};

    private AoCollections() {
    }

    public static final <T> SortedSet<T> emptySortedSet() {
        return EMPTY_SORTED_SET;
    }

    public static <T> SortedSet<T> singletonSortedSet(T o) {
        return new SingletonSortedSet<T>(o);
    }

    public static <T> Collection<T> optimalUnmodifiableCollection(Collection<? extends T> collection) {
        if (collection == null) {
            return null;
        }
        int size = collection.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        Class<?> clazz = collection.getClass();
        int len = unmodifiableCollectionClasses.length;
        for (int i = 0; i < len; ++i) {
            if (unmodifiableCollectionClasses[i] != clazz) continue;
            Collection<T> unmodifiable = collection;
            return unmodifiable;
        }
        if (size == 1) {
            return Collections.singletonList(collection.iterator().next());
        }
        return Collections.unmodifiableCollection(collection);
    }

    public static <E> Collection<E> asCollection(Iterable<E> iterable) {
        if (iterable == null) {
            return null;
        }
        if (iterable instanceof Collection) {
            return (Collection)iterable;
        }
        ArrayList<E> list = new ArrayList<E>();
        for (E elem : iterable) {
            list.add(elem);
        }
        return list;
    }

    private static <T> Collection<T> unmodifiableCopyCollection(Collection<? extends T> collection, boolean copyNeeded) {
        if (collection == null) {
            return null;
        }
        int size = collection.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            return Collections.singletonList(collection.iterator().next());
        }
        return Collections.unmodifiableCollection(copyNeeded ? new ArrayList(collection) : collection);
    }

    public static <T> Collection<T> unmodifiableCopyCollection(Collection<? extends T> collection) {
        return AoCollections.unmodifiableCopyCollection(collection, true);
    }

    public static <T> Collection<T> unmodifiableCopyCollection(Iterable<? extends T> iter) {
        if (iter == null) {
            return null;
        }
        if (iter instanceof Collection) {
            return AoCollections.unmodifiableCopyCollection((Collection)iter, true);
        }
        return AoCollections.unmodifiableCopyCollection(AoCollections.asCollection(iter), false);
    }

    public static <T> List<T> optimalUnmodifiableList(List<? extends T> list) {
        if (list == null) {
            return null;
        }
        int size = list.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        Class<?> clazz = list.getClass();
        int len = unmodifiableListClasses.length;
        for (int i = 0; i < len; ++i) {
            if (unmodifiableListClasses[i] != clazz) continue;
            List<T> unmodifiable = list;
            return unmodifiable;
        }
        if (size == 1) {
            return Collections.singletonList(list.get(0));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static <E> List<E> asList(Iterable<E> iterable) {
        if (iterable == null) {
            return null;
        }
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<E> list = new ArrayList<E>();
        for (E elem : iterable) {
            list.add(elem);
        }
        return list;
    }

    private static <T> List<T> unmodifiableCopyList(Collection<? extends T> collection, boolean copyNeeded) {
        if (collection == null) {
            return null;
        }
        int size = collection.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            return Collections.singletonList(collection.iterator().next());
        }
        if (!copyNeeded && collection instanceof List) {
            return Collections.unmodifiableList((List)collection);
        }
        return Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    public static <T> List<T> unmodifiableCopyList(Collection<? extends T> collection) {
        return AoCollections.unmodifiableCopyList(collection, true);
    }

    public static <T> List<T> unmodifiableCopyList(Iterable<? extends T> iter) {
        if (iter == null) {
            return null;
        }
        if (iter instanceof Collection) {
            return AoCollections.unmodifiableCopyList((Collection)iter, true);
        }
        return AoCollections.unmodifiableCopyList(AoCollections.asList(iter), false);
    }

    public static <T> Set<T> optimalUnmodifiableSet(Set<? extends T> set) {
        if (set == null) {
            return null;
        }
        int size = set.size();
        if (size == 0) {
            return Collections.emptySet();
        }
        Class<?> clazz = set.getClass();
        int len = unmodifiableSetClasses.length;
        for (int i = 0; i < len; ++i) {
            if (unmodifiableSetClasses[i] != clazz) continue;
            Set<T> unmodifiable = set;
            return unmodifiable;
        }
        if (size == 1) {
            return Collections.singleton(set.iterator().next());
        }
        return Collections.unmodifiableSet(set);
    }

    public static <E> Set<E> asSet(Iterable<E> iterable) {
        if (iterable == null) {
            return null;
        }
        if (iterable instanceof Set) {
            return (Set)iterable;
        }
        LinkedHashSet<E> set = new LinkedHashSet<E>();
        for (E elem : iterable) {
            set.add(elem);
        }
        return set;
    }

    private static <T> Set<T> unmodifiableCopySet(Collection<? extends T> collection, boolean copyNeeded) {
        if (collection == null) {
            return null;
        }
        int size = collection.size();
        if (size == 0) {
            return Collections.emptySet();
        }
        if (size == 1) {
            return Collections.singleton(collection.iterator().next());
        }
        if (!copyNeeded && collection instanceof Set) {
            return Collections.unmodifiableSet((Set)collection);
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(collection);
        if (set.size() == 1) {
            return Collections.singleton(set.iterator().next());
        }
        return Collections.unmodifiableSet(set);
    }

    public static <T> Set<T> unmodifiableCopySet(Collection<? extends T> collection) {
        return AoCollections.unmodifiableCopySet(collection, true);
    }

    public static <T> Set<T> unmodifiableCopySet(Iterable<? extends T> iter) {
        if (iter == null) {
            return null;
        }
        if (iter instanceof Collection) {
            return AoCollections.unmodifiableCopySet((Collection)iter, true);
        }
        return AoCollections.unmodifiableCopySet(AoCollections.asSet(iter), false);
    }

    public static <T> SortedSet<T> optimalUnmodifiableSortedSet(SortedSet<T> sortedSet) {
        if (sortedSet == null) {
            return null;
        }
        int size = sortedSet.size();
        if (size == 0) {
            return AoCollections.emptySortedSet();
        }
        Class<?> clazz = sortedSet.getClass();
        int len = unmodifiableSortedSetClasses.length;
        for (int i = 0; i < len; ++i) {
            if (unmodifiableSortedSetClasses[i] != clazz) continue;
            return sortedSet;
        }
        if (size == 1) {
            return AoCollections.singletonSortedSet(sortedSet.first());
        }
        return Collections.unmodifiableSortedSet(sortedSet);
    }

    public static <E> SortedSet<E> asSortedSet(Iterable<E> iterable) {
        if (iterable == null) {
            return null;
        }
        if (iterable instanceof SortedSet) {
            return (SortedSet)iterable;
        }
        TreeSet<E> sortedSet = new TreeSet<E>();
        for (E elem : iterable) {
            sortedSet.add(elem);
        }
        return sortedSet;
    }

    private static <T> SortedSet<T> unmodifiableCopySortedSet(Collection<? extends T> collection, boolean copyNeeded) {
        if (collection == null) {
            return null;
        }
        int size = collection.size();
        if (size == 0) {
            return AoCollections.emptySortedSet();
        }
        if (size == 1) {
            return AoCollections.singletonSortedSet(collection.iterator().next());
        }
        if (!copyNeeded && collection instanceof SortedSet) {
            return Collections.unmodifiableSortedSet((SortedSet)collection);
        }
        TreeSet<Object> copy = collection instanceof SortedSet ? new TreeSet((SortedSet)collection) : new TreeSet<T>(collection);
        if (copy.size() == 1) {
            return AoCollections.singletonSortedSet(copy.iterator().next());
        }
        return Collections.unmodifiableSortedSet(copy);
    }

    public static <T> SortedSet<T> unmodifiableCopySortedSet(Collection<? extends T> collection) {
        return AoCollections.unmodifiableCopySortedSet(collection, true);
    }

    public static <T> SortedSet<T> unmodifiableCopySortedSet(Iterable<? extends T> iter) {
        if (iter == null) {
            return null;
        }
        if (iter instanceof Collection) {
            return AoCollections.unmodifiableCopySortedSet((Collection)iter, true);
        }
        return AoCollections.unmodifiableCopySortedSet(AoCollections.asSortedSet(iter), false);
    }

    public static <K, V> Map<K, V> optimalUnmodifiableMap(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return null;
        }
        int size = map.size();
        if (size == 0) {
            return Collections.emptyMap();
        }
        Class<?> clazz = map.getClass();
        int len = unmodifiableMapClasses.length;
        for (int i = 0; i < len; ++i) {
            if (unmodifiableMapClasses[i] != clazz) continue;
            Map<K, V> unmodifiable = map;
            return unmodifiable;
        }
        if (size == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> unmodifiableCopyMap(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return null;
        }
        int size = map.size();
        if (size == 0) {
            return Collections.emptyMap();
        }
        if (size == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }

    public static <K, V> SortedMap<K, V> optimalUnmodifiableSortedMap(SortedMap<K, ? extends V> sortedMap) {
        if (sortedMap == null) {
            return null;
        }
        Class<?> clazz = sortedMap.getClass();
        int len = unmodifiableSortedMapClasses.length;
        for (int i = 0; i < len; ++i) {
            if (unmodifiableSortedMapClasses[i] != clazz) continue;
            SortedMap<K, V> unmodifiable = sortedMap;
            return unmodifiable;
        }
        return Collections.unmodifiableSortedMap(sortedMap);
    }

    public static <K, V> SortedMap<K, V> unmodifiableCopySortedMap(Map<K, ? extends V> map) {
        if (map == null) {
            return null;
        }
        TreeMap<K, Object> copy = map instanceof SortedMap ? new TreeMap((SortedMap)map) : new TreeMap<K, V>(map);
        return Collections.unmodifiableSortedMap(copy);
    }

    @Deprecated
    public static <E> Iterator<E> emptyIterator() {
        return Collections.emptyIterator();
    }

    @Deprecated
    public static <E> Iterator<E> singletonIterator(E value) {
        return new SingletonIterator<E>(value);
    }

    public static <E> Iterator<E> unmodifiableIterator(Iterator<? extends E> iter) {
        if (iter == null) {
            return null;
        }
        if (iter instanceof UnmodifiableIterator || iter instanceof EnumerationIterator || iter instanceof SingletonIterator || iter == Collections.emptyIterator() || iter == Collections.emptyListIterator()) {
            Iterator<? extends E> unmodifiable = iter;
            return unmodifiable;
        }
        return new UnmodifiableIterator<E>(iter);
    }

    public static <E> PeekIterator<E> peekIterator(Iterator<? extends E> iter) {
        return new PeekIterator<E>(iter);
    }

    public static boolean equals(Collection<?> collection1, Collection<?> collection2) {
        if (collection1 == null) {
            return collection2 == null;
        }
        if (collection2 == null) {
            return false;
        }
        int size = collection1.size();
        if (size != collection2.size()) {
            return false;
        }
        Iterator<?> iter1 = collection1.iterator();
        Iterator<?> iter2 = collection2.iterator();
        int count = 0;
        while (iter1.hasNext() && iter2.hasNext()) {
            if (!Objects.equals(iter1.next(), iter2.next())) {
                return false;
            }
            ++count;
        }
        if (size != count || iter1.hasNext() || iter2.hasNext()) {
            throw new ConcurrentModificationException();
        }
        return true;
    }

    public static int hashCode(Iterable<?> iterable) {
        if (iterable == null) {
            return 0;
        }
        int hashCode = 1;
        for (Object e : iterable) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    public static <E, R extends E> List<R> filter(List<? extends E> list, Class<? extends R> clazz) {
        if (list == null) {
            return null;
        }
        List results = MinimalList.emptyList();
        for (E element : list) {
            if (!clazz.isInstance(element)) continue;
            results = MinimalList.add(results, clazz.cast(element));
        }
        return MinimalList.unmodifiable(results);
    }

    public static <K, V> Set<K> filterByValue(Map<? extends K, ? extends V> map, V value) {
        if (map == null) {
            return null;
        }
        LinkedHashSet<K> filtered = new LinkedHashSet<K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key;
            if (Objects.equals(entry.getValue(), value) && !filtered.add(key = entry.getKey())) {
                throw new AssertionError((Object)("Duplicate key: " + key));
            }
        }
        return filtered;
    }

    public static <K, V> SortedSet<K> filterByValue(SortedMap<K, ? extends V> map, V value) {
        if (map == null) {
            return null;
        }
        TreeSet<K> filtered = new TreeSet<K>(map.comparator());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key;
            if (Objects.equals(entry.getValue(), value) && !filtered.add(key = entry.getKey())) {
                throw new AssertionError((Object)("Duplicate key: " + key));
            }
        }
        return filtered;
    }

    public static int getHashInitialCapacity(int elements) {
        return (int)((float)elements / 0.75f) + 1;
    }

    public static <E> ArrayList<E> newArrayList(int elements) {
        return elements == -1 ? new ArrayList() : new ArrayList(elements);
    }

    public static <E> ArrayList<E> newArrayList(Integer elements) {
        return AoCollections.newArrayList(elements == null ? -1 : elements);
    }

    public static <K, V> HashMap<K, V> newHashMap(int elements) {
        return elements == -1 ? new HashMap() : new HashMap(AoCollections.getHashInitialCapacity(elements));
    }

    public static <K, V> HashMap<K, V> newHashMap(Integer elements) {
        return AoCollections.newHashMap(elements == null ? -1 : elements);
    }

    public static <E> HashSet<E> newHashSet(int elements) {
        return elements == -1 ? new HashSet() : new HashSet(AoCollections.getHashInitialCapacity(elements));
    }

    public static <E> HashSet<E> newHashSet(Integer elements) {
        return AoCollections.newHashSet(elements == null ? -1 : elements);
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap(int elements) {
        return elements == -1 ? new IdentityHashMap() : new IdentityHashMap(elements);
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap(Integer elements) {
        return AoCollections.newIdentityHashMap(elements == null ? -1 : elements);
    }

    public static IntArrayList newIntArrayList(int elements) {
        return elements == -1 ? new IntArrayList() : new IntArrayList(elements);
    }

    public static IntArrayList newIntArrayList(Integer elements) {
        return AoCollections.newIntArrayList(elements == null ? -1 : elements);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int elements) {
        return elements == -1 ? new LinkedHashMap() : new LinkedHashMap(AoCollections.getHashInitialCapacity(elements));
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Integer elements) {
        return AoCollections.newLinkedHashMap(elements == null ? -1 : elements);
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(int elements) {
        return elements == -1 ? new LinkedHashSet() : new LinkedHashSet(AoCollections.getHashInitialCapacity(elements));
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(Integer elements) {
        return AoCollections.newLinkedHashSet(elements == null ? -1 : elements);
    }

    public static LongArrayList newLongArrayList(int elements) {
        return elements == -1 ? new LongArrayList() : new LongArrayList(elements);
    }

    public static LongArrayList newLongArrayList(Integer elements) {
        return AoCollections.newLongArrayList(elements == null ? -1 : elements);
    }

    public static <E> SortedArrayList<E> newSortedArrayList(int elements) {
        return elements == -1 ? new SortedArrayList() : new SortedArrayList(elements);
    }

    public static <E> SortedArrayList<E> newSortedArrayList(Integer elements) {
        return AoCollections.newSortedArrayList(elements == null ? -1 : elements);
    }

    public static class PeekIterator<E>
    implements Iterator<E> {
        private final Iterator<? extends E> iter;
        private E next;

        PeekIterator(Iterator<? extends E> iter) {
            this.iter = iter;
            this.next = iter.hasNext() ? iter.next() : null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            E value = this.next;
            if (value == null) {
                throw new NoSuchElementException();
            }
            this.next = this.iter.hasNext() ? this.iter.next() : null;
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public E peek() {
            E value = this.next;
            if (value == null) {
                throw new NoSuchElementException();
            }
            return value;
        }
    }

    static class UnmodifiableIterator<E>
    implements Iterator<E> {
        private final Iterator<? extends E> iter;

        UnmodifiableIterator(Iterator<? extends E> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public E next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @Deprecated
    static class SingletonIterator<E>
    implements Iterator<E> {
        private final E value;
        private boolean hasNext = true;

        SingletonIterator(E value) {
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public E next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.hasNext = false;
            return this.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SingletonSortedSet<E>
    extends AbstractSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = -6732971044735913580L;
        private final E element;

        SingletonSortedSet(E e) {
            this.element = e;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private boolean hasNext = true;

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public E next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return element;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object o) {
            return Objects.equals(o, this.element);
        }

        @Override
        public Comparator<? super E> comparator() {
            return null;
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            if (Objects.equals(this.element, fromElement) && Objects.equals(this.element, toElement)) {
                return AoCollections.emptySortedSet();
            }
            throw new IllegalArgumentException();
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            if (Objects.equals(this.element, toElement)) {
                return AoCollections.emptySortedSet();
            }
            throw new IllegalArgumentException();
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            if (Objects.equals(this.element, fromElement)) {
                return this;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public E first() {
            return this.element;
        }

        @Override
        public E last() {
            return this.element;
        }
    }

    private static class EmptySortedSet
    extends AbstractSet<Object>
    implements SortedSet<Object>,
    Serializable {
        private static final long serialVersionUID = 5914343416838268017L;

        private EmptySortedSet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Object next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        private Object readResolve() {
            return EMPTY_SORTED_SET;
        }

        @Override
        public Comparator<? super Object> comparator() {
            return null;
        }

        @Override
        public SortedSet<Object> subSet(Object fromElement, Object toElement) {
            throw new IllegalArgumentException();
        }

        @Override
        public SortedSet<Object> headSet(Object toElement) {
            throw new IllegalArgumentException();
        }

        @Override
        public SortedSet<Object> tailSet(Object fromElement) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object first() {
            throw new NoSuchElementException();
        }

        @Override
        public Object last() {
            throw new NoSuchElementException();
        }
    }
}

