/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.collections;

import com.aoapps.collections.HashCodeComparator;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class ArraySet<E>
extends AbstractSet<E>
implements Serializable {
    private static final long serialVersionUID = 7396605502356021412L;
    private static final boolean ASSERTIONS_ENABLED = true;
    private static final int BINARY_SEARCH_THRESHOLD = 13;
    private final ArrayList<E> elements;

    @Deprecated
    public ArraySet() {
        this.elements = new ArrayList();
    }

    @Deprecated
    public ArraySet(int initialCapacity) {
        this.elements = new ArrayList(initialCapacity);
    }

    @Deprecated
    public ArraySet(Collection<? extends E> c) {
        this.elements = new ArrayList(c.size());
        this.addAll(c);
    }

    private boolean assertInOrderAndUnique(ArrayList<E> elements) {
        int size = elements.size();
        if (size > 1) {
            E prev = elements.get(0);
            int prevHash = prev.hashCode();
            for (int index = 1; index < size; ++index) {
                E elem = elements.get(index);
                int elemHash = elem.hashCode();
                if (elemHash < prevHash) {
                    throw new AssertionError((Object)("elements not sorted by hashCode: " + elemHash + "<" + prevHash + ": " + elem + "<" + prev));
                }
                if (elemHash == prevHash) {
                    E morePrev;
                    if (elem.equals(prev)) {
                        throw new AssertionError((Object)("Element not unique: " + elem));
                    }
                    for (int i = index - 2; i >= 0 && (morePrev = elements.get(i)).hashCode() == elemHash; --i) {
                        if (elem.equals(morePrev)) {
                            throw new AssertionError((Object)("Element not unique: " + elem));
                        }
                    }
                }
                prev = elem;
                prevHash = elemHash;
            }
        }
        return true;
    }

    public ArraySet(ArrayList<E> elements) {
        assert (this.assertInOrderAndUnique(elements));
        this.elements = elements;
    }

    private int binarySearch(E elem) {
        return Collections.binarySearch(this.elements, elem, HashCodeComparator.getInstance());
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        int size = this.elements.size();
        if (size == 0 || o == null) {
            return false;
        }
        if (size < 13) {
            for (int i = 0; i < size; ++i) {
                if (!this.elements.get(i).equals(o)) continue;
                return true;
            }
        } else {
            int i;
            int index = this.binarySearch(o);
            if (index < 0) {
                return false;
            }
            E elem = this.elements.get(index);
            if (elem.equals(o)) {
                return true;
            }
            int oHash = o.hashCode();
            for (i = index + 1; i < size && (elem = this.elements.get(i)).hashCode() == oHash; ++i) {
                if (!elem.equals(o)) continue;
                return true;
            }
            for (i = index - 1; i >= 0 && (elem = this.elements.get(i)).hashCode() == oHash; --i) {
                if (!elem.equals(o)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.elements.toArray(a);
    }

    @Override
    public boolean add(E e) {
        E last;
        int lastHash;
        int size = this.elements.size();
        if (size == 0) {
            this.elements.add(e);
            return true;
        }
        int eHash = e.hashCode();
        if (eHash > (lastHash = (last = this.elements.get(size - 1)).hashCode())) {
            this.elements.add(e);
            return true;
        }
        if (eHash == lastHash) {
            E elem;
            if (last.equals(e)) {
                return false;
            }
            for (int i = size - 2; i >= 0 && (elem = this.elements.get(i)).hashCode() == eHash; --i) {
                if (!elem.equals(e)) continue;
                return false;
            }
            this.elements.add(e);
            return true;
        }
        if (this.contains(e)) {
            return false;
        }
        throw new UnsupportedOperationException("May only add the last element.");
    }

    @Override
    public boolean remove(Object o) {
        int size = this.elements.size();
        if (size == 0) {
            return false;
        }
        E lastElem = this.elements.get(size - 1);
        if (lastElem.equals(o)) {
            this.elements.remove(size - 1);
            return true;
        }
        if (this.contains(o)) {
            throw new UnsupportedOperationException("May only remove the last element.");
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E elem : c) {
            if (!this.add(elem)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.elements.clear();
    }
}

