/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.collections;

public class IdentityKey<T> {
    public static final IdentityKey<?> NULL = new IdentityKey<Object>(null);
    private final T value;

    public static <T> IdentityKey<T> ofNull() {
        return NULL;
    }

    public static <T> IdentityKey<T> of(T value) {
        if (value == null) {
            return IdentityKey.ofNull();
        }
        return new IdentityKey<T>(value);
    }

    @Deprecated
    public IdentityKey(T value) {
        this.value = value;
    }

    public String toString() {
        return this.value == null ? "null" : this.value.toString();
    }

    public int hashCode() {
        return System.identityHashCode(this.value);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public T getValue() {
        return this.value;
    }
}

