/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.collections;

import com.aoapps.collections.MinimalList;
import com.aoapps.lang.reflect.Classes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;

public class PolymorphicMultimap<K, V> {
    private final Class<K> upperBound;
    private final ConcurrentMap<Class<? extends K>, Lists<K, V>> listsByClass = new ConcurrentHashMap<Class<? extends K>, Lists<K, V>>();

    public PolymorphicMultimap(Class<K> upperBound) {
        this.upperBound = upperBound;
    }

    public void put(final K key, final V value) {
        Class<K> keyClass = key.getClass().asSubclass(this.upperBound);
        for (Class clazz : Classes.getAllClasses(keyClass, this.upperBound)) {
            Lists newLists;
            Lists oldLists;
            boolean replaced;
            Class<K> uClass = clazz.asSubclass(this.upperBound);
            Map.Entry newEntry = new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(V value2) {
                    throw new UnsupportedOperationException();
                }
            };
            do {
                List<1> newEntries;
                List<Object> newValues;
                List<Object> newKeys;
                if ((oldLists = (Lists)this.listsByClass.get(uClass)) == null) {
                    newKeys = Collections.singletonList(key);
                    newValues = Collections.singletonList(value);
                    newEntries = Collections.singletonList(newEntry);
                } else {
                    int newSize = oldLists.keys.size() + 1;
                    ArrayList<K> newKeysTemp = new ArrayList<K>(newSize);
                    newKeysTemp.addAll(oldLists.keys);
                    newKeysTemp.add(key);
                    newKeys = Collections.unmodifiableList(newKeysTemp);
                    ArrayList<V> newValuesTemp = new ArrayList<V>(newSize);
                    newValuesTemp.addAll(oldLists.values);
                    newValuesTemp.add(value);
                    newValues = Collections.unmodifiableList(newValuesTemp);
                    ArrayList<1> newEntriesTemp = new ArrayList<1>(newSize);
                    newEntriesTemp.addAll(oldLists.entries);
                    newEntriesTemp.add(newEntry);
                    newEntries = Collections.unmodifiableList(newEntriesTemp);
                }
                newLists = new Lists(newKeys, newValues, newEntries);
            } while (!(replaced = oldLists == null ? this.listsByClass.putIfAbsent(uClass, newLists) == null : this.listsByClass.replace(uClass, oldLists, newLists)));
        }
    }

    protected <T extends K> Lists<T, V> getLists(Class<T> clazz) {
        return (Lists)this.listsByClass.get(clazz);
    }

    public <T extends K> List<T> getKeys(Class<T> clazz) {
        Lists<T, V> lists = this.getLists(clazz);
        if (lists == null) {
            return Collections.emptyList();
        }
        return ((Lists)lists).keys;
    }

    public <T extends K> List<T> getKeys(Class<T> clazz, Predicate<? super T> filter) {
        List<T> keys = this.getKeys(clazz);
        List matches = MinimalList.emptyList();
        for (T key : keys) {
            if (!filter.test(key)) continue;
            matches = MinimalList.add(matches, key);
        }
        return matches.size() == keys.size() ? keys : MinimalList.unmodifiable(matches);
    }

    public <T extends K> List<T> getKeysFilterValue(Class<T> clazz, Predicate<? super V> filter) {
        Lists<T, V> lists = this.getLists(clazz);
        if (lists == null) {
            return Collections.emptyList();
        }
        List<Map.Entry<T, V>> entries = this.getEntries(clazz);
        List matches = MinimalList.emptyList();
        for (Map.Entry<T, V> entry : entries) {
            if (!filter.test(entry.getValue())) continue;
            matches = MinimalList.add(matches, entry.getKey());
        }
        return matches.size() == entries.size() ? ((Lists)lists).keys : MinimalList.unmodifiable(matches);
    }

    public <T extends K> List<T> getKeysFilterEntry(Class<T> clazz, Predicate<? super Map.Entry<T, V>> filter) {
        Lists<T, V> lists = this.getLists(clazz);
        if (lists == null) {
            return Collections.emptyList();
        }
        List<Map.Entry<T, V>> entries = this.getEntries(clazz);
        List matches = MinimalList.emptyList();
        for (Map.Entry<T, V> entry : entries) {
            if (!filter.test(entry)) continue;
            matches = MinimalList.add(matches, entry.getKey());
        }
        return matches.size() == entries.size() ? ((Lists)lists).keys : MinimalList.unmodifiable(matches);
    }

    public List<V> getValues(Class<? extends K> clazz) {
        Lists<? extends K, V> lists = this.getLists(clazz);
        if (lists == null) {
            return Collections.emptyList();
        }
        return ((Lists)lists).values;
    }

    public List<V> getValues(Class<? extends K> clazz, Predicate<? super V> filter) {
        List<V> values = this.getValues(clazz);
        List matches = MinimalList.emptyList();
        for (V value : values) {
            if (!filter.test(value)) continue;
            matches = MinimalList.add(matches, value);
        }
        return matches.size() == values.size() ? values : MinimalList.unmodifiable(matches);
    }

    public <T extends K> List<V> getValuesFilterKey(Class<T> clazz, Predicate<? super T> filter) {
        Lists<T, V> lists = this.getLists(clazz);
        if (lists == null) {
            return Collections.emptyList();
        }
        List<Map.Entry<T, V>> entries = this.getEntries(clazz);
        List matches = MinimalList.emptyList();
        for (Map.Entry<T, V> entry : entries) {
            if (!filter.test(entry.getKey())) continue;
            matches = MinimalList.add(matches, entry.getValue());
        }
        return matches.size() == entries.size() ? ((Lists)lists).values : MinimalList.unmodifiable(matches);
    }

    public <T extends K> List<V> getValuesFilterEntry(Class<T> clazz, Predicate<? super Map.Entry<T, V>> filter) {
        Lists<T, V> lists = this.getLists(clazz);
        if (lists == null) {
            return Collections.emptyList();
        }
        List<Map.Entry<T, V>> entries = this.getEntries(clazz);
        List matches = MinimalList.emptyList();
        for (Map.Entry<T, V> entry : entries) {
            if (!filter.test(entry)) continue;
            matches = MinimalList.add(matches, entry.getValue());
        }
        return matches.size() == entries.size() ? ((Lists)lists).values : MinimalList.unmodifiable(matches);
    }

    public <T extends K> List<Map.Entry<T, V>> getEntries(Class<T> clazz) {
        Lists<T, V> lists = this.getLists(clazz);
        if (lists == null) {
            return Collections.emptyList();
        }
        return ((Lists)lists).entries;
    }

    public <T extends K> List<Map.Entry<T, V>> getEntries(Class<T> clazz, Predicate<? super Map.Entry<T, V>> filter) {
        List<Map.Entry<T, V>> entries = this.getEntries(clazz);
        List<Object> matches = MinimalList.emptyList();
        for (Map.Entry<T, V> entry : entries) {
            if (!filter.test(entry)) continue;
            matches = MinimalList.add(matches, entry);
        }
        return matches.size() == entries.size() ? entries : MinimalList.unmodifiable(matches);
    }

    public <T extends K> List<Map.Entry<T, V>> getEntriesFilterKey(Class<T> clazz, Predicate<? super T> filter) {
        List<Map.Entry<T, V>> entries = this.getEntries(clazz);
        List<Object> matches = MinimalList.emptyList();
        for (Map.Entry<T, V> entry : entries) {
            if (!filter.test(entry.getKey())) continue;
            matches = MinimalList.add(matches, entry);
        }
        return matches.size() == entries.size() ? entries : MinimalList.unmodifiable(matches);
    }

    public <T extends K> List<Map.Entry<T, V>> getEntriesFilterValue(Class<T> clazz, Predicate<? super V> filter) {
        List<Map.Entry<T, V>> entries = this.getEntries(clazz);
        List<Object> matches = MinimalList.emptyList();
        for (Map.Entry<T, V> entry : entries) {
            if (!filter.test(entry.getValue())) continue;
            matches = MinimalList.add(matches, entry);
        }
        return matches.size() == entries.size() ? entries : MinimalList.unmodifiable(matches);
    }

    public <T extends K> T getFirstKey(Class<T> clazz) {
        List<T> keys = this.getKeys(clazz);
        return keys.isEmpty() ? null : (T)keys.get(0);
    }

    public <T extends K> T getFirstKey(Class<T> clazz, Predicate<? super T> filter) {
        for (T key : this.getKeys(clazz)) {
            if (!filter.test(key)) continue;
            return key;
        }
        return null;
    }

    public <T extends K> T getFirstKeyFilterValue(Class<T> clazz, Predicate<? super V> filter) {
        for (Map.Entry<T, V> entry : this.getEntries(clazz)) {
            if (!filter.test(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public <T extends K> T getFirstKeyFilterEntry(Class<T> clazz, Predicate<? super Map.Entry<T, V>> filter) {
        Map.Entry<T, V> entry = this.getFirstEntry(clazz, filter);
        return entry == null ? null : (T)entry.getKey();
    }

    public V getFirstValue(Class<? extends K> clazz) {
        List<V> values = this.getValues(clazz);
        return values.isEmpty() ? null : (V)values.get(0);
    }

    public V getFirstValue(Class<? extends K> clazz, Predicate<? super V> filter) {
        for (V value : this.getValues(clazz)) {
            if (!filter.test(value)) continue;
            return value;
        }
        return null;
    }

    public <T extends K> V getFirstValueFilterKey(Class<T> clazz, Predicate<? super T> filter) {
        for (Map.Entry<T, V> entry : this.getEntries(clazz)) {
            if (!filter.test(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public <T extends K> V getFirstValueFilterEntry(Class<T> clazz, Predicate<? super Map.Entry<T, V>> filter) {
        Map.Entry<T, V> entry = this.getFirstEntry(clazz, filter);
        return entry == null ? null : (V)entry.getValue();
    }

    public <T extends K> Map.Entry<T, V> getFirstEntry(Class<T> clazz) {
        List<Map.Entry<T, V>> entries = this.getEntries(clazz);
        return entries.isEmpty() ? null : entries.get(0);
    }

    public <T extends K> Map.Entry<T, V> getFirstEntry(Class<T> clazz, Predicate<? super Map.Entry<T, V>> filter) {
        for (Map.Entry<T, V> entry : this.getEntries(clazz)) {
            if (!filter.test(entry)) continue;
            return entry;
        }
        return null;
    }

    public <T extends K> Map.Entry<T, V> getFirstEntryFilterKey(Class<T> clazz, Predicate<? super T> filter) {
        for (Map.Entry<T, V> entry : this.getEntries(clazz)) {
            if (!filter.test(entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    public <T extends K> Map.Entry<T, V> getFirstEntryFilterValue(Class<T> clazz, Predicate<? super V> filter) {
        for (Map.Entry<T, V> entry : this.getEntries(clazz)) {
            if (!filter.test(entry.getValue())) continue;
            return entry;
        }
        return null;
    }

    public <T extends K> T getLastKey(Class<T> clazz) {
        List<T> keys = this.getKeys(clazz);
        int size = keys.size();
        return size == 0 ? null : (T)keys.get(size - 1);
    }

    public <T extends K> T getLastKey(Class<T> clazz, Predicate<? super T> filter) {
        List<T> keys = this.getKeys(clazz);
        for (int i = keys.size() - 1; i >= 0; --i) {
            T key = keys.get(i);
            if (!filter.test(key)) continue;
            return key;
        }
        return null;
    }

    public <T extends K> T getLastKeyFilterValue(Class<T> clazz, Predicate<? super V> filter) {
        List<Map.Entry<T, V>> entries = this.getEntries(clazz);
        for (int i = entries.size() - 1; i >= 0; --i) {
            Map.Entry<T, V> entry = entries.get(i);
            if (!filter.test(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public <T extends K> T getLastKeyFilterEntry(Class<T> clazz, Predicate<? super Map.Entry<T, V>> filter) {
        Map.Entry<T, V> entry = this.getLastEntry(clazz, filter);
        return entry == null ? null : (T)entry.getKey();
    }

    public V getLastValue(Class<? extends K> clazz) {
        List<V> values = this.getValues(clazz);
        int size = values.size();
        return size == 0 ? null : (V)values.get(size - 1);
    }

    public V getLastValue(Class<? extends K> clazz, Predicate<? super V> filter) {
        List<V> values = this.getValues(clazz);
        for (int i = values.size() - 1; i >= 0; --i) {
            V value = values.get(i);
            if (!filter.test(value)) continue;
            return value;
        }
        return null;
    }

    public <T extends K> V getLastValueFilterKey(Class<T> clazz, Predicate<? super T> filter) {
        List<Map.Entry<T, V>> entries = this.getEntries(clazz);
        for (int i = entries.size() - 1; i >= 0; --i) {
            Map.Entry<T, V> entry = entries.get(i);
            if (!filter.test(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public <T extends K> V getLastValueFilterEntry(Class<T> clazz, Predicate<? super Map.Entry<T, V>> filter) {
        Map.Entry<T, V> entry = this.getLastEntry(clazz, filter);
        return entry == null ? null : (V)entry.getValue();
    }

    public <T extends K> Map.Entry<T, V> getLastEntry(Class<T> clazz) {
        List<Map.Entry<T, V>> entries = this.getEntries(clazz);
        int size = entries.size();
        return size == 0 ? null : entries.get(size - 1);
    }

    public <T extends K> Map.Entry<T, V> getLastEntry(Class<T> clazz, Predicate<? super Map.Entry<T, V>> filter) {
        List<Map.Entry<T, V>> entries = this.getEntries(clazz);
        for (int i = entries.size() - 1; i >= 0; --i) {
            Map.Entry<T, V> entry = entries.get(i);
            if (!filter.test(entry)) continue;
            return entry;
        }
        return null;
    }

    public <T extends K> Map.Entry<T, V> getLastEntryFilterKey(Class<T> clazz, Predicate<? super T> filter) {
        List<Map.Entry<T, V>> entries = this.getEntries(clazz);
        for (int i = entries.size() - 1; i >= 0; --i) {
            Map.Entry<T, V> entry = entries.get(i);
            if (!filter.test(entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    public <T extends K> Map.Entry<T, V> getLastEntryFilterValue(Class<T> clazz, Predicate<? super V> filter) {
        List<Map.Entry<T, V>> entries = this.getEntries(clazz);
        for (int i = entries.size() - 1; i >= 0; --i) {
            Map.Entry<T, V> entry = entries.get(i);
            if (!filter.test(entry.getValue())) continue;
            return entry;
        }
        return null;
    }

    protected static class Lists<K, V> {
        private final List<K> keys;
        private final List<V> values;
        private final List<Map.Entry<K, V>> entries;

        private Lists(List<K> keys, List<V> values, List<Map.Entry<K, V>> entries) {
            assert (keys.size() == values.size());
            assert (values.size() == entries.size());
            this.keys = keys;
            this.values = values;
            this.entries = entries;
        }
    }
}

