/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.collections;

import com.aoapps.collections.MinimalList;
import com.aoapps.lang.reflect.Classes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;

public class PolymorphicRegistry<U> {
    private final Class<U> upperBound;
    private final ConcurrentMap<Class<? extends U>, List<U>> instancesByClass = new ConcurrentHashMap<Class<? extends U>, List<U>>();

    public PolymorphicRegistry(Class<U> upperBound) {
        this.upperBound = upperBound;
    }

    public void add(U instance) {
        Class<U> instanceClass = instance.getClass().asSubclass(this.upperBound);
        for (Class clazz : Classes.getAllClasses(instanceClass, this.upperBound)) {
            List<Object> newList;
            List oldList;
            boolean replaced;
            Class<U> uClass = clazz.asSubclass(this.upperBound);
            do {
                if ((oldList = (List)this.instancesByClass.get(uClass)) == null) {
                    newList = Collections.singletonList(instance);
                    continue;
                }
                int newSize = oldList.size() + 1;
                ArrayList<U> newListTemp = new ArrayList<U>(newSize);
                newListTemp.addAll(oldList);
                newListTemp.add(instance);
                newList = Collections.unmodifiableList(newListTemp);
            } while (!(replaced = oldList == null ? this.instancesByClass.putIfAbsent(uClass, newList) == null : this.instancesByClass.replace(uClass, oldList, newList)));
        }
    }

    public <T extends U> List<T> get(Class<T> clazz) {
        List instances = (List)this.instancesByClass.get(clazz);
        if (instances == null) {
            return Collections.emptyList();
        }
        return instances;
    }

    public <T extends U> List<T> get(Class<T> clazz, Predicate<? super T> filter) {
        List<T> instances = this.get(clazz);
        List matches = MinimalList.emptyList();
        for (T instance : instances) {
            if (!filter.test(instance)) continue;
            matches = MinimalList.add(matches, instance);
        }
        return matches.size() == instances.size() ? instances : MinimalList.unmodifiable(matches);
    }

    public <T extends U> T getFirst(Class<T> clazz) {
        List<T> instances = this.get(clazz);
        return instances.isEmpty() ? null : (T)instances.get(0);
    }

    public <T extends U> T getFirst(Class<T> clazz, Predicate<? super T> filter) {
        for (T instance : this.get(clazz)) {
            if (!filter.test(instance)) continue;
            return instance;
        }
        return null;
    }

    public <T extends U> T getLast(Class<T> clazz) {
        List<T> instances = this.get(clazz);
        int size = instances.size();
        return size == 0 ? null : (T)instances.get(size - 1);
    }

    public <T extends U> T getLast(Class<T> clazz, Predicate<? super T> filter) {
        List<T> instances = this.get(clazz);
        for (int i = instances.size() - 1; i >= 0; --i) {
            T instance = instances.get(i);
            if (!filter.test(instance)) continue;
            return instance;
        }
        return null;
    }
}

