/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class SortedArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1L;

    public SortedArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public SortedArrayList() {
    }

    protected int binarySearchHashCode(int elemHash) {
        int left = 0;
        int right = this.size() - 1;
        while (left <= right) {
            int mid = left + right >> 1;
            int midHash = this.get(mid).hashCode();
            if (elemHash == midHash) {
                return mid;
            }
            if (elemHash < midHash) {
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        return -(left + 1);
    }

    @Override
    public int indexOf(Object elem) {
        Object T;
        Object T2;
        int pos;
        int elemHash = elem.hashCode();
        int elemHashPos = this.binarySearchHashCode(elemHash);
        if (elemHashPos < 0) {
            return -1;
        }
        for (pos = elemHashPos; pos >= 0 && (T2 = this.get(pos)).hashCode() == elemHash; --pos) {
            if (!T2.equals(elem)) continue;
            while (pos > 0 && this.get(pos - 1).equals(elem)) {
                --pos;
            }
            return pos;
        }
        int size = this.size();
        for (pos = elemHashPos + 1; pos < size && (T = this.get(pos)).hashCode() == elemHash; ++pos) {
            if (!T.equals(elem)) continue;
            return pos;
        }
        return -1;
    }

    public int indexOf(int hashCode) {
        int pos = this.binarySearchHashCode(hashCode);
        if (pos < 0) {
            return -1;
        }
        while (pos > 0 && this.get(pos - 1).hashCode() == hashCode) {
            --pos;
        }
        return pos;
    }

    @Override
    public int lastIndexOf(Object elem) {
        Object T;
        int pos;
        int elemHash = elem.hashCode();
        int elemHashPos = this.binarySearchHashCode(elemHash);
        if (elemHashPos < 0) {
            return -1;
        }
        int size = this.size();
        for (pos = elemHashPos; pos < size && (T = this.get(pos)).hashCode() == elemHash; ++pos) {
            if (!T.equals(elem)) continue;
            while (pos < size - 1 && this.get(pos + 1).equals(elem)) {
                ++pos;
            }
            return pos;
        }
        for (pos = elemHashPos - 1; pos >= 0 && (T = this.get(pos)).hashCode() == elemHash; --pos) {
            if (!T.equals(elem)) continue;
            return pos;
        }
        return -1;
    }

    @Override
    public E set(int index, E element) {
        throw new RuntimeException("Not allowed to set specific indexes");
    }

    @Override
    public boolean add(E o) {
        int size = this.size();
        if (size == 0) {
            super.add(o);
        } else {
            int Ohash = o.hashCode();
            if (Ohash >= this.get(size - 1).hashCode()) {
                super.add(o);
            } else {
                int index = this.binarySearchHashCode(Ohash);
                if (index < 0) {
                    super.add(-(index + 1), o);
                } else {
                    while (index < size - 1 && this.get(index + 1).hashCode() == Ohash) {
                        ++index;
                    }
                    super.add(index + 1, o);
                }
            }
        }
        return true;
    }

    @Override
    public void add(int index, E element) {
        throw new RuntimeException("Not allowed to add to specific indexes");
    }

    @Override
    public boolean remove(Object o) {
        int index = this.lastIndexOf(o);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Iterator<E> iter = c.iterator();
        boolean didOne = false;
        while (iter.hasNext()) {
            this.add(iter.next());
            didOne = true;
        }
        return didOne;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new RuntimeException("Not allowed to add to a specific index");
    }
}

