/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.collections;

import com.aoapps.collections.IntArrayList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class SortedIntArrayList
extends IntArrayList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6921205612595042282L;

    public SortedIntArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public SortedIntArrayList() {
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    protected int binarySearch(int value) {
        int left = 0;
        int right = this.size - 1;
        while (left <= right) {
            int mid = left + right >> 1;
            int midValue = this.elementData[mid];
            if (value == midValue) {
                return mid;
            }
            if (value < midValue) {
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        return -(left + 1);
    }

    @Override
    public int indexOf(int elem) {
        int pos = this.binarySearch(elem);
        if (pos < 0) {
            return -1;
        }
        while (pos > 0 && this.elementData[pos - 1] == elem) {
            --pos;
        }
        return pos;
    }

    @Override
    public int lastIndexOf(int elem) {
        int pos = this.binarySearch(elem);
        if (pos < 0) {
            return -1;
        }
        while (pos < this.size - 1 && this.elementData[pos + 1] == elem) {
            ++pos;
        }
        return pos;
    }

    @Override
    public int set(int index, int element) {
        throw new RuntimeException("Not allowed to set specific indexes");
    }

    @Override
    public boolean add(int o) {
        int mySize = this.size();
        if (mySize == 0) {
            super.add(o);
        } else if (o >= this.elementData[mySize - 1]) {
            super.add(o);
        } else {
            int index = this.binarySearch(o);
            if (index < 0) {
                super.add(-(index + 1), o);
            } else {
                super.add(index + 1, o);
            }
        }
        return true;
    }

    @Override
    public void add(int index, int element) {
        throw new RuntimeException("Not allowed to add to specific indexes");
    }

    @Override
    public boolean removeByValue(int value) {
        int index = this.binarySearch(value);
        if (index < 0) {
            return false;
        }
        this.removeAtIndex(index);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        Iterator<? extends Integer> iter = c.iterator();
        boolean didOne = false;
        while (iter.hasNext()) {
            this.add((int)iter.next());
            didOne = true;
        }
        return didOne;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Integer> c) {
        throw new RuntimeException("Not allowed to add to a specific index");
    }
}

