/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.collections;

import com.aoapps.lang.EmptyArrays;
import com.aoapps.lang.io.FastObjectInput;
import com.aoapps.lang.io.FastObjectOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class UnmodifiableArraySet<E>
extends AbstractSet<E>
implements Externalizable {
    private static final boolean ASSERTIONS_ENABLED = true;
    private static final int BINARY_SEARCH_THRESHOLD = 22;
    private E[] elements;
    private static final long serialVersionUID = 5725680713634634667L;

    private static boolean inOrderAndUnique(Object[] elements) {
        int size = elements.length;
        if (size > 1) {
            Object prev = elements[0];
            int prevHash = prev.hashCode();
            for (int index = 1; index < size; ++index) {
                Object elem = elements[index];
                int elemHash = elem.hashCode();
                if (elemHash < prevHash) {
                    return false;
                }
                if (elemHash == prevHash) {
                    Object morePrev;
                    if (elem.equals(prev)) {
                        return false;
                    }
                    for (int i = index - 2; i >= 0 && (morePrev = elements[i]).hashCode() == elemHash; --i) {
                        if (!elem.equals(morePrev)) continue;
                        return false;
                    }
                }
                prev = elem;
                prevHash = elemHash;
            }
        }
        return true;
    }

    @SafeVarargs
    public UnmodifiableArraySet(E ... elements) {
        assert (UnmodifiableArraySet.inOrderAndUnique(elements));
        this.elements = elements;
    }

    public UnmodifiableArraySet(Collection<E> elements) {
        this(elements.toArray());
    }

    private static int binarySearch(Object[] elements, int oHash) {
        return UnmodifiableArraySet.binarySearch0(elements, 0, elements.length, oHash);
    }

    private static int binarySearch0(Object[] elements, int fromIndex, int toIndex, int oHash) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midHash = elements[mid].hashCode();
            if (midHash < oHash) {
                low = mid + 1;
                continue;
            }
            if (midHash > oHash) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public boolean isEmpty() {
        return this.elements.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        Object[] elems = this.elements;
        int size = elems.length;
        if (size == 0 || o == null) {
            return false;
        }
        if (size < 22) {
            for (int i = 0; i < size; ++i) {
                if (!elems[i].equals(o)) continue;
                return true;
            }
        } else {
            int i;
            int index = UnmodifiableArraySet.binarySearch(elems, o.hashCode());
            if (index < 0) {
                return false;
            }
            Object elem = elems[index];
            if (elem.equals(o)) {
                return true;
            }
            int oHash = o.hashCode();
            for (i = index + 1; i < size && (elem = elems[i]).hashCode() == oHash; ++i) {
                if (!elem.equals(o)) continue;
                return true;
            }
            for (i = index - 1; i >= 0 && (elem = elems[i]).hashCode() == oHash; --i) {
                if (!elem.equals(o)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int index = 0;
            final E[] elems = UnmodifiableArraySet.access$000(UnmodifiableArraySet.this);

            @Override
            public boolean hasNext() {
                return this.index < this.elems.length;
            }

            @Override
            public E next() {
                if (this.index < this.elems.length) {
                    return this.elems[this.index++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elements, this.elements.length);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.elements.length;
        if (a.length < size) {
            return Arrays.copyOf(this.elements, size, a.getClass());
        }
        System.arraycopy(this.elements, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public UnmodifiableArraySet() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        FastObjectOutput fastOut = FastObjectOutput.wrap((ObjectOutput)out);
        try {
            int len = this.elements.length;
            fastOut.writeInt(len);
            if (len > 0) {
                E[] elems = this.elements;
                for (int i = 0; i < len; ++i) {
                    fastOut.writeObject(elems[i]);
                }
            }
        }
        finally {
            fastOut.unwrap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (this.elements != null) {
            throw new IllegalStateException();
        }
        FastObjectInput fastIn = FastObjectInput.wrap((ObjectInput)in);
        try {
            int len = fastIn.readInt();
            if (len == 0) {
                this.elements = EmptyArrays.EMPTY_OBJECT_ARRAY;
            } else {
                Object[] newElements = new Object[len];
                for (int i = 0; i < len; ++i) {
                    newElements[i] = fastIn.readObject();
                }
                assert (UnmodifiableArraySet.inOrderAndUnique(newElements));
                this.elements = newElements;
            }
        }
        finally {
            fastIn.unwrap();
        }
    }

    static /* synthetic */ Object[] access$000(UnmodifiableArraySet x0) {
        return x0.elements;
    }
}

