/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.concurrent;

import com.aoapps.collections.AoCollections;
import com.aoapps.concurrent.Executors;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.NotImplementedException;

public class ConcurrentListenerManager<L>
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(ConcurrentListenerManager.class.getName());
    private static final Queue<EventCall<Object>> SYNC_DO_NOT_QUEUE = new Queue<EventCall<Object>>(){
        private static final String MESSAGE = "This queue is a synchronous marker and none of its method should be called.";

        @Override
        public boolean add(EventCall<Object> e) {
            throw new AssertionError((Object)MESSAGE);
        }

        @Override
        public boolean offer(EventCall<Object> e) {
            throw new AssertionError((Object)MESSAGE);
        }

        @Override
        public EventCall<Object> remove() {
            throw new AssertionError((Object)MESSAGE);
        }

        @Override
        public EventCall<Object> poll() {
            throw new AssertionError((Object)MESSAGE);
        }

        @Override
        public EventCall<Object> element() {
            throw new AssertionError((Object)MESSAGE);
        }

        @Override
        public EventCall<Object> peek() {
            throw new AssertionError((Object)MESSAGE);
        }

        @Override
        public int size() {
            throw new AssertionError((Object)MESSAGE);
        }

        @Override
        public boolean isEmpty() {
            throw new AssertionError((Object)MESSAGE);
        }

        @Override
        public boolean contains(Object o) {
            throw new AssertionError((Object)MESSAGE);
        }

        @Override
        public Iterator<EventCall<Object>> iterator() {
            throw new AssertionError((Object)MESSAGE);
        }

        @Override
        public Object[] toArray() {
            throw new AssertionError((Object)MESSAGE);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new AssertionError((Object)MESSAGE);
        }

        @Override
        public boolean remove(Object o) {
            throw new AssertionError((Object)MESSAGE);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new AssertionError((Object)MESSAGE);
        }

        @Override
        public boolean addAll(Collection<? extends EventCall<Object>> c) {
            throw new AssertionError((Object)MESSAGE);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new AssertionError((Object)MESSAGE);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new AssertionError((Object)MESSAGE);
        }

        @Override
        public void clear() {
            throw new AssertionError((Object)MESSAGE);
        }
    };
    private final Map<L, Queue<EventCall<L>>> listeners = new IdentityHashMap<L, Queue<EventCall<L>>>();
    private final Executors executor = new Executors();

    @Override
    public void close() {
        logger.log(Level.FINE, "Calling executor.close()");
        this.executor.close();
        logger.log(Level.FINE, "executor.close() finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(L listener, boolean synchronous) throws IllegalStateException {
        Map<L, Queue<EventCall<L>>> map = this.listeners;
        synchronized (map) {
            if (this.listeners.containsKey(listener)) {
                throw new IllegalStateException("listener already added");
            }
            this.listeners.put(listener, synchronous ? SYNC_DO_NOT_QUEUE : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(L listener) {
        Map<L, Queue<EventCall<L>>> map = this.listeners;
        synchronized (map) {
            if (!this.listeners.containsKey(listener)) {
                return false;
            }
            this.listeners.remove(listener);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> enqueueEvent(Event<? super L> event) {
        Map<L, Queue<EventCall<L>>> map = this.listeners;
        synchronized (map) {
            final IdentityHashMap unfinishedCalls = AoCollections.newIdentityHashMap((int)this.listeners.size());
            for (Map.Entry<L, Queue<EventCall<L>>> entry : this.listeners.entrySet()) {
                boolean isFirst;
                L listener = entry.getKey();
                Runnable call = event.createCall(listener);
                Queue<EventCall<L>> queue = entry.getValue();
                if (queue == SYNC_DO_NOT_QUEUE) {
                    try {
                        call.run();
                        continue;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        logger.log(Level.SEVERE, null, t);
                        continue;
                    }
                }
                if (queue == null) {
                    queue = new LinkedList<EventCall<L>>();
                    entry.setValue(queue);
                    isFirst = true;
                } else {
                    isFirst = false;
                }
                unfinishedCalls.put(listener, Boolean.TRUE);
                queue.add(new EventCall(unfinishedCalls, call));
                if (!isFirst) continue;
                this.executor.getUnbounded().submit(() -> {
                    while (true) {
                        EventCall<L> eventCall;
                        Map<L, Object> map = this.listeners;
                        synchronized (map) {
                            Queue<EventCall<L>> queue1 = this.listeners.get(listener);
                            if (queue1.isEmpty()) {
                                this.listeners.remove(listener);
                                break;
                            }
                            eventCall = queue1.remove();
                        }
                        try {
                            eventCall.call.run();
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t) {
                            logger.log(Level.SEVERE, null, t);
                        }
                        map = eventCall.unfinishedCalls;
                        synchronized (map) {
                            Boolean removedValue = eventCall.unfinishedCalls.remove(listener);
                            if (eventCall.unfinishedCalls.isEmpty()) {
                                eventCall.unfinishedCalls.notifyAll();
                            }
                            if (removedValue == null) {
                                throw new AssertionError();
                            }
                        }
                    }
                });
            }
            return new Future<Object>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean isDone() {
                    Map map = unfinishedCalls;
                    synchronized (map) {
                        return unfinishedCalls.isEmpty();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object get() throws InterruptedException {
                    Map map = unfinishedCalls;
                    synchronized (map) {
                        while (!unfinishedCalls.isEmpty()) {
                            unfinishedCalls.wait();
                        }
                        return null;
                    }
                }

                @Override
                public Object get(long timeout, TimeUnit unit) throws TimeoutException {
                    throw new NotImplementedException("TODO");
                }
            };
        }
    }

    private static class EventCall<L> {
        final Map<L, Boolean> unfinishedCalls;
        final Runnable call;

        EventCall(Map<L, Boolean> unfinishedCalls, Runnable call) {
            this.unfinishedCalls = unfinishedCalls;
            this.call = call;
        }
    }

    @FunctionalInterface
    public static interface Event<L> {
        public Runnable createCall(L var1);
    }
}

