/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.concurrent;

import com.aoapps.collections.AoCollections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class ConcurrentUtils {
    private ConcurrentUtils() {
        throw new AssertionError();
    }

    public static void waitForAll(Iterable<? extends Future<?>> futures) throws InterruptedException, ExecutionException {
        for (Future<?> future : futures) {
            future.get();
        }
    }

    public static <E> List<E> getAll(Iterable<? extends Future<? extends E>> futures) throws InterruptedException, ExecutionException {
        int startSize = futures instanceof Collection ? ((Collection)futures).size() : 10;
        return ConcurrentUtils.getAll(futures, new ArrayList(startSize));
    }

    public static <E, C extends Collection<E>> C getAll(Iterable<? extends Future<? extends E>> futures, C output) throws InterruptedException, ExecutionException {
        for (Future<E> future : futures) {
            output.add(future.get());
        }
        return output;
    }

    public static <K, V> Map<K, V> getAll(Map<? extends K, ? extends Future<? extends V>> futures) throws InterruptedException, ExecutionException {
        return ConcurrentUtils.getAll(futures, AoCollections.newLinkedHashMap((int)futures.size()));
    }

    public static <K, V, M extends Map<K, V>> M getAll(Map<? extends K, ? extends Future<? extends V>> futures, M output) throws InterruptedException, ExecutionException {
        for (Map.Entry<K, Future<V>> entry : futures.entrySet()) {
            output.put(entry.getKey(), entry.getValue().get());
        }
        return output;
    }
}

