/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExecutorServiceShutdownHook
extends Thread {
    private static final Logger logger = Logger.getLogger(ExecutorServiceShutdownHook.class.getName());
    private static final String DEFAULT_THREAD_NAME = ExecutorServiceShutdownHook.class.getName();
    private static final long DEFAULT_SHUTDOWN_TIMEOUT = 5L;
    private static final TimeUnit DEFAULT_SHUTDOWN_TIMEUNIT = TimeUnit.SECONDS;
    private final ExecutorService executorService;
    private final long shutdownTimeout;
    private final TimeUnit shutdownTimeoutUnit;

    public ExecutorServiceShutdownHook(ExecutorService executorService) {
        this(executorService, DEFAULT_THREAD_NAME, 5L, DEFAULT_SHUTDOWN_TIMEUNIT);
    }

    public ExecutorServiceShutdownHook(ExecutorService executorService, long shutdownTimeout, TimeUnit shutdownTimeoutUnit) {
        this(executorService, DEFAULT_THREAD_NAME, shutdownTimeout, shutdownTimeoutUnit);
    }

    public ExecutorServiceShutdownHook(ExecutorService executorService, String threadName) {
        this(executorService, threadName, 5L, DEFAULT_SHUTDOWN_TIMEUNIT);
    }

    public ExecutorServiceShutdownHook(ExecutorService executorService, String threadName, long shutdownTimeout, TimeUnit shutdownTimeoutUnit) {
        super(threadName);
        this.executorService = executorService;
        this.shutdownTimeout = shutdownTimeout;
        this.shutdownTimeoutUnit = shutdownTimeoutUnit;
    }

    @Override
    public void run() {
        try {
            this.executorService.shutdown();
        }
        catch (SecurityException e) {
            logger.log(Level.WARNING, null, e);
        }
        try {
            if (!this.executorService.awaitTermination(this.shutdownTimeout, this.shutdownTimeoutUnit)) {
                try {
                    this.executorService.shutdownNow();
                }
                catch (SecurityException e) {
                    logger.log(Level.WARNING, null, e);
                }
            }
        }
        catch (InterruptedException e) {
            try {
                logger.log(Level.SEVERE, null, e);
                try {
                    this.executorService.shutdownNow();
                }
                catch (SecurityException e2) {
                    logger.log(Level.WARNING, null, e2);
                }
            }
            finally {
                Thread.currentThread().interrupt();
            }
        }
    }
}

