/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.concurrent;

import com.aoapps.concurrent.Executor;
import com.aoapps.concurrent.ExecutorServiceShutdownHook;
import com.aoapps.hodgepodge.i18n.I18nThreadLocalCallable;
import com.aoapps.hodgepodge.i18n.I18nThreadLocalRunnable;
import com.aoapps.lang.RuntimeUtils;
import com.aoapps.lang.concurrent.ThreadLocalCallable;
import com.aoapps.lang.concurrent.ThreadLocalRunnable;
import com.aoapps.lang.util.AtomicSequence;
import com.aoapps.lang.util.Sequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Executors
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(Executors.class.getName());
    private static final boolean DAEMON_THREADS = true;
    private static final long CLOSE_WAIT_NANOS = 100000000L;
    private static final int THREADS_PER_PROCESSOR = 2;
    private static final ThreadLocal<ThreadFactory> currentThreadFactory = new ThreadLocal();
    private static final AtomicInteger activeCount = new AtomicInteger();
    private final AtomicBoolean closed = new AtomicBoolean();
    private static final Sequence idSequence = new AtomicSequence(0L);
    private final long id = idSequence.getNextSequenceValue();
    private final int preferredConcurrency;
    private static final AtomicReference<Timer> timer = new AtomicReference();
    private final AtomicLong nextIncompleteFutureId = new AtomicLong(1L);
    private final ConcurrentMap<Long, ThreadFactoryFuture<?>> incompleteFutures = new ConcurrentHashMap();
    private final UnboundedExecutor unbounded = new UnboundedExecutor(this);
    private final PerProcessorExecutor perProcessor;
    private final SequentialExecutor sequential = new SequentialExecutor(this);

    @Deprecated
    public static Executors newInstance() {
        return new Executors();
    }

    public Executors() {
        int availableProcessors = RuntimeUtils.getAvailableProcessors();
        int n = this.preferredConcurrency = availableProcessors == 1 ? 1 : availableProcessors * 2;
        assert (activeCount.get() >= 0);
        int newActiveCount = activeCount.incrementAndGet();
        if (newActiveCount < 0) {
            activeCount.decrementAndGet();
            throw new IllegalStateException("activeCount integer wraparound detected");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "id={0}, activeCount={1}", new Object[]{this.id, newActiveCount});
        }
        this.perProcessor = new PerProcessorExecutor(this);
    }

    public String toString() {
        return Executors.class.getName() + '[' + this.id + ']';
    }

    public int getPreferredConcurrency() {
        return this.preferredConcurrency;
    }

    private static Timer getTimer() {
        assert (activeCount.get() > 0);
        Timer t = timer.get();
        if (t == null && !timer.compareAndSet(null, t = new Timer(Executors.class.getName() + ".timer", true))) {
            t.cancel();
            t = timer.get();
            if (t == null) {
                throw new IllegalStateException();
            }
        }
        return t;
    }

    private <T> IncompleteFuture<T> incompleteFutureSubmit(ThreadFactory threadFactory, SimpleExecutorService executorService, Callable<? extends T> task) {
        Long incompleteFutureId = this.nextIncompleteFutureId.getAndIncrement();
        Future<Object> future = executorService.submit(() -> {
            try {
                Object v = task.call();
                return v;
            }
            finally {
                this.incompleteFutures.remove(incompleteFutureId);
            }
        });
        IncompleteFuture incompleteFuture = new IncompleteFuture(threadFactory, incompleteFutureId, future);
        this.incompleteFutures.put(incompleteFutureId, incompleteFuture);
        return incompleteFuture;
    }

    private <T> IncompleteFuture<T> incompleteFutureSubmit(ThreadFactory threadFactory, SimpleExecutorService executorService, Runnable task, T result) {
        Long incompleteFutureId = this.nextIncompleteFutureId.getAndIncrement();
        Future<T> submitted = executorService.submit(() -> {
            try {
                task.run();
            }
            finally {
                this.incompleteFutures.remove(incompleteFutureId);
            }
        }, result);
        IncompleteFuture future = new IncompleteFuture(threadFactory, incompleteFutureId, submitted);
        this.incompleteFutures.put(incompleteFutureId, future);
        return future;
    }

    private <T> Future<T> incompleteFutureSubmit(ThreadFactory threadFactory, SimpleExecutorService executorService, Callable<? extends T> task, long delay) {
        Long incompleteFutureId = this.nextIncompleteFutureId.getAndIncrement();
        IncompleteCallableTimerTask<? extends T> timerTask = new IncompleteCallableTimerTask<T>(this, threadFactory, executorService, incompleteFutureId, task);
        Executors.getTimer().schedule(timerTask, delay);
        this.incompleteFutures.put(incompleteFutureId, timerTask);
        return timerTask;
    }

    private <T> Future<T> incompleteFutureSubmit(ThreadFactory threadFactory, SimpleExecutorService executorService, Runnable task, T result, long delay) {
        Long incompleteFutureId = this.nextIncompleteFutureId.getAndIncrement();
        IncompleteRunnableTimerTask<T> timerTask = new IncompleteRunnableTimerTask<T>(this, threadFactory, executorService, incompleteFutureId, task, result);
        Executors.getTimer().schedule(timerTask, delay);
        this.incompleteFutures.put(incompleteFutureId, timerTask);
        return timerTask;
    }

    protected <T> Callable<T> wrap(Callable<T> task) {
        return new I18nThreadLocalCallable(task);
    }

    protected Runnable wrap(Runnable task) {
        return new I18nThreadLocalRunnable(task);
    }

    public Executor getUnbounded() {
        return this.unbounded;
    }

    public Executor getPerProcessor() {
        return this.perProcessor;
    }

    public Executor getSequential() {
        return this.sequential;
    }

    @Override
    public void close() {
        boolean alreadyClosed = this.closed.getAndSet(true);
        if (!alreadyClosed) {
            assert (activeCount.get() > 0);
            int newActiveCount = activeCount.decrementAndGet();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "activeCount={0}", newActiveCount);
            }
            if (newActiveCount == 0) {
                UnboundedExecutor.close();
                PerProcessorExecutor.close();
                Timer t = timer.getAndSet(null);
                if (t != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Canceling timer");
                    }
                    t.cancel();
                }
                this.incompleteFutures.clear();
            } else {
                ArrayList waitFutures = new ArrayList(this.incompleteFutures.values());
                this.incompleteFutures.clear();
                ThreadFactory tf = currentThreadFactory.get();
                long waitUntil = System.nanoTime() + 100000000L;
                ArrayList<ThreadFactoryFuture> ownThreadFactoryWaitFutures = null;
                int size = waitFutures.size();
                for (int i = 0; i < size; ++i) {
                    ThreadFactoryFuture future = (ThreadFactoryFuture)waitFutures.get(i);
                    if (tf != future.getThreadFactory()) {
                        if (ownThreadFactoryWaitFutures == null) {
                            ownThreadFactoryWaitFutures = new ArrayList<ThreadFactoryFuture>(size);
                        }
                        ownThreadFactoryWaitFutures.add(future);
                        continue;
                    }
                    long nanosRemaining = waitUntil - System.nanoTime();
                    if (nanosRemaining >= 0L) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Waiting on waitFuture[{0}], {1} ns remaining", new Object[]{i, nanosRemaining});
                        }
                        try {
                            future.get(nanosRemaining, TimeUnit.NANOSECONDS);
                            continue;
                        }
                        catch (CancellationException | ExecutionException exception) {
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                        catch (TimeoutException e) {
                            future.cancel(true);
                            continue;
                        }
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "No time left, canceling waitFuture[{0}]", i);
                    }
                    future.cancel(true);
                }
                if (ownThreadFactoryWaitFutures != null && !Thread.currentThread().isInterrupted()) {
                    ArrayList<ThreadFactoryFuture> waitOnOtherThreads = ownThreadFactoryWaitFutures;
                    new Thread(() -> {
                        int size = waitOnOtherThreads.size();
                        for (int i = 0; i < size; ++i) {
                            ThreadFactoryFuture future = (ThreadFactoryFuture)waitOnOtherThreads.get(i);
                            long nanosRemaining = waitUntil - System.nanoTime();
                            if (nanosRemaining >= 0L) {
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.log(Level.FINE, "Waiting on waitOnOtherThreads[{0}], {1} ns remaining", new Object[]{i, nanosRemaining});
                                }
                                try {
                                    future.get(nanosRemaining, TimeUnit.NANOSECONDS);
                                    continue;
                                }
                                catch (CancellationException | ExecutionException exception) {
                                    continue;
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    break;
                                }
                                catch (TimeoutException e) {
                                    future.cancel(true);
                                    continue;
                                }
                            }
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "No time left, canceling waitOnOtherThreads[{0}]", i);
                            }
                            future.cancel(true);
                        }
                    }, this.toString() + ".close()").start();
                }
            }
        }
    }

    private static class SequentialExecutor
    extends ExecutorImpl {
        private static final ThreadFactory sequentialThreadFactory = r -> {
            throw new IllegalStateException("No threads should be created by the sequential executor");
        };
        private final SimpleExecutorService sequentialExecutorService = new SimpleExecutorService(){

            @Override
            public <T> Future<T> submit(Callable<T> task) {
                return new SequentialFuture(task, executors.unbounded);
            }

            @Override
            public <T> Future<T> submit(Runnable task, T result) {
                return this.submit(() -> {
                    task.run();
                    return result;
                });
            }
        };

        private SequentialExecutor(Executors executors) {
            super(executors);
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }

        @Override
        ThreadFactory getThreadFactory() {
            return sequentialThreadFactory;
        }

        @Override
        protected SimpleExecutorService getExecutorService() {
            assert (activeCount.get() > 0);
            return this.sequentialExecutorService;
        }

        @Override
        public <T> List<T> callAll(Collection<? extends Callable<? extends T>> tasks) throws InterruptedException, ExecutionException {
            int size = tasks.size();
            if (size == 0) {
                return Collections.emptyList();
            }
            try {
                if (size == 1) {
                    return Collections.singletonList(tasks.iterator().next().call());
                }
                ArrayList<T> results = new ArrayList<T>(size);
                for (Callable<T> task : tasks) {
                    results.add(task.call());
                }
                return Collections.unmodifiableList(results);
            }
            catch (InterruptedException | ThreadDeath e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ExecutionException(t);
            }
        }

        @Override
        public void runAll(Collection<? extends Runnable> tasks) throws ExecutionException {
            try {
                for (Runnable runnable : tasks) {
                    runnable.run();
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                throw new ExecutionException(t);
            }
        }

        private static class SequentialFuture<V>
        implements Future<V> {
            private final Lock lock = new Lock();
            private final Callable<V> task;
            private final UnboundedExecutor unboundedExecutor;
            private boolean canceled;
            private boolean done;
            private Thread gettingThread;
            private V result;
            private Throwable exception;

            private SequentialFuture(Callable<V> task, UnboundedExecutor unboundedExecutor) {
                this.task = task;
                this.unboundedExecutor = unboundedExecutor;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                Lock lock = this.lock;
                synchronized (lock) {
                    if (this.canceled) {
                        return false;
                    }
                    if (this.done) {
                        return false;
                    }
                    this.canceled = true;
                    this.done = true;
                    if (mayInterruptIfRunning && this.gettingThread != null) {
                        this.gettingThread.interrupt();
                    }
                    this.lock.notifyAll();
                    return true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCancelled() {
                Lock lock = this.lock;
                synchronized (lock) {
                    return this.canceled;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDone() {
                Lock lock = this.lock;
                synchronized (lock) {
                    return this.done;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V get() throws InterruptedException, CancellationException, ExecutionException {
                Lock lock = this.lock;
                synchronized (lock) {
                    while (true) {
                        if (this.canceled) {
                            throw new CancellationException();
                        }
                        if (this.done) {
                            if (this.exception != null) {
                                throw new ExecutionException(this.exception);
                            }
                            return this.result;
                        }
                        if (this.gettingThread == null) break;
                        this.lock.wait();
                    }
                    this.gettingThread = Thread.currentThread();
                }
                try {
                    V r = this.task.call();
                    Lock lock2 = this.lock;
                    synchronized (lock2) {
                        this.gettingThread = null;
                        this.done = true;
                        this.result = r;
                        this.lock.notifyAll();
                    }
                    return r;
                }
                catch (InterruptedException | ThreadDeath e) {
                    throw e;
                }
                catch (Throwable t) {
                    Lock lock3 = this.lock;
                    synchronized (lock3) {
                        this.gettingThread = null;
                        this.done = true;
                        this.exception = t;
                        this.lock.notifyAll();
                    }
                    throw new ExecutionException(t);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V get(long timeout, TimeUnit unit) throws InterruptedException, CancellationException, ExecutionException, TimeoutException {
                Lock lock = this.lock;
                synchronized (lock) {
                    if (this.canceled) {
                        throw new CancellationException();
                    }
                    if (this.done) {
                        if (this.exception != null) {
                            throw new ExecutionException(this.exception);
                        }
                        return this.result;
                    }
                }
                try {
                    return (V)this.unboundedExecutor.submit(this::get).get(timeout, unit);
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof InterruptedException) {
                        throw (InterruptedException)cause;
                    }
                    if (cause instanceof CancellationException) {
                        throw (CancellationException)cause;
                    }
                    if (cause instanceof ExecutionException) {
                        throw (ExecutionException)cause;
                    }
                    throw e;
                }
            }

            private static class Lock {
                private Lock() {
                }
            }
        }
    }

    private static class PerProcessorExecutor
    extends ExecutorImpl {
        private static final ThreadLocal<Integer> currentThreadPerProcessorIndex = new ThreadLocal();
        private static final List<PrefixThreadFactory> threadFactories = new CopyOnWriteArrayList<PrefixThreadFactory>();
        private static final PerProcessorExecutorServicesLock perProcessorExecutorServicesLock = new PerProcessorExecutorServicesLock();
        private static final List<ExecutorServiceWrapper> perProcessorExecutorServices = new ArrayList<ExecutorServiceWrapper>();

        private static PrefixThreadFactory getThreadFactory(int index) {
            PrefixThreadFactory perProcessorThreadFactory = index < threadFactories.size() ? threadFactories.get(index) : null;
            if (perProcessorThreadFactory == null) {
                final Integer indexObj = index;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "new perProcessorThreadFactory: {0}", index);
                }
                perProcessorThreadFactory = new PrefixThreadFactory(Executors.class.getName() + ".perProcessor-" + index + "-thread-", 5){

                    @Override
                    public Thread newThread(Runnable target) {
                        return super.newThread(() -> {
                            assert (currentThreadPerProcessorIndex.get() == null);
                            currentThreadPerProcessorIndex.set(indexObj);
                            target.run();
                        });
                    }
                };
                while (threadFactories.size() <= index) {
                    threadFactories.add(null);
                }
                threadFactories.set(index, perProcessorThreadFactory);
            }
            return perProcessorThreadFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void close() {
            PerProcessorExecutorServicesLock perProcessorExecutorServicesLock = PerProcessorExecutor.perProcessorExecutorServicesLock;
            synchronized (perProcessorExecutorServicesLock) {
                for (int i = perProcessorExecutorServices.size() - 1; i >= 0; --i) {
                    int index = i;
                    ExecutorServiceWrapper ppes = perProcessorExecutorServices.get(index);
                    if (ppes == null) continue;
                    Runnable ppesShutdown = () -> {
                        try {
                            ppes.executorService.shutdown();
                        }
                        catch (SecurityException e) {
                            logger.log(Level.WARNING, null, e);
                        }
                        try {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "awaiting termination of perProcessorExecutorServices[{0}]", index);
                            }
                            if (ppes.executorService.awaitTermination(100000000L, TimeUnit.NANOSECONDS)) {
                                ppes.removeShutdownHook();
                            }
                        }
                        catch (InterruptedException e) {
                            logger.log(Level.WARNING, null, e);
                            Thread.currentThread().interrupt();
                        }
                    };
                    perProcessorExecutorServices.set(index, null);
                    ThreadFactory tf = (ThreadFactory)currentThreadFactory.get();
                    if (tf != null && tf == threadFactories.get(index)) {
                        new Thread(ppesShutdown).start();
                        continue;
                    }
                    ppesShutdown.run();
                }
            }
        }

        private PerProcessorExecutor(Executors executors) {
            super(executors);
        }

        @Override
        ThreadFactory getThreadFactory() {
            int index;
            Integer perProcessorIndex = currentThreadPerProcessorIndex.get();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "perProcessorIndex={0}", perProcessorIndex);
            }
            int n = index = perProcessorIndex == null ? 0 : perProcessorIndex + 1;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "index={0}", index);
            }
            return PerProcessorExecutor.getThreadFactory(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected SimpleExecutorService getExecutorService() {
            int index;
            assert (activeCount.get() > 0);
            Integer perProcessorIndex = currentThreadPerProcessorIndex.get();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "perProcessorIndex={0}", perProcessorIndex);
            }
            int n = index = perProcessorIndex == null ? 0 : perProcessorIndex + 1;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "index={0}", index);
            }
            PerProcessorExecutorServicesLock perProcessorExecutorServicesLock = PerProcessorExecutor.perProcessorExecutorServicesLock;
            synchronized (perProcessorExecutorServicesLock) {
                ExecutorServiceWrapper perProcessorExecutorService;
                ExecutorServiceWrapper executorServiceWrapper = perProcessorExecutorService = index < perProcessorExecutorServices.size() ? perProcessorExecutorServices.get(index) : null;
                if (perProcessorExecutorService == null) {
                    ExecutorService executorService;
                    PrefixThreadFactory perProcessorThreadFactory = PerProcessorExecutor.getThreadFactory(index);
                    int numThreads = this.executors.preferredConcurrency;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "new perProcessorExecutorService: index={0}, numThreads={1}", new Object[]{index, numThreads});
                    }
                    if (index == 0) {
                        executorService = java.util.concurrent.Executors.newFixedThreadPool(numThreads, perProcessorThreadFactory);
                    } else {
                        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(numThreads, numThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), perProcessorThreadFactory);
                        threadPool.allowCoreThreadTimeOut(true);
                        executorService = threadPool;
                    }
                    perProcessorExecutorService = new ExecutorServiceWrapper(executorService, perProcessorThreadFactory.namePrefix + "shutdownHook");
                    while (perProcessorExecutorServices.size() <= index) {
                        perProcessorExecutorServices.add(null);
                    }
                    if (perProcessorExecutorServices.set(index, perProcessorExecutorService) != null) {
                        throw new AssertionError();
                    }
                }
                return perProcessorExecutorService;
            }
        }

        private static class PerProcessorExecutorServicesLock {
            private PerProcessorExecutorServicesLock() {
            }
        }
    }

    private static class UnboundedExecutor
    extends ExecutorImpl {
        private static final AtomicReference<ExecutorServiceWrapper> unboundedExecutorService = new AtomicReference();
        private static final String THREAD_FACTORY_NAME_PREFIX = Executors.class.getName() + ".unbounded-thread-";
        private static final ThreadFactory unboundedThreadFactory = new PrefixThreadFactory(THREAD_FACTORY_NAME_PREFIX, 5);

        private static void close() {
            ExecutorServiceWrapper ues = unboundedExecutorService.getAndSet(null);
            if (ues != null) {
                Runnable uesShutdown = () -> {
                    try {
                        ues.executorService.shutdown();
                    }
                    catch (SecurityException e) {
                        logger.log(Level.WARNING, null, e);
                    }
                    try {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "awaiting termination of unboundedExecutorService");
                        }
                        if (ues.executorService.awaitTermination(100000000L, TimeUnit.NANOSECONDS)) {
                            ues.removeShutdownHook();
                        }
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.WARNING, null, e);
                        Thread.currentThread().interrupt();
                    }
                };
                ThreadFactory tf = (ThreadFactory)currentThreadFactory.get();
                if (tf != null && tf == unboundedThreadFactory) {
                    new Thread(uesShutdown).start();
                } else {
                    uesShutdown.run();
                }
            }
        }

        private UnboundedExecutor(Executors executors) {
            super(executors);
        }

        @Override
        ThreadFactory getThreadFactory() {
            return unboundedThreadFactory;
        }

        @Override
        protected SimpleExecutorService getExecutorService() {
            assert (activeCount.get() > 0);
            ExecutorServiceWrapper ues = unboundedExecutorService.get();
            if (ues == null && !unboundedExecutorService.compareAndSet(null, ues = new ExecutorServiceWrapper(java.util.concurrent.Executors.newCachedThreadPool(unboundedThreadFactory), THREAD_FACTORY_NAME_PREFIX + "shutdownHook"))) {
                ues.executorService.shutdown();
                ues.removeShutdownHook();
                ues = unboundedExecutorService.get();
                if (ues == null) {
                    throw new IllegalStateException();
                }
            }
            return ues;
        }

        @Override
        protected <T> Callable<T> wrap(Callable<T> task) {
            return super.wrap(new ThreadLocalCallable(task, PerProcessorExecutor.currentThreadPerProcessorIndex));
        }

        @Override
        protected Runnable wrap(Runnable task) {
            return super.wrap((Runnable)new ThreadLocalRunnable(task, PerProcessorExecutor.currentThreadPerProcessorIndex));
        }
    }

    private static abstract class ExecutorImpl
    implements Executor {
        protected final Executors executors;

        protected ExecutorImpl(Executors executors) {
            this.executors = executors;
        }

        @Override
        public void execute(Runnable command) {
            this.submit(command);
        }

        abstract ThreadFactory getThreadFactory();

        protected abstract SimpleExecutorService getExecutorService();

        protected <T> Callable<T> wrap(Callable<T> task) {
            return this.executors.wrap(task);
        }

        protected Runnable wrap(Runnable task) {
            return this.executors.wrap(task);
        }

        @Override
        public <T> Future<T> submit(Callable<? extends T> task) throws IllegalStateException {
            if (this.executors.closed.get()) {
                throw new IllegalStateException();
            }
            return this.executors.incompleteFutureSubmit(this.getThreadFactory(), this.getExecutorService(), this.wrap(task));
        }

        @Override
        public <T> List<T> callAll(Collection<? extends Callable<? extends T>> tasks) throws IllegalStateException, InterruptedException, ExecutionException {
            int i;
            if (this.executors.closed.get()) {
                throw new IllegalStateException();
            }
            int size = tasks.size();
            if (size == 0) {
                return Collections.emptyList();
            }
            if (size == 1) {
                try {
                    return Collections.singletonList(tasks.iterator().next().call());
                }
                catch (InterruptedException | ThreadDeath e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new ExecutionException(t);
                }
            }
            ArrayList<Callable<T>> taskList = tasks instanceof List ? (ArrayList<Callable<T>>)tasks : new ArrayList<Callable<T>>(tasks);
            ArrayList<Future<T>> futures = new ArrayList<Future<T>>(size - 1);
            ArrayList results = new ArrayList(size);
            for (i = 0; i < size; ++i) {
                Callable task = (Callable)taskList.get(i);
                if (i < size - 1) {
                    futures.add(this.submit(task));
                    results.add(null);
                    continue;
                }
                try {
                    results.add(task.call());
                    continue;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    throw new ExecutionException(t);
                }
            }
            for (i = 0; i < size - 1; ++i) {
                results.set(i, ((Future)futures.get(i)).get());
            }
            return Collections.unmodifiableList(results);
        }

        @Override
        public <T> Future<T> submit(Callable<? extends T> task, long delay) throws IllegalStateException {
            if (delay <= 0L) {
                return this.submit(task);
            }
            if (this.executors.closed.get()) {
                throw new IllegalStateException();
            }
            return this.executors.incompleteFutureSubmit(this.getThreadFactory(), this.getExecutorService(), this.wrap(task), delay);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) throws IllegalStateException {
            if (this.executors.closed.get()) {
                throw new IllegalStateException();
            }
            return this.executors.incompleteFutureSubmit(this.getThreadFactory(), this.getExecutorService(), this.wrap(task), result);
        }

        @Override
        public Future<?> submit(Runnable task) throws IllegalStateException {
            return this.submit(task, null);
        }

        @Override
        public void runAll(Collection<? extends Runnable> tasks) throws IllegalStateException, InterruptedException, ExecutionException {
            if (this.executors.closed.get()) {
                throw new IllegalStateException();
            }
            int size = tasks.size();
            if (size != 0) {
                if (size == 1) {
                    try {
                        tasks.iterator().next().run();
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        throw new ExecutionException(t);
                    }
                } else {
                    int i;
                    ArrayList<? extends Runnable> taskList = tasks instanceof List ? (ArrayList<? extends Runnable>)tasks : new ArrayList<Runnable>(tasks);
                    ArrayList futures = new ArrayList(size - 1);
                    for (i = 0; i < size; ++i) {
                        Runnable task = (Runnable)taskList.get(i);
                        if (i < size - 1) {
                            futures.add(this.submit(task));
                            continue;
                        }
                        try {
                            task.run();
                            continue;
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t) {
                            throw new ExecutionException(t);
                        }
                    }
                    for (i = 0; i < size - 1; ++i) {
                        ((Future)futures.get(i)).get();
                    }
                }
            }
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result, long delay) throws IllegalStateException {
            if (delay <= 0L) {
                return this.submit(task, result);
            }
            if (this.executors.closed.get()) {
                throw new IllegalStateException();
            }
            return this.executors.incompleteFutureSubmit(this.getThreadFactory(), this.getExecutorService(), this.wrap(task), result, delay);
        }

        @Override
        public Future<?> submit(Runnable task, long delay) throws IllegalStateException {
            return this.submit(task, null, delay);
        }
    }

    private static class IncompleteRunnableTimerTask<T>
    extends IncompleteTimerTask<T> {
        final Runnable task;
        final T result;

        IncompleteRunnableTimerTask(Executors executors, ThreadFactory threadFactory, SimpleExecutorService executorService, Long incompleteFutureId, Runnable task, T result) {
            super(executors, threadFactory, executorService, incompleteFutureId);
            this.task = task;
            this.result = result;
        }

        @Override
        public void run() {
            try {
                try {
                    this.setFuture(this.executors.incompleteFutureSubmit(this.threadFactory, this.executorService, this.task, this.result));
                }
                finally {
                    this.executors.incompleteFutures.remove(this.incompleteFutureId);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, null, t);
            }
            finally {
                if (Thread.interrupted()) {
                    logger.log(Level.WARNING, "Cleared thread interrupted state before returning to timer");
                }
            }
        }
    }

    private static class IncompleteCallableTimerTask<V>
    extends IncompleteTimerTask<V> {
        final Callable<? extends V> task;

        IncompleteCallableTimerTask(Executors executors, ThreadFactory threadFactory, SimpleExecutorService executorService, Long incompleteFutureId, Callable<? extends V> task) {
            super(executors, threadFactory, executorService, incompleteFutureId);
            this.task = task;
        }

        @Override
        public void run() {
            try {
                try {
                    this.setFuture(this.executors.incompleteFutureSubmit(this.threadFactory, this.executorService, this.task));
                }
                finally {
                    this.executors.incompleteFutures.remove(this.incompleteFutureId);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, null, t);
            }
            finally {
                if (Thread.interrupted()) {
                    logger.log(Level.WARNING, "Cleared thread interrupted state before returning to timer");
                }
            }
        }
    }

    private static abstract class IncompleteTimerTask<V>
    extends TimerTask
    implements ThreadFactoryFuture<V> {
        protected final Executors executors;
        protected final ThreadFactory threadFactory;
        protected final SimpleExecutorService executorService;
        protected final Long incompleteFutureId;
        private final IncompleteLock incompleteLock = new IncompleteLock();
        private boolean canceled;
        private IncompleteFuture<V> future;

        private IncompleteTimerTask(Executors executors, ThreadFactory threadFactory, SimpleExecutorService executorService, Long incompleteFutureId) {
            this.executors = executors;
            this.threadFactory = threadFactory;
            this.executorService = executorService;
            this.incompleteFutureId = incompleteFutureId;
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setFuture(IncompleteFuture<V> future) {
            IncompleteLock incompleteLock = this.incompleteLock;
            synchronized (incompleteLock) {
                this.future = future;
                this.incompleteLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            try {
                IncompleteLock incompleteLock = this.incompleteLock;
                synchronized (incompleteLock) {
                    this.canceled = true;
                    this.incompleteLock.notifyAll();
                }
                boolean bl = super.cancel();
                return bl;
            }
            finally {
                this.executors.incompleteFutures.remove(this.incompleteFutureId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                IncompleteFuture<V> f;
                IncompleteLock incompleteLock = this.incompleteLock;
                synchronized (incompleteLock) {
                    f = this.future;
                    this.canceled = true;
                    this.incompleteLock.notifyAll();
                }
                boolean bl = f == null ? super.cancel() : f.cancel(mayInterruptIfRunning);
                return bl;
            }
            finally {
                this.executors.incompleteFutures.remove(this.incompleteFutureId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            IncompleteFuture<V> f;
            boolean c;
            IncompleteLock incompleteLock = this.incompleteLock;
            synchronized (incompleteLock) {
                c = this.canceled;
                f = this.future;
            }
            return f == null ? c : f.isCancelled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            IncompleteFuture<V> f;
            boolean c;
            IncompleteLock incompleteLock = this.incompleteLock;
            synchronized (incompleteLock) {
                c = this.canceled;
                f = this.future;
            }
            return f == null ? c : f.isDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get() throws InterruptedException, CancellationException, ExecutionException {
            IncompleteFuture<V> f;
            IncompleteLock incompleteLock = this.incompleteLock;
            synchronized (incompleteLock) {
                while (this.future == null) {
                    if (this.canceled) {
                        throw new CancellationException();
                    }
                    this.incompleteLock.wait();
                }
                f = this.future;
            }
            return f.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, CancellationException, ExecutionException, TimeoutException {
            IncompleteFuture<V> f;
            long waitUntil = System.nanoTime() + unit.toNanos(timeout);
            IncompleteLock incompleteLock = this.incompleteLock;
            synchronized (incompleteLock) {
                while (this.future == null) {
                    if (this.canceled) {
                        throw new CancellationException();
                    }
                    long nanosRemaining = waitUntil - System.nanoTime();
                    if (nanosRemaining <= 0L) {
                        throw new TimeoutException();
                    }
                    this.incompleteLock.wait(nanosRemaining / 1000000L, (int)(nanosRemaining % 1000000L));
                }
                f = this.future;
            }
            return f.get(Math.max(0L, waitUntil - System.nanoTime()), TimeUnit.NANOSECONDS);
        }

        private static class IncompleteLock {
            private IncompleteLock() {
            }
        }
    }

    private static class ExecutorServiceWrapper
    implements SimpleExecutorService {
        final ExecutorService executorService;
        private final Thread shutdownHook;

        ExecutorServiceWrapper(ExecutorService executorService, String shutdownHookThreadName) {
            this.executorService = executorService;
            logger.log(Level.FINE, "Registering shutdown hook");
            ExecutorServiceShutdownHook newShutdownHook = new ExecutorServiceShutdownHook(executorService, shutdownHookThreadName);
            try {
                Runtime.getRuntime().addShutdownHook(newShutdownHook);
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                logger.log(Level.WARNING, "Failed to add shutdown hook", e);
                newShutdownHook = null;
            }
            catch (SecurityException e) {
                logger.log(Level.FINE, "Shutdown hook not allowed", e);
                newShutdownHook = null;
            }
            this.shutdownHook = newShutdownHook;
        }

        void removeShutdownHook() {
            if (this.shutdownHook != null) {
                logger.log(Level.FINE, "Removing shutdown hook");
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (SecurityException e) {
                    logger.log(Level.WARNING, "Failed to remove shutdown hook", e);
                }
            }
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.executorService.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.executorService.submit(task, result);
        }
    }

    private static interface SimpleExecutorService {
        public <T> Future<T> submit(Callable<T> var1);

        public <T> Future<T> submit(Runnable var1, T var2);
    }

    private class IncompleteFuture<V>
    implements ThreadFactoryFuture<V> {
        private final ThreadFactory threadFactory;
        private final Long incompleteFutureId;
        private final Future<V> future;

        private IncompleteFuture(ThreadFactory threadFactory, Long incompleteFutureId, Future<V> future) {
            this.threadFactory = threadFactory;
            this.incompleteFutureId = incompleteFutureId;
            this.future = future;
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                boolean bl = this.future.cancel(mayInterruptIfRunning);
                return bl;
            }
            finally {
                Executors.this.incompleteFutures.remove(this.incompleteFutureId);
            }
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.future.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.future.get(timeout, unit);
        }
    }

    private static interface ThreadFactoryFuture<V>
    extends Future<V> {
        public ThreadFactory getThreadFactory();
    }

    private static class PrefixThreadFactory
    implements ThreadFactory {
        final String namePrefix;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final int priority;

        private PrefixThreadFactory(String namePrefix, int priority) {
            this.namePrefix = namePrefix;
            this.priority = priority;
        }

        @Override
        public Thread newThread(Runnable target) {
            String name = this.namePrefix + this.threadNumber.getAndIncrement();
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "newThread={0}", name);
            }
            Thread t = new Thread(() -> {
                currentThreadFactory.set(this);
                target.run();
            }, name);
            t.setPriority(this.priority);
            t.setDaemon(true);
            return t;
        }
    }
}

