/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.cron;

import com.aoapps.concurrent.Executor;
import com.aoapps.concurrent.Executors;
import com.aoapps.cron.CronJob;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CronDaemon {
    private static final long MAX_SLEEP_TIME = 60000L;
    private static volatile Logger logger = Logger.getLogger(CronDaemon.class.getName());
    private static Executors executors;
    private static Task task;
    private static Future<?> future;
    private static final List<CronJob> cronJobs;
    private static final List<Logger> loggers;
    private static final List<CronJobTask> runningJobTasks;
    private static final Object lock;

    private CronDaemon() {
        throw new AssertionError();
    }

    public static void setLogger(Logger logger) {
        CronDaemon.logger = logger != null ? logger : Logger.getLogger(CronDaemon.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCronJob(CronJob job, Logger logger) {
        if (job != null) {
            Object object = lock;
            synchronized (object) {
                boolean found = false;
                for (CronJob cronJob : cronJobs) {
                    if (cronJob != job) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    cronJobs.add(job);
                    loggers.add(logger);
                    if (executors == null) {
                        executors = new Executors();
                    }
                    if (task == null) {
                        task = new Task();
                        future = executors.getUnbounded().submit((Runnable)task);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCronJob(CronJob job) {
        Object object = lock;
        synchronized (object) {
            if (job != null) {
                int len = cronJobs.size();
                for (int i = 0; i < len; ++i) {
                    if (cronJobs.get(i) != job) continue;
                    cronJobs.remove(i);
                    loggers.remove(i);
                    break;
                }
            }
            if (cronJobs.isEmpty()) {
                task = null;
                if (future != null) {
                    future.cancel(false);
                    future = null;
                }
                if (executors != null) {
                    executors.close();
                    executors = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void jobDone(CronJobTask task) {
        Object object = lock;
        synchronized (object) {
            Iterator<CronJobTask> iter = runningJobTasks.iterator();
            while (iter.hasNext()) {
                if (iter.next() != task) continue;
                iter.remove();
                return;
            }
        }
        Logger l = logger;
        if (l.isLoggable(Level.WARNING)) {
            l.log(Level.WARNING, "cron_job.name=" + task.job.getName(), new Throwable("Warning: task not found"));
        }
    }

    private static void runJob(CronJob job, Logger logger, int minute, int hour, int dayOfMonth, int month, int dayOfWeek, int year) {
        block14: {
            assert (Thread.holdsLock(lock));
            try {
                boolean run;
                CronJob.ScheduleMode scheduleMode = job.getScheduleMode();
                if (scheduleMode == CronJob.ScheduleMode.SKIP) {
                    run = true;
                    for (CronJobTask jobTask : runningJobTasks) {
                        if (jobTask.job != job) continue;
                        run = false;
                        break;
                    }
                } else if (scheduleMode == CronJob.ScheduleMode.CONCURRENT) {
                    run = true;
                } else {
                    throw new RuntimeException("Unknown value from CronJob.getScheduleMode: " + (Object)((Object)scheduleMode));
                }
                if (run) {
                    CronJobTask jobTask = new CronJobTask(job, logger, minute, hour, dayOfMonth, month, dayOfWeek, year);
                    runningJobTasks.add(jobTask);
                    Executor executor = job.getExecutor().getExecutor(executors);
                    Future jobFuture = executor.submit((Runnable)jobTask);
                    if (executor == executors.getSequential()) {
                        jobFuture.get();
                    }
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (InterruptedException e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "cron_job.name=" + job.getName(), e);
                }
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.SEVERE)) break block14;
                logger.log(Level.SEVERE, "cron_job.name=" + job.getName(), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runImmediately(CronJob job) throws IllegalStateException {
        GregorianCalendar gcal = new GregorianCalendar();
        int minute = gcal.get(12);
        int hour = gcal.get(11);
        int dayOfMonth = gcal.get(5);
        int month = gcal.get(2);
        int dayOfWeek = gcal.get(7);
        int year = gcal.get(1);
        Object object = lock;
        synchronized (object) {
            int size = cronJobs.size();
            for (int i = 0; i < size; ++i) {
                if (job != cronJobs.get(i)) continue;
                CronDaemon.runJob(job, loggers.get(i), minute, hour, dayOfMonth, month, dayOfWeek, year);
                return;
            }
        }
        throw new IllegalStateException("CronJob has not been added.");
    }

    static {
        cronJobs = new ArrayList<CronJob>();
        loggers = new ArrayList<Logger>();
        runningJobTasks = new LinkedList<CronJobTask>();
        lock = cronJobs;
    }

    private static class CronJobTask
    implements Runnable {
        private final CronJob job;
        private final Logger logger;
        private final int minute;
        private final int hour;
        private final int dayOfMonth;
        private final int month;
        private final int dayOfWeek;
        private final int year;

        private CronJobTask(CronJob job, Logger logger, int minute, int hour, int dayOfMonth, int month, int dayOfWeek, int year) {
            this.job = job;
            this.logger = logger;
            this.minute = minute;
            this.hour = hour;
            this.dayOfMonth = dayOfMonth;
            this.month = month;
            this.dayOfWeek = dayOfWeek;
            this.year = year;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread thread = Thread.currentThread();
                int oldPriority = thread.getPriority();
                int priority = this.job.getThreadPriority();
                try {
                    if (oldPriority != priority) {
                        try {
                            thread.setPriority(priority);
                        }
                        catch (SecurityException e) {
                            if (this.logger.isLoggable(Level.WARNING)) {
                                this.logger.log(Level.WARNING, "cron_job.name=" + this.job.getName(), e);
                            }
                            priority = oldPriority;
                        }
                    }
                    this.job.run(this.minute, this.hour, this.dayOfMonth, this.month, this.dayOfWeek, this.year);
                }
                finally {
                    block20: {
                        if (oldPriority != priority) {
                            try {
                                thread.setPriority(oldPriority);
                            }
                            catch (SecurityException e) {
                                if (!this.logger.isLoggable(Level.WARNING)) break block20;
                                this.logger.log(Level.WARNING, "cron_job.name=" + this.job.getName(), e);
                            }
                        }
                    }
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                if (this.logger.isLoggable(Level.SEVERE)) {
                    this.logger.log(Level.SEVERE, "cron_job.name=" + this.job.getName(), t);
                }
            }
            finally {
                CronDaemon.jobDone(this);
            }
        }
    }

    private static class Task
    implements Runnable {
        private final GregorianCalendar gcal = new GregorianCalendar();
        private int lastMinute = Integer.MIN_VALUE;
        private int lastHour = Integer.MIN_VALUE;
        private int lastDayOfMonth = Integer.MIN_VALUE;
        private int lastMonth = Integer.MIN_VALUE;
        private int lastDayOfWeek = Integer.MIN_VALUE;
        private int lastYear = Integer.MIN_VALUE;

        private Task() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            long sleepTime = 0L;
            try {
                while (sleepTime <= 0L) {
                    Object object = lock;
                    synchronized (object) {
                        if (task != this) {
                            return;
                        }
                    }
                    this.gcal.setTimeInMillis(System.currentTimeMillis());
                    int minute = this.gcal.get(12);
                    int hour = this.gcal.get(11);
                    int dayOfMonth = this.gcal.get(5);
                    int month = this.gcal.get(2);
                    int dayOfWeek = this.gcal.get(7);
                    int year = this.gcal.get(1);
                    if (minute == this.lastMinute && hour == this.lastHour && dayOfMonth == this.lastDayOfMonth && month == this.lastMonth && dayOfWeek == this.lastDayOfWeek && year == this.lastYear) {
                        sleepTime = 1000L;
                        continue;
                    }
                    Object object2 = lock;
                    synchronized (object2) {
                        int size = cronJobs.size();
                        for (int i = 0; i < size; ++i) {
                            CronJob job = (CronJob)cronJobs.get(i);
                            Logger jobLogger = (Logger)loggers.get(i);
                            try {
                                if (!job.getSchedule().isScheduled(minute, hour, dayOfMonth, month, dayOfWeek, year)) continue;
                                CronDaemon.runJob(job, jobLogger, minute, hour, dayOfMonth, month, dayOfWeek, year);
                                continue;
                            }
                            catch (ThreadDeath td) {
                                throw td;
                            }
                            catch (Throwable t) {
                                if (!jobLogger.isLoggable(Level.SEVERE)) continue;
                                jobLogger.log(Level.SEVERE, "cron_job.name=" + job.getName(), t);
                            }
                        }
                    }
                    this.lastMinute = minute;
                    this.lastHour = hour;
                    this.lastDayOfMonth = dayOfMonth;
                    this.lastMonth = month;
                    this.lastDayOfWeek = dayOfWeek;
                    this.lastYear = year;
                    this.gcal.add(12, 1);
                    this.gcal.set(13, 0);
                    this.gcal.set(14, 0);
                    sleepTime = this.gcal.getTimeInMillis() - System.currentTimeMillis();
                    if (sleepTime <= 60000L) continue;
                    sleepTime = 60000L;
                }
                return;
            }
            catch (ThreadDeath td) {
                sleepTime = 30000L;
                throw td;
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, null, t);
                sleepTime = 30000L;
                return;
            }
            finally {
                try {
                    logger.log(Level.FINER, "Resubmitting task with sleepTime = {0}", sleepTime);
                    assert (sleepTime > 0L);
                    Object t = lock;
                    synchronized (t) {
                        if (task == this && executors != null) {
                            future = executors.getUnbounded().submit((Runnable)this, sleepTime);
                        }
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Unable to resubmit task, cron daemon dying", t);
                }
            }
        }
    }
}

