/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.cron;

import com.aoapps.collections.AoCollections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class Matcher {
    private static final Map<String, Integer> monthNameMap = AoCollections.newHashMap((int)23);
    private static final Map<String, Integer> dayOfWeekNameMap;

    abstract int getStepOffset();

    public abstract boolean matches(int var1);

    public static Matcher parseMinute(String str) throws IllegalArgumentException {
        Map<String, Integer> nameMap = Collections.emptyMap();
        return Matcher.parseMatcher(str, 0, 59, 60, nameMap);
    }

    public static Matcher parseHour(String str) throws IllegalArgumentException {
        Map<String, Integer> nameMap = Collections.emptyMap();
        return Matcher.parseMatcher(str, 0, 23, 24, nameMap);
    }

    public static Matcher parseDayOfMonth(String str) throws IllegalArgumentException {
        Map<String, Integer> nameMap = Collections.emptyMap();
        return Matcher.parseMatcher(str, 1, 31, 32, nameMap);
    }

    public static Matcher parseMonth(String str) throws IllegalArgumentException {
        return Matcher.parseMatcher(str, 1, 12, 13, monthNameMap);
    }

    public static Matcher parseDayOfWeek(String str) throws IllegalArgumentException {
        return Matcher.parseMatcher(str, 0, 7, 7, dayOfWeekNameMap);
    }

    private static boolean assertAllKeysLowerCase(Map<String, ?> map) {
        for (String key : map.keySet()) {
            assert (key.equals(key.toLowerCase(Locale.ROOT)));
        }
        return true;
    }

    private static int parseInt(String str, Map<String, Integer> nameMap) throws NumberFormatException {
        assert (Matcher.assertAllKeysLowerCase(nameMap));
        Integer namedValue = nameMap.get(str.toLowerCase(Locale.ROOT));
        return namedValue != null ? namedValue : Integer.parseInt(str);
    }

    public static Matcher parseMatcher(String str, int minimum, int maximum, int modulus, Map<String, Integer> nameMap) throws IllegalArgumentException {
        if (str.indexOf(44) != -1) {
            ArrayList<Matcher> list = new ArrayList<Matcher>();
            StringTokenizer st = new StringTokenizer(str, ",");
            while (st.hasMoreTokens()) {
                list.add(Matcher.parseMatcher(st.nextToken(), minimum, maximum, modulus, nameMap));
            }
            return new List(list);
        }
        int pos = str.indexOf(47);
        if (pos != -1) {
            return new Step(Matcher.parseMatcher(str.substring(0, pos), minimum, maximum, modulus, nameMap), Integer.parseInt(str.substring(pos + 1)));
        }
        if ("*".equals(str)) {
            return new Asterisk(minimum);
        }
        pos = str.indexOf(45);
        if (pos != -1) {
            int begin = Matcher.parseInt(str.substring(0, pos), nameMap);
            if (begin < minimum || begin > maximum) {
                throw new IllegalArgumentException();
            }
            int end = Matcher.parseInt(str.substring(pos + 1), nameMap);
            if (end < minimum || end > maximum) {
                throw new IllegalArgumentException();
            }
            return new Range(begin % modulus, end % modulus);
        }
        int value = Matcher.parseInt(str, nameMap);
        if (value < minimum || value > maximum) {
            throw new IllegalArgumentException();
        }
        return new Value(value % modulus);
    }

    static {
        monthNameMap.put("jan", 1);
        monthNameMap.put("january", 1);
        monthNameMap.put("feb", 2);
        monthNameMap.put("february", 2);
        monthNameMap.put("mar", 3);
        monthNameMap.put("march", 3);
        monthNameMap.put("apr", 4);
        monthNameMap.put("april", 4);
        monthNameMap.put("may", 5);
        monthNameMap.put("jun", 6);
        monthNameMap.put("june", 6);
        monthNameMap.put("jul", 7);
        monthNameMap.put("july", 7);
        monthNameMap.put("aug", 8);
        monthNameMap.put("august", 8);
        monthNameMap.put("sep", 9);
        monthNameMap.put("september", 9);
        monthNameMap.put("oct", 10);
        monthNameMap.put("october", 10);
        monthNameMap.put("nov", 11);
        monthNameMap.put("november", 11);
        monthNameMap.put("dec", 12);
        monthNameMap.put("december", 12);
        dayOfWeekNameMap = AoCollections.newHashMap((int)14);
        dayOfWeekNameMap.put("sun", 0);
        dayOfWeekNameMap.put("sunday", 0);
        dayOfWeekNameMap.put("mon", 1);
        dayOfWeekNameMap.put("monday", 1);
        dayOfWeekNameMap.put("tue", 2);
        dayOfWeekNameMap.put("tuesday", 2);
        dayOfWeekNameMap.put("wed", 3);
        dayOfWeekNameMap.put("wednesday", 3);
        dayOfWeekNameMap.put("thu", 4);
        dayOfWeekNameMap.put("thursday", 4);
        dayOfWeekNameMap.put("fri", 5);
        dayOfWeekNameMap.put("friday", 5);
        dayOfWeekNameMap.put("sat", 6);
        dayOfWeekNameMap.put("saturday", 6);
    }

    public static class Value
    extends Matcher {
        private final int value;

        public Value(int value) {
            this.value = value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }

        @Override
        int getStepOffset() {
            return this.value;
        }

        @Override
        public boolean matches(int value) {
            return this.value == value;
        }
    }

    public static class Range
    extends Matcher {
        private final int begin;
        private final int end;

        public Range(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        public String toString() {
            return this.begin + "-" + this.end;
        }

        @Override
        int getStepOffset() {
            return this.begin;
        }

        @Override
        public boolean matches(int value) {
            if (this.begin <= this.end) {
                return value >= this.begin && value <= this.end;
            }
            return value >= this.begin || value <= this.end;
        }
    }

    public static class Asterisk
    extends Matcher {
        private final int stepOffset;

        public Asterisk(int stepOffset) {
            this.stepOffset = stepOffset;
        }

        public String toString() {
            return "*";
        }

        @Override
        int getStepOffset() {
            return this.stepOffset;
        }

        @Override
        public boolean matches(int value) {
            return true;
        }
    }

    public static class Step
    extends Matcher {
        private final Matcher matcher;
        private final int step;

        public Step(Matcher matcher, int step) {
            this.matcher = matcher;
            this.step = step;
        }

        public String toString() {
            return this.matcher + "/" + this.step;
        }

        @Override
        int getStepOffset() {
            throw new AssertionError();
        }

        @Override
        public boolean matches(int value) {
            return this.matcher.matches(value) && (value - this.matcher.getStepOffset()) % this.step == 0;
        }
    }

    public static class List
    extends Matcher {
        private final Matcher[] list;

        public List(Collection<Matcher> list) {
            this.list = list.toArray(new Matcher[list.size()]);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.list.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.list[i]);
            }
            return sb.toString();
        }

        @Override
        int getStepOffset() {
            throw new AssertionError();
        }

        @Override
        public boolean matches(int value) {
            for (Matcher matcher : this.list) {
                if (!matcher.matches(value)) continue;
                return true;
            }
            return false;
        }
    }
}

