/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang;

import com.aoapps.lang.Throwables;
import java.util.function.Function;

public final class AutoCloseables {
    private AutoCloseables() {
    }

    public static Throwable closeAndCatch(Throwable t0, AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                t0 = Throwables.addSuppressed(t0, t);
            }
        }
        return t0;
    }

    public static Throwable closeAndCatch(AutoCloseable closeable) {
        return AutoCloseables.closeAndCatch(null, closeable);
    }

    public static Throwable closeAndCatch(Throwable t0, AutoCloseable ... closeable) {
        if (closeable != null) {
            for (AutoCloseable ac : closeable) {
                t0 = AutoCloseables.closeAndCatch(t0, ac);
            }
        }
        return t0;
    }

    public static Throwable closeAndCatch(AutoCloseable ... closeable) {
        return AutoCloseables.closeAndCatch(null, closeable);
    }

    public static Throwable closeAndCatch(Throwable t0, Iterable<? extends AutoCloseable> closeable) {
        if (closeable != null) {
            for (AutoCloseable autoCloseable : closeable) {
                t0 = AutoCloseables.closeAndCatch(t0, autoCloseable);
            }
        }
        return t0;
    }

    public static Throwable closeAndCatch(Iterable<? extends AutoCloseable> closeable) {
        return AutoCloseables.closeAndCatch(null, closeable);
    }

    public static <X extends Throwable> void closeAndThrow(Throwable t0, Class<? extends X> xClass, Function<? super Throwable, ? extends X> xSupplier, AutoCloseable closeable) throws Error, RuntimeException, X {
        Throwable t = AutoCloseables.closeAndCatch(t0, closeable);
        if (t != null) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (xClass.isInstance(t)) {
                throw (Throwable)xClass.cast(t);
            }
            throw (Throwable)xSupplier.apply(t);
        }
    }

    public static <X extends Throwable> void closeAndThrow(Class<? extends X> xClass, Function<? super Throwable, ? extends X> xSupplier, AutoCloseable closeable) throws Error, RuntimeException, X {
        AutoCloseables.closeAndThrow(null, xClass, xSupplier, closeable);
    }

    public static <X extends Throwable> void closeAndThrow(Throwable t0, Class<? extends X> xClass, Function<? super Throwable, ? extends X> xSupplier, AutoCloseable ... closeable) throws Error, RuntimeException, X {
        Throwable t = AutoCloseables.closeAndCatch(t0, closeable);
        if (t != null) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (xClass.isInstance(t)) {
                throw (Throwable)xClass.cast(t);
            }
            throw (Throwable)xSupplier.apply(t);
        }
    }

    public static <X extends Throwable> void closeAndThrow(Class<? extends X> xClass, Function<? super Throwable, ? extends X> xSupplier, AutoCloseable ... closeable) throws Error, RuntimeException, X {
        AutoCloseables.closeAndThrow(null, xClass, xSupplier, closeable);
    }

    public static <X extends Throwable> void closeAndThrow(Throwable t0, Class<? extends X> xClass, Function<? super Throwable, ? extends X> xSupplier, Iterable<? extends AutoCloseable> closeable) throws Error, RuntimeException, X {
        Throwable t = AutoCloseables.closeAndCatch(t0, closeable);
        if (t != null) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (xClass.isInstance(t)) {
                throw (Throwable)xClass.cast(t);
            }
            throw (Throwable)xSupplier.apply(t);
        }
    }

    public static <X extends Throwable> void closeAndThrow(Class<? extends X> xClass, Function<? super Throwable, ? extends X> xSupplier, Iterable<? extends AutoCloseable> closeable) throws Error, RuntimeException, X {
        AutoCloseables.closeAndThrow(null, xClass, xSupplier, closeable);
    }

    public static <X extends Throwable> X closeAndWrap(Throwable t0, Class<? extends X> xClass, Function<? super Throwable, ? extends X> xSupplier, AutoCloseable closeable) {
        return Throwables.wrap(AutoCloseables.closeAndCatch(t0, closeable), xClass, xSupplier);
    }

    public static <X extends Throwable> X closeAndWrap(Throwable t0, Class<? extends X> xClass, Function<? super Throwable, ? extends X> xSupplier, AutoCloseable ... closeable) {
        return Throwables.wrap(AutoCloseables.closeAndCatch(t0, closeable), xClass, xSupplier);
    }

    public static <X extends Throwable> X closeAndWrap(Throwable t0, Class<? extends X> xClass, Function<? super Throwable, ? extends X> xSupplier, Iterable<? extends AutoCloseable> closeable) {
        return Throwables.wrap(AutoCloseables.closeAndCatch(t0, closeable), xClass, xSupplier);
    }
}

