/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang;

import com.aoapps.lang.CoercionOptimizer;
import com.aoapps.lang.CoercionOptimizerInitializer;
import com.aoapps.lang.Strings;
import com.aoapps.lang.exception.WrappedException;
import com.aoapps.lang.io.AppendableWriter;
import com.aoapps.lang.io.Encoder;
import com.aoapps.lang.io.EncoderWriter;
import com.aoapps.lang.io.Writable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.swing.text.Segment;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public final class Coercion {
    private static final Object optimizersLock = new Object();
    private static volatile CoercionOptimizer[] optimizers = new CoercionOptimizer[0];

    public static String toString(Object value) {
        while (value instanceof Optional) {
            value = ((Optional)value).orElse(null);
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Writable) {
            return value.toString();
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (value instanceof char[]) {
            char[] chs = (char[])value;
            return chs.length == 0 ? "" : new String(chs);
        }
        if (value instanceof Node) {
            try {
                TransformerFactory transFactory = TransformerFactory.newInstance();
                try {
                    transFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                catch (TransformerConfigurationException e) {
                    throw new AssertionError("All implementations are required to support the javax.xml.XMLConstants.FEATURE_SECURE_PROCESSING feature.", e);
                }
                transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                Transformer transformer = transFactory.newTransformer();
                StringWriter buffer = new StringWriter();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
                transformer.transform(new DOMSource((Node)value), new StreamResult(buffer));
                return buffer.toString();
            }
            catch (TransformerException e) {
                throw new WrappedException(e);
            }
        }
        return value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerOptimizer(CoercionOptimizer optimizer) {
        Object object = optimizersLock;
        synchronized (object) {
            CoercionOptimizer[] newOptimizer = Arrays.copyOf(optimizers, optimizers.length + 1);
            newOptimizer[newOptimizer.length - 1] = optimizer;
            optimizers = newOptimizer;
        }
    }

    private static Writer optimize(Writer out, Encoder encoder) throws IOException {
        while (true) {
            Writer newOut = out;
            for (CoercionOptimizer optimizer : optimizers) {
                newOut = optimizer.optimize(newOut, encoder);
            }
            if (newOut == out) {
                return out;
            }
            out = newOut;
        }
    }

    private static Appendable optimize(Appendable out, Encoder encoder) throws IOException {
        if (out instanceof Writer) {
            return Coercion.optimize((Writer)out, encoder);
        }
        return out;
    }

    public static void write(Object value, Writer out) throws IOException {
        while (value instanceof Optional) {
            value = ((Optional)value).orElse(null);
        }
        if (value != null) {
            assert (out != null);
            if (out instanceof EncoderWriter) {
                EncoderWriter encoderWriter = (EncoderWriter)out;
                Coercion.write(value, encoderWriter.getEncoder(), encoderWriter.getOut());
            } else {
                out = Coercion.optimize(out, null);
                if (value instanceof String) {
                    out.write((String)value);
                } else if (value instanceof Writable) {
                    Writable writable = (Writable)value;
                    if (writable.isFastToString()) {
                        out.write(writable.toString());
                    } else {
                        writable.writeTo(out);
                    }
                } else if (value instanceof Segment) {
                    Segment s = (Segment)value;
                    out.write(s.array, s.offset, s.count);
                } else if (value instanceof CharSequence) {
                    out.append((CharSequence)value);
                } else if (value instanceof char[]) {
                    out.write((char[])value);
                } else {
                    if (value instanceof Node) {
                        try {
                            TransformerFactory transFactory = TransformerFactory.newInstance();
                            try {
                                transFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                            }
                            catch (TransformerConfigurationException e) {
                                throw new AssertionError("All implementations are required to support the javax.xml.XMLConstants.FEATURE_SECURE_PROCESSING feature.", e);
                            }
                            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                            Transformer transformer = transFactory.newTransformer();
                            transformer.setOutputProperty("omit-xml-declaration", "yes");
                            transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
                            transformer.transform(new DOMSource((Node)value), new StreamResult(out));
                        }
                        catch (TransformerException e) {
                            throw new IOException(e);
                        }
                    }
                    out.write(value.toString());
                }
            }
        }
    }

    public static void write(Object value, Encoder encoder, Writer out) throws IOException {
        if (encoder == null) {
            Coercion.write(value, out);
        } else {
            while (value instanceof Optional) {
                value = ((Optional)value).orElse(null);
            }
            if (value != null) {
                out = Coercion.optimize(out, encoder);
                if (value instanceof String) {
                    encoder.write((String)value, out);
                } else if (value instanceof Writable) {
                    Writable writable = (Writable)value;
                    if (writable.isFastToString()) {
                        encoder.write(writable.toString(), out);
                    } else {
                        writable.writeTo(encoder, out);
                    }
                } else if (value instanceof Segment) {
                    Segment s = (Segment)value;
                    encoder.write(s.array, s.offset, s.count, out);
                } else if (value instanceof CharSequence) {
                    encoder.append((CharSequence)value, (Appendable)out);
                } else if (value instanceof char[]) {
                    encoder.write((char[])value, out);
                } else {
                    if (value instanceof Node) {
                        try {
                            TransformerFactory transFactory = TransformerFactory.newInstance();
                            try {
                                transFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                            }
                            catch (TransformerConfigurationException e) {
                                throw new AssertionError("All implementations are required to support the javax.xml.XMLConstants.FEATURE_SECURE_PROCESSING feature.", e);
                            }
                            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                            Transformer transformer = transFactory.newTransformer();
                            transformer.setOutputProperty("omit-xml-declaration", "yes");
                            transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
                            transformer.transform(new DOMSource((Node)value), new StreamResult(new EncoderWriter(encoder, out)));
                        }
                        catch (TransformerException e) {
                            throw new IOException(e);
                        }
                    }
                    encoder.write(value.toString(), out);
                }
            }
        }
    }

    public static void append(Object value, Appendable out) throws IOException {
        assert (out != null);
        if (out instanceof Writer) {
            Coercion.write(value, (Writer)out);
        } else {
            while (value instanceof Optional) {
                value = ((Optional)value).orElse(null);
            }
            if (value != null) {
                out = Coercion.optimize(out, null);
                if (value instanceof String) {
                    out.append((String)value);
                } else if (value instanceof Writable) {
                    Writable writable = (Writable)value;
                    if (writable.isFastToString()) {
                        out.append(writable.toString());
                    } else {
                        writable.appendTo(out);
                    }
                } else if (value instanceof CharSequence) {
                    out.append((CharSequence)value);
                } else if (value instanceof char[]) {
                    char[] chs = (char[])value;
                    int chsLen = chs.length;
                    if (chsLen > 0) {
                        out.append(new Segment(chs, 0, chsLen));
                    }
                } else {
                    if (value instanceof Node) {
                        try {
                            TransformerFactory transFactory = TransformerFactory.newInstance();
                            try {
                                transFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                            }
                            catch (TransformerConfigurationException e) {
                                throw new AssertionError("All implementations are required to support the javax.xml.XMLConstants.FEATURE_SECURE_PROCESSING feature.", e);
                            }
                            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                            Transformer transformer = transFactory.newTransformer();
                            transformer.setOutputProperty("omit-xml-declaration", "yes");
                            transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
                            transformer.transform(new DOMSource((Node)value), new StreamResult(AppendableWriter.wrap(out)));
                        }
                        catch (TransformerException e) {
                            throw new IOException(e);
                        }
                    }
                    out.append(value.toString());
                }
            }
        }
    }

    public static void append(Object value, Encoder encoder, Appendable out) throws IOException {
        if (encoder == null) {
            Coercion.append(value, out);
        } else if (out instanceof Writer) {
            Coercion.write(value, encoder, (Writer)out);
        } else {
            while (value instanceof Optional) {
                value = ((Optional)value).orElse(null);
            }
            if (value != null) {
                out = Coercion.optimize(out, encoder);
                if (value instanceof String) {
                    encoder.append((String)value, out);
                } else if (value instanceof Writable) {
                    Writable writable = (Writable)value;
                    if (writable.isFastToString()) {
                        encoder.append(writable.toString(), out);
                    } else {
                        writable.appendTo(encoder, out);
                    }
                } else if (value instanceof CharSequence) {
                    encoder.append((CharSequence)value, out);
                } else if (value instanceof char[]) {
                    char[] chs = (char[])value;
                    int chsLen = chs.length;
                    if (chsLen > 0) {
                        encoder.append(new Segment(chs, 0, chsLen), out);
                    }
                } else {
                    if (value instanceof Node) {
                        try {
                            TransformerFactory transFactory = TransformerFactory.newInstance();
                            try {
                                transFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                            }
                            catch (TransformerConfigurationException e) {
                                throw new AssertionError("All implementations are required to support the javax.xml.XMLConstants.FEATURE_SECURE_PROCESSING feature.", e);
                            }
                            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                            Transformer transformer = transFactory.newTransformer();
                            transformer.setOutputProperty("omit-xml-declaration", "yes");
                            transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
                            transformer.transform(new DOMSource((Node)value), new StreamResult(new EncoderWriter(encoder, AppendableWriter.wrap(out))));
                        }
                        catch (TransformerException e) {
                            throw new IOException(e);
                        }
                    }
                    encoder.append(value.toString(), out);
                }
            }
        }
    }

    public static boolean isEmpty(Object value) throws IOException {
        while (value instanceof Optional) {
            value = ((Optional)value).orElse(null);
        }
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        if (value instanceof Writable) {
            return ((Writable)value).getLength() == 0L;
        }
        if (value instanceof CharSequence) {
            return ((CharSequence)value).length() == 0;
        }
        if (value instanceof char[]) {
            return ((char[])value).length == 0;
        }
        if (value instanceof Node) {
            return false;
        }
        return value.toString().isEmpty();
    }

    public static Object nullIfEmpty(Object value) throws IOException {
        while (value instanceof Optional) {
            value = ((Optional)value).orElse(null);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Strings.nullIfEmpty((String)value);
        }
        if (value instanceof Writable) {
            return ((Writable)value).getLength() == 0L ? null : value;
        }
        if (value instanceof CharSequence) {
            return ((CharSequence)value).length() == 0 ? null : value;
        }
        if (value instanceof char[]) {
            return ((char[])value).length == 0 ? null : value;
        }
        if (value instanceof Node) {
            return value;
        }
        return Strings.nullIfEmpty(value.toString());
    }

    public static Object trim(Object value) throws IOException {
        while (value instanceof Optional) {
            value = ((Optional)value).orElse(null);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Strings.trim((String)value);
        }
        if (value instanceof Writable) {
            Writable writable = (Writable)value;
            if (writable.isFastToString()) {
                return Strings.trim(writable.toString());
            }
            return writable.trim();
        }
        if (value instanceof CharSequence) {
            CharSequence cs = Strings.trim((CharSequence)value);
            return cs.length() == 0 ? "" : cs;
        }
        if (value instanceof char[]) {
            char[] chs = (char[])value;
            int chsLen = chs.length;
            if (chsLen == 0) {
                return "";
            }
            CharSequence cs = Strings.trim(new Segment(chs, 0, chsLen));
            return cs.length() == 0 ? "" : (cs.length() == chsLen ? (Object)chs : cs);
        }
        if (value instanceof Node) {
            return value;
        }
        return Strings.trim(value.toString());
    }

    public static Object trimNullIfEmpty(Object value) throws IOException {
        while (value instanceof Optional) {
            value = ((Optional)value).orElse(null);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Strings.trimNullIfEmpty((String)value);
        }
        if (value instanceof Writable) {
            Writable writable = (Writable)value;
            if (writable.isFastToString()) {
                return Strings.trimNullIfEmpty(writable.toString());
            }
            return (writable = writable.trim()).getLength() == 0L ? null : writable;
        }
        if (value instanceof CharSequence) {
            return Strings.trimNullIfEmpty((CharSequence)value);
        }
        if (value instanceof char[]) {
            char[] chs = (char[])value;
            int chsLen = chs.length;
            if (chsLen == 0) {
                return null;
            }
            CharSequence cs = Strings.trimNullIfEmpty(new Segment(chs, 0, chsLen));
            return cs == null ? null : (cs.length() == chsLen ? chs : (char[])cs);
        }
        if (value instanceof Node) {
            return value;
        }
        return Strings.trimNullIfEmpty(value.toString());
    }

    private Coercion() {
    }

    static {
        for (CoercionOptimizerInitializer initializer : ServiceLoader.load(CoercionOptimizerInitializer.class)) {
            initializer.run();
        }
    }
}

