/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Properties;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Projects {
    private static final Logger logger = Logger.getLogger(Projects.class.getName());
    private static final Pattern RELEASE = Pattern.compile("(.+)-([0-9]+)$");

    private Projects() {
    }

    public static String readVersion(String resource, InputStream in, String groupId, String artifactId) throws IOException {
        String version = null;
        if (in != null) {
            Properties p = new Properties();
            p.load(in);
            assert (groupId.equals(p.getProperty("groupId")));
            assert (artifactId.equals(p.getProperty("artifactId")));
            version = p.getProperty("version");
            if (version != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Version \"" + version + "\" found from resource: " + resource);
                }
            } else if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Resource does not contain \"version\": " + resource);
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Resource not found: " + resource);
        }
        return version;
    }

    public static String readVersion(Function<String, InputStream> getResourceAsStream, String groupId, String artifactId) throws IOException {
        String resource = "/META-INF/maven/" + groupId + '/' + artifactId + "/pom.properties";
        try (InputStream in = getResourceAsStream.apply(resource);){
            String string = Projects.readVersion(resource, in, groupId, artifactId);
            return string;
        }
    }

    public static String getVersion(ClassLoader cl, String groupId, String artifactId) {
        try {
            return Projects.readVersion(cl == null ? ClassLoader::getSystemResourceAsStream : cl::getResourceAsStream, groupId, artifactId);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String getVersion(ClassLoader cl, String groupId, String artifactId, String def) {
        String version = Projects.getVersion(cl, groupId, artifactId);
        if (version == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Using provided default version for project \"" + groupId + ":" + artifactId + "\": " + def);
            }
            return def;
        }
        return version;
    }

    public static String getVersion(String groupId, String artifactId) {
        return Projects.getVersion(Projects.class.getClassLoader(), groupId, artifactId);
    }

    public static String getVersion(String groupId, String artifactId, String def) {
        String version = Projects.getVersion(groupId, artifactId);
        if (version == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Using provided default version for project \"" + groupId + ":" + artifactId + "\": " + def);
            }
            return def;
        }
        return version;
    }

    public static String getVersion(Package pk) {
        if (pk == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "No package provided");
            }
            return null;
        }
        String version = pk.getImplementationVersion();
        if (version != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Using implementation version \"" + version + "\" for package: " + pk);
            }
            return version;
        }
        version = pk.getSpecificationVersion();
        if (version != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Using specification version \"" + version + "\" for package: " + pk);
            }
            return version;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Did not find any version information for package: " + pk);
        }
        return null;
    }

    public static String getVersion(Package pk, String def) {
        String version = Projects.getVersion(pk);
        if (version == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Using provided default version for package \"" + pk + "\": " + def);
            }
            return def;
        }
        return version;
    }

    public static String getVersion(Class<?> clazz, String groupId, String artifactId) {
        try {
            String version = Projects.readVersion(clazz::getResourceAsStream, groupId, artifactId);
            if (version == null) {
                version = Projects.getVersion(clazz.getPackage());
            }
            return version;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String getVersion(Class<?> clazz, String groupId, String artifactId, String def) {
        String version = Projects.getVersion(clazz, groupId, artifactId);
        if (version == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Using provided default version for project \"" + groupId + ":" + artifactId + "\" or class \"" + clazz + "\": " + def);
            }
            return def;
        }
        return version;
    }

    public static String stripRelease(String version) {
        Matcher matcher = RELEASE.matcher(version);
        return matcher.matches() ? matcher.group(1) : version;
    }

    public static String getRelease(String version) {
        Matcher matcher = RELEASE.matcher(version);
        return matcher.matches() ? matcher.group(2) : null;
    }
}

