/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.concurrent;

public class ThreadLocalsRunnable
implements Runnable {
    private final Runnable task;
    private final ThreadLocal<?>[] threadLocals;
    private final Object[] values;

    public ThreadLocalsRunnable(Runnable task, ThreadLocal<?> ... threadLocals) {
        this.task = task;
        this.threadLocals = threadLocals;
        int len = threadLocals.length;
        Object[] vals = new Object[len];
        for (int i = 0; i < len; ++i) {
            vals[i] = threadLocals[i].get();
        }
        this.values = vals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ThreadLocal<?> tl;
        int i;
        ThreadLocal<?>[] tls = this.threadLocals;
        int len = tls.length;
        Object[] oldValues = new Object[len];
        for (int i2 = 0; i2 < len; ++i2) {
            oldValues[i2] = tls[i2].get();
        }
        Object[] newValues = this.values;
        try {
            for (i = 0; i < len; ++i) {
                Object newValue = newValues[i];
                if (oldValues[i] == newValue) continue;
                tl = tls[i];
                tl.set(newValue);
            }
            this.task.run();
        }
        finally {
            for (i = 0; i < len; ++i) {
                Object oldValue = oldValues[i];
                if (oldValue == newValues[i]) continue;
                tl = tls[i];
                tl.set(oldValue);
            }
        }
    }
}

