/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.i18n;

import com.aoapps.lang.i18n.ThreadLocale;
import java.util.Currency;
import java.util.Locale;

public class CurrencyUtil {
    private CurrencyUtil() {
    }

    public static String getSymbol(Currency currency, Locale locale) {
        String currencyCode;
        String symbol = currency.getSymbol(locale);
        if (symbol.equals(currencyCode = currency.getCurrencyCode())) {
            switch (currencyCode) {
                case "USD": {
                    return "$";
                }
                case "EUR": {
                    return "\u20ac";
                }
                case "JPY": {
                    return "\u00a5";
                }
                case "CAD": {
                    if (Locale.FRENCH.getLanguage().equals(locale.getLanguage())) {
                        return "$\u00a0CA";
                    }
                    return "Can$";
                }
            }
        }
        return symbol;
    }

    public static String getSymbol(Currency currency) {
        return CurrencyUtil.getSymbol(currency, ThreadLocale.get());
    }
}

