/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.i18n;

import com.aoapps.lang.NullArgumentException;
import java.util.Locale;

public class LocaleString {
    private final Locale locale;
    private final String value;

    public LocaleString(Locale locale, String value) {
        this.locale = NullArgumentException.checkNotNull(locale, "locale");
        this.value = NullArgumentException.checkNotNull(value, "value");
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LocaleString)) {
            return false;
        }
        LocaleString other = (LocaleString)obj;
        return this.locale.equals(other.locale) && this.value.equals(other.value);
    }

    public int hashCode() {
        int hash = this.locale.hashCode();
        hash = hash * 31 + this.value.hashCode();
        return hash;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getValue() {
        return this.value;
    }

    public LocaleString toLowerCase() {
        String newValue = this.value.toLowerCase(this.locale);
        return newValue == this.value ? this : new LocaleString(this.locale, newValue);
    }

    public LocaleString toUpperCase() {
        String newValue = this.value.toUpperCase(this.locale);
        return newValue == this.value ? this : new LocaleString(this.locale, newValue);
    }

    public LocaleString trim() {
        String newValue = this.value.trim();
        return newValue == this.value ? this : new LocaleString(this.locale, newValue);
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public boolean startsWith(String prefix) {
        return this.value.startsWith(prefix);
    }

    public boolean startsWith(String prefix, int offset) {
        return this.value.startsWith(prefix, offset);
    }

    public boolean endsWith(String prefix) {
        return this.value.endsWith(prefix);
    }
}

