/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.i18n;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Locales {
    @Deprecated
    public static final Locale ROOT = Locale.ROOT;
    public static final Locale ARABIC = Locales.parseLocale("ar");
    public static final Locale BULGARIAN = Locales.parseLocale("bg");
    public static final Locale CATALAN = Locales.parseLocale("ca");
    public static final Locale CZECH = Locales.parseLocale("cs");
    public static final Locale DANISH = Locales.parseLocale("da");
    @Deprecated
    public static final Locale GERMAN = Locale.GERMAN;
    public static final Locale GREEK = Locales.parseLocale("el");
    @Deprecated
    public static final Locale ENGLISH = Locale.ENGLISH;
    public static final Locale SPANISH = Locales.parseLocale("es");
    public static final Locale ESTONIAN = Locales.parseLocale("et");
    public static final Locale PERSIAN = Locales.parseLocale("fa");
    public static final Locale FINNISH = Locales.parseLocale("fi");
    @Deprecated
    public static final Locale FRENCH = Locale.FRENCH;
    public static final Locale HINDI = Locales.parseLocale("hi");
    public static final Locale CROATIAN = Locales.parseLocale("hr");
    public static final Locale HUNGARIAN = Locales.parseLocale("hu");
    public static final Locale INDONESIAN = Locales.parseLocale("in");
    public static final Locale ICELANDIC = Locales.parseLocale("is");
    @Deprecated
    public static final Locale ITALIAN = Locale.ITALIAN;
    @Deprecated
    public static final Locale JAPANESE = Locale.JAPANESE;
    @Deprecated
    public static final Locale KOREAN = Locale.KOREAN;
    public static final Locale HEBREW = Locales.parseLocale("iw");
    public static final Locale LITHUANIAN = Locales.parseLocale("lt");
    public static final Locale LATVIAN = Locales.parseLocale("lv");
    public static final Locale DUTCH = Locales.parseLocale("nl");
    public static final Locale NORWEGIAN = Locales.parseLocale("no");
    public static final Locale POLISH = Locales.parseLocale("pl");
    public static final Locale PORTUGUESE = Locales.parseLocale("pt");
    public static final Locale ROMANIAN = Locales.parseLocale("ro");
    public static final Locale RUSSIAN = Locales.parseLocale("ru");
    public static final Locale SLOVAK = Locales.parseLocale("sk");
    public static final Locale SLOVENIAN = Locales.parseLocale("sl");
    public static final Locale SERBIAN = Locales.parseLocale("sr");
    public static final Locale SWEDISH = Locales.parseLocale("sv");
    public static final Locale TURKISH = Locales.parseLocale("tr");
    @Deprecated
    public static final Locale CHINESE = Locale.CHINESE;
    @Deprecated
    public static final Locale SIMPLIFIED_CHINESE = Locale.SIMPLIFIED_CHINESE;
    @Deprecated
    public static final Locale TRADITIONAL_CHINESE = Locale.TRADITIONAL_CHINESE;
    @Deprecated
    public static final Locale FRANCE = Locale.FRANCE;
    @Deprecated
    public static final Locale GERMANY = Locale.GERMANY;
    @Deprecated
    public static final Locale ITALY = Locale.ITALY;
    @Deprecated
    public static final Locale JAPAN = Locale.JAPAN;
    @Deprecated
    public static final Locale KOREA = Locale.KOREA;
    @Deprecated
    public static final Locale CHINA = Locale.CHINA;
    @Deprecated
    public static final Locale PRC = Locale.PRC;
    @Deprecated
    public static final Locale TAIWAN = Locale.TAIWAN;
    @Deprecated
    public static final Locale UK = Locale.UK;
    @Deprecated
    public static final Locale US = Locale.US;
    @Deprecated
    public static final Locale CANADA = Locale.CANADA;
    @Deprecated
    public static final Locale CANADA_FRENCH = Locale.CANADA_FRENCH;

    private Locales() {
    }

    public static Locale getCachedLocale(String language, String country, String variant) {
        return LocaleCache.getCachedLocale(language, country, variant);
    }

    private static int indexOfSeparator(String locale, int fromIndex) {
        int pos1 = locale.indexOf(95, fromIndex);
        int pos2 = locale.indexOf(45, fromIndex);
        if (pos1 == -1) {
            return pos2;
        }
        if (pos2 == -1) {
            return pos1;
        }
        return Math.min(pos1, pos2);
    }

    public static Locale parseLocale(String locale) {
        int pos = Locales.indexOfSeparator(locale, 0);
        if (pos == -1) {
            return Locales.getCachedLocale(locale, "", "");
        }
        int pos2 = Locales.indexOfSeparator(locale, pos + 1);
        if (pos2 == -1) {
            return Locales.getCachedLocale(locale.substring(0, pos).toLowerCase(Locale.ROOT), locale.substring(pos + 1).toUpperCase(Locale.ROOT), "");
        }
        return Locales.getCachedLocale(locale.substring(0, pos).toLowerCase(Locale.ROOT), locale.substring(pos + 1, pos2).toUpperCase(Locale.ROOT), locale.substring(pos2 + 1));
    }

    public static boolean isRightToLeft(Locale locale) {
        String language = locale.getLanguage();
        return "ar".equals(language) || "iw".equals(language) || "fa".equals(language);
    }

    private static class LocaleCache {
        private static final ConcurrentMap<CacheKey, Locale> locales = new ConcurrentHashMap<CacheKey, Locale>(16, 0.75f, 1);

        private static Locale getCachedLocale(String language, String country, String variant) {
            Locale existing;
            CacheKey key = new CacheKey(language = language.toLowerCase(Locale.ROOT), country = country.toUpperCase(Locale.ROOT), variant);
            Locale locale = (Locale)locales.get(key);
            if (locale == null && (existing = locales.putIfAbsent(key, locale = new Locale(language, country, variant))) != null) {
                locale = existing;
            }
            return locale;
        }

        private LocaleCache() {
        }

        static {
            for (Locale locale : Locale.getAvailableLocales()) {
                if (!locale.getScript().isEmpty() || !locale.getExtensionKeys().isEmpty()) continue;
                locales.put(new CacheKey(locale.getLanguage(), locale.getCountry(), locale.getVariant()), locale);
            }
        }

        private static class CacheKey {
            private final String language;
            private final String country;
            private final String variant;

            private CacheKey(String language, String country, String variant) {
                this.language = language;
                this.country = country;
                this.variant = variant;
            }

            public boolean equals(Object o) {
                if (!(o instanceof CacheKey)) {
                    return false;
                }
                CacheKey other = (CacheKey)o;
                return this.language.equals(other.language) && this.country.equals(other.country) && this.variant.equals(other.variant);
            }

            public int hashCode() {
                int hash = this.language.hashCode();
                hash = hash * 31 + this.country.hashCode();
                hash = hash * 31 + this.variant.hashCode();
                return hash;
            }
        }
    }
}

