/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.i18n;

import com.aoapps.lang.i18n.CurrencyComparator;
import com.aoapps.lang.i18n.Money;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class Monies
implements Comparable<Monies>,
Iterable<Money> {
    private static final Monies EMPTY_MONIES = new Monies(Collections.emptyMap());
    private final Map<Currency, Money> monies;

    private static void add(Map<Currency, Money> monies, Money addend) {
        Currency currency = addend.getCurrency();
        Money total = monies.get(currency);
        total = total == null ? addend : total.add(addend);
        monies.put(currency, total);
    }

    private static void subtract(Map<Currency, Money> monies, Money subtrahend) {
        Currency currency = subtrahend.getCurrency();
        Money total = monies.get(currency);
        total = total == null ? subtrahend : total.subtract(subtrahend);
        monies.put(currency, total);
    }

    public static Monies of() {
        return EMPTY_MONIES;
    }

    public static Monies of(Money money) {
        if (money == null) {
            return Monies.of();
        }
        return new Monies(Collections.singletonMap(money.getCurrency(), money));
    }

    private static Monies of(SortedMap<Currency, Money> newMap) {
        int size = newMap.size();
        if (size == 0) {
            return Monies.of();
        }
        if (size == 1) {
            return Monies.of(newMap.values().iterator().next());
        }
        return new Monies(Collections.unmodifiableMap(newMap));
    }

    public static Monies of(Money ... monies) {
        if (monies == null || monies.length == 0) {
            return Monies.of();
        }
        if (monies.length == 1) {
            return Monies.of(monies[0]);
        }
        TreeMap<Currency, Money> newMap = new TreeMap<Currency, Money>(CurrencyComparator.getInstance());
        for (Money m : monies) {
            if (m == null) continue;
            Monies.add(newMap, m);
        }
        return Monies.of(newMap);
    }

    public static Monies of(Iterable<Money> monies) {
        if (monies == null) {
            return Monies.of();
        }
        TreeMap<Currency, Money> newMap = new TreeMap<Currency, Money>(CurrencyComparator.getInstance());
        for (Money m : monies) {
            if (m == null) continue;
            Monies.add(newMap, m);
        }
        return Monies.of(newMap);
    }

    private Monies(Map<Currency, Money> monies) {
        this.monies = monies;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Monies)) {
            return false;
        }
        Monies other = (Monies)o;
        return this.monies.equals(other.monies);
    }

    public int hashCode() {
        return this.monies.hashCode();
    }

    private static int compare(Money m1, Money m2) {
        if (m1 == null) {
            if (m2 == null) {
                return 0;
            }
            return Long.compare(0L, m2.getUnscaledValue());
        }
        if (m2 == null) {
            return Long.compare(m1.getUnscaledValue(), 0L);
        }
        return m1.compareTo(m2);
    }

    @Override
    public int compareTo(Monies o) {
        HashSet<Currency> currencies = new HashSet<Currency>();
        currencies.addAll(this.monies.keySet());
        currencies.addAll(o.monies.keySet());
        boolean isLessThan = false;
        boolean isMoreThan = false;
        for (Currency currency : currencies) {
            int diff = Monies.compare(this.monies.get(currency), o.monies.get(currency));
            if (diff < 0) {
                if (isMoreThan) {
                    throw new IllegalArgumentException("Incomparable monies, both less-than and greater-than: " + this + " and " + o);
                }
                isLessThan = true;
                continue;
            }
            if (diff <= 0) continue;
            if (isLessThan) {
                throw new IllegalArgumentException("Incomparable monies, both less-than and greater-than: " + this + " and " + o);
            }
            isMoreThan = true;
        }
        if (isLessThan) {
            return -1;
        }
        if (isMoreThan) {
            return 1;
        }
        return 0;
    }

    @Override
    public Iterator<Money> iterator() {
        return this.getValues().iterator();
    }

    public Money get(Currency currency) {
        return this.monies.get(currency);
    }

    public Map<Currency, Money> getMap() {
        return this.monies;
    }

    public boolean isEmpty() {
        return this.monies.isEmpty();
    }

    public int size() {
        return this.monies.size();
    }

    public Set<Currency> getCurrencies() {
        return this.monies.keySet();
    }

    public Collection<Money> getValues() {
        return this.monies.values();
    }

    public String toString() {
        int size = this.monies.size();
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            return this.monies.values().iterator().next().toString();
        }
        StringBuilder sb = new StringBuilder();
        for (Money money : this.monies.values()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(money);
        }
        return sb.toString();
    }

    public Monies add(Money addend) throws ArithmeticException {
        if (addend == null) {
            return this;
        }
        TreeMap<Currency, Money> newMap = new TreeMap<Currency, Money>(CurrencyComparator.getInstance());
        newMap.putAll(this.monies);
        Monies.add(newMap, addend);
        return Monies.of(newMap);
    }

    public Monies add(Monies addend) throws ArithmeticException {
        if (addend == null) {
            return this;
        }
        TreeMap<Currency, Money> newMap = new TreeMap<Currency, Money>(CurrencyComparator.getInstance());
        newMap.putAll(this.monies);
        for (Money money : addend) {
            Monies.add(newMap, money);
        }
        return Monies.of(newMap);
    }

    public Monies multiply(BigDecimal multiplicand) throws ArithmeticException {
        TreeMap<Currency, Money> newMap = new TreeMap<Currency, Money>(CurrencyComparator.getInstance());
        for (Money money : this.monies.values()) {
            Currency currency = money.getCurrency();
            newMap.put(currency, money.multiply(multiplicand));
        }
        return Monies.of(newMap);
    }

    public Monies multiply(BigDecimal multiplicand, RoundingMode roundingMode) throws ArithmeticException {
        TreeMap<Currency, Money> newMap = new TreeMap<Currency, Money>(CurrencyComparator.getInstance());
        for (Money money : this.monies.values()) {
            Currency currency = money.getCurrency();
            newMap.put(currency, money.multiply(multiplicand, roundingMode));
        }
        return Monies.of(newMap);
    }

    public Monies negate() {
        TreeMap<Currency, Money> newMap = new TreeMap<Currency, Money>(CurrencyComparator.getInstance());
        for (Money money : this.monies.values()) {
            Currency currency = money.getCurrency();
            newMap.put(currency, money.negate());
        }
        return Monies.of(newMap);
    }

    public Monies subtract(Money subtrahend) throws ArithmeticException {
        if (subtrahend == null) {
            return this;
        }
        TreeMap<Currency, Money> newMap = new TreeMap<Currency, Money>(CurrencyComparator.getInstance());
        newMap.putAll(this.monies);
        Monies.subtract(newMap, subtrahend);
        return Monies.of(newMap);
    }

    public Monies subtract(Monies subtrahend) throws ArithmeticException {
        if (subtrahend == null) {
            return this;
        }
        TreeMap<Currency, Money> newMap = new TreeMap<Currency, Money>(CurrencyComparator.getInstance());
        newMap.putAll(this.monies);
        for (Money money : subtrahend) {
            Monies.subtract(newMap, money);
        }
        return Monies.of(newMap);
    }

    public boolean isZero() {
        for (Money money : this.monies.values()) {
            if (money.getUnscaledValue() == 0L) continue;
            return false;
        }
        return true;
    }

    public Monies removeZeros() {
        boolean hasZero = false;
        for (Money money : this.monies.values()) {
            if (money.getUnscaledValue() != 0L) continue;
            hasZero = true;
            break;
        }
        if (!hasZero) {
            return this;
        }
        TreeMap<Currency, Money> newMap = new TreeMap<Currency, Money>(CurrencyComparator.getInstance());
        for (Money money : this.monies.values()) {
            if (money.getUnscaledValue() == 0L) continue;
            newMap.put(money.getCurrency(), money);
        }
        return Monies.of(newMap);
    }
}

