/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.i18n;

import com.aoapps.lang.function.SerializableBiFunction;
import com.aoapps.lang.i18n.ThreadLocale;
import com.aoapps.lang.text.MessageFormatFactory;
import java.io.Serializable;
import java.text.FieldPosition;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Resources
implements Serializable {
    private static final Logger logger = Logger.getLogger(Resources.class.getName());
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String DEFAULT_SUBPACKAGE = "i18n";
    public static final String DEFAULT_NAME = "ApplicationResources";
    private static final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private static final long serialVersionUID = 2L;
    private final SerializableBiFunction<String, Locale, ResourceBundle> bundleAccessor;
    private final String baseName;
    private final String prefix;

    @Deprecated
    public static Resources getResources(SerializableBiFunction<String, Locale, ResourceBundle> bundleAccessor, String baseName, String prefix) {
        return new Resources(bundleAccessor, baseName, prefix);
    }

    @Deprecated
    public static Resources getResources(String baseName, String prefix) {
        return Resources.getResources((SerializableBiFunction<String, Locale, ResourceBundle>)null, baseName, prefix);
    }

    @Deprecated
    public static Resources getResources(SerializableBiFunction<String, Locale, ResourceBundle> bundleAccessor, String baseName) {
        return Resources.getResources(bundleAccessor, baseName, null);
    }

    @Deprecated
    public static Resources getResources(String baseName) {
        return Resources.getResources((SerializableBiFunction<String, Locale, ResourceBundle>)null, baseName, null);
    }

    public static Resources getResources(SerializableBiFunction<String, Locale, ResourceBundle> bundleAccessor, Package pack, String name, String prefix) {
        return Resources.getResources(bundleAccessor, name == null ? pack.getName() + "." + DEFAULT_SUBPACKAGE + "." + DEFAULT_NAME : pack.getName() + '.' + name, prefix);
    }

    @Deprecated
    public static Resources getResources(Package pack, String name, String prefix) {
        return Resources.getResources(null, pack, name, prefix);
    }

    public static Resources getResources(SerializableBiFunction<String, Locale, ResourceBundle> bundleAccessor, Package pack, String name) {
        return Resources.getResources(bundleAccessor, pack, name, null);
    }

    @Deprecated
    public static Resources getResources(Package pack, String name) {
        return Resources.getResources(null, pack, name, null);
    }

    public static Resources getResources(SerializableBiFunction<String, Locale, ResourceBundle> bundleAccessor, Package pack) {
        return Resources.getResources(bundleAccessor, pack, null, null);
    }

    @Deprecated
    public static Resources getResources(Package pack) {
        return Resources.getResources(pack, null, null);
    }

    public static Resources getResources(SerializableBiFunction<String, Locale, ResourceBundle> bundleAccessor, Class<?> clazz) {
        return Resources.getResources(bundleAccessor, clazz.getPackage(), null, clazz.getSimpleName() + '.');
    }

    @Deprecated
    public static Resources getResources(Class<?> clazz) {
        return Resources.getResources(null, clazz.getPackage(), null, clazz.getSimpleName() + '.');
    }

    public static void addListener(Listener listener) {
        if (listener != null) {
            listeners.add(listener);
        }
    }

    public static void removeListener(Listener listener) {
        Iterator<Listener> iter = listeners.iterator();
        while (iter.hasNext()) {
            if (iter.next() != listener) continue;
            iter.remove();
        }
    }

    private Resources(SerializableBiFunction<String, Locale, ResourceBundle> bundleAccessor, String baseName, String prefix) {
        this.bundleAccessor = bundleAccessor;
        this.baseName = Objects.requireNonNull(baseName);
        if (prefix != null && prefix.isEmpty()) {
            prefix = null;
        }
        this.prefix = prefix;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getPrefix() {
        return this.prefix == null ? "" : this.prefix;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return this.bundleAccessor != null ? (ResourceBundle)this.bundleAccessor.apply(this.baseName, locale) : ResourceBundle.getBundle(this.baseName, locale);
    }

    public ResourceBundle getResourceBundle() {
        return this.getResourceBundle(ThreadLocale.get());
    }

    public String getMessage(Locale locale, String key, Object ... args) {
        String resource;
        block8: {
            if (args == null) {
                args = EMPTY_OBJECT_ARRAY;
            }
            if (this.prefix != null) {
                key = this.prefix + key;
            }
            resource = null;
            try {
                resource = this.getResourceBundle(locale).getString(key);
                if (resource == null && logger.isLoggable(Level.FINE)) {
                    logger.fine("Bundle lookup failed: baseName = \"" + this.baseName + "\", locale = \"" + locale + "\", key = \"" + key + '\"');
                }
            }
            catch (MissingResourceException err) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Bundle lookup failed: baseName = \"" + this.baseName + "\", locale = \"" + locale + "\", key = \"" + key + '\"', err);
                }
                if (!logger.isLoggable(Level.FINE)) break block8;
                logger.fine("Bundle lookup failed: baseName = \"" + this.baseName + "\", locale = \"" + locale + "\", key = \"" + key + "\" (enable FINER logging for stack trace)");
            }
        }
        if (resource == null) {
            return "???" + locale.toString() + '.' + key + "???";
        }
        String result = args.length == 0 ? new String(resource) : MessageFormatFactory.getMessageFormat(resource, locale).format(args, new StringBuffer(resource.length() << 1), (FieldPosition)null).toString();
        for (Listener l : listeners) {
            l.onGetMessage(this, locale, key, args, resource, result);
        }
        return result;
    }

    public String getMessage(Locale locale, String key) {
        return this.getMessage(locale, key, EMPTY_OBJECT_ARRAY);
    }

    public String getMessage(String key, Object ... args) {
        return this.getMessage(ThreadLocale.get(), key, args);
    }

    public String getMessage(String key) {
        return this.getMessage(ThreadLocale.get(), key, EMPTY_OBJECT_ARRAY);
    }

    @FunctionalInterface
    public static interface Listener {
        public void onGetMessage(Resources var1, Locale var2, String var3, Object[] var4, String var5, String var6);
    }
}

