/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.io;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import javax.swing.text.Segment;

public class AppendableWriter
extends Writer {
    private final Appendable out;

    public static Writer wrap(Appendable out) {
        if (out instanceof Writer) {
            return (Writer)out;
        }
        return new AppendableWriter(out);
    }

    public AppendableWriter(Appendable out) {
        this.out = out;
    }

    public Appendable getOut() {
        return this.out;
    }

    @Override
    public void write(int c) throws IOException {
        this.out.append((char)c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.out.append(new Segment(cbuf, 0, cbuf.length));
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.out.append(new Segment(cbuf, off, len));
    }

    @Override
    public void write(String str) throws IOException {
        this.out.append(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.out.append(str, off, off + len);
    }

    @Override
    public AppendableWriter append(CharSequence csq) throws IOException {
        this.out.append(csq);
        return this;
    }

    @Override
    public AppendableWriter append(CharSequence csq, int start, int end) throws IOException {
        this.out.append(csq, start, end);
        return this;
    }

    @Override
    public AppendableWriter append(char c) throws IOException {
        this.out.append(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
        if (this.out instanceof Flushable) {
            ((Flushable)((Object)this.out)).flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out instanceof Closeable) {
            ((Closeable)((Object)this.out)).close();
        }
    }
}

