/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.io;

import com.aoapps.lang.io.IoUtils;
import com.aoapps.lang.util.BufferManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public final class FileUtils {
    private FileUtils() {
    }

    @Deprecated
    public static void delete(File file) throws IOException {
        Files.delete(file.toPath());
    }

    @Deprecated
    public static void deleteRecursive(File file) throws IOException {
        Path deleteMe = file.toPath();
        Files.walkFileTree(deleteMe, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    throw exc;
                }
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
        assert (!Files.exists(deleteMe, LinkOption.NOFOLLOW_LINKS));
    }

    public static boolean contentEquals(File file, byte[] contents) throws IOException {
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            return false;
        }
        if (length != 0L && length != (long)contents.length) {
            return false;
        }
        try (FileInputStream in = new FileInputStream(file);){
            boolean bl = IoUtils.contentEquals(in, contents);
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean contentEquals(File file1, File file2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int contentHashCode(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            int readVal;
            int result = 1;
            while ((readVal = ((InputStream)in).read()) != -1) {
                result = 31 * result + (byte)readVal;
            }
            int n = result;
            return n;
        }
    }

    @Deprecated
    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        return FileUtils.createTempDirectory(prefix, suffix, null);
    }

    @Deprecated
    public static File createTempDirectory(String prefix, String suffix, File directory) throws IOException {
        File tempFile;
        do {
            tempFile = File.createTempFile(prefix, suffix, directory);
            Files.delete(tempFile.toPath());
        } while (!tempFile.mkdir());
        return tempFile;
    }

    public static long copyToFile(InputStream in, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            long l = IoUtils.copy(in, out);
            return l;
        }
    }

    public static File copyToTempFile(InputStream in, String prefix, String suffix) throws IOException {
        return FileUtils.copyToTempFile(in, prefix, suffix, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyToTempFile(InputStream in, String prefix, String suffix, File directory) throws IOException {
        Path tmpPath = Files.createTempFile("cache_", null, new FileAttribute[0]);
        File tmpFile = tmpPath.toFile();
        boolean successful = false;
        try {
            FileUtils.copyToFile(in, tmpFile);
            successful = true;
            File file = tmpFile;
            return file;
        }
        finally {
            if (!successful) {
                Files.delete(tmpPath);
            }
        }
    }

    @Deprecated
    public static File mkdir(File directory) throws IOException {
        return Files.createDirectory(directory.toPath(), new FileAttribute[0]).toFile();
    }

    @Deprecated
    public static File mkdirs(File directory) throws IOException {
        return Files.createDirectories(directory.toPath(), new FileAttribute[0]).toFile();
    }

    public static File checkIsDirectory(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new IOException("Not a directory: " + directory.getPath());
        }
        return directory;
    }

    public static long copy(File from, File to) throws IOException {
        try (FileInputStream in = new FileInputStream(from);){
            long modified = from.lastModified();
            long bytes = FileUtils.copyToFile(in, to);
            if (modified != 0L) {
                to.setLastModified(modified);
            }
            long l = bytes;
            return l;
        }
    }

    public static long copy(File from, OutputStream out) throws IOException {
        try (FileInputStream in = new FileInputStream(from);){
            long l = IoUtils.copy(in, out);
            return l;
        }
    }

    public static long copy(File from, Writer out) throws IOException {
        try (FileReader in = new FileReader(from);){
            long l = IoUtils.copy((Reader)in, out);
            return l;
        }
    }

    public static long copy(File from, Appendable out) throws IOException {
        try (FileReader in = new FileReader(from);){
            long l = IoUtils.copy((Reader)in, out);
            return l;
        }
    }

    public static void copyRecursive(File from, File to) throws IOException {
        FileUtils.copyRecursive(from, to, null);
    }

    public static void copyRecursive(File from, File to, FileFilter fileFilter) throws IOException {
        if (fileFilter == null || fileFilter.accept(from)) {
            if (from.isDirectory()) {
                if (to.exists()) {
                    throw new IOException("Directory exists: " + to);
                }
                long modified = from.lastModified();
                Files.createDirectory(to.toPath(), new FileAttribute[0]).toFile();
                String[] list = from.list();
                if (list != null) {
                    for (String child : list) {
                        FileUtils.copyRecursive(new File(from, child), new File(to, child), fileFilter);
                    }
                }
                if (modified != 0L) {
                    to.setLastModified(modified);
                }
            } else if (from.isFile()) {
                if (to.exists()) {
                    throw new IOException("File exists: " + to);
                }
                FileUtils.copy(from, to);
            } else {
                throw new IOException("Neither directory not file: " + to);
            }
        }
    }

    public static String getExtension(String path) {
        int pos = path.lastIndexOf(46);
        if (pos < 1) {
            return "";
        }
        int pos2 = path.indexOf(47, pos + 1);
        if (pos2 != -1) {
            return "";
        }
        return path.substring(pos + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static File getFile(URL url, String urlEncoding, boolean deleteOnExit) throws IOException {
        File file;
        String path;
        if ("file".equalsIgnoreCase(url.getProtocol()) && (path = url.getFile()).length() > 0 && (file = new File(URLDecoder.decode(path, urlEncoding).replace('/', File.separatorChar))).exists() && file.isFile()) {
            return file;
        }
        Path tmpPath = Files.createTempFile("url", null, new FileAttribute[0]);
        File tmpFile = tmpPath.toFile();
        boolean successful = false;
        try {
            if (deleteOnExit) {
                tmpFile.deleteOnExit();
            }
            try (InputStream in = url.openStream();){
                FileUtils.copyToFile(in, tmpFile);
            }
            successful = true;
            File file2 = tmpFile;
            return file2;
        }
        finally {
            if (!successful) {
                Files.delete(tmpPath);
            }
        }
    }

    public static void rename(File from, File to) throws IOException {
        if (!from.renameTo(to)) {
            throw new IOException("Unable to atomically rename \"" + from + "\" to \"" + to + '\"');
        }
    }

    public static void renameAllowNonAtomic(File from, File to) throws IOException {
        if (!from.renameTo(to)) {
            try {
                FileUtils.copy(from, to);
                Files.delete(from.toPath());
            }
            catch (IOException e) {
                throw new IOException("Unable to non-atomically rename \"" + from + "\" to \"" + to + '\"', e);
            }
        }
    }

    public static String readFileAsString(File file) throws IOException {
        return FileUtils.readFileAsString(file, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(File file, Charset charset) throws IOException {
        long len = file.length();
        StringBuilder SB = len > 0L && len <= Integer.MAX_VALUE ? new StringBuilder((int)len) : new StringBuilder();
        try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), charset);){
            char[] buff = BufferManager.getChars();
            try {
                int numChars;
                while ((numChars = ((Reader)in).read(buff, 0, 4096)) != -1) {
                    SB.append(buff, 0, numChars);
                }
            }
            finally {
                BufferManager.release(buff, false);
            }
        }
        return SB.toString();
    }
}

