/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.io;

import com.aoapps.lang.EmptyArrays;
import com.aoapps.lang.Throwables;
import com.aoapps.lang.exception.LocalizedException;
import com.aoapps.lang.i18n.Resources;
import java.io.IOException;
import java.io.Serializable;

public class LocalizedIOException
extends IOException
implements LocalizedException {
    private static final long serialVersionUID = 3L;
    protected final Resources resources;
    protected final String key;
    protected final Serializable[] args;

    public LocalizedIOException(Resources resources, String key) {
        super(resources.getMessage(key));
        this.resources = resources;
        this.key = key;
        this.args = EmptyArrays.EMPTY_SERIALIZABLE_ARRAY;
    }

    public LocalizedIOException(Resources resources, String key, Serializable ... args) {
        super(resources.getMessage(key, args));
        this.resources = resources;
        this.key = key;
        this.args = args;
    }

    public LocalizedIOException(Throwable cause, Resources resources, String key) {
        super(resources.getMessage(key), cause);
        this.resources = resources;
        this.key = key;
        this.args = EmptyArrays.EMPTY_SERIALIZABLE_ARRAY;
    }

    public LocalizedIOException(Throwable cause, Resources resources, String key, Serializable ... args) {
        super(resources.getMessage(key, args), cause);
        this.resources = resources;
        this.key = key;
        this.args = args;
    }

    @Override
    public String getLocalizedMessage() {
        return this.resources.getMessage(this.key, this.args);
    }

    @Override
    public final Resources getResources() {
        return this.resources;
    }

    @Override
    public final String getKey() {
        return this.key;
    }

    @Override
    public final Serializable[] getArgs() {
        return this.args;
    }

    static {
        Throwables.registerSurrogateFactory(LocalizedIOException.class, (template, cause) -> new LocalizedIOException(cause, template.resources, template.key, template.args));
    }
}

