/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.io.function;

import java.io.IOException;
import java.util.Objects;

@FunctionalInterface
public interface IOPredicateE<T, Ex extends Throwable> {
    public boolean test(T var1) throws IOException, Ex;

    default public IOPredicateE<T, Ex> and(IOPredicateE<? super T, ? extends Ex> other) throws IOException, Ex {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    default public IOPredicateE<T, Ex> negate() throws IOException, Ex {
        return t -> !this.test(t);
    }

    default public IOPredicateE<T, Ex> or(IOPredicateE<? super T, ? extends Ex> other) throws IOException, Ex {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }

    public static <T, Ex extends Throwable> IOPredicateE<T, Ex> isEqual(Object targetRef) {
        return null == targetRef ? Objects::isNull : object -> targetRef.equals(object);
    }

    public static <T, Ex extends Throwable> IOPredicateE<T, Ex> not(IOPredicateE<? super T, ? extends Ex> target) throws IOException, Ex {
        Objects.requireNonNull(target);
        return target.negate();
    }
}

