/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;

public class BigFraction
extends Number
implements Serializable,
Comparable<BigFraction> {
    private static final long serialVersionUID = 6382807525128346490L;
    private static final BigInteger ONE_HUNDRED = BigInteger.valueOf(100L);
    private static final BigInteger ONE_THOUSAND = BigInteger.valueOf(1000L);
    private static final BigInteger TEN_THOUSAND = BigInteger.valueOf(10000L);
    private static final BigInteger ONE_HUNDRED_THOUSAND = BigInteger.valueOf(100000L);
    public static final BigFraction ZERO = new BigFraction(0L, 1L, false);
    public static final BigFraction ONE = new BigFraction(1L, 1L, false);
    private final BigInteger numerator;
    private final BigInteger denominator;
    private final boolean displayPercentage;

    public static BigFraction valueOf(long numerator, long denominator, boolean displayPercentage) throws NumberFormatException {
        if (!displayPercentage && denominator == 1L) {
            if (numerator == 0L) {
                return ZERO;
            }
            if (numerator == 1L) {
                return ONE;
            }
        }
        return new BigFraction(numerator, denominator, displayPercentage);
    }

    public static BigFraction valueOf(BigInteger value, boolean displayPercentage) throws NumberFormatException {
        if (!displayPercentage) {
            if (value.signum() == 0) {
                return ZERO;
            }
            if (value.compareTo(BigInteger.ONE) == 0) {
                return ONE;
            }
        }
        return new BigFraction(value, BigInteger.ONE, displayPercentage);
    }

    public static BigFraction valueOf(BigDecimal value, boolean displayPercentage) throws NumberFormatException {
        int scale;
        if (!displayPercentage) {
            if (value.signum() == 0) {
                return ZERO;
            }
            if (value.compareTo(BigDecimal.ONE) == 0) {
                return ONE;
            }
        }
        if ((scale = value.scale()) <= 0) {
            return new BigFraction(value.toBigIntegerExact(), BigInteger.ONE, displayPercentage);
        }
        return new BigFraction(value.movePointRight(scale).toBigIntegerExact(), BigInteger.TEN.pow(scale), displayPercentage).reduce();
    }

    public static BigFraction valueOf(BigInteger numerator, BigInteger denominator, boolean displayPercentage) throws NumberFormatException {
        if (!displayPercentage && denominator.compareTo(BigInteger.ONE) == 0) {
            if (numerator.signum() == 0) {
                return ZERO;
            }
            if (numerator.compareTo(BigInteger.ONE) == 0) {
                return ONE;
            }
        }
        return new BigFraction(numerator, denominator, displayPercentage);
    }

    private static boolean totalMatches(BigDecimal[] results, BigDecimal total) {
        BigDecimal sum = null;
        for (BigDecimal result : results) {
            sum = sum == null ? result : sum.add(result);
        }
        assert (sum != null);
        return sum.equals(total);
    }

    public static BigDecimal[] distributeValue(BigDecimal total, DistributionMethod distributionMethod, BigFraction ... fractions) {
        int totalSignum = total.signum();
        int len = fractions.length;
        if (len == 0) {
            throw new IllegalArgumentException("fractions must contain at least one element");
        }
        BigFraction sum = ZERO;
        for (BigFraction fraction : fractions) {
            if (fraction.signum() < 0) {
                throw new IllegalArgumentException("fractions contains value<0: " + fraction);
            }
            sum = sum.add(fraction);
        }
        if (sum.compareTo(ONE) != 0) {
            throw new IllegalArgumentException("sum(fractions)!=1: " + sum);
        }
        BigDecimal[] results = new BigDecimal[len];
        if (totalSignum == 0) {
            for (int i = 0; i < len; ++i) {
                results[i] = total;
            }
        } else {
            switch (distributionMethod) {
                case PROPORTIONAL: {
                    Object[] fractionOrdereds = Arrays.copyOf(fractions, len);
                    Arrays.sort(fractionOrdereds);
                    BigFraction[] fractionAltereds = (BigFraction[])Arrays.copyOf(fractionOrdereds, len);
                    BigDecimal remaining = total;
                    block6: for (int c = len - 1; c >= 0; --c) {
                        BigFraction fractionAltered = fractionAltereds[c];
                        BigDecimal result = BigFraction.valueOf(remaining, false).multiply(fractionAltered).getBigDecimal(total.scale(), RoundingMode.UP);
                        if (result.signum() != 0 && result.signum() != totalSignum) {
                            throw new AssertionError((Object)("sign(result)!=sign(total): " + result));
                        }
                        remaining = remaining.subtract(result);
                        BigFraction divisor = ONE.subtract(fractionAltered);
                        for (int d = c - 1; d >= 0; --d) {
                            fractionAltereds[d] = fractionAltereds[d].divide(divisor);
                        }
                        Object fractionOrdered = fractionOrdereds[c];
                        for (int d = 0; d < len; ++d) {
                            if (results[d] != null || fractions[d].compareTo((BigFraction)fractionOrdered) != 0) continue;
                            results[d] = result;
                            continue block6;
                        }
                    }
                    if (remaining.signum() != 0) {
                        throw new AssertionError((Object)("remaining!=0: " + remaining));
                    }
                    break;
                }
                case HALF_UP: {
                    int signum;
                    BigFraction totalFraction = BigFraction.valueOf(total, false);
                    BigFraction[] remainders = new BigFraction[len];
                    BigFraction totalRemainder = ZERO;
                    for (int i = 0; i < len; ++i) {
                        BigFraction value = totalFraction.multiply(fractions[i]);
                        BigDecimal result = value.getBigDecimal(total.scale(), RoundingMode.HALF_UP);
                        BigFraction remainder = value.subtract(BigFraction.valueOf(result, false));
                        results[i] = result;
                        remainders[i] = remainder;
                        totalRemainder = totalRemainder.add(remainder);
                    }
                    BigDecimal offsetDecimal = BigDecimal.valueOf(1L, total.scale());
                    BigFraction offsetFraction = BigFraction.valueOf(offsetDecimal, false);
                    while ((signum = totalRemainder.signum()) != 0) {
                        int i;
                        int largestRemainderIndex;
                        BigFraction largestRemainder;
                        if (signum > 0) {
                            largestRemainder = remainders[0];
                            largestRemainderIndex = 0;
                            for (i = 1; i < len; ++i) {
                                if (!(totalSignum > 0 ? remainders[i].compareTo(largestRemainder) > 0 : remainders[i].compareTo(largestRemainder) >= 0)) continue;
                                largestRemainder = remainders[i];
                                largestRemainderIndex = i;
                            }
                            results[largestRemainderIndex] = results[largestRemainderIndex].add(offsetDecimal);
                            remainders[largestRemainderIndex] = remainders[largestRemainderIndex].subtract(offsetFraction);
                            totalRemainder = totalRemainder.subtract(offsetFraction);
                            continue;
                        }
                        largestRemainder = remainders[0];
                        largestRemainderIndex = 0;
                        for (i = 1; i < len; ++i) {
                            if (!(totalSignum < 0 ? remainders[i].compareTo(largestRemainder) < 0 : remainders[i].compareTo(largestRemainder) <= 0)) continue;
                            largestRemainder = remainders[i];
                            largestRemainderIndex = i;
                        }
                        results[largestRemainderIndex] = results[largestRemainderIndex].subtract(offsetDecimal);
                        remainders[largestRemainderIndex] = remainders[largestRemainderIndex].add(offsetFraction);
                        totalRemainder = totalRemainder.add(offsetFraction);
                    }
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected distributionMethod: " + (Object)((Object)distributionMethod)));
                }
            }
        }
        assert (BigFraction.totalMatches(results, total));
        return results;
    }

    public BigFraction(String value) throws NumberFormatException {
        if (value.endsWith("%")) {
            BigDecimal bd = new BigDecimal(value.substring(0, value.length() - 1)).movePointLeft(2);
            int scale = bd.scale();
            if (scale <= 0) {
                this.numerator = bd.toBigIntegerExact();
                this.denominator = BigInteger.ONE;
            } else {
                this.numerator = bd.movePointRight(scale).toBigIntegerExact();
                this.denominator = BigInteger.TEN.pow(scale);
            }
            this.displayPercentage = true;
        } else {
            int slashPos = value.indexOf(47);
            if (slashPos == -1) {
                throw new NumberFormatException("Unable to find slash (/)");
            }
            this.numerator = new BigInteger(value.substring(0, slashPos));
            this.denominator = new BigInteger(value.substring(slashPos + 1));
            this.displayPercentage = false;
        }
        this.validate();
    }

    public BigFraction(long numerator, long denominator, boolean displayPercentage) throws NumberFormatException {
        this.numerator = BigInteger.valueOf(numerator);
        this.denominator = BigInteger.valueOf(denominator);
        this.displayPercentage = displayPercentage;
        this.validate();
    }

    public BigFraction(BigInteger numerator, BigInteger denominator, boolean displayPercentage) throws NumberFormatException {
        this.numerator = numerator;
        this.denominator = denominator;
        this.displayPercentage = displayPercentage;
        this.validate();
    }

    private void validate() throws NumberFormatException {
        if (this.denominator.signum() <= 0) {
            throw new NumberFormatException("denominator<=0");
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.validate();
    }

    public String toString() {
        if (this.displayPercentage) {
            if (this.denominator.compareTo(ONE_HUNDRED) == 0) {
                return this.numerator.toString() + '%';
            }
            BigFraction reduced = this.reduce();
            BigInteger[] divideAndRemainer = ONE_HUNDRED.divideAndRemainder(reduced.denominator);
            if (divideAndRemainer[1].signum() == 0) {
                return reduced.numerator.multiply(divideAndRemainer[0]).toString() + "%";
            }
            divideAndRemainer = ONE_THOUSAND.divideAndRemainder(reduced.denominator);
            if (divideAndRemainer[1].signum() == 0) {
                return new BigDecimal(reduced.numerator.multiply(divideAndRemainer[0]), 1).toPlainString() + "%";
            }
            divideAndRemainer = TEN_THOUSAND.divideAndRemainder(reduced.denominator);
            if (divideAndRemainer[1].signum() == 0) {
                return new BigDecimal(reduced.numerator.multiply(divideAndRemainer[0]), 2).toPlainString() + "%";
            }
            divideAndRemainer = ONE_HUNDRED_THOUSAND.divideAndRemainder(reduced.denominator);
            if (divideAndRemainer[1].signum() == 0) {
                return new BigDecimal(reduced.numerator.multiply(divideAndRemainer[0]), 3).toPlainString() + "%";
            }
        }
        return this.numerator.toString() + '/' + this.denominator.toString();
    }

    public BigInteger getNumerator() {
        return this.numerator;
    }

    public BigInteger getDenominator() {
        return this.denominator;
    }

    public boolean isDisplayPercentage() {
        return this.displayPercentage;
    }

    @Override
    public int intValue() {
        return this.numerator.divide(this.denominator).intValue();
    }

    @Override
    public long longValue() {
        return this.numerator.divide(this.denominator).longValue();
    }

    @Override
    public float floatValue() {
        return this.numerator.floatValue() / this.denominator.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.numerator.doubleValue() / this.denominator.doubleValue();
    }

    public BigInteger getBigInteger() throws ArithmeticException {
        return this.getBigInteger(RoundingMode.UNNECESSARY);
    }

    public BigInteger getBigInteger(RoundingMode roundingMode) throws ArithmeticException {
        return this.getBigDecimal(0, roundingMode).toBigIntegerExact();
    }

    public BigDecimal getBigDecimal(int scale) throws ArithmeticException {
        return this.getBigDecimal(scale, RoundingMode.UNNECESSARY);
    }

    public BigDecimal getBigDecimal(int scale, RoundingMode roundingMode) throws ArithmeticException {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), scale, roundingMode);
    }

    public int hashCode() {
        return this.numerator.hashCode() * 31 + this.denominator.hashCode() + (this.displayPercentage ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof BigFraction)) {
            return false;
        }
        BigFraction other = (BigFraction)o;
        return this.displayPercentage == other.displayPercentage && this.numerator.equals(other.numerator) && this.denominator.equals(other.denominator);
    }

    @Override
    public int compareTo(BigFraction o) {
        if (this.denominator.compareTo(o.denominator) == 0) {
            return this.numerator.compareTo(o.numerator);
        }
        return this.numerator.multiply(o.denominator).compareTo(o.numerator.multiply(this.denominator));
    }

    private BigFraction reduce(BigInteger newNumerator, BigInteger newDenominator, boolean displayPercentage) {
        BigInteger gcd;
        if (!displayPercentage && newNumerator.signum() == 0) {
            return ZERO;
        }
        if (newDenominator.signum() < 0) {
            newNumerator = newNumerator.negate();
            newDenominator = newDenominator.negate();
        }
        if ((gcd = newNumerator.gcd(newDenominator)).compareTo(BigInteger.ONE) != 0) {
            newNumerator = newNumerator.divide(gcd);
            newDenominator = newDenominator.divide(gcd);
        }
        if (displayPercentage == this.displayPercentage && newNumerator.compareTo(this.numerator) == 0 && newDenominator.compareTo(this.denominator) == 0) {
            return this;
        }
        return BigFraction.valueOf(newNumerator, newDenominator, displayPercentage);
    }

    public BigFraction reduce() {
        return this.reduce(this.numerator, this.denominator, this.displayPercentage);
    }

    public BigFraction add(BigFraction val) {
        if (this.denominator.compareTo(val.denominator) == 0) {
            return this.reduce(this.numerator.add(val.numerator), this.denominator, this.displayPercentage || val.displayPercentage);
        }
        return this.reduce(this.numerator.multiply(val.denominator).add(val.numerator.multiply(this.denominator)), this.denominator.multiply(val.denominator), this.displayPercentage || val.displayPercentage);
    }

    public BigFraction subtract(BigFraction val) {
        if (this.denominator.compareTo(val.denominator) == 0) {
            return this.reduce(this.numerator.subtract(val.numerator), this.denominator, this.displayPercentage || val.displayPercentage);
        }
        return this.reduce(this.numerator.multiply(val.denominator).subtract(val.numerator.multiply(this.denominator)), this.denominator.multiply(val.denominator), this.displayPercentage || val.displayPercentage);
    }

    public BigFraction multiply(BigFraction val) {
        if (val.compareTo(ONE) == 0) {
            return this.reduce(this.numerator, this.denominator, this.displayPercentage && val.displayPercentage);
        }
        if (this.compareTo(ONE) == 0) {
            return val.reduce(val.numerator, val.denominator, this.displayPercentage && val.displayPercentage);
        }
        return this.reduce(this.numerator.multiply(val.numerator), this.denominator.multiply(val.denominator), this.displayPercentage && val.displayPercentage);
    }

    public BigFraction divide(BigFraction val) {
        if (val.compareTo(ONE) == 0) {
            return this.reduce();
        }
        if (this.compareTo(ONE) == 0) {
            return this.reduce(val.denominator, val.numerator, this.displayPercentage);
        }
        return this.reduce(this.numerator.multiply(val.denominator), this.denominator.multiply(val.numerator), this.displayPercentage);
    }

    public BigFraction negate() {
        return BigFraction.valueOf(this.numerator.negate(), this.denominator, this.displayPercentage);
    }

    public BigFraction abs() {
        return this.numerator.signum() >= 0 ? this : this.negate();
    }

    public BigFraction max(BigFraction val) {
        int diff = this.compareTo(val);
        if (diff > 0) {
            return this;
        }
        if (diff < 0) {
            return val;
        }
        diff = this.denominator.compareTo(val.denominator);
        return diff <= 0 ? this : val;
    }

    public BigFraction min(BigFraction val) {
        int diff = this.compareTo(val);
        if (diff < 0) {
            return this;
        }
        if (diff > 0) {
            return val;
        }
        diff = this.denominator.compareTo(val.denominator);
        return diff <= 0 ? this : val;
    }

    public BigFraction pow(int exponent) {
        if (exponent == 0) {
            return ONE;
        }
        BigFraction reduced = this.reduce();
        if (exponent == 1) {
            return reduced;
        }
        return BigFraction.valueOf(reduced.numerator.pow(exponent), reduced.denominator.pow(exponent), reduced.displayPercentage);
    }

    public int signum() {
        return this.numerator.signum();
    }

    public static enum DistributionMethod {
        PROPORTIONAL,
        HALF_UP;

    }
}

