/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.math;

public class SafeMath {
    private SafeMath() {
    }

    public static byte castByte(int value) throws ArithmeticException {
        if (value < -128) {
            throw new ArithmeticException("byte underflow: " + value);
        }
        if (value > 127) {
            throw new ArithmeticException("byte overflow: " + value);
        }
        return (byte)value;
    }

    public static byte castByte(long value) throws ArithmeticException {
        if (value < -128L) {
            throw new ArithmeticException("byte underflow: " + value);
        }
        if (value > 127L) {
            throw new ArithmeticException("byte overflow: " + value);
        }
        return (byte)value;
    }

    public static short castShort(int value) throws ArithmeticException {
        if (value < Short.MIN_VALUE) {
            throw new ArithmeticException("short underflow: " + value);
        }
        if (value > Short.MAX_VALUE) {
            throw new ArithmeticException("short overflow: " + value);
        }
        return (short)value;
    }

    public static short castShort(long value) throws ArithmeticException {
        if (value < -32768L) {
            throw new ArithmeticException("short underflow: " + value);
        }
        if (value > 32767L) {
            throw new ArithmeticException("short overflow: " + value);
        }
        return (short)value;
    }

    public static int castInt(long value) throws ArithmeticException {
        if (value < Integer.MIN_VALUE) {
            throw new ArithmeticException("int underflow: " + value);
        }
        if (value > Integer.MAX_VALUE) {
            throw new ArithmeticException("int overflow: " + value);
        }
        return (int)value;
    }

    @Deprecated
    public static long multiply(long value1, long value2) {
        return Math.multiplyExact(value1, value2);
    }

    public static long multiply(long ... values) {
        long product = 1L;
        for (long value : values) {
            product = Math.multiplyExact(product, value);
        }
        return product;
    }

    public static int avg(int value1, int value2) {
        return (int)(((long)value1 + (long)value2) / 2L);
    }

    public static int avg(int ... values) {
        long sum = 0L;
        for (int value : values) {
            sum += (long)value;
        }
        return (int)(sum / (long)values.length);
    }
}

