/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.math;

import java.util.Collection;

public class Statistics {
    private Statistics() {
    }

    public static double mean(Collection<? extends Number> samples) {
        double sum = 0.0;
        int numSamples = 0;
        for (Number number : samples) {
            if (number == null) continue;
            sum += number.doubleValue();
            ++numSamples;
        }
        return sum / (double)numSamples;
    }

    public static double standardDeviation(double mean, Collection<? extends Number> samples) {
        double sum = 0.0;
        int numSamples = 0;
        for (Number number : samples) {
            if (number == null) continue;
            double diff = number.doubleValue() - mean;
            sum += diff * diff;
            ++numSamples;
        }
        return Math.sqrt(sum / (double)numSamples);
    }
}

